/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.cli.entity;

import com.github.ajalt.clikt.output.TermUi;
import com.jakewharton.picnic.-DslKt;
import com.jakewharton.picnic.RowDsl;
import com.jakewharton.picnic.Table;
import com.jakewharton.picnic.TableDsl;
import com.jakewharton.picnic.TableSectionDsl;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.cli.AbstractCottontailCommand;
import org.vitrivr.cottontail.cli.entity.CreateEntityCommand;
import org.vitrivr.cottontail.client.SimpleClient;
import org.vitrivr.cottontail.client.iterators.TupleIterator;
import org.vitrivr.cottontail.client.language.ddl.ListEntities;
import org.vitrivr.cottontail.database.queries.binding.extensions.NameExtensionsKt;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.utilities.output.TabulationUtilities;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/cli/entity/CreateEntityCommand;", "Lorg/vitrivr/cottontail/cli/AbstractCottontailCommand$Entity;", "client", "Lorg/vitrivr/cottontail/client/SimpleClient;", "(Lorg/vitrivr/cottontail/client/SimpleClient;)V", "checkValid", "", "exec", "", "promptForColumn", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$ColumnDefinition;", "cottontaildb"})
@ExperimentalTime
public final class CreateEntityCommand
extends AbstractCottontailCommand.Entity {
    public CreateEntityCommand(@NotNull SimpleClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(client, "create", "Creates a new entity in the database. Usage: entity create <schema>.<entity>", false, 8, null);
    }

    @Override
    public void exec() {
        this.checkValid();
        CottontailGrpc.EntityDefinition.Builder colDef = CottontailGrpc.EntityDefinition.newBuilder().setEntity(NameExtensionsKt.proto(this.getEntityName()));
        do {
            String string = "Please specify column to add at position " + (colDef.getColumnsCount() + 1) + '.';
            boolean bl = false;
            System.out.println((Object)string);
            CottontailGrpc.ColumnDefinition ret = this.promptForColumn();
            if (ret == null) continue;
            colDef.addColumns(ret);
        } while (colDef.getColumnsCount() <= 0 || !Intrinsics.areEqual((Object)TermUi.confirm$default((TermUi)TermUi.INSTANCE, (String)("Do you want to add another column (size = " + colDef.getColumnsCount() + ")?"), (boolean)false, (boolean)false, null, (boolean)false, null, (int)62, null), (Object)false));
        Table tbl2 = -DslKt.table((Function1)((Function1)new Function1<TableDsl, Unit>(this, colDef){
            final /* synthetic */ CreateEntityCommand this$0;
            final /* synthetic */ CottontailGrpc.EntityDefinition.Builder $colDef;
            {
                this.this$0 = $receiver;
                this.$colDef = $colDef;
                super(1);
            }

            public final void invoke(@NotNull TableDsl $this$table) {
                Intrinsics.checkNotNullParameter((Object)$this$table, (String)"$this$table");
                $this$table.cellStyle((Function1)exec.tbl.1.INSTANCE);
                $this$table.header((Function1)new Function1<TableSectionDsl, Unit>(this.this$0){
                    final /* synthetic */ CreateEntityCommand this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull TableSectionDsl $this$header) {
                        Intrinsics.checkNotNullParameter((Object)$this$header, (String)"$this$header");
                        $this$header.row((Function1)new Function1<RowDsl, Unit>(this.this$0){
                            final /* synthetic */ CreateEntityCommand this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull RowDsl $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.cell((Object)CreateEntityCommand.access$getEntityName(this.this$0), (Function1)exec.tbl.1.INSTANCE);
                            }
                        });
                        $this$header.row((Function1)exec.tbl.2.INSTANCE);
                    }
                });
                $this$table.body((Function1)new Function1<TableSectionDsl, Unit>(this.$colDef){
                    final /* synthetic */ CottontailGrpc.EntityDefinition.Builder $colDef;
                    {
                        this.$colDef = $colDef;
                        super(1);
                    }

                    public final void invoke(@NotNull TableSectionDsl $this$body) {
                        Intrinsics.checkNotNullParameter((Object)$this$body, (String)"$this$body");
                        List list = this.$colDef.getColumnsList();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"colDef.columnsList");
                        Iterable $this$forEach$iv = list;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            CottontailGrpc.ColumnDefinition def = (CottontailGrpc.ColumnDefinition)element$iv;
                            boolean bl = false;
                            $this$body.row((Function1)new Function1<RowDsl, Unit>(def){
                                final /* synthetic */ CottontailGrpc.ColumnDefinition $def;
                                {
                                    this.$def = $def;
                                    super(1);
                                }

                                public final void invoke(@NotNull RowDsl $this$row) {
                                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                    Object[] objectArray = new Object[]{this.$def.getName(), this.$def.getType(), this.$def.getLength(), this.$def.getNullable()};
                                    RowDsl.cells$default((RowDsl)$this$row, (Object[])objectArray, null, (int)2, null);
                                }
                            });
                        }
                    }
                });
            }
        }));
        if (Intrinsics.areEqual((Object)TermUi.confirm$default((TermUi)TermUi.INSTANCE, (String)Intrinsics.stringPlus((String)"Please confirm that you want to create the entity:\n", (Object)tbl2), (boolean)true, (boolean)false, null, (boolean)false, null, (int)60, null), (Object)true)) {
            boolean $i$f$measureTimedValue = false;
            boolean bl = false;
            TimeSource $this$measureTimedValue$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            boolean bl2 = false;
            TimeMark mark$iv$iv = $this$measureTimedValue$iv$iv.markNow();
            boolean bl3 = false;
            SimpleClient simpleClient = this.getClient();
            CottontailGrpc.CreateEntityMessage createEntityMessage = CottontailGrpc.CreateEntityMessage.newBuilder().setDefinition(colDef).build();
            Intrinsics.checkNotNullExpressionValue((Object)createEntityMessage, (String)"newBuilder().setDefinition(colDef).build()");
            Table result$iv$iv = TabulationUtilities.INSTANCE.tabulate(simpleClient.create(createEntityMessage));
            TimedValue time = new TimedValue((Object)result$iv$iv, mark$iv$iv.elapsedNow-UwyO8pc(), null);
            Object object = "Entity " + this.getEntityName() + " created successfully (took " + Duration.toString-impl((long)time.getDuration-UwyO8pc()) + ").";
            boolean bl4 = false;
            System.out.println(object);
            object = time.getValue();
            bl4 = false;
            System.out.print(object);
        } else {
            String string = "Create entity " + this.getEntityName() + " aborted!";
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    private final boolean checkValid() {
        try {
            TupleIterator ret = this.getClient().list(new ListEntities(this.getEntityName().schema().toString()));
            while (ret.hasNext()) {
            }
            return true;
        }
        catch (StatusRuntimeException e) {
            if (Intrinsics.areEqual((Object)e.getStatus(), (Object)Status.NOT_FOUND)) {
                String string = "Error: Schema " + this.getEntityName().schema() + " not found.";
                boolean bl = false;
                System.out.println((Object)string);
            }
            return false;
        }
    }

    private final CottontailGrpc.ColumnDefinition promptForColumn() {
        int n;
        CottontailGrpc.ColumnDefinition.Builder def = CottontailGrpc.ColumnDefinition.newBuilder();
        def.getNameBuilder().setName(TermUi.prompt$default((TermUi)TermUi.INSTANCE, (String)"Column name (must consist of letters and numbers)", null, (boolean)false, (boolean)false, null, null, (boolean)false, (int)126, null));
        def.setType((CottontailGrpc.Type)TermUi.prompt$default((TermUi)TermUi.INSTANCE, (String)("Column type (" + ArraysKt.joinToString$default((Object[])CottontailGrpc.Type.values(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ')'), null, (boolean)false, (boolean)false, null, null, (boolean)false, null, (Function1)promptForColumn.1.INSTANCE, (int)254, null));
        Object object = def.getType();
        int n2 = object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Integer n3 = (Integer)TermUi.prompt$default((TermUi)TermUi.INSTANCE, (String)"\rColumn lengths (i.e. number of entries for vectors)", null, (boolean)false, (boolean)false, null, null, (boolean)false, null, (Function1)promptForColumn.2.INSTANCE, (int)254, null);
                if (n3 == null) {
                    n = 1;
                    break;
                }
                n = n3;
                break;
            }
            default: {
                n = -1;
            }
        }
        def.setLength(n);
        object = TermUi.confirm$default((TermUi)TermUi.INSTANCE, (String)"Should column be nullable?", (boolean)false, (boolean)false, null, (boolean)false, null, (int)60, null);
        def.setNullable(object == null ? false : (Boolean)object);
        Table tbl2 = -DslKt.table((Function1)((Function1)new Function1<TableDsl, Unit>(def){
            final /* synthetic */ CottontailGrpc.ColumnDefinition.Builder $def;
            {
                this.$def = $def;
                super(1);
            }

            public final void invoke(@NotNull TableDsl $this$table) {
                Intrinsics.checkNotNullParameter((Object)$this$table, (String)"$this$table");
                $this$table.cellStyle((Function1)promptForColumn.tbl.1.INSTANCE);
                $this$table.header((Function1)promptForColumn.tbl.2.INSTANCE);
                $this$table.body((Function1)new Function1<TableSectionDsl, Unit>(this.$def){
                    final /* synthetic */ CottontailGrpc.ColumnDefinition.Builder $def;
                    {
                        this.$def = $def;
                        super(1);
                    }

                    public final void invoke(@NotNull TableSectionDsl $this$body) {
                        Intrinsics.checkNotNullParameter((Object)$this$body, (String)"$this$body");
                        $this$body.row((Function1)new Function1<RowDsl, Unit>(this.$def){
                            final /* synthetic */ CottontailGrpc.ColumnDefinition.Builder $def;
                            {
                                this.$def = $def;
                                super(1);
                            }

                            public final void invoke(@NotNull RowDsl $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                Object[] objectArray = new Object[]{this.$def.getName(), this.$def.getType(), this.$def.getLength(), this.$def.getNullable()};
                                RowDsl.cells$default((RowDsl)$this$row, (Object[])objectArray, null, (int)2, null);
                            }
                        });
                    }
                });
            }
        }));
        return Intrinsics.areEqual((Object)TermUi.confirm$default((TermUi)TermUi.INSTANCE, (String)Intrinsics.stringPlus((String)"Please confirm column:\n", (Object)tbl2), (boolean)false, (boolean)false, null, (boolean)false, null, (int)62, null), (Object)true) ? def.build() : (CottontailGrpc.ColumnDefinition)null;
    }

    public static final /* synthetic */ Name.EntityName access$getEntityName(CreateEntityCommand $this) {
        return $this.getEntityName();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CottontailGrpc.Type.values().length];
            nArray[CottontailGrpc.Type.DOUBLE_VEC.ordinal()] = 1;
            nArray[CottontailGrpc.Type.FLOAT_VEC.ordinal()] = 2;
            nArray[CottontailGrpc.Type.LONG_VEC.ordinal()] = 3;
            nArray[CottontailGrpc.Type.INT_VEC.ordinal()] = 4;
            nArray[CottontailGrpc.Type.BOOL_VEC.ordinal()] = 5;
            nArray[CottontailGrpc.Type.COMPLEX32_VEC.ordinal()] = 6;
            nArray[CottontailGrpc.Type.COMPLEX64_VEC.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

