/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.cli.entity;

import com.github.ajalt.clikt.completion.CompletionCandidates;
import com.github.ajalt.clikt.core.ParameterHolder;
import com.github.ajalt.clikt.core.UsageError;
import com.github.ajalt.clikt.parameters.options.FlagOptionKt;
import com.github.ajalt.clikt.parameters.options.OptionCallTransformContext;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.options.ValueWithDefault;
import com.github.ajalt.clikt.parameters.types.ChoiceKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.cli.AbstractCottontailCommand;
import org.vitrivr.cottontail.cli.entity.ImportDataCommand$special$;
import org.vitrivr.cottontail.client.SimpleClient;
import org.vitrivr.cottontail.client.iterators.Tuple;
import org.vitrivr.cottontail.client.iterators.TupleIterator;
import org.vitrivr.cottontail.client.language.ddl.AboutEntity;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.queries.binding.extensions.NameExtensionsKt;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.utilities.data.Format;
import org.vitrivr.cottontail.utilities.data.importer.DataImporter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0017\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0018H\u0002\u00a2\u0006\u0002\u0010\u001aR\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/cli/entity/ImportDataCommand;", "Lorg/vitrivr/cottontail/cli/AbstractCottontailCommand$Entity;", "client", "Lorg/vitrivr/cottontail/client/SimpleClient;", "(Lorg/vitrivr/cottontail/client/SimpleClient;)V", "format", "Lorg/vitrivr/cottontail/utilities/data/Format;", "getFormat", "()Lorg/vitrivr/cottontail/utilities/data/Format;", "format$delegate", "Lkotlin/properties/ReadOnlyProperty;", "input", "Ljava/nio/file/Path;", "getInput", "()Ljava/nio/file/Path;", "input$delegate", "singleTransaction", "", "getSingleTransaction", "()Z", "singleTransaction$delegate", "exec", "", "readSchema", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "cottontaildb"})
@ExperimentalTime
public final class ImportDataCommand
extends AbstractCottontailCommand.Entity {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty format$delegate;
    @NotNull
    private final ReadOnlyProperty input$delegate;
    @NotNull
    private final ReadOnlyProperty singleTransaction$delegate;

    /*
     * WARNING - void declaration
     */
    public ImportDataCommand(@NotNull SimpleClient client) {
        void metavar$iv$iv;
        void $this$convert$iv$iv;
        Map map2;
        void $this$associateByTo$iv$iv$iv;
        void $this$associateBy$iv$iv;
        String[] $this$enum_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(client, "import", "Used to import data into Cottontail DB.", false, 8, null);
        String[] stringArray = new String[]{"-f", "--format"};
        stringArray = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)("Format for used for data import (Options: " + ArraysKt.joinToString$default((Object[])Format.values(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ")."), null, (boolean)false, null, null, null, null, (int)252, null);
        ImportDataCommand importDataCommand = this;
        boolean ignoreCase$iv = true;
        boolean $i$f$enum = false;
        Format[] formatArray = Format.values();
        OptionWithValues optionWithValues = $this$enum_u24default$iv;
        boolean $i$f$associateBy22 = false;
        int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associateBy$iv$iv).length), (int)16);
        void var10_13 = $this$associateBy$iv$iv;
        Map destination$iv$iv$iv = new LinkedHashMap(capacity$iv$iv);
        boolean $i$f$associateByTo = false;
        for (void element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv;
            Enum enum_ = (Enum)element$iv$iv$iv;
            map2 = destination$iv$iv$iv;
            boolean bl = false;
            void it = it$iv;
            String string = it.name();
            map2.put(string, element$iv$iv$iv);
        }
        map2 = destination$iv$iv$iv;
        OptionWithValues optionWithValues2 = ChoiceKt.choice$default((OptionWithValues)optionWithValues, (Map)map2, null, (boolean)ignoreCase$iv, (int)2, null);
        importDataCommand.format$delegate = OptionWithValuesKt.required((OptionWithValues)optionWithValues2).provideDelegate((ParameterHolder)this, $$delegatedProperties[0]);
        $this$enum_u24default$iv = new String[]{"-i", "--input"};
        OptionWithValues $this$convert_u24default$iv = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])$this$enum_u24default$iv, (String)"Limits the amount of printed results", null, (boolean)false, null, null, null, null, (int)252, null);
        Function1 metavar$iv = special$$inlined$convert$default$1.INSTANCE;
        CompletionCandidates completionCandidates$iv = (CompletionCandidates)$this$convert_u24default$iv.getCompletionCandidatesWithDefault().getDefault();
        optionWithValues = $this$convert_u24default$iv;
        Function1 $i$f$associateBy22 = metavar$iv;
        CompletionCandidates completionCandidates$iv$iv = completionCandidates$iv;
        boolean $i$f$convert = false;
        Function2 proc$iv$iv = (Function2)new Function2<OptionCallTransformContext, String, Path>((OptionWithValues)$this$convert$iv$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Path invoke(@NotNull OptionCallTransformContext $this$null, @NotNull String it) {
                Path path;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    String string = (String)this.$this_convert.getTransformValue().invoke((Object)$this$null, (Object)it);
                    OptionCallTransformContext $this$input_delegate_u24lambda_u2d0 = $this$null;
                    boolean bl = false;
                    path = Paths.get((String)it2, new String[0]);
                }
                catch (UsageError err) {
                    err.setParamName($this$null.getName());
                    throw err;
                }
                catch (Exception err) {
                    String string = err.getMessage();
                    $this$null.fail(string == null ? "" : string);
                    throw new KotlinNothingValueException();
                }
                return path;
            }
        };
        this.input$delegate = OptionWithValuesKt.required((OptionWithValues)OptionWithValues.copy$default((OptionWithValues)$this$convert$iv$iv, (Function2)proc$iv$iv, (Function2)OptionWithValuesKt.defaultEachProcessor(), (Function2)OptionWithValuesKt.defaultAllProcessor(), (Function2)OptionWithValuesKt.defaultValidator(), null, (ValueWithDefault)ValueWithDefault.copy$default((ValueWithDefault)$this$convert$iv$iv.getMetavarWithDefault(), null, (Object)metavar$iv$iv, (int)1, null), (int)0, null, (boolean)false, null, null, null, null, null, (ValueWithDefault)ValueWithDefault.copy$default((ValueWithDefault)$this$convert$iv$iv.getCompletionCandidatesWithDefault(), null, (Object)completionCandidates$iv$iv, (int)1, null), (int)16336, null)).provideDelegate((ParameterHolder)this, $$delegatedProperties[1]);
        stringArray = new String[]{"-t", "--transaction"};
        this.singleTransaction$delegate = FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, null, null, (boolean)false, null, null, null, null, (int)254, null), (String[])new String[0], (boolean)false, null, (int)6, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[2]);
    }

    private final Format getFormat() {
        return (Format)((Object)this.format$delegate.getValue((Object)this, $$delegatedProperties[0]));
    }

    private final Path getInput() {
        Object object = this.input$delegate.getValue((Object)this, $$delegatedProperties[1]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-input>(...)");
        return (Path)object;
    }

    private final boolean getSingleTransaction() {
        return (Boolean)this.singleTransaction$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exec() {
        ColumnDef<?>[] schema = this.readSchema();
        DataImporter iterator2 = this.getFormat().newImporter(this.getInput(), schema);
        Long txId = this.getSingleTransaction() ? Long.valueOf(this.getClient().begin()) : (Long)null;
        try {
            Iterator $this$forEach$iv = iterator2;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator4 = iterator3;
            while (iterator4.hasNext()) {
                Object element$iv = iterator4.next();
                CottontailGrpc.InsertMessage.Builder it = (CottontailGrpc.InsertMessage.Builder)element$iv;
                boolean bl2 = false;
                it.setFrom(NameExtensionsKt.protoFrom(this.getEntityName()));
                if (txId != null) {
                    it.getMetadataBuilder().setTransactionId(txId.longValue());
                }
                SimpleClient simpleClient = this.getClient();
                CottontailGrpc.InsertMessage insertMessage = it.build();
                Intrinsics.checkNotNullExpressionValue((Object)insertMessage, (String)"it.build()");
                simpleClient.insert(insertMessage);
            }
            if (txId != null) {
                this.getClient().commit(txId.longValue());
            }
        }
        catch (Throwable e) {
            if (txId != null) {
                this.getClient().rollback(txId.longValue());
            }
        }
        finally {
            iterator2.close();
        }
    }

    private final ColumnDef<?>[] readSchema() {
        boolean bl = false;
        List columns = new ArrayList();
        TupleIterator schemaInfo = this.getClient().about(new AboutEntity(this.getEntityName().toString()));
        Iterator $this$forEach$iv = (Iterator)schemaInfo;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        boolean bl2 = false;
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            String[] stringArray;
            Object element$iv = iterator3.next();
            Tuple it = (Tuple)element$iv;
            boolean bl3 = false;
            if (!Intrinsics.areEqual((Object)it.asString(1), (Object)"COLUMN")) continue;
            String string = it.asString(0);
            Intrinsics.checkNotNull((Object)string);
            String[] stringArray2 = new String[]{"."};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Name.ColumnName columnName = new Name.ColumnName(Arrays.copyOf(stringArray, stringArray.length));
            String string2 = it.asString(2);
            Intrinsics.checkNotNull((Object)string2);
            Integer n = it.asInt(4);
            Intrinsics.checkNotNull((Object)n);
            Type<?> type = Type.Companion.forName(string2, n);
            Boolean bl4 = it.asBoolean(5);
            Intrinsics.checkNotNull((Object)bl4);
            columns.add(new ColumnDef(columnName, type, bl4, false, 8, null));
        }
        Collection $this$toTypedArray$iv = columns;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ColumnDef[] columnDefArray = thisCollection$iv.toArray(new ColumnDef[0]);
        if (columnDefArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return columnDefArray;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ImportDataCommand.class, "format", "getFormat()Lorg/vitrivr/cottontail/utilities/data/Format;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ImportDataCommand.class, "input", "getInput()Ljava/nio/file/Path;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ImportDataCommand.class, "singleTransaction", "getSingleTransaction()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

