/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.column.mapdb;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.column.Column;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.column.ColumnEngine;
import org.vitrivr.cottontail.database.column.ColumnTx;
import org.vitrivr.cottontail.database.column.ColumnTxSnapshot;
import org.vitrivr.cottontail.database.column.mapdb.ColumnHeader;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.general.TxAction;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.storage.serializers.mapdb.MapDBSerializer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 5*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u000256B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010/\u001a\u000200H\u0016J\u001a\u00101\u001a\f02R\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00103\u001a\u000204H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u00067"}, d2={"Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn;", "T", "Lorg/vitrivr/cottontail/model/values/types/Value;", "Lorg/vitrivr/cottontail/database/column/Column;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/Entity;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "closed", "", "getClosed", "()Z", "columnDef", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumnDef$annotations", "()V", "getColumnDef", "()Lorg/vitrivr/cottontail/database/column/ColumnDef;", "engine", "Lorg/vitrivr/cottontail/database/column/ColumnEngine;", "getEngine", "()Lorg/vitrivr/cottontail/database/column/ColumnEngine;", "header", "Lorg/vitrivr/cottontail/database/column/mapdb/ColumnHeader;", "getHeader", "()Lorg/vitrivr/cottontail/database/column/mapdb/ColumnHeader;", "maxTupleId", "", "getMaxTupleId", "()J", "name", "Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "getParent", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "getPath", "()Ljava/nio/file/Path;", "store", "Lorg/mapdb/CottontailStoreWAL;", "version", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn$Tx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class MapDBColumn<T extends Value>
implements Column<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @NotNull
    private final Entity parent;
    @NotNull
    private CottontailStoreWAL store;
    @NotNull
    private final ColumnDef<T> columnDef;
    @NotNull
    private final StampedLock closeLock;
    private static final long RECORD_ID_TUPLE_ID_SHIFT = 2L;
    private static final long HEADER_RECORD_ID = 1L;

    /*
     * WARNING - void declaration
     */
    public MapDBColumn(@NotNull Path path, @NotNull Entity parent) {
        CottontailStoreWAL cottontailStoreWAL;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.path = path;
        this.parent = parent;
        MapDBColumn mapDBColumn = this;
        try {
            MapDBColumn mapDBColumn2 = mapDBColumn;
            cottontailStoreWAL = this.getParent().getParent().getParent().getConfig().getMapdb().store(this.getPath());
        }
        catch (DBException dBException) {
            void e;
            MapDBColumn mapDBColumn3 = mapDBColumn;
            throw new DatabaseException("Failed to open column at '" + this.getPath() + "': " + e.getMessage() + '\'', null, 2, null);
        }
        mapDBColumn2.store = cottontailStoreWAL;
        this.columnDef = this.getHeader().getColumnDef();
        this.closeLock = new StampedLock();
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Entity getParent() {
        return this.parent;
    }

    private final ColumnHeader getHeader() {
        ColumnHeader columnHeader = (ColumnHeader)this.store.get(1L, ColumnHeader.Serializer);
        if (columnHeader == null) {
            throw new DatabaseException.DataCorruptionException("Failed to open header of column '" + this.getName() + "'!'");
        }
        return columnHeader;
    }

    @Override
    @NotNull
    public ColumnDef<T> getColumnDef() {
        return this.columnDef;
    }

    public static /* synthetic */ void getColumnDef$annotations() {
    }

    @Override
    @NotNull
    public Name.ColumnName getName() {
        return this.getColumnDef().getName();
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V2_0;
    }

    @Override
    @NotNull
    public ColumnEngine getEngine() {
        return ColumnEngine.MAPDB;
    }

    @Override
    public long getMaxTupleId() {
        return this.store.getMaxRecid();
    }

    @Override
    public boolean getClosed() {
        return this.store.isClosed();
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    @Override
    public void close() {
        if (!this.getClosed()) {
            this.store.close();
        }
    }

    @Override
    public boolean getNullable() {
        return Column.DefaultImpls.getNullable(this);
    }

    @Override
    public int getSize() {
        return Column.DefaultImpls.getSize(this);
    }

    @Override
    @NotNull
    public Type<T> getType() {
        return Column.DefaultImpls.getType(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn$Companion;", "", "()V", "HEADER_RECORD_ID", "", "RECORD_ID_TUPLE_ID_SHIFT", "initialize", "", "path", "Ljava/nio/file/Path;", "column", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "config", "Lorg/vitrivr/cottontail/config/MapDBConfig;", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public final void initialize(@NotNull Path path, @NotNull ColumnDef<?> column, @NotNull MapDBConfig config) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(column, (String)"column");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (Files.exists(path, new LinkOption[0])) {
                throw new DatabaseException.InvalidFileException("Could not initialize column " + column.getName() + ". A file already exists under " + path + '.');
            }
            CottontailStoreWAL store = config.store(path);
            store.put(new ColumnHeader(column, 0L, 0L, 0L, 14, null), ColumnHeader.Serializer);
            store.commit();
            store.close();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0014J-\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u00060\u0007j\u0002`\u00172\b\u0010\u0018\u001a\u0004\u0018\u00018\u00002\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0007H\u0016J\u001b\u0010\u001c\u001a\u0004\u0018\u00018\u00002\n\u0010\u0016\u001a\u00060\u0007j\u0002`\u0017H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u0017\u0010!\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\"\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00170#H\u0016J\u001a\u0010\"\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\u00170#2\u0006\u0010$\u001a\u00020%H\u0016J%\u0010&\u001a\u0004\u0018\u00018\u00002\n\u0010\u0016\u001a\u00060\u0007j\u0002`\u00172\b\u0010\u0018\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn$Tx;", "Lorg/vitrivr/cottontail/database/general/AbstractTx;", "Lorg/vitrivr/cottontail/database/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/database/column/Column;", "getDbo", "()Lorg/vitrivr/cottontail/database/column/Column;", "serializer", "Lorg/vitrivr/cottontail/storage/serializers/mapdb/MapDBSerializer;", "snapshot", "Lorg/vitrivr/cottontail/database/column/ColumnTxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/column/ColumnTxSnapshot;", "cleanup", "", "compareAndUpdate", "", "tupleId", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "value", "expected", "(JLorg/vitrivr/cottontail/model/values/types/Value;Lorg/vitrivr/cottontail/model/values/types/Value;)Z", "count", "delete", "(J)Lorg/vitrivr/cottontail/model/values/types/Value;", "insert", "record", "(Lorg/vitrivr/cottontail/model/values/types/Value;)J", "read", "scan", "", "range", "Lkotlin/ranges/LongRange;", "update", "(JLorg/vitrivr/cottontail/model/values/types/Value;)Lorg/vitrivr/cottontail/model/values/types/Value;", "cottontaildb"})
    public final class Tx
    extends AbstractTx
    implements ColumnTx<T> {
        @NotNull
        private final MapDBSerializer<T> serializer;
        private final long closeStamp;
        @NotNull
        private final ColumnTxSnapshot snapshot;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)MapDBColumn.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.serializer = MapDBColumn.this.getType().serializerFactory().mapdb(MapDBColumn.this.getType().getLogicalSize());
            this.closeStamp = MapDBColumn.this.closeLock.readLock();
            if (MapDBColumn.this.getClosed()) {
                MapDBColumn.this.closeLock.unlockRead(this.closeStamp);
                throw new TxException.TxDBOClosedException(this.getContext().getTxId(), MapDBColumn.this);
            }
            this.snapshot = new ColumnTxSnapshot(MapDBColumn.this){
                private volatile long delta;
                @NotNull
                private final List<TxAction> actions;
                final /* synthetic */ MapDBColumn<T> this$0;
                {
                    this.this$0 = $receiver;
                    this.actions = CollectionsKt.emptyList();
                }

                public long getDelta() {
                    return this.delta;
                }

                public void setDelta(long l) {
                    this.delta = l;
                }

                @NotNull
                public List<TxAction> getActions() {
                    return this.actions;
                }

                public void commit() {
                    ColumnHeader columnHeader = MapDBColumn.access$getHeader(this.this$0);
                    long l = System.currentTimeMillis();
                    long l2 = MapDBColumn.access$getHeader(this.this$0).getCount() + this.getDelta();
                    ColumnHeader header = ColumnHeader.copy$default(columnHeader, null, l2, 0L, l, 5, null);
                    MapDBColumn.access$getStore$p(this.this$0).update(1L, header, ColumnHeader.Serializer);
                    MapDBColumn.access$getStore$p(this.this$0).commit();
                }

                public void rollback() {
                    MapDBColumn.access$getStore$p(this.this$0).rollback();
                }

                public boolean record(@NotNull TxAction action) {
                    Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                    return false;
                }
            };
        }

        @Override
        @NotNull
        public Column<T> getDbo() {
            return MapDBColumn.this;
        }

        @Override
        @NotNull
        public ColumnTxSnapshot getSnapshot() {
            return this.snapshot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public T read(long tupleId) {
            void this_$iv;
            AbstractTx abstractTx = this;
            MapDBColumn mapDBColumn = MapDBColumn.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                boolean bl3 = false;
                boolean bl4 = false;
                Value value = (Value)mapDBColumn.store.get(tupleId + 2L, this.serializer);
                return value;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public long count() {
            void this_$iv;
            AbstractTx abstractTx = this;
            MapDBColumn mapDBColumn = MapDBColumn.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                boolean bl3 = false;
                boolean bl4 = false;
                long l = mapDBColumn.getHeader().getCount() + this.getSnapshot().getDelta();
                return l;
            }
            finally {
                readLock.unlock();
            }
        }

        @Override
        @NotNull
        public Iterator<Long> scan() {
            return this.scan(new LongRange(0L, MapDBColumn.this.getMaxTupleId()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Iterator<Long> scan(@NotNull LongRange range) {
            Iterator<Long> iterator2;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            AbstractTx abstractTx = this;
            MapDBColumn mapDBColumn = MapDBColumn.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                boolean bl3 = false;
                boolean bl4 = false;
                iterator2 = new Iterator<Long>(mapDBColumn, range){
                    @NotNull
                    private final CottontailStoreWAL.RecordIdIterator wrapped;
                    final /* synthetic */ MapDBColumn<T> this$0;
                    final /* synthetic */ LongRange $range;
                    {
                        this.this$0 = $receiver;
                        this.$range = $range;
                        this.wrapped = new CottontailStoreWAL.RecordIdIterator(MapDBColumn.access$getStore$p(this.this$0), new LongRange(this.$range.getFirst() + 2L, this.$range.getLast() + 2L));
                    }

                    public boolean hasNext() {
                        return this.wrapped.hasNext();
                    }

                    @NotNull
                    public Long next() {
                        return this.wrapped.next() - 2L;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
            finally {
                readLock.unlock();
            }
            return iterator2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public long insert(@Nullable T record) {
            int n;
            int n2;
            int n3;
            void this_$iv;
            AbstractTx abstractTx = this;
            MapDBColumn mapDBColumn = MapDBColumn.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n4 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n5 = 0;
            n5 = 0;
            int n6 = n4;
            while (n5 < n6) {
                n3 = n5++;
                n2 = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                n = 0;
                boolean bl4 = false;
                try {
                    long l;
                    if (record == null && this.getColumnDef().getNullable()) {
                        l = mapDBColumn.store.preallocate() - 2L;
                    } else if (record != null) {
                        l = mapDBColumn.store.put(record, this.serializer) - 2L;
                    } else {
                        throw new IllegalArgumentException("Column " + this.getColumnDef() + " does not allow for NULL values.");
                    }
                    long tupleId = l;
                    ColumnTxSnapshot columnTxSnapshot = this.getSnapshot();
                    columnTxSnapshot.setDelta(columnTxSnapshot.getDelta() + 1L);
                    long l2 = tupleId;
                    return l2;
                }
                catch (DBException e) {
                    this.setStatus(TxStatus.ERROR);
                    String string = e.getMessage();
                    throw new TxException.TxStorageException(this.getContext().getTxId(), string == null ? "Unknown" : string);
                }
            }
            finally {
                n6 = 0;
                n3 = 0;
                n3 = 0;
                n2 = n4;
                while (n3 < n2) {
                    n = n3++;
                    boolean bl5 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public T update(long tupleId, @Nullable T value) {
            int n;
            int n2;
            int n3;
            void this_$iv;
            AbstractTx abstractTx = this;
            MapDBColumn mapDBColumn = MapDBColumn.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n4 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n5 = 0;
            n5 = 0;
            int n6 = n4;
            while (n5 < n6) {
                n3 = n5++;
                n2 = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                Value value2;
                n = 0;
                boolean bl4 = false;
                try {
                    Value ret = (Value)mapDBColumn.store.get(tupleId + 2L, this.serializer);
                    mapDBColumn.store.update(tupleId + 2L, value, this.serializer);
                    value2 = ret;
                }
                catch (DBException e) {
                    this.setStatus(TxStatus.ERROR);
                    String string = e.getMessage();
                    throw new TxException.TxStorageException(this.getContext().getTxId(), string == null ? "Unknown exception during data storage" : string);
                }
                return value2;
            }
            finally {
                n6 = 0;
                n3 = 0;
                n3 = 0;
                n2 = n4;
                while (n3 < n2) {
                    n = n3++;
                    boolean bl5 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public boolean compareAndUpdate(long tupleId, @Nullable T value, @Nullable T expected) {
            int n;
            int n2;
            int n3;
            void this_$iv;
            AbstractTx abstractTx = this;
            MapDBColumn mapDBColumn = MapDBColumn.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n4 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n5 = 0;
            n5 = 0;
            int n6 = n4;
            while (n5 < n6) {
                n3 = n5++;
                n2 = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                n = 0;
                boolean bl4 = false;
                try {
                    boolean ret;
                    boolean bl5 = ret = mapDBColumn.store.compareAndSwap(tupleId + 2L, expected, value, this.serializer);
                    return bl5;
                }
                catch (DBException e) {
                    this.setStatus(TxStatus.ERROR);
                    String string = e.getMessage();
                    throw new TxException.TxStorageException(this.getContext().getTxId(), string == null ? "Unknown" : string);
                }
            }
            finally {
                n6 = 0;
                n3 = 0;
                n3 = 0;
                n2 = n4;
                while (n3 < n2) {
                    n = n3++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public T delete(long tupleId) {
            int n;
            int n2;
            int n3;
            void this_$iv;
            AbstractTx abstractTx = this;
            MapDBColumn mapDBColumn = MapDBColumn.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n4 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n5 = 0;
            n5 = 0;
            int n6 = n4;
            while (n5 < n6) {
                n3 = n5++;
                n2 = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                Value value;
                n = 0;
                boolean bl4 = false;
                try {
                    Value ret = (Value)mapDBColumn.store.get(tupleId + 2L, this.serializer);
                    mapDBColumn.store.delete(tupleId + 2L, this.serializer);
                    ColumnTxSnapshot columnTxSnapshot = this.getSnapshot();
                    columnTxSnapshot.setDelta(columnTxSnapshot.getDelta() - 1L);
                    mapDBColumn.store.update(1L, mapDBColumn.getHeader(), ColumnHeader.Serializer);
                    value = ret;
                }
                catch (DBException e) {
                    this.setStatus(TxStatus.ERROR);
                    String string = e.getMessage();
                    throw new TxException.TxStorageException(this.getContext().getTxId(), string == null ? "Unknown" : string);
                }
                return value;
            }
            finally {
                n6 = 0;
                n3 = 0;
                n3 = 0;
                n2 = n4;
                while (n3 < n2) {
                    n = n3++;
                    boolean bl5 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        protected void cleanup() {
            MapDBColumn.this.closeLock.unlockRead(this.closeStamp);
        }

        @Override
        @NotNull
        public ColumnDef<T> getColumnDef() {
            return ColumnTx.DefaultImpls.getColumnDef(this);
        }
    }
}

