/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.general;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.general.Tx;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.exceptions.TxException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H$J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0013J%\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u001b\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/database/general/AbstractTx;", "Lorg/vitrivr/cottontail/database/general/Tx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "getContext", "()Lorg/vitrivr/cottontail/execution/TransactionContext;", "<set-?>", "Lorg/vitrivr/cottontail/database/general/TxStatus;", "status", "getStatus", "()Lorg/vitrivr/cottontail/database/general/TxStatus;", "setStatus", "(Lorg/vitrivr/cottontail/database/general/TxStatus;)V", "txLatch", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getTxLatch", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "cleanup", "", "commit", "rollback", "withReadLock", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withWriteLock", "cottontaildb"})
public abstract class AbstractTx
implements Tx {
    @NotNull
    private final TransactionContext context;
    @NotNull
    private volatile TxStatus status;
    @NotNull
    private final ReentrantReadWriteLock txLatch;

    public AbstractTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.status = TxStatus.CLEAN;
        this.txLatch = new ReentrantReadWriteLock();
    }

    @Override
    @NotNull
    public TransactionContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public final TxStatus getStatus() {
        return this.status;
    }

    protected final void setStatus(@NotNull TxStatus txStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)txStatus), (String)"<set-?>");
        this.status = txStatus;
    }

    @NotNull
    public final ReentrantReadWriteLock getTxLatch() {
        return this.txLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void commit() {
        try {
            if (this.status == TxStatus.DIRTY) {
                this.getSnapshot().commit();
            } else if (this.status == TxStatus.ERROR) {
                throw new IllegalArgumentException("Transaction " + this.getContext().getTxId() + " cannot be committed, because it is is an error state.");
            }
        }
        finally {
            this.status = TxStatus.CLOSED;
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rollback() {
        try {
            if (this.status == TxStatus.DIRTY || this.status == TxStatus.ERROR) {
                this.getSnapshot().rollback();
            }
        }
        finally {
            this.status = TxStatus.CLOSED;
            this.cleanup();
        }
    }

    protected abstract void cleanup();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> T withWriteLock(@NotNull Function0<? extends T> block) {
        Object object;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withWriteLock = false;
        if (this.getStatus() == TxStatus.CLOSED) {
            throw new TxException.TxClosedException(this.getContext().getTxId());
        }
        if (this.getStatus() == TxStatus.ERROR) {
            throw new TxException.TxInErrorException(this.getContext().getTxId());
        }
        this.getContext().requestLock(this.getDbo(), LockMode.EXCLUSIVE);
        this.status = TxStatus.DIRTY;
        ReentrantReadWriteLock reentrantReadWriteLock = this.getTxLatch();
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            object = block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T> T withReadLock(@NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$withReadLock = false;
        if (this.getStatus() == TxStatus.CLOSED) {
            throw new TxException.TxClosedException(this.getContext().getTxId());
        }
        if (this.getStatus() == TxStatus.ERROR) {
            throw new TxException.TxInErrorException(this.getContext().getTxId());
        }
        this.getContext().requestLock(this.getDbo(), LockMode.SHARED);
        ReentrantReadWriteLock reentrantReadWriteLock = this.getTxLatch();
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            object = block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }
}

