/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.gg;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SplittableRandom;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.index.gg.GGIndex;
import org.vitrivr.cottontail.database.index.gg.GGIndexConfig;
import org.vitrivr.cottontail.database.index.pq.PQIndex;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.operations.Operation;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.knn.KnnPredicate;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.functions.basics.Argument;
import org.vitrivr.cottontail.functions.basics.Function;
import org.vitrivr.cottontail.functions.basics.Signature;
import org.vitrivr.cottontail.functions.math.distance.Distances;
import org.vitrivr.cottontail.functions.math.distance.basics.VectorDistance;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.model.values.types.VectorValue;
import org.vitrivr.cottontail.utilities.math.KnnUtilities;
import org.vitrivr.cottontail.utilities.selection.ComparablePair;
import org.vitrivr.cottontail.utilities.selection.MinHeapSelection;
import org.vitrivr.cottontail.utilities.selection.MinSingleSelection;
import org.vitrivr.cottontail.utilities.selection.Selection;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0002*+B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006,"}, d2={"Lorg/vitrivr/cottontail/database/index/gg/GGIndex;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "config", "Lorg/vitrivr/cottontail/database/index/gg/GGIndexConfig;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/DefaultEntity;Lorg/vitrivr/cottontail/database/index/gg/GGIndexConfig;)V", "getConfig", "()Lorg/vitrivr/cottontail/database/index/gg/GGIndexConfig;", "groupsStore", "Lorg/mapdb/HTreeMap;", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "", "produces", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getProduces", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "cost-FdqVpck", "(Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;)[F", "newTx", "Lorg/vitrivr/cottontail/database/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class GGIndex
extends AbstractIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColumnDef<?>[] produces;
    @NotNull
    private final IndexType type;
    @NotNull
    private final GGIndexConfig config;
    @NotNull
    private final HTreeMap<VectorValue<?>, long[]> groupsStore;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    public static final String GG_INDEX_NAME = "cdb_gg_means";
    @NotNull
    private static final Logger LOGGER;

    public GGIndex(@NotNull Path path, @NotNull DefaultEntity parent, @Nullable GGIndexConfig config) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(path, parent);
        GroupSerializer groupSerializer = new GroupSerializer[]{KnnUtilities.INSTANCE.distanceColumnDef(this.getParent().getName())};
        this.produces = groupSerializer;
        this.type = IndexType.GG;
        DB dB = this.getStore();
        Serializer serializer2 = (Serializer)this.getColumns()[0].getType().serializerFactory();
        groupSerializer = Serializer.LONG_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"LONG_ARRAY");
        this.groupsStore = dB.hashMap(GG_INDEX_NAME, serializer2, (Serializer)groupSerializer).counterEnable().createOrOpen();
        boolean bl = this.getColumns().length == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "GGIndex only supports indexing a single column.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Atomic.Var configOnDisk = (Atomic.Var)this.getStore().atomicVar(GG_INDEX_NAME, (Serializer)GGIndexConfig.Serializer).createOrOpen();
        if (configOnDisk.get() == null) {
            this.config = config != null ? config : new GGIndexConfig(50, System.currentTimeMillis(), Distances.L2);
            configOnDisk.set((Object)this.getConfig());
        } else {
            Object object = configOnDisk.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configOnDisk.get()");
            this.config = (GGIndexConfig)object;
        }
        this.getStore().commit();
    }

    public /* synthetic */ GGIndex(Path path, DefaultEntity defaultEntity, GGIndexConfig gGIndexConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            gGIndexConfig = null;
        }
        this(path, defaultEntity, gGIndexConfig);
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public GGIndexConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof KnnPredicate && Intrinsics.areEqual(((KnnPredicate)predicate).getColumn(), this.getColumns()[0]) && Intrinsics.areEqual((Object)((KnnPredicate)predicate).getDistance().getSignature().getName(), (Object)this.getConfig().getDistance().getFunctionName());
    }

    @Override
    @NotNull
    public float[] cost-FdqVpck(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return Cost.Companion.getZERO-9E9yFcc();
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    static {
        Logger logger = LoggerFactory.getLogger(GGIndex.class);
        Intrinsics.checkNotNull((Object)logger);
        LOGGER = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/database/index/gg/GGIndex$Companion;", "", "()V", "GG_INDEX_NAME", "", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/database/index/gg/GGIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/index/gg/GGIndex;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "clear", "", "count", "", "filter", "", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "filterRange", "partitionIndex", "", "partitions", "rebuild", "update", "event", "Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation;", "cottontaildb"})
    private final class Tx
    extends AbstractIndex.Tx {
        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)GGIndex.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public long count() {
            long l;
            void this_$iv;
            AbstractTx abstractTx = this;
            GGIndex gGIndex = GGIndex.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                boolean bl3 = false;
                boolean bl4 = false;
                l = gGIndex.groupsStore.size();
            }
            finally {
                readLock.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void rebuild() {
            int n;
            int n2;
            void this_$iv;
            AbstractTx abstractTx = this;
            GGIndex gGIndex = GGIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                PQIndex.Companion.getLOGGER().debug("Rebuilding GG index {}", (Object)gGIndex.getName());
                EntityTx txn = (EntityTx)this.getContext().getTx(this.getDbo().getParent());
                boolean bl6 = false;
                Set remainingTids = new LinkedHashSet();
                boolean $i$f$emptyArray = false;
                Iterator<Record> $this$forEach$iv = txn.scan((ColumnDef[])((Object[])new ColumnDef[0]));
                boolean $i$f$forEach = false;
                Iterator<Record> iterator2 = $this$forEach$iv;
                boolean bl7 = false;
                Iterator<Record> iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    Record element$iv;
                    Record it = element$iv = iterator3.next();
                    boolean bl8 = false;
                    remainingTids.add(it.getTupleId());
                }
                int groupSize = (remainingTids.size() + gGIndex.getConfig().getNumGroups() - 1) / gGIndex.getConfig().getNumGroups();
                boolean bl9 = false;
                Set finishedTIds = new LinkedHashSet();
                SplittableRandom random = new SplittableRandom(gGIndex.getConfig().getSeed());
                gGIndex.groupsStore.clear();
                while (true) {
                    Collection collection = remainingTids;
                    boolean bl10 = false;
                    if (!(!collection.isEmpty())) break;
                    long groupSeedTid = ((Number)CollectionsKt.elementAt((Iterable)remainingTids, (int)random.nextInt(remainingTids.size()))).longValue();
                    Value groupSeedValue = txn.read(groupSeedTid, gGIndex.getColumns()).get(gGIndex.getColumns()[0]);
                    if (!(groupSeedValue instanceof VectorValue)) continue;
                    Argument.Typed[] bl8 = new Argument.Typed[]{new Argument.Typed(gGIndex.getColumns()[0].getType())};
                    Signature.Closed signature = new Signature.Closed(gGIndex.getConfig().getDistance().getFunctionName(), bl8, Type.Double.INSTANCE);
                    Function<?> function = gGIndex.getParent().getParent().getParent().getFunctions().obtain(signature);
                    boolean bl11 = function instanceof VectorDistance.Binary;
                    boolean bl12 = false;
                    boolean bl13 = false;
                    if (!bl11) {
                        boolean bl14 = false;
                        String string = "GGIndex rebuild failed: Function " + signature + " is not a vector distance function.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    MinHeapSelection<Comparable> knn = new MinHeapSelection<Comparable>(groupSize);
                    Iterable $this$forEach$iv2 = remainingTids;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        long tid = ((Number)element$iv).longValue();
                        boolean bl15 = false;
                        Record r = txn.read(tid, gGIndex.getColumns());
                        Value vec = r.get(gGIndex.getColumns()[0]);
                        if (!(vec instanceof VectorValue)) continue;
                        Value[] valueArray = new Value[]{vec};
                        double distance = ((DoubleValue)((VectorDistance.Binary)function).invoke(valueArray)).unbox-impl();
                        if (knn.getSize() >= groupSize) {
                            Object t = knn.peek();
                            Intrinsics.checkNotNull(t);
                            if (DoubleValue.compareTo-impl(((DoubleValue)((ComparablePair)t).getSecond()).unbox-impl(), DoubleValue.box-impl(distance)) <= 0) continue;
                        }
                        knn.offer(new ComparablePair<Pair, DoubleValue>(new Pair((Object)tid, (Object)vec), DoubleValue.box-impl(distance)));
                    }
                    VectorValue groupMean = ((VectorValue)groupSeedValue).new();
                    int n6 = 0;
                    List groupTids = new ArrayList();
                    n6 = 0;
                    int n7 = knn.getSize();
                    if (n6 < n7) {
                        do {
                            int i = n6++;
                            Pair element = (Pair)((ComparablePair)knn.get(i)).getFirst();
                            groupMean = groupMean.plus((VectorValue)element.getSecond());
                            groupTids.add(element.getFirst());
                            boolean bl16 = remainingTids.remove(element.getFirst());
                            boolean bl17 = false;
                            boolean bl18 = false;
                            if (!bl16) {
                                boolean bl19 = false;
                                String string = Intrinsics.stringPlus((String)gGIndex.getName().getSimple(), (Object)" processed an element that should have been removed by now.");
                                throw (Throwable)new IllegalStateException(string.toString());
                            }
                            bl16 = finishedTIds.add(element.getFirst());
                            bl17 = false;
                            bl18 = false;
                            if (bl16) continue;
                            boolean bl20 = false;
                            String string = Intrinsics.stringPlus((String)gGIndex.getName().getSimple(), (Object)" processed an element that was already processed.");
                            throw (Throwable)new IllegalStateException(string.toString());
                        } while (n6 < n7);
                    }
                    groupMean = groupMean.div(DoubleValue.box-impl(DoubleValue.constructor-impl((Number)knn.getSize())));
                    Map map2 = (Map)gGIndex.groupsStore;
                    long[] lArray = CollectionsKt.toLongArray((Collection)groupTids);
                    boolean bl21 = false;
                    map2.put(groupMean, lArray);
                }
                gGIndex.getDirtyField().compareAndSet(true, false);
                PQIndex.Companion.getLOGGER().debug("Rebuilding GGIndex {} complete.", (Object)gGIndex.getName());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n8 = n2++;
                    boolean bl22 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void update(@NotNull Operation.DataManagementOperation event) {
            int n;
            int n2;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractTx abstractTx = this;
            GGIndex gGIndex = GGIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                gGIndex.getDirtyField().compareAndSet(false, true);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void clear() {
            int n;
            int n2;
            void this_$iv;
            AbstractTx abstractTx = this;
            GGIndex gGIndex = GGIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                gGIndex.getDirtyField().compareAndSet(false, true);
                gGIndex.groupsStore.clear();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        @NotNull
        public Iterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new Iterator<Record>(predicate, GGIndex.this, this){
                @NotNull
                private final KnnPredicate predicate;
                @NotNull
                private final VectorValue<?> vector;
                @NotNull
                private final Lazy resultsQueue$delegate;
                final /* synthetic */ Predicate $predicate;
                final /* synthetic */ GGIndex this$0;
                final /* synthetic */ Tx this$1;
                {
                    Object object;
                    this.$predicate = $predicate;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    if (!(this.$predicate instanceof KnnPredicate) || !Intrinsics.areEqual((Object)((KnnPredicate)this.$predicate).getDistance().getSignature().getName(), (Object)this.this$0.getConfig().getDistance().getFunctionName())) {
                        throw new QueryException.UnsupportedPredicateException("Index '" + this.this$0.getName() + "' (GGIndex) does not support predicates of type '" + Reflection.getOrCreateKotlinClass(this.$predicate.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (KnnPredicate)this.$predicate;
                    this.resultsQueue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ArrayDeque<StandaloneRecord>>(this){
                        final /* synthetic */ filter.1 this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final ArrayDeque<StandaloneRecord> invoke() {
                            return filter.1.access$prepareResults(this.this$0);
                        }
                    }));
                    AbstractTx this_$iv = this.this$1;
                    boolean $i$f$withReadLock = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
                    boolean bl = false;
                    boolean bl2 = false;
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    readLock.lock();
                    try {
                        boolean bl3 = false;
                        boolean bl4 = false;
                        object = Unit.INSTANCE;
                    }
                    finally {
                        readLock.unlock();
                    }
                    Value value = this.predicate.getQuery().getValue();
                    boolean bl5 = value instanceof VectorValue;
                    boolean bl6 = false;
                    bl = false;
                    if (!bl5) {
                        boolean bl7 = false;
                        String string = "Bound value for query vector has wrong type (found = " + ((object = value) == null ? null : object.getType()) + ").";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    this.vector = (VectorValue)value;
                }

                private final ArrayDeque<StandaloneRecord> getResultsQueue() {
                    Lazy lazy = this.resultsQueue$delegate;
                    Object var2_2 = null;
                    boolean bl = false;
                    return (ArrayDeque)lazy.getValue();
                }

                public boolean hasNext() {
                    Collection collection = (Collection)this.getResultsQueue();
                    boolean bl = false;
                    return !collection.isEmpty();
                }

                @NotNull
                public Record next() {
                    return (Record)this.getResultsQueue().removeFirst();
                }

                private final ArrayDeque<StandaloneRecord> prepareResults() {
                    int considerNumGroups = (this.this$0.getConfig().getNumGroups() + 9) / 10;
                    EntityTx txn = (EntityTx)this.this$1.getContext().getTx(this.this$0.getParent());
                    Argument.Typed[] typedArray = new Argument.Typed[]{new Argument.Typed<?>(this.this$0.getColumns()[0].getType())};
                    Signature.Closed<R> signature = new Signature.Closed<R>(this.this$0.getConfig().getDistance().getFunctionName(), typedArray, Type.Double.INSTANCE);
                    Function<?> function = this.this$0.getParent().getParent().getParent().getFunctions().obtain(signature);
                    boolean bl = function instanceof VectorDistance.Binary;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Function " + signature + " is not a vector distance function.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    bl = (long)this.predicate.getK() < txn.maxTupleId() / (long)this.this$0.getConfig().getNumGroups() * (long)considerNumGroups;
                    bl2 = false;
                    bl3 = false;
                    if (!bl) {
                        boolean bl5 = false;
                        String string = "Value of k is too large for this index considering " + considerNumGroups + " groups.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    MinHeapSelection<Comparable> groupKnn = new MinHeapSelection<Comparable>(considerNumGroups);
                    GGIndex.Companion.getLOGGER().debug("Scanning group mean signals.");
                    Map $this$forEach$iv = (Map)GGIndex.access$getGroupsStore$p(this.this$0);
                    int $i$f$forEach = 0;
                    Map map2 = $this$forEach$iv;
                    int n = 0;
                    Object object = map2.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> it = element$iv = object.next();
                        boolean bl6 = false;
                        Object object2 = it.getValue();
                        Intrinsics.checkNotNullExpressionValue(object2, (String)"it.value");
                        V v = object2;
                        object2 = new Value[]{(Value)it.getKey()};
                        groupKnn.offer(new ComparablePair<V, Comparable>(v, (Comparable)((VectorDistance.Binary)function).invoke((Value)object2)));
                    }
                    Selection knn = this.predicate.getK() == 1 ? (Selection)new MinSingleSelection<T>() : (Selection)new MinHeapSelection<T>(this.predicate.getK());
                    GGIndex.Companion.getLOGGER().debug("Scanning group members.");
                    $i$f$forEach = 0;
                    int n2 = groupKnn.getSize();
                    if ($i$f$forEach < n2) {
                        do {
                            int k = $i$f$forEach++;
                            object = (long[])((ComparablePair)groupKnn.get(k)).getFirst();
                            int n3 = 0;
                            int n4 = ((Object)object).length;
                            while (n3 < n4) {
                                Object tupleId = object[n3];
                                ++n3;
                                Value value = txn.read((long)tupleId, this.this$0.getColumns()).get(this.this$0.getColumns()[0]);
                                if (!(value instanceof VectorValue)) continue;
                                Value[] valueArray = new Value[]{value};
                                double distance = ((DoubleValue)((VectorDistance.Binary)function).invoke(valueArray)).unbox-impl();
                                if (knn.getSize() >= knn.getK()) {
                                    T t = knn.peek();
                                    Intrinsics.checkNotNull(t);
                                    if (DoubleValue.compareTo-impl(((DoubleValue)((ComparablePair)t).getSecond()).unbox-impl(), DoubleValue.box-impl(distance)) <= 0) continue;
                                }
                                knn.offer((Comparable)new ComparablePair<Long, DoubleValue>((long)tupleId, DoubleValue.box-impl(distance)));
                            }
                        } while ($i$f$forEach < n2);
                    }
                    ArrayDeque queue = new ArrayDeque(this.predicate.getK());
                    n2 = 0;
                    n = knn.getSize();
                    if (n2 < n) {
                        do {
                            int i = n2++;
                            Value[] valueArray = new Value[]{(Value)((ComparablePair)knn.get(i)).getSecond()};
                            queue.add((Object)new StandaloneRecord(((Number)((ComparablePair)knn.get(i)).getFirst()).longValue(), this.this$0.getProduces(), valueArray));
                        } while (n2 < n);
                    }
                    return queue;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }

                public static final /* synthetic */ ArrayDeque access$prepareResults(filter.1 $this) {
                    return $this.prepareResults();
                }
            };
        }

        @Override
        @NotNull
        public Iterator<Record> filterRange(@NotNull Predicate predicate, int partitionIndex, int partitions) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            throw new UnsupportedOperationException("The UniqueHashIndex does not support ranged filtering!");
        }
    }
}

