/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.lsh.superbit;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.index.lsh.superbit.SamplingMethod;
import org.vitrivr.cottontail.model.values.Complex32VectorValue;
import org.vitrivr.cottontail.model.values.Complex64VectorValue;
import org.vitrivr.cottontail.model.values.DoubleVectorValue;
import org.vitrivr.cottontail.model.values.FloatVectorValue;
import org.vitrivr.cottontail.model.values.types.ComplexVectorValue;
import org.vitrivr.cottontail.model.values.types.NumericValue;
import org.vitrivr.cottontail.model.values.types.VectorValue;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\nJ\u0012\u0010\u001e\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001a\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u001b\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBit;", "Ljava/io/Serializable;", "N", "", "L", "seed", "", "samplingMethod", "Lorg/vitrivr/cottontail/database/index/lsh/superbit/SamplingMethod;", "species", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "(IIJLorg/vitrivr/cottontail/database/index/lsh/superbit/SamplingMethod;Lorg/vitrivr/cottontail/model/values/types/VectorValue;)V", "getL", "()I", "getN", "_hyperplanes", "", "[Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "d", "getD", "hyperplanes", "getHyperplanes", "()[Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "getSamplingMethod", "()Lorg/vitrivr/cottontail/database/index/lsh/superbit/SamplingMethod;", "getSeed", "()J", "signature", "", "vector", "signatureComplex", "Lorg/vitrivr/cottontail/model/values/types/ComplexVectorValue;", "cottontaildb"})
public final class SuperBit
implements Serializable {
    private final int N;
    private final int L;
    private final long seed;
    @NotNull
    private final SamplingMethod samplingMethod;
    private final int d;
    @NotNull
    private final VectorValue<?>[] _hyperplanes;

    public SuperBit(int N, int L, long seed, @NotNull SamplingMethod samplingMethod, @NotNull VectorValue<?> species) {
        VectorValue[] vectorValueArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)samplingMethod), (String)"samplingMethod");
        Intrinsics.checkNotNullParameter(species, (String)"species");
        this.N = N;
        this.L = L;
        this.seed = seed;
        this.samplingMethod = samplingMethod;
        this.d = species.getLogicalSize();
        boolean bl = this.d > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Dimension d must be >= 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.N >= 1 && this.N <= this.d;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Super-Bit depth N must be 1 <= N <= d";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.L >= 1;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Number of Super-Bits L must be >= 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int K = this.N * this.L;
        SamplingMethod samplingMethod2 = this.samplingMethod;
        int n2 = WhenMappings.$EnumSwitchMapping$0[samplingMethod2.ordinal()];
        switch (n2) {
            case 1: {
                VectorValue rnd;
                int n3;
                VectorValue[] vectorValueArray2;
                int n4;
                Object[] objectArray;
                int n5;
                int n6;
                VectorValue<?> vectorValue;
                int n7;
                int n8;
                RandomGenerator random = new SplittableRandom(this.seed);
                n = K;
                VectorValue[] vectorValueArray3 = new VectorValue[n];
                for (n8 = 0; n8 < n; ++n8) {
                    VectorValue<Double> vectorValue2;
                    int n9;
                    VectorValue[] vectorValueArray4;
                    n7 = n8;
                    vectorValue = species;
                    if (vectorValue instanceof DoubleVectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize();
                        objectArray = new double[n5];
                        n4 = n7;
                        vectorValueArray2 = vectorValueArray3;
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = random.nextDouble() - 0.5;
                        }
                        vectorValueArray4 = vectorValueArray2;
                        n9 = n4;
                        vectorValue2 = DoubleVectorValue.box-impl(DoubleVectorValue.constructor-impl(objectArray));
                    } else if (vectorValue instanceof FloatVectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize();
                        objectArray = new float[n5];
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = (float)(random.nextDouble() - 0.5);
                        }
                        vectorValueArray4 = vectorValueArray2;
                        n9 = n4;
                        vectorValue2 = FloatVectorValue.box-impl(FloatVectorValue.constructor-impl((float[])objectArray));
                    } else if (vectorValue instanceof Complex32VectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize() * 2;
                        objectArray = new float[n5];
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = (float)(random.nextDouble() - 0.5);
                        }
                        vectorValueArray4 = vectorValueArray2;
                        n9 = n4;
                        vectorValue2 = Complex32VectorValue.box-impl(Complex32VectorValue.constructor-impl((float[])objectArray));
                    } else if (vectorValue instanceof Complex64VectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize() * 2;
                        objectArray = new double[n5];
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = random.nextDouble() - 0.5;
                        }
                        vectorValueArray4 = vectorValueArray2;
                        n9 = n4;
                        vectorValue2 = Complex64VectorValue.box-impl(Complex64VectorValue.constructor-impl(objectArray));
                    } else {
                        throw new IllegalArgumentException("Unsupported vector type");
                    }
                    rnd = vectorValue2;
                    vectorValueArray4[n9] = rnd.div((NumericValue)rnd.norm2());
                }
                vectorValueArray = vectorValueArray3;
                break;
            }
            case 2: {
                VectorValue rnd;
                int n3;
                VectorValue[] vectorValueArray2;
                int n4;
                Object[] objectArray;
                int n5;
                int n6;
                VectorValue<?> vectorValue;
                int n7;
                int n8;
                RandomGenerator random = new Random(this.seed);
                n = K;
                VectorValue[] vectorValueArray3 = new VectorValue[n];
                for (n8 = 0; n8 < n; ++n8) {
                    VectorValue<Double> vectorValue3;
                    int n10;
                    VectorValue[] vectorValueArray5;
                    n7 = n8;
                    vectorValue = species;
                    if (vectorValue instanceof DoubleVectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize();
                        objectArray = new double[n5];
                        n4 = n7;
                        vectorValueArray2 = vectorValueArray3;
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = ((Random)random).nextGaussian();
                        }
                        vectorValueArray5 = vectorValueArray2;
                        n10 = n4;
                        vectorValue3 = DoubleVectorValue.box-impl(DoubleVectorValue.constructor-impl(objectArray));
                    } else if (vectorValue instanceof FloatVectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize();
                        objectArray = new float[n5];
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = (float)((Random)random).nextGaussian();
                        }
                        vectorValueArray5 = vectorValueArray2;
                        n10 = n4;
                        vectorValue3 = FloatVectorValue.box-impl(FloatVectorValue.constructor-impl((float[])objectArray));
                    } else if (vectorValue instanceof Complex32VectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize() * 2;
                        objectArray = new float[n5];
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = (float)((Random)random).nextGaussian();
                        }
                        vectorValueArray5 = vectorValueArray2;
                        n10 = n4;
                        vectorValue3 = Complex32VectorValue.box-impl(Complex32VectorValue.constructor-impl((float[])objectArray));
                    } else if (vectorValue instanceof Complex64VectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize() * 2;
                        objectArray = new double[n5];
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = ((Random)random).nextGaussian();
                        }
                        vectorValueArray5 = vectorValueArray2;
                        n10 = n4;
                        vectorValue3 = Complex64VectorValue.box-impl(Complex64VectorValue.constructor-impl(objectArray));
                    } else {
                        throw new IllegalArgumentException("Unsupported vector type");
                    }
                    rnd = vectorValue3;
                    vectorValueArray5[n10] = rnd.div((NumericValue)rnd.norm2());
                }
                vectorValueArray = vectorValueArray3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        VectorValue[] v = vectorValueArray;
        n2 = 0;
        int n11 = K;
        VectorValue[] vectorValueArray6 = new VectorValue[n11];
        while (n2 < n11) {
            n = n2++;
            vectorValueArray6[n] = v[n];
        }
        VectorValue[] w = vectorValueArray6;
        n2 = 0;
        n11 = this.L;
        if (n2 < n11) {
            do {
                int j;
                int i = n2++;
                n = 1;
                int n12 = this.N;
                if (n > n12) continue;
                do {
                    int n13;
                    if ((n13 = 1) < (j = n++)) {
                        do {
                            int k = n13++;
                            w[i * this.N + j - 1] = w[i * this.N + j - 1].minus(w[i * this.N + k - 1].times(w[i * this.N + j - 1].dot(v[i * this.N + k - 1])));
                        } while (n13 < j);
                    }
                    w[i * this.N + j - 1] = w[i * this.N + j - 1].div((NumericValue)w[i * this.N + j - 1].norm2());
                } while (j != n12);
            } while (n2 < n11);
        }
        this._hyperplanes = w;
    }

    public final int getN() {
        return this.N;
    }

    public final int getL() {
        return this.L;
    }

    public final long getSeed() {
        return this.seed;
    }

    @NotNull
    public final SamplingMethod getSamplingMethod() {
        return this.samplingMethod;
    }

    public final int getD() {
        return this.d;
    }

    @NotNull
    public final VectorValue<?>[] getHyperplanes() {
        VectorValue<?>[] vectorValueArray = this._hyperplanes;
        boolean bl = false;
        VectorValue<?>[] vectorValueArray2 = Arrays.copyOf(vectorValueArray, vectorValueArray.length);
        Intrinsics.checkNotNullExpressionValue(vectorValueArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return vectorValueArray2;
    }

    @NotNull
    public final boolean[] signature(@NotNull VectorValue<?> vector) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        boolean[] signature = new boolean[this._hyperplanes.length];
        int n = 0;
        int n2 = this._hyperplanes.length + -1;
        if (n <= n2) {
            do {
                int i;
                boolean bl = signature[i] = this._hyperplanes[i = n++].dot(vector).asInt-HuW2oqM() >= 0;
            } while (n <= n2);
        }
        return signature;
    }

    @NotNull
    public final boolean[] signatureComplex(@NotNull ComplexVectorValue<?> vector) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        int n = this._hyperplanes.length;
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            blArray[n2] = n2 % 2 == 0 ? this._hyperplanes[n2].dot((VectorValue)vector).getReal().asInt-HuW2oqM() >= 0 : this._hyperplanes[n2].dot((VectorValue)vector).getImaginary().asInt-HuW2oqM() >= 0;
        }
        return blArray;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SamplingMethod.values().length];
            nArray[SamplingMethod.UNIFORM.ordinal()] = 1;
            nArray[SamplingMethod.GAUSSIAN.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

