/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.binding;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.queries.binding.Binding;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B1\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0001H\u0016J(\u0010\u0014\u001a\u00020\u00152\u001e\u0010\u0016\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00150\u0017H\u0016J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00182\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0096\u0002J\u0014\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0014\u0010\u001f\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u001f\u0010 \u001a\u00020\u00152\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010!\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\u0018\u0010\"\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u00180#H\u0016R \u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006$"}, d2={"Lorg/vitrivr/cottontail/database/queries/binding/RecordBinding;", "Lorg/vitrivr/cottontail/model/basics/Record;", "tupleId", "", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "values", "Lorg/vitrivr/cottontail/database/queries/binding/Binding;", "(J[Lorg/vitrivr/cottontail/database/column/ColumnDef;[Lorg/vitrivr/cottontail/database/queries/binding/Binding;)V", "getColumns", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getTupleId", "()J", "setTupleId", "(J)V", "[Lorg/vitrivr/cottontail/database/queries/binding/Binding;", "copy", "forEach", "", "action", "Lkotlin/Function2;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "get", "columnIndex", "", "column", "has", "", "indexOf", "set", "value", "toMap", "", "cottontaildb"})
public final class RecordBinding
implements Record {
    private long tupleId;
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    private final Binding[] values;

    public RecordBinding(long tupleId, @NotNull ColumnDef<?>[] columns, @NotNull Binding[] values) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.tupleId = tupleId;
        this.columns = columns;
        this.values = values;
    }

    @Override
    public long getTupleId() {
        return this.tupleId;
    }

    @Override
    public void setTupleId(long l) {
        this.tupleId = l;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    @Override
    @NotNull
    public Record copy() {
        long l = this.getTupleId();
        Object[] objectArray = this.getColumns();
        boolean bl = false;
        ColumnDef<?>[] columnDefArray = Arrays.copyOf(objectArray, objectArray.length);
        Intrinsics.checkNotNullExpressionValue(columnDefArray, (String)"java.util.Arrays.copyOf(this, size)");
        objectArray = this.values;
        bl = false;
        Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return new RecordBinding(l, columnDefArray, (Binding[])objectArray2);
    }

    @Override
    public void forEach(@NotNull Function2<? super ColumnDef<?>, ? super Value, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ColumnDef<?>[] columnDefArray = this.getColumns();
        int n = columnDefArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            ColumnDef<?> c = columnDefArray[i];
            action.invoke(c, (Object)this.values[i2].getValue());
        }
    }

    @Override
    public boolean has(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return ArraysKt.contains((Object[])this.getColumns(), column);
    }

    @Override
    public int indexOf(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return ArraysKt.indexOf((Object[])this.getColumns(), column);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<ColumnDef<?>, Value> toMap() {
        Collection<Value> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Binding[] bindingArray = this.values;
        Object[] objectArray = this.getColumns();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var6_7 = $this$mapTo$iv$iv;
        int n = ((void)var6_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = var6_7[i];
            collection = destination$iv$iv;
            boolean bl = false;
            Value value = it.getValue();
            collection.add(value);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray2 = thisCollection$iv.toArray(new Value[0]);
        if (objectArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray3 = objectArray2;
        Object[] objectArray4 = objectArray;
        return (Map)new Object2ObjectArrayMap(objectArray4, objectArray3);
    }

    @Override
    @Nullable
    public Value get(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return this.get(ArraysKt.indexOf((Object[])this.getColumns(), column));
    }

    @Nullable
    public final Value get(int columnIndex) {
        boolean bl = 0 <= columnIndex ? columnIndex < this.getSize() : false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The specified column " + columnIndex + " is out of bounds.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.values[columnIndex].getValue();
    }

    @Override
    public void set(@NotNull ColumnDef<?> column, @Nullable Value value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        throw new UnsupportedOperationException("A bound record cannot be updated with new value.");
    }

    @Override
    public int getSize() {
        return Record.DefaultImpls.getSize(this);
    }
}

