/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.predicates.bool;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.queries.binding.Binding;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.bool.ComparisonOperator;
import org.vitrivr.cottontail.database.queries.predicates.bool.ConnectionOperator;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.utilities.extensions.BooleanMathExtensionKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u0005\u0010\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "()V", "atomics", "", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic;", "getAtomics", "()Ljava/util/Set;", "isMatch", "", "score", "", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "Atomic", "Compound", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Compound;", "cottontaildb"})
public abstract class BooleanPredicate
implements Predicate {
    private BooleanPredicate() {
    }

    @NotNull
    public abstract Set<Atomic> getAtomics();

    public abstract boolean isMatch();

    public abstract double score(@NotNull Record var1);

    public /* synthetic */ BooleanPredicate(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\b\u0002\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\u0007H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic;", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;", "operator", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/ComparisonOperator;", "not", "", "dependsOn", "", "Lorg/vitrivr/cottontail/database/queries/GroupId;", "(Lorg/vitrivr/cottontail/database/queries/predicates/bool/ComparisonOperator;ZI)V", "atomicCpuCost", "", "getAtomicCpuCost", "()F", "atomics", "", "getAtomics", "()Ljava/util/Set;", "columns", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumns", "()Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "getDependsOn", "()I", "getNot", "()Z", "getOperator", "()Lorg/vitrivr/cottontail/database/queries/predicates/bool/ComparisonOperator;", "digest", "", "equals", "other", "", "hashCode", "isMatch", "score", "", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "toString", "", "cottontaildb"})
    public static final class Atomic
    extends BooleanPredicate {
        @NotNull
        private final ComparisonOperator operator;
        private final boolean not;
        private final int dependsOn;
        @NotNull
        private final ObjectOpenHashSet<ColumnDef<?>> columns;

        public Atomic(@NotNull ComparisonOperator operator2, boolean not, int dependsOn) {
            Intrinsics.checkNotNullParameter((Object)operator2, (String)"operator");
            super(null);
            this.operator = operator2;
            this.not = not;
            this.dependsOn = dependsOn;
            this.columns = new ObjectOpenHashSet();
            ComparisonOperator comparisonOperator = this.operator;
            if (comparisonOperator instanceof ComparisonOperator.Binary) {
                if (this.operator.getLeft() instanceof Binding.Column) {
                    this.getColumns().add(((Binding.Column)this.operator.getLeft()).getColumn());
                }
                if (((ComparisonOperator.Binary)this.operator).getRight() instanceof Binding.Column) {
                    this.getColumns().add(((Binding.Column)((ComparisonOperator.Binary)this.operator).getRight()).getColumn());
                }
            } else if (comparisonOperator instanceof ComparisonOperator.Between) {
                if (this.operator.getLeft() instanceof Binding.Column) {
                    this.getColumns().add(((Binding.Column)this.operator.getLeft()).getColumn());
                }
                if (((ComparisonOperator.Between)this.operator).getRightLower() instanceof Binding.Column) {
                    this.getColumns().add(((Binding.Column)((ComparisonOperator.Between)this.operator).getRightLower()).getColumn());
                }
                if (((ComparisonOperator.Between)this.operator).getRightUpper() instanceof Binding.Column) {
                    this.getColumns().add(((Binding.Column)((ComparisonOperator.Between)this.operator).getRightUpper()).getColumn());
                }
            } else if (comparisonOperator instanceof ComparisonOperator.In) {
                if (this.operator.getLeft() instanceof Binding.Column) {
                    this.getColumns().add(((Binding.Column)this.operator.getLeft()).getColumn());
                }
            } else if (comparisonOperator instanceof ComparisonOperator.IsNull && this.operator.getLeft() instanceof Binding.Column) {
                this.getColumns().add(((Binding.Column)this.operator.getLeft()).getColumn());
            }
        }

        public /* synthetic */ Atomic(ComparisonOperator comparisonOperator, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            this(comparisonOperator, bl, n);
        }

        @NotNull
        public final ComparisonOperator getOperator() {
            return this.operator;
        }

        public final boolean getNot() {
            return this.not;
        }

        public final int getDependsOn() {
            return this.dependsOn;
        }

        @Override
        public float getAtomicCpuCost() {
            return this.operator.getAtomicCpuCost();
        }

        @NotNull
        public ObjectOpenHashSet<ColumnDef<?>> getColumns() {
            return this.columns;
        }

        @Override
        @NotNull
        public Set<Atomic> getAtomics() {
            return SetsKt.setOf((Object)this);
        }

        @Override
        public double score(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            return BooleanMathExtensionKt.toDouble(this.isMatch());
        }

        @Override
        public long digest() {
            return 33L * (long)this.hashCode();
        }

        @Override
        public boolean isMatch() {
            return !this.not && this.operator.match() || this.not && !this.operator.match();
        }

        @NotNull
        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.not) {
                builder.append("!(");
            }
            builder.append(this.operator.toString());
            if (this.not) {
                builder.append(")");
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            return string;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Atomic)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.operator, (Object)((Atomic)other).operator)) {
                return false;
            }
            return this.not == ((Atomic)other).not;
        }

        public int hashCode() {
            int result = this.operator.hashCode();
            result = 31 * result + Boolean.hashCode(this.not);
            return result;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u0006'"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Compound;", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;", "connector", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/ConnectionOperator;", "p1", "p2", "(Lorg/vitrivr/cottontail/database/queries/predicates/bool/ConnectionOperator;Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;)V", "atomicCpuCost", "", "getAtomicCpuCost", "()F", "atomics", "", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic;", "getAtomics", "()Ljava/util/Set;", "columns", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumns", "getConnector", "()Lorg/vitrivr/cottontail/database/queries/predicates/bool/ConnectionOperator;", "getP1", "()Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;", "getP2", "digest", "", "equals", "", "other", "", "hashCode", "", "isMatch", "score", "", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "toString", "", "cottontaildb"})
    public static final class Compound
    extends BooleanPredicate {
        @NotNull
        private final ConnectionOperator connector;
        @NotNull
        private final BooleanPredicate p1;
        @NotNull
        private final BooleanPredicate p2;

        public Compound(@NotNull ConnectionOperator connector, @NotNull BooleanPredicate p1, @NotNull BooleanPredicate p2) {
            Intrinsics.checkNotNullParameter((Object)((Object)connector), (String)"connector");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
            super(null);
            this.connector = connector;
            this.p1 = p1;
            this.p2 = p2;
        }

        @NotNull
        public final ConnectionOperator getConnector() {
            return this.connector;
        }

        @NotNull
        public final BooleanPredicate getP1() {
            return this.p1;
        }

        @NotNull
        public final BooleanPredicate getP2() {
            return this.p2;
        }

        @Override
        public float getAtomicCpuCost() {
            return this.p1.getAtomicCpuCost() + this.p2.getAtomicCpuCost();
        }

        @Override
        @NotNull
        public Set<Atomic> getAtomics() {
            return SetsKt.plus(this.p1.getAtomics(), (Iterable)this.p2.getAtomics());
        }

        @Override
        @NotNull
        public Set<ColumnDef<?>> getColumns() {
            return SetsKt.plus(this.p1.getColumns(), (Iterable)this.p2.getColumns());
        }

        @Override
        public boolean isMatch() {
            boolean bl;
            ConnectionOperator connectionOperator = this.connector;
            int n = WhenMappings.$EnumSwitchMapping$0[connectionOperator.ordinal()];
            switch (n) {
                case 1: {
                    if (this.p1.isMatch() && this.p2.isMatch()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    if (this.p1.isMatch() || this.p2.isMatch()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return bl;
        }

        @Override
        public double score(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            return this.connector == ConnectionOperator.AND && this.p1.isMatch() && this.p2.isMatch() ? 1.0 : (this.connector == ConnectionOperator.OR ? (this.p1.score(record) + this.p2.score(record)) / 2.0 : 0.0);
        }

        @NotNull
        public String toString() {
            return "" + this.p1 + ' ' + (Object)((Object)this.connector) + ' ' + this.p2;
        }

        @Override
        public long digest() {
            return 33L * (long)this.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Compound)) {
                return false;
            }
            if (this.connector != ((Compound)other).connector) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.p1, (Object)((Compound)other).p1)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.p2, (Object)((Compound)other).p2);
        }

        public int hashCode() {
            int result = this.connector.hashCode();
            result = 31 * result + this.p1.hashCode();
            result = 31 * result + this.p2.hashCode();
            return result;
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ConnectionOperator.values().length];
                nArray[ConnectionOperator.AND.ordinal()] = 1;
                nArray[ConnectionOperator.OR.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

