/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.statistics.columns;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.vitrivr.cottontail.database.statistics.columns.ValueStatistics;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.types.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0000H\u0016J\u001d\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\b\u0016J\u001d\u0010\u0017\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u0014H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\tR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0007\"\u0004\b\u0011\u0010\t\u00f8\u0001\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/database/statistics/columns/DoubleValueStatistics;", "Lorg/vitrivr/cottontail/database/statistics/columns/ValueStatistics;", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "()V", "max", "", "getMax", "()D", "setMax", "(D)V", "mean", "getMean", "min", "getMin", "setMin", "sum", "getSum", "setSum", "copy", "delete", "", "deleted", "delete-0taYP3Q", "insert", "inserted", "insert-0taYP3Q", "reset", "Serializer", "cottontaildb"})
public final class DoubleValueStatistics
extends ValueStatistics<DoubleValue> {
    @NotNull
    public static final Serializer Serializer = new Serializer(null);
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;
    private double sum;

    public DoubleValueStatistics() {
        super(Type.Double.INSTANCE);
    }

    public final double getMin() {
        return this.min;
    }

    public final void setMin(double d) {
        this.min = d;
    }

    public final double getMax() {
        return this.max;
    }

    public final void setMax(double d) {
        this.max = d;
    }

    public final double getSum() {
        return this.sum;
    }

    public final void setSum(double d) {
        this.sum = d;
    }

    public final double getMean() {
        return this.sum / (double)this.getNumberOfNonNullEntries();
    }

    public void insert-0taYP3Q(@Nullable DoubleValue inserted) {
        super.insert((Value)inserted);
        if (inserted != null) {
            this.min = Double.min(inserted.unbox-impl(), this.min);
            this.max = Double.max(inserted.unbox-impl(), this.max);
            DoubleValueStatistics doubleValueStatistics = this;
            doubleValueStatistics.sum += inserted.unbox-impl();
        }
    }

    public void delete-0taYP3Q(@Nullable DoubleValue deleted) {
        super.delete((Value)deleted);
        if (deleted != null) {
            DoubleValueStatistics doubleValueStatistics = this;
            doubleValueStatistics.sum -= deleted.unbox-impl();
            if (this.min == deleted.unbox-impl() || this.max == deleted.unbox-impl()) {
                this.setFresh(false);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
        this.sum = 0.0;
    }

    @NotNull
    public DoubleValueStatistics copy() {
        DoubleValueStatistics copy = new DoubleValueStatistics();
        copy.setFresh(this.getFresh());
        copy.setNumberOfNullEntries(this.getNumberOfNullEntries());
        copy.setNumberOfNonNullEntries(this.getNumberOfNonNullEntries());
        copy.min = this.min;
        copy.max = this.max;
        copy.sum = this.sum;
        return copy;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/statistics/columns/DoubleValueStatistics$Serializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/database/statistics/columns/DoubleValueStatistics;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb"})
    public static final class Serializer
    implements org.mapdb.Serializer<DoubleValueStatistics> {
        private Serializer() {
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull DoubleValueStatistics value) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            out.writeDouble(value.getMin());
            out.writeDouble(value.getMax());
            out.writeDouble(value.getSum());
        }

        @NotNull
        public DoubleValueStatistics deserialize(@NotNull DataInput2 input, int available) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            DoubleValueStatistics stat = new DoubleValueStatistics();
            stat.setMin(input.readDouble());
            stat.setMax(input.readDouble());
            stat.setSum(input.readDouble());
            return stat;
        }

        public /* synthetic */ Serializer(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

