/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.execution;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.Tx;
import org.vitrivr.cottontail.database.locking.Lock;
import org.vitrivr.cottontail.database.locking.LockHolder;
import org.vitrivr.cottontail.database.locking.LockManager;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.operations.Operation;
import org.vitrivr.cottontail.execution.Transaction;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.execution.TransactionStatus;
import org.vitrivr.cottontail.execution.TransactionType;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.model.basics.Record;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001b\u0010\u0018\u001a\b\u0018\u00010\u000fR\u00020\u00002\n\u0010\u0019\u001a\u00060\u0016j\u0002`\u001aH\u0086\u0002R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RE\u0010\r\u001a6\u0012\u0014\u0012\u0012 \u0010*\b\u0018\u00010\u000fR\u00020\u00000\u000fR\u00020\u0000 \u0010*\u001a\u0012\u0014\u0012\u0012 \u0010*\b\u0018\u00010\u000fR\u00020\u00000\u000fR\u00020\u0000\u0018\u00010\u00110\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R^\u0010\u0014\u001aR\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00160\u0016\u0012\u0014\u0012\u0012 \u0010*\b\u0018\u00010\u000fR\u00020\u00000\u000fR\u00020\u0000 \u0010*(\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00160\u0016\u0012\u0014\u0012\u0012 \u0010*\b\u0018\u00010\u000fR\u00020\u00000\u000fR\u00020\u0000\u0018\u00010\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/vitrivr/cottontail/execution/TransactionManager;", "", "transactionTableSize", "", "transactionHistorySize", "(II)V", "lockManager", "Lorg/vitrivr/cottontail/database/locking/LockManager;", "Lorg/vitrivr/cottontail/database/general/DBO;", "getLockManager", "()Lorg/vitrivr/cottontail/database/locking/LockManager;", "tidCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "transactionHistory", "", "Lorg/vitrivr/cottontail/execution/TransactionManager$TransactionImpl;", "kotlin.jvm.PlatformType", "", "getTransactionHistory", "()Ljava/util/List;", "transactions", "", "", "", "get", "txId", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "Companion", "TransactionImpl", "cottontaildb"})
public final class TransactionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int transactionHistorySize;
    private final Map<Long, TransactionImpl> transactions;
    @NotNull
    private final AtomicLong tidCounter;
    @NotNull
    private final LockManager<DBO> lockManager;
    private final List<TransactionImpl> transactionHistory;
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionManager.class);

    public TransactionManager(int transactionTableSize, int transactionHistorySize) {
        this.transactionHistorySize = transactionHistorySize;
        this.transactions = Collections.synchronizedMap((Map)new Long2ObjectOpenHashMap(transactionTableSize, 0.25f));
        this.tidCounter = new AtomicLong(1L);
        this.lockManager = new LockManager();
        this.transactionHistory = Collections.synchronizedList(new LinkedList());
    }

    @NotNull
    public final LockManager<DBO> getLockManager() {
        return this.lockManager;
    }

    public final List<TransactionImpl> getTransactionHistory() {
        return this.transactionHistory;
    }

    @Nullable
    public final TransactionImpl get(long txId) {
        return this.transactions.get(txId);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/execution/TransactionManager$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010-\u001a\u00020.H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020.2\u0006\u00105\u001a\u00020 H\u0002J\u0010\u00106\u001a\u00020*2\u0006\u00107\u001a\u00020\u0002H\u0016J\b\u00108\u001a\u00020.H\u0016J\b\u00109\u001a\u00020.H\u0002J\b\u0010:\u001a\u00020.H\u0002J\u0018\u0010;\u001a\u00020.2\u0006\u00107\u001a\u00020\u00022\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020.H\u0016J\u0010\u0010?\u001a\u00020.2\u0006\u0010@\u001a\u00020AH\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u001e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u001e\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019R\u001e\u0010!\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020 @RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001e\u0010%\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020$@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006B"}, d2={"Lorg/vitrivr/cottontail/execution/TransactionManager$TransactionImpl;", "Lorg/vitrivr/cottontail/database/locking/LockHolder;", "Lorg/vitrivr/cottontail/database/general/DBO;", "Lorg/vitrivr/cottontail/execution/Transaction;", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "type", "Lorg/vitrivr/cottontail/execution/TransactionType;", "(Lorg/vitrivr/cottontail/execution/TransactionManager;Lorg/vitrivr/cottontail/execution/TransactionType;)V", "activeContexts", "Ljava/util/HashSet;", "Lkotlin/coroutines/CoroutineContext;", "created", "", "getCreated", "()J", "<set-?>", "ended", "getEnded", "()Ljava/lang/Long;", "Ljava/lang/Long;", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "", "numberOfError", "getNumberOfError", "()I", "numberOfOngoing", "getNumberOfOngoing", "numberOfSuccess", "getNumberOfSuccess", "numberOfTxs", "getNumberOfTxs", "", "readonly", "getReadonly", "()Z", "Lorg/vitrivr/cottontail/execution/TransactionStatus;", "state", "getState", "()Lorg/vitrivr/cottontail/execution/TransactionStatus;", "txns", "", "Lorg/vitrivr/cottontail/database/general/Tx;", "getType", "()Lorg/vitrivr/cottontail/execution/TransactionType;", "commit", "", "execute", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/model/basics/Record;", "operator", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator;", "finalize", "committed", "getTx", "dbo", "kill", "performCommit", "performRollback", "requestLock", "mode", "Lorg/vitrivr/cottontail/database/locking/LockMode;", "rollback", "signalEvent", "action", "Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation;", "cottontaildb"})
    public final class TransactionImpl
    extends LockHolder<DBO>
    implements Transaction,
    TransactionContext {
        @NotNull
        private final TransactionType type;
        @NotNull
        private volatile TransactionStatus state;
        @NotNull
        private final Map<DBO, Tx> txns;
        @NotNull
        private final Mutex mutex;
        private final long created;
        @Nullable
        private Long ended;
        private volatile int numberOfSuccess;
        private volatile int numberOfError;
        @NotNull
        private final HashSet<CoroutineContext> activeContexts;
        private boolean readonly;

        public TransactionImpl(TransactionType type) {
            Intrinsics.checkNotNullParameter((Object)TransactionManager.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            super(TransactionManager.this.tidCounter.getAndIncrement());
            this.type = type;
            this.state = TransactionStatus.IDLE;
            Object object = Object2ObjectMaps.synchronize((Object2ObjectMap)((Object2ObjectMap)new Object2ObjectLinkedOpenHashMap()));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"synchronize(Object2ObjectLinkedOpenHashMap())");
            this.txns = (Map)object;
            this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
            this.created = System.currentTimeMillis();
            this.activeContexts = new HashSet();
            this.readonly = true;
            object = TransactionManager.this.transactions;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this@TransactionManager.transactions");
            Long l = this.getTxId();
            boolean bl = false;
            object.put(l, this);
            TransactionManager.this.getTransactionHistory().add(this);
            if (TransactionManager.this.getTransactionHistory().size() >= TransactionManager.this.transactionHistorySize) {
                TransactionManager.this.getTransactionHistory().remove(0);
            }
        }

        @Override
        @NotNull
        public TransactionType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public TransactionStatus getState() {
            return this.state;
        }

        public final int getNumberOfTxs() {
            return this.txns.size();
        }

        public final long getCreated() {
            return this.created;
        }

        @Nullable
        public final Long getEnded() {
            return this.ended;
        }

        public final int getNumberOfSuccess() {
            return this.numberOfSuccess;
        }

        public final int getNumberOfError() {
            return this.numberOfError;
        }

        public final int getNumberOfOngoing() {
            return this.activeContexts.size();
        }

        @Override
        public boolean getReadonly() {
            return this.readonly;
        }

        @Override
        @NotNull
        public Tx getTx(@NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Tx tx = this.txns.computeIfAbsent(dbo, arg_0 -> TransactionImpl.getTx$lambda-0(dbo, this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)tx, (String)"this.txns.computeIfAbsent(dbo) { dbo.newTx(this) }");
            return tx;
        }

        @Override
        public void requestLock(@NotNull DBO dbo, @NotNull LockMode mode) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            TransactionManager.this.getLockManager().lock(this, dbo, mode);
        }

        @Override
        public void signalEvent(@NotNull Operation.DataManagementOperation action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        }

        @Override
        @NotNull
        public Flow<Record> execute(@NotNull Operator operator2) {
            Intrinsics.checkNotNullParameter((Object)operator2, (String)"operator");
            return FlowKt.cancellable((Flow)FlowKt.onCompletion((Flow)FlowKt.onStart(operator2.toFlow(this), (Function2)((Function2)new Function2<FlowCollector<? super Record>, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ TransactionImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = TransactionImpl.access$getMutex$p(this.this$0);
                            var4_4 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            var6_8 = false;
                            this.L$0 = $this$withLock_u24default$iv;
                            this.L$1 = var4_4;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var12_2) {
                                return var12_2;
                            }
                            ** GOTO lbl24
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var4_4 = (TransactionImpl)this.L$1;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$TransactionImpl$execute$1$1 = false;
                                var8_12 = var4_4.getState().getCanExecute();
                                var9_14 = false;
                                var10_15 = false;
                                if (!var8_12) {
                                    $i$a$-check-TransactionManager$TransactionImpl$execute$1$1$1 = false;
                                    var10_16 = "Cannot start execution of transaction " + var4_4.getTxId() + " because it is in the wrong state (s = " + (Object)var4_4.getState() + ").";
                                    throw (Throwable)new IllegalStateException(var10_16.toString());
                                }
                                TransactionImpl.access$setState$p(var4_4, TransactionStatus.RUNNING);
                                var8_13 = this;
                                $i$f$currentCoroutineContext = false;
                                TransactionImpl.access$getActiveContexts$p(var4_4).add(this.getContext());
                                var6_9 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull FlowCollector<? super Record> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (Function3)((Function3)new Function3<FlowCollector<? super Record>, Throwable, Continuation<? super Unit>, Object>(this, null){
                Object L$1;
                Object L$2;
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ TransactionImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(3, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            it = (Throwable)this.L$0;
                            var3_4 = TransactionImpl.access$getMutex$p(this.this$0);
                            var5_5 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            var7_9 = false;
                            this.L$0 = it;
                            this.L$1 = $this$withLock_u24default$iv;
                            this.L$2 = var5_5;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var11_2) {
                                return var11_2;
                            }
                            ** GOTO lbl27
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var5_5 = (TransactionImpl)this.L$2;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$1;
                            it = (Throwable)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl27:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$TransactionImpl$execute$2$1 = false;
                                var9_13 = this;
                                $i$f$currentCoroutineContext = false;
                                TransactionImpl.access$getActiveContexts$p(var5_5).remove(this.getContext());
                                if (it == null) {
                                    var9_13 = var5_5;
                                    TransactionImpl.access$setNumberOfSuccess$p((TransactionImpl)var9_13, var9_13.getNumberOfSuccess() + 1);
                                    if (var5_5.getNumberOfOngoing() == 0 && var5_5.getState() == TransactionStatus.RUNNING) {
                                        TransactionImpl.access$setState$p(var5_5, TransactionStatus.IDLE);
                                        if (var5_5.getType().getAutoCommit()) {
                                            TransactionImpl.access$performCommit(var5_5);
                                        }
                                    }
                                } else {
                                    var9_13 = var5_5;
                                    TransactionImpl.access$setNumberOfError$p((TransactionImpl)var9_13, var9_13.getNumberOfError() + 1);
                                    TransactionImpl.access$setState$p(var5_5, TransactionStatus.ERROR);
                                    if (var5_5.getType().getAutoRollback()) {
                                        TransactionImpl.access$performRollback(var5_5);
                                    }
                                }
                                var7_10 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull FlowCollector<? super Record> p1, @Nullable Throwable p2, @Nullable Continuation<? super Unit> p3) {
                    Function3<FlowCollector<? super Record>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p2;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            })));
        }

        @Override
        public void commit() {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ TransactionImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = TransactionImpl.access$getMutex$p(this.this$0);
                            var4_4 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            var6_8 = false;
                            this.L$0 = $this$withLock_u24default$iv;
                            this.L$1 = var4_4;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var12_2) {
                                return var12_2;
                            }
                            ** GOTO lbl24
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var4_4 = (TransactionImpl)this.L$1;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$TransactionImpl$commit$1$1 = false;
                                var8_12 = var4_4.getState().getCanCommit();
                                var9_13 = false;
                                var10_14 = false;
                                if (!var8_12) {
                                    $i$a$-check-TransactionManager$TransactionImpl$commit$1$1$1 = false;
                                    var10_15 = "Unable to commit transaction " + var4_4.getTxId() + " because it is in wrong state (s = " + (Object)var4_4.getState() + ").";
                                    throw (Throwable)new IllegalStateException(var10_15.toString());
                                }
                                TransactionImpl.access$performCommit(var4_4);
                                var6_9 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void performCommit() {
            this.state = TransactionStatus.FINALIZING;
            try {
                Iterable $this$forEachIndexed$iv = CollectionsKt.reversed((Iterable)this.txns.values());
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void txn;
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Tx tx = (Tx)item$iv;
                    int i = n;
                    boolean bl2 = false;
                    try {
                        txn.commit();
                    }
                    catch (Throwable e) {
                        LOGGER.error("An error occurred while committing Tx " + i + " (" + txn.getDbo().getName() + ") of transaction " + this.getTxId() + ". This is serious!", e);
                    }
                }
            }
            finally {
                this.finalize(true);
            }
        }

        @Override
        public void rollback() {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ TransactionImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = TransactionImpl.access$getMutex$p(this.this$0);
                            var4_4 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            var6_8 = false;
                            this.L$0 = $this$withLock_u24default$iv;
                            this.L$1 = var4_4;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var12_2) {
                                return var12_2;
                            }
                            ** GOTO lbl24
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var4_4 = (TransactionImpl)this.L$1;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$TransactionImpl$rollback$1$1 = false;
                                var8_12 = var4_4.getState().getCanRollback();
                                var9_13 = false;
                                var10_14 = false;
                                if (!var8_12) {
                                    $i$a$-check-TransactionManager$TransactionImpl$rollback$1$1$1 = false;
                                    var10_15 = "Unable to rollback transaction " + var4_4.getTxId() + " because it is in wrong state (s = " + (Object)var4_4.getState() + ").";
                                    throw (Throwable)new IllegalStateException(var10_15.toString());
                                }
                                TransactionImpl.access$performRollback(var4_4);
                                var6_9 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void performRollback() {
            this.state = TransactionStatus.FINALIZING;
            try {
                Iterable $this$forEachIndexed$iv = CollectionsKt.reversed((Iterable)this.txns.values());
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void txn;
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Tx tx = (Tx)item$iv;
                    int i = n;
                    boolean bl2 = false;
                    try {
                        txn.rollback();
                    }
                    catch (Throwable e) {
                        LOGGER.error("An error occurred while rolling back Tx " + i + " (" + txn.getDbo().getName() + ") of transaction " + this.getTxId() + ". This is serious!", e);
                    }
                }
            }
            finally {
                this.finalize(false);
            }
        }

        @Override
        public void kill() {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ TransactionImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = TransactionImpl.access$getMutex$p(this.this$0);
                            var4_4 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            var6_7 = false;
                            this.L$0 = $this$withLock_u24default$iv;
                            this.L$1 = var4_4;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var14_2) {
                                return var14_2;
                            }
                            ** GOTO lbl24
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var4_4 = (TransactionImpl)this.L$1;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$TransactionImpl$kill$1$1 = false;
                                if (var4_4.getState() == TransactionStatus.RUNNING) {
                                    $this$forEach$iv = TransactionImpl.access$getActiveContexts$p(var4_4);
                                    $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        it = (CoroutineContext)element$iv;
                                        $i$a$-forEach-TransactionManager$TransactionImpl$kill$1$1$1 = false;
                                        JobKt.cancel((CoroutineContext)it, (CancellationException)new CancellationException("Transaction " + var4_4.getTxId() + " was killed by user."));
                                    }
                                } else if (var4_4.getState().getCanRollback()) {
                                    TransactionImpl.access$performRollback(var4_4);
                                } else {
                                    throw new IllegalStateException("Unable to kill transaction " + var4_4.getTxId() + " because it is in wrong state (s = " + (Object)var4_4.getState() + ").");
                                }
                                var6_8 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        /*
         * WARNING - void declaration
         */
        private final void finalize(boolean committed) {
            void $this$forEach$iv;
            Iterable iterable = this.allLocks();
            TransactionManager transactionManager = TransactionManager.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Lock it = (Lock)element$iv;
                boolean bl = false;
                transactionManager.getLockManager().unlock(this, (DBO)it.getObj());
            }
            this.txns.clear();
            this.ended = System.currentTimeMillis();
            this.state = committed ? TransactionStatus.COMMIT : TransactionStatus.ROLLBACK;
            TransactionManager.this.transactions.remove(this.getTxId());
        }

        private static final Tx getTx$lambda-0(DBO $dbo, TransactionImpl this$0, DBO it) {
            Intrinsics.checkNotNullParameter((Object)$dbo, (String)"$dbo");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $dbo.newTx(this$0);
        }

        public static final /* synthetic */ Mutex access$getMutex$p(TransactionImpl $this) {
            return $this.mutex;
        }

        public static final /* synthetic */ void access$setState$p(TransactionImpl $this, TransactionStatus transactionStatus) {
            $this.state = transactionStatus;
        }

        public static final /* synthetic */ HashSet access$getActiveContexts$p(TransactionImpl $this) {
            return $this.activeContexts;
        }

        public static final /* synthetic */ void access$setNumberOfSuccess$p(TransactionImpl $this, int n) {
            $this.numberOfSuccess = n;
        }

        public static final /* synthetic */ void access$performCommit(TransactionImpl $this) {
            $this.performCommit();
        }

        public static final /* synthetic */ void access$setNumberOfError$p(TransactionImpl $this, int n) {
            $this.numberOfError = n;
        }

        public static final /* synthetic */ void access$performRollback(TransactionImpl $this) {
            $this.performRollback();
        }
    }
}

