/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.execution.operators.sort;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.queries.sort.SortOrder;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00052\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0005\u0005\u0006\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0004\u0082\u0001\u0004\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator;", "Ljava/util/Comparator;", "Lorg/vitrivr/cottontail/model/basics/Record;", "Lkotlin/Comparator;", "()V", "Companion", "MultiNonNullColumnComparator", "MultiNullColumnComparator", "SingleNonNullColumnComparator", "SingleNullColumnComparator", "Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator$SingleNonNullColumnComparator;", "Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator$SingleNullColumnComparator;", "Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator$MultiNonNullColumnComparator;", "Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator$MultiNullColumnComparator;", "cottontaildb"})
public abstract class RecordComparator
implements Comparator<Record> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private RecordComparator() {
    }

    public /* synthetic */ RecordComparator(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u001c\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator$Companion;", "", "()V", "fromList", "Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator;", "sortOn", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final RecordComparator fromList(@NotNull List<? extends Pair<? extends ColumnDef<?>, ? extends SortOrder>> sortOn) {
            RecordComparator recordComparator;
            Intrinsics.checkNotNullParameter(sortOn, (String)"sortOn");
            if (sortOn.size() == 1 && ((ColumnDef)((Pair)CollectionsKt.first(sortOn)).getFirst()).getNullable()) {
                recordComparator = new SingleNullColumnComparator((ColumnDef)((Pair)CollectionsKt.first(sortOn)).getFirst(), (SortOrder)((Object)((Pair)CollectionsKt.first(sortOn)).getSecond()));
                return recordComparator;
            }
            if (sortOn.size() == 1 && !((ColumnDef)((Pair)CollectionsKt.first(sortOn)).getFirst()).getNullable()) {
                recordComparator = new SingleNonNullColumnComparator((ColumnDef)((Pair)CollectionsKt.first(sortOn)).getFirst(), (SortOrder)((Object)((Pair)CollectionsKt.first(sortOn)).getSecond()));
                return recordComparator;
            }
            if (sortOn.size() > 1) {
                boolean bl;
                block7: {
                    Iterable $this$any$iv = sortOn;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Pair it = (Pair)element$iv;
                            boolean bl2 = false;
                            if (!((ColumnDef)it.getFirst()).getNullable()) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    recordComparator = new MultiNullColumnComparator(sortOn);
                    return recordComparator;
                }
            }
            recordComparator = new MultiNonNullColumnComparator(sortOn);
            return recordComparator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator$SingleNonNullColumnComparator;", "Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator;", "c", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "o", "Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;", "(Lorg/vitrivr/cottontail/database/column/ColumnDef;Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;)V", "getC", "()Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getO", "()Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;", "compare", "", "o1", "Lorg/vitrivr/cottontail/model/basics/Record;", "o2", "cottontaildb"})
    public static final class SingleNonNullColumnComparator
    extends RecordComparator {
        @NotNull
        private final ColumnDef<?> c;
        @NotNull
        private final SortOrder o;

        public SingleNonNullColumnComparator(@NotNull ColumnDef<?> c, @NotNull SortOrder o) {
            Intrinsics.checkNotNullParameter(c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)((Object)o), (String)"o");
            super(null);
            this.c = c;
            this.o = o;
            boolean bl = !this.c.getNullable();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Column cannot be nullable for SingleNonNullColumnComparator but is.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final ColumnDef<?> getC() {
            return this.c;
        }

        @NotNull
        public final SortOrder getO() {
            return this.o;
        }

        @Override
        public int compare(@NotNull Record o1, @NotNull Record o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            Value value = o1.get(this.c);
            Intrinsics.checkNotNull((Object)value);
            Value value2 = o2.get(this.c);
            Intrinsics.checkNotNull((Object)value2);
            return this.o.times(MathKt.getSign((int)value.compareTo(value2)));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator$SingleNullColumnComparator;", "Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator;", "c", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "o", "Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;", "(Lorg/vitrivr/cottontail/database/column/ColumnDef;Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;)V", "getC", "()Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getO", "()Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;", "compare", "", "o1", "Lorg/vitrivr/cottontail/model/basics/Record;", "o2", "cottontaildb"})
    public static final class SingleNullColumnComparator
    extends RecordComparator {
        @NotNull
        private final ColumnDef<?> c;
        @NotNull
        private final SortOrder o;

        public SingleNullColumnComparator(@NotNull ColumnDef<?> c, @NotNull SortOrder o) {
            Intrinsics.checkNotNullParameter(c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)((Object)o), (String)"o");
            super(null);
            this.c = c;
            this.o = o;
        }

        @NotNull
        public final ColumnDef<?> getC() {
            return this.c;
        }

        @NotNull
        public final SortOrder getO() {
            return this.o;
        }

        @Override
        public int compare(@NotNull Record o1, @NotNull Record o2) {
            int n;
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            if (o1.get(this.c) == null && o2.get(this.c) == null) {
                n = 0;
            } else if (o1.get(this.c) == null && o2.get(this.c) != null) {
                n = -1;
            } else if (o1.get(this.c) != null && o2.get(this.c) == null) {
                n = 1;
            } else {
                Value value = o1.get(this.c);
                Intrinsics.checkNotNull((Object)value);
                Value value2 = o2.get(this.c);
                Intrinsics.checkNotNull((Object)value2);
                n = MathKt.getSign((int)value.compareTo(value2));
            }
            return this.o.times(n);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u001c\u0010\u0002\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R$\u0010\u0002\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator$MultiNonNullColumnComparator;", "Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator;", "sortOn", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;", "(Ljava/util/List;)V", "compare", "", "o1", "Lorg/vitrivr/cottontail/model/basics/Record;", "o2", "cottontaildb"})
    public static final class MultiNonNullColumnComparator
    extends RecordComparator {
        @NotNull
        private final List<Pair<ColumnDef<?>, SortOrder>> sortOn;

        public MultiNonNullColumnComparator(@NotNull List<? extends Pair<? extends ColumnDef<?>, ? extends SortOrder>> sortOn) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter(sortOn, (String)"sortOn");
                super(null);
                this.sortOn = sortOn;
                Iterable $this$any$iv = this.sortOn;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl2 = false;
                        if (!((ColumnDef)it.getFirst()).getNullable()) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            boolean bl3 = !bl;
            boolean bl4 = false;
            boolean bl5 = false;
            if (!bl3) {
                boolean bl6 = false;
                String string = "Columns cannot be nullable for SingleNonNullColumnComparator but are.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        @Override
        public int compare(@NotNull Record o1, @NotNull Record o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            int comparison = 0;
            for (Pair<ColumnDef<?>, SortOrder> c : this.sortOn) {
                SortOrder sortOrder = (SortOrder)((Object)c.getSecond());
                Value value = o1.get((ColumnDef)c.getFirst());
                Intrinsics.checkNotNull((Object)value);
                Value value2 = o2.get((ColumnDef)c.getFirst());
                Intrinsics.checkNotNull((Object)value2);
                comparison = sortOrder.times(MathKt.getSign((int)value.compareTo(value2)));
                if (comparison == 0) continue;
                break;
            }
            return comparison;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u001c\u0010\u0002\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R$\u0010\u0002\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator$MultiNullColumnComparator;", "Lorg/vitrivr/cottontail/execution/operators/sort/RecordComparator;", "sortOn", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;", "(Ljava/util/List;)V", "compare", "", "o1", "Lorg/vitrivr/cottontail/model/basics/Record;", "o2", "cottontaildb"})
    public static final class MultiNullColumnComparator
    extends RecordComparator {
        @NotNull
        private final List<Pair<ColumnDef<?>, SortOrder>> sortOn;

        public MultiNullColumnComparator(@NotNull List<? extends Pair<? extends ColumnDef<?>, ? extends SortOrder>> sortOn) {
            Intrinsics.checkNotNullParameter(sortOn, (String)"sortOn");
            super(null);
            this.sortOn = sortOn;
        }

        @Override
        public int compare(@NotNull Record o1, @NotNull Record o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            int comparison = 0;
            for (Pair<ColumnDef<?>, SortOrder> c : this.sortOn) {
                int n;
                Value c1 = o1.get((ColumnDef)c.getFirst());
                Value c2 = o2.get((ColumnDef)c.getFirst());
                SortOrder sortOrder = (SortOrder)((Object)c.getSecond());
                if (c1 == null && c2 == null) {
                    n = 0;
                } else if (c1 == null && c2 != null) {
                    n = -1;
                } else if (c1 != null && c2 == null) {
                    n = 1;
                } else {
                    Value value = c1;
                    Intrinsics.checkNotNull((Object)value);
                    Value value2 = c2;
                    Intrinsics.checkNotNull((Object)value2);
                    n = MathKt.getSign((int)value.compareTo(value2));
                }
                if ((comparison = sortOrder.times(n)) == 0) continue;
                break;
            }
            return comparison;
        }
    }
}

