/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.functions;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.functions.basics.Argument;
import org.vitrivr.cottontail.functions.basics.Function;
import org.vitrivr.cottontail.functions.basics.FunctionGenerator;
import org.vitrivr.cottontail.functions.basics.Signature;
import org.vitrivr.cottontail.functions.exception.FunctionNotFoundException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\bJ\u0016\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0012\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fJ\u0012\u0010\f\u001a\u00020\r2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0006R\"\u0010\u0003\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/functions/FunctionRegistry;", "", "()V", "generators", "", "Lorg/vitrivr/cottontail/functions/basics/Signature$Open;", "Lorg/vitrivr/cottontail/functions/basics/FunctionGenerator;", "registry", "Lorg/vitrivr/cottontail/functions/basics/Signature$Closed;", "Lorg/vitrivr/cottontail/functions/basics/Function;", "obtain", "signature", "register", "", "function", "Lorg/vitrivr/cottontail/functions/basics/Function$Stateless;", "generator", "cottontaildb"})
public final class FunctionRegistry {
    @NotNull
    private final Map<Signature.Closed<?>, Function<?>> registry;
    @NotNull
    private final Map<Signature.Open<?>, FunctionGenerator<?>> generators;

    public FunctionRegistry() {
        boolean bl = false;
        this.registry = new LinkedHashMap();
        bl = false;
        this.generators = new LinkedHashMap();
    }

    public final void register(@NotNull Function.Stateless<?> function) {
        Object v0;
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            boolean bl2 = !this.registry.containsKey(function.getSignature());
            boolean bl3 = false;
            bl = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "Function " + function.getSignature() + " collides with existing function.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Iterable iterable = this.generators.keySet();
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl5 = false;
            for (Object t : iterable2) {
                Signature.Open it = (Signature.Open)t;
                boolean bl6 = false;
                if (!it.collides(function.getSignature())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Signature.Open collision = v0;
        boolean bl7 = collision == null;
        bl = false;
        boolean bl8 = false;
        if (!bl7) {
            boolean bl9 = false;
            String string = "Function generator " + collision + " collides with function " + function.getSignature() + '.';
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map<Signature.Closed<?>, Function<?>> map2 = this.registry;
        Signature.Closed closed = function.getSignature();
        bl8 = false;
        map2.put(closed, function);
    }

    public final void register(@NotNull FunctionGenerator<?> generator) {
        Object v0;
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(generator, (String)"generator");
            boolean bl2 = !this.generators.containsKey(generator.getSignature());
            boolean bl3 = false;
            bl = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "Function generator for name " + generator.getSignature() + " collides with existing generator.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Iterable iterable = this.registry.keySet();
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl5 = false;
            for (Object t : iterable2) {
                Signature.Closed it = (Signature.Closed)t;
                boolean bl6 = false;
                if (!it.collides((Signature)generator.getSignature())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Signature.Closed collision = v0;
        boolean bl7 = collision == null;
        bl = false;
        boolean bl8 = false;
        if (!bl7) {
            boolean bl9 = false;
            String string = "Static function " + collision + " collides with function generator " + generator.getSignature();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map<Signature.Open<?>, FunctionGenerator<?>> map2 = this.generators;
        Signature.Open<?> open = generator.getSignature();
        bl8 = false;
        map2.put(open, generator);
    }

    @NotNull
    public final Function<?> obtain(@NotNull Signature.Closed<?> signature) {
        Intrinsics.checkNotNullParameter(signature, (String)"signature");
        Function<?> function = this.registry.get(signature);
        if (function != null) {
            return function;
        }
        Argument.Typed<?>[] typedArray = signature.getArguments();
        return this.obtain(signature.toOpen(new int[0])).generate(Arrays.copyOf(typedArray, typedArray.length));
    }

    @NotNull
    public final FunctionGenerator<?> obtain(@NotNull Signature.Open<?> signature) {
        Intrinsics.checkNotNullParameter(signature, (String)"signature");
        FunctionGenerator<?> functionGenerator = this.generators.get(signature);
        if (functionGenerator == null) {
            throw new FunctionNotFoundException((Signature)signature);
        }
        return functionGenerator;
    }
}

