/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.functions.math.distance.binary;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.functions.basics.AbstractFunctionGenerator;
import org.vitrivr.cottontail.functions.basics.Argument;
import org.vitrivr.cottontail.functions.basics.Function;
import org.vitrivr.cottontail.functions.basics.Signature;
import org.vitrivr.cottontail.functions.exception.FunctionNotSupportedException;
import org.vitrivr.cottontail.functions.math.distance.basics.VectorDistance;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.Complex32VectorValue;
import org.vitrivr.cottontail.model.values.Complex64Value;
import org.vitrivr.cottontail.model.values.Complex64VectorValue;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.DoubleVectorValue;
import org.vitrivr.cottontail.model.values.FloatVectorValue;
import org.vitrivr.cottontail.model.values.IntVectorValue;
import org.vitrivr.cottontail.model.values.LongVectorValue;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.model.values.types.VectorValue;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0007\r\u000e\u000f\u0010\u0011\u0012\u0013B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0001\u0006\u0014\u0015\u0016\u0017\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance;", "T", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "Lorg/vitrivr/cottontail/functions/math/distance/basics/VectorDistance$Binary;", "()V", "cost", "", "getCost", "()F", "name", "Lorg/vitrivr/cottontail/model/basics/Name$FunctionName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$FunctionName;", "Complex32Vector", "Complex64Vector", "DoubleVector", "FloatVector", "Generator", "IntVector", "LongVector", "Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance$Complex64Vector;", "Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance$Complex32Vector;", "Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance$DoubleVector;", "Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance$FloatVector;", "Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance$LongVector;", "Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance$IntVector;", "cottontaildb"})
public abstract class InnerProductDistance<T extends VectorValue<?>>
implements VectorDistance.Binary<T> {
    @NotNull
    private final Name.FunctionName name = Generator.INSTANCE.getFUNCTION_NAME();

    private InnerProductDistance() {
    }

    @Override
    @NotNull
    public Name.FunctionName getName() {
        return this.name;
    }

    @Override
    public float getCost() {
        return (float)this.getD() * (3.0f * Cost.Companion.getCOST_FLOP() + 2.0f * Cost.Companion.getCOST_MEMORY_ACCESS()) + Cost.Companion.getCOST_FLOP();
    }

    @Override
    public int getD() {
        return VectorDistance.Binary.DefaultImpls.getD(this);
    }

    @Override
    public boolean getExecutable() {
        return VectorDistance.Binary.DefaultImpls.getExecutable(this);
    }

    @Override
    @NotNull
    public Signature.Closed<? extends DoubleValue> getSignature() {
        return VectorDistance.Binary.DefaultImpls.getSignature(this);
    }

    @Override
    @NotNull
    public int[] getStatefulArguments() {
        return VectorDistance.Binary.DefaultImpls.getStatefulArguments(this);
    }

    public /* synthetic */ InnerProductDistance(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0014\u00f8\u0001\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\t8VX\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance$Generator;", "Lorg/vitrivr/cottontail/functions/basics/AbstractFunctionGenerator;", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "()V", "FUNCTION_NAME", "Lorg/vitrivr/cottontail/model/basics/Name$FunctionName;", "getFUNCTION_NAME", "()Lorg/vitrivr/cottontail/model/basics/Name$FunctionName;", "signature", "Lorg/vitrivr/cottontail/functions/basics/Signature$Open;", "getSignature", "()Lorg/vitrivr/cottontail/functions/basics/Signature$Open;", "generateInternal", "Lorg/vitrivr/cottontail/functions/basics/Function;", "dst", "Lorg/vitrivr/cottontail/functions/basics/Signature$Closed;", "cottontaildb"})
    public static final class Generator
    extends AbstractFunctionGenerator<DoubleValue> {
        @NotNull
        public static final Generator INSTANCE = new Generator();
        @NotNull
        private static final Name.FunctionName FUNCTION_NAME;

        private Generator() {
        }

        @NotNull
        public final Name.FunctionName getFUNCTION_NAME() {
            return FUNCTION_NAME;
        }

        @Override
        @NotNull
        public Signature.Open<? extends DoubleValue> getSignature() {
            Argument[] argumentArray = new Argument[]{Argument.Vector.INSTANCE, Argument.Vector.INSTANCE};
            return new Signature.Open(FUNCTION_NAME, argumentArray, Type.Double.INSTANCE);
        }

        @Override
        @NotNull
        protected Function<DoubleValue> generateInternal(@NotNull Signature.Closed<?> dst) {
            Function function;
            Intrinsics.checkNotNullParameter(dst, (String)"dst");
            Type<?> type = dst.getArguments()[0].getType();
            if (type instanceof Type.Complex64Vector) {
                function = new Complex64Vector(type.getLogicalSize());
            } else if (type instanceof Type.Complex32Vector) {
                function = new Complex32Vector(type.getLogicalSize());
            } else if (type instanceof Type.DoubleVector) {
                function = new DoubleVector(type.getLogicalSize());
            } else if (type instanceof Type.FloatVector) {
                function = new FloatVector(type.getLogicalSize());
            } else if (type instanceof Type.LongVector) {
                function = new LongVector(type.getLogicalSize());
            } else if (type instanceof Type.IntVector) {
                function = new IntVector(type.getLogicalSize());
            } else {
                throw new FunctionNotSupportedException("Function generator signature " + this.getSignature() + " does not support destination signature (dst = " + dst + ").");
            }
            return function;
        }

        static {
            String[] stringArray = new String[]{"innerproduct"};
            FUNCTION_NAME = new Name.FunctionName(stringArray);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J1\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u001bR%\u0010\u0006\u001a\u00020\u0002X\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance$Complex64Vector;", "Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance;", "Lorg/vitrivr/cottontail/model/values/Complex64VectorValue;", "size", "", "(I)V", "query", "getQuery-Leomr7I", "()[D", "setQuery-bcMpDBc", "([D)V", "[D", "type", "Lorg/vitrivr/cottontail/model/basics/Type$Complex64Vector;", "getType", "()Lorg/vitrivr/cottontail/model/basics/Type$Complex64Vector;", "copy", "d", "invoke", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "arguments", "", "Lorg/vitrivr/cottontail/model/values/types/Value;", "invoke-He8yXgM", "([Lorg/vitrivr/cottontail/model/values/types/Value;)D", "prepare", "", "([Lorg/vitrivr/cottontail/model/values/types/Value;)V", "cottontaildb"})
    public static final class Complex64Vector
    extends InnerProductDistance<Complex64VectorValue> {
        @NotNull
        private final Type.Complex64Vector type;
        @NotNull
        private double[] query;

        public Complex64Vector(int size) {
            super(null);
            this.type = new Type.Complex64Vector(size);
            this.query = this.getType().defaultValue-Leomr7I();
        }

        @NotNull
        public Type.Complex64Vector getType() {
            return this.type;
        }

        @NotNull
        public double[] getQuery-Leomr7I() {
            return this.query;
        }

        public void setQuery-bcMpDBc(@NotNull double[] dArray) {
            Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
            this.query = dArray;
        }

        @NotNull
        public Complex64Vector copy(int d) {
            return new Complex64Vector(d);
        }

        public double invoke-He8yXgM(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.Complex64VectorValue");
            }
            double[] probing = ((Complex64VectorValue)value).unbox-impl();
            double real = 0.0;
            double imaginary = 0.0;
            int n = 0;
            int n2 = Complex64VectorValue.getLogicalSize-impl(this.getQuery-Leomr7I());
            if (n < n2) {
                do {
                    int i = n++;
                    int iprime = i << 1;
                    real += this.getQuery-Leomr7I()[iprime] * probing[iprime] + this.getQuery-Leomr7I()[iprime + 1] * probing[iprime + 1];
                    imaginary += this.getQuery-Leomr7I()[iprime + 1] * probing[iprime] - this.getQuery-Leomr7I()[iprime] * probing[iprime + 1];
                } while (n < n2);
            }
            return DoubleValue.minus-He8yXgM(DoubleValue.constructor-impl(1.0), DoubleValue.box-impl(Complex64Value.abs-Z2rTJmk(Complex64Value.constructor-impl(real, imaginary))));
        }

        @Override
        public void prepare(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            boolean bl = Intrinsics.areEqual(value == null ? null : value.getType(), (Object)this.getType());
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                Value value2;
                boolean bl4 = false;
                String string = "Value of type " + ((value2 = arguments[0]) == null ? null : value2.getType()) + " cannot be applied as argument for " + this.getSignature() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value value3 = arguments[0];
            if (value3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.Complex64VectorValue");
            }
            this.setQuery-bcMpDBc(((Complex64VectorValue)value3).unbox-impl());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J1\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u001bR%\u0010\u0006\u001a\u00020\u0002X\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance$Complex32Vector;", "Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance;", "Lorg/vitrivr/cottontail/model/values/Complex32VectorValue;", "size", "", "(I)V", "query", "getQuery-4O27Dt0", "()[F", "setQuery-ngFg1xk", "([F)V", "[F", "type", "Lorg/vitrivr/cottontail/model/basics/Type$Complex32Vector;", "getType", "()Lorg/vitrivr/cottontail/model/basics/Type$Complex32Vector;", "copy", "d", "invoke", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "arguments", "", "Lorg/vitrivr/cottontail/model/values/types/Value;", "invoke-He8yXgM", "([Lorg/vitrivr/cottontail/model/values/types/Value;)D", "prepare", "", "([Lorg/vitrivr/cottontail/model/values/types/Value;)V", "cottontaildb"})
    public static final class Complex32Vector
    extends InnerProductDistance<Complex32VectorValue> {
        @NotNull
        private final Type.Complex32Vector type;
        @NotNull
        private float[] query;

        public Complex32Vector(int size) {
            super(null);
            this.type = new Type.Complex32Vector(size);
            this.query = this.getType().defaultValue-4O27Dt0();
        }

        @NotNull
        public Type.Complex32Vector getType() {
            return this.type;
        }

        @NotNull
        public float[] getQuery-4O27Dt0() {
            return this.query;
        }

        public void setQuery-ngFg1xk(@NotNull float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
            this.query = fArray;
        }

        @NotNull
        public Complex32Vector copy(int d) {
            return new Complex32Vector(d);
        }

        public double invoke-He8yXgM(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.Complex32VectorValue");
            }
            float[] probing = ((Complex32VectorValue)value).unbox-impl();
            double real = 0.0;
            double imaginary = 0.0;
            int n = 0;
            int n2 = Complex32VectorValue.getLogicalSize-impl(this.getQuery-4O27Dt0());
            if (n < n2) {
                do {
                    int i = n++;
                    int iprime = i << 1;
                    real += (double)(this.getQuery-4O27Dt0()[iprime] * probing[iprime] + this.getQuery-4O27Dt0()[iprime + 1] * probing[iprime + 1]);
                    imaginary += (double)(this.getQuery-4O27Dt0()[iprime + 1] * probing[iprime] - this.getQuery-4O27Dt0()[iprime] * probing[iprime + 1]);
                } while (n < n2);
            }
            return Complex64Value.abs-Z2rTJmk(Complex64Value.constructor-impl(real, imaginary));
        }

        @Override
        public void prepare(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            boolean bl = Intrinsics.areEqual(value == null ? null : value.getType(), (Object)this.getType());
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                Value value2;
                boolean bl4 = false;
                String string = "Value of type " + ((value2 = arguments[0]) == null ? null : value2.getType()) + " cannot be applied as argument for " + this.getSignature() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value value3 = arguments[0];
            if (value3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.Complex32VectorValue");
            }
            this.setQuery-ngFg1xk(((Complex32VectorValue)value3).unbox-impl());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J1\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u001bR%\u0010\u0006\u001a\u00020\u0002X\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance$DoubleVector;", "Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance;", "Lorg/vitrivr/cottontail/model/values/DoubleVectorValue;", "size", "", "(I)V", "query", "getQuery-Jz4_OW8", "()[D", "setQuery-SrTAqT8", "([D)V", "[D", "type", "Lorg/vitrivr/cottontail/model/basics/Type$DoubleVector;", "getType", "()Lorg/vitrivr/cottontail/model/basics/Type$DoubleVector;", "copy", "d", "invoke", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "arguments", "", "Lorg/vitrivr/cottontail/model/values/types/Value;", "invoke-He8yXgM", "([Lorg/vitrivr/cottontail/model/values/types/Value;)D", "prepare", "", "([Lorg/vitrivr/cottontail/model/values/types/Value;)V", "cottontaildb"})
    public static final class DoubleVector
    extends InnerProductDistance<DoubleVectorValue> {
        @NotNull
        private final Type.DoubleVector type;
        @NotNull
        private double[] query;

        public DoubleVector(int size) {
            super(null);
            this.type = new Type.DoubleVector(size);
            this.query = this.getType().defaultValue-Jz4_OW8();
        }

        @NotNull
        public Type.DoubleVector getType() {
            return this.type;
        }

        @NotNull
        public double[] getQuery-Jz4_OW8() {
            return this.query;
        }

        public void setQuery-SrTAqT8(@NotNull double[] dArray) {
            Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
            this.query = dArray;
        }

        @NotNull
        public DoubleVector copy(int d) {
            return new DoubleVector(d);
        }

        public double invoke-He8yXgM(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.DoubleVectorValue");
            }
            double[] probing = ((DoubleVectorValue)value).unbox-impl();
            double dotp = 0.0;
            int n = 0;
            int n2 = this.getQuery-Jz4_OW8().length + -1;
            if (n <= n2) {
                do {
                    int i = n++;
                    dotp += this.getQuery-Jz4_OW8()[i] * probing[i];
                } while (n <= n2);
            }
            return DoubleValue.constructor-impl(dotp);
        }

        @Override
        public void prepare(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            boolean bl = Intrinsics.areEqual(value == null ? null : value.getType(), (Object)this.getType());
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                Value value2;
                boolean bl4 = false;
                String string = "Value of type " + ((value2 = arguments[0]) == null ? null : value2.getType()) + " cannot be applied as argument for " + this.getSignature() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value value3 = arguments[0];
            if (value3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.DoubleVectorValue");
            }
            this.setQuery-SrTAqT8(((DoubleVectorValue)value3).unbox-impl());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J1\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u001bR%\u0010\u0006\u001a\u00020\u0002X\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance$FloatVector;", "Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance;", "Lorg/vitrivr/cottontail/model/values/FloatVectorValue;", "size", "", "(I)V", "query", "getQuery-3wzOJwo", "()[F", "setQuery-jre6TT8", "([F)V", "[F", "type", "Lorg/vitrivr/cottontail/model/basics/Type$FloatVector;", "getType", "()Lorg/vitrivr/cottontail/model/basics/Type$FloatVector;", "copy", "d", "invoke", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "arguments", "", "Lorg/vitrivr/cottontail/model/values/types/Value;", "invoke-He8yXgM", "([Lorg/vitrivr/cottontail/model/values/types/Value;)D", "prepare", "", "([Lorg/vitrivr/cottontail/model/values/types/Value;)V", "cottontaildb"})
    public static final class FloatVector
    extends InnerProductDistance<FloatVectorValue> {
        @NotNull
        private final Type.FloatVector type;
        @NotNull
        private float[] query;

        public FloatVector(int size) {
            super(null);
            this.type = new Type.FloatVector(size);
            this.query = this.getType().defaultValue-3wzOJwo();
        }

        @NotNull
        public Type.FloatVector getType() {
            return this.type;
        }

        @NotNull
        public float[] getQuery-3wzOJwo() {
            return this.query;
        }

        public void setQuery-jre6TT8(@NotNull float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
            this.query = fArray;
        }

        @NotNull
        public FloatVector copy(int d) {
            return new FloatVector(d);
        }

        public double invoke-He8yXgM(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.FloatVectorValue");
            }
            float[] probing = ((FloatVectorValue)value).unbox-impl();
            double dotp = 0.0;
            int n = 0;
            int n2 = this.getQuery-3wzOJwo().length + -1;
            if (n <= n2) {
                do {
                    int i = n++;
                    dotp += (double)(this.getQuery-3wzOJwo()[i] * probing[i]);
                } while (n <= n2);
            }
            return DoubleValue.constructor-impl(dotp);
        }

        @Override
        public void prepare(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            boolean bl = Intrinsics.areEqual(value == null ? null : value.getType(), (Object)this.getType());
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                Value value2;
                boolean bl4 = false;
                String string = "Value of type " + ((value2 = arguments[0]) == null ? null : value2.getType()) + " cannot be applied as argument for " + this.getSignature() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value value3 = arguments[0];
            if (value3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.FloatVectorValue");
            }
            this.setQuery-jre6TT8(((FloatVectorValue)value3).unbox-impl());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J1\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u001bR%\u0010\u0006\u001a\u00020\u0002X\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance$LongVector;", "Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance;", "Lorg/vitrivr/cottontail/model/values/LongVectorValue;", "size", "", "(I)V", "query", "getQuery-8fdD9LQ", "()[J", "setQuery-1cZuvkg", "([J)V", "[J", "type", "Lorg/vitrivr/cottontail/model/basics/Type$LongVector;", "getType", "()Lorg/vitrivr/cottontail/model/basics/Type$LongVector;", "copy", "d", "invoke", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "arguments", "", "Lorg/vitrivr/cottontail/model/values/types/Value;", "invoke-He8yXgM", "([Lorg/vitrivr/cottontail/model/values/types/Value;)D", "prepare", "", "([Lorg/vitrivr/cottontail/model/values/types/Value;)V", "cottontaildb"})
    public static final class LongVector
    extends InnerProductDistance<LongVectorValue> {
        @NotNull
        private final Type.LongVector type;
        @NotNull
        private long[] query;

        public LongVector(int size) {
            super(null);
            this.type = new Type.LongVector(size);
            this.query = this.getType().defaultValue-8fdD9LQ();
        }

        @NotNull
        public Type.LongVector getType() {
            return this.type;
        }

        @NotNull
        public long[] getQuery-8fdD9LQ() {
            return this.query;
        }

        public void setQuery-1cZuvkg(@NotNull long[] lArray) {
            Intrinsics.checkNotNullParameter((Object)lArray, (String)"<set-?>");
            this.query = lArray;
        }

        @NotNull
        public LongVector copy(int d) {
            return new LongVector(d);
        }

        public double invoke-He8yXgM(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[1];
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.LongVectorValue");
            }
            long[] probing = ((LongVectorValue)value).unbox-impl();
            double dotp = 0.0;
            int n = 0;
            int n2 = this.getQuery-8fdD9LQ().length + -1;
            if (n <= n2) {
                do {
                    int i = n++;
                    dotp += (double)(this.getQuery-8fdD9LQ()[i] * probing[i]);
                } while (n <= n2);
            }
            return DoubleValue.constructor-impl(dotp);
        }

        @Override
        public void prepare(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            boolean bl = Intrinsics.areEqual(value == null ? null : value.getType(), (Object)this.getType());
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                Value value2;
                boolean bl4 = false;
                String string = "Value of type " + ((value2 = arguments[0]) == null ? null : value2.getType()) + " cannot be applied as argument for " + this.getSignature() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value value3 = arguments[0];
            if (value3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.LongVectorValue");
            }
            this.setQuery-1cZuvkg(((LongVectorValue)value3).unbox-impl());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J1\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u001bR%\u0010\u0006\u001a\u00020\u0002X\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance$IntVector;", "Lorg/vitrivr/cottontail/functions/math/distance/binary/InnerProductDistance;", "Lorg/vitrivr/cottontail/model/values/IntVectorValue;", "size", "", "(I)V", "query", "getQuery-bSjjh_E", "()[I", "setQuery-SN65Eng", "([I)V", "[I", "type", "Lorg/vitrivr/cottontail/model/basics/Type$IntVector;", "getType", "()Lorg/vitrivr/cottontail/model/basics/Type$IntVector;", "copy", "d", "invoke", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "arguments", "", "Lorg/vitrivr/cottontail/model/values/types/Value;", "invoke-He8yXgM", "([Lorg/vitrivr/cottontail/model/values/types/Value;)D", "prepare", "", "([Lorg/vitrivr/cottontail/model/values/types/Value;)V", "cottontaildb"})
    public static final class IntVector
    extends InnerProductDistance<IntVectorValue> {
        @NotNull
        private final Type.IntVector type;
        @NotNull
        private int[] query;

        public IntVector(int size) {
            super(null);
            this.type = new Type.IntVector(size);
            this.query = this.getType().defaultValue-bSjjh_E();
        }

        @NotNull
        public Type.IntVector getType() {
            return this.type;
        }

        @NotNull
        public int[] getQuery-bSjjh_E() {
            return this.query;
        }

        public void setQuery-SN65Eng(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.query = nArray;
        }

        @NotNull
        public IntVector copy(int d) {
            return new IntVector(d);
        }

        public double invoke-He8yXgM(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.IntVectorValue");
            }
            int[] probing = ((IntVectorValue)value).unbox-impl();
            double dotp = 0.0;
            int n = 0;
            int n2 = this.getQuery-bSjjh_E().length + -1;
            if (n <= n2) {
                do {
                    int i = n++;
                    dotp += (double)(this.getQuery-bSjjh_E()[i] * probing[i]);
                } while (n <= n2);
            }
            return DoubleValue.constructor-impl(dotp);
        }

        @Override
        public void prepare(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            boolean bl = Intrinsics.areEqual(value == null ? null : value.getType(), (Object)this.getType());
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                Value value2;
                boolean bl4 = false;
                String string = "Value of type " + ((value2 = arguments[0]) == null ? null : value2.getType()) + " cannot be applied as argument for " + this.getSignature() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value value3 = arguments[0];
            if (value3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.IntVectorValue");
            }
            this.setQuery-SN65Eng(((IntVectorValue)value3).unbox-impl());
        }
    }
}

