/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.io.BufferedWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.catalogue.CatalogueTx;
import org.vitrivr.cottontail.database.column.Column;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.column.ColumnEngine;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.general.Tx;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.operations.Operation;
import org.vitrivr.cottontail.database.schema.Schema;
import org.vitrivr.cottontail.database.schema.SchemaTx;
import org.vitrivr.cottontail.execution.Transaction;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.execution.TransactionStatus;
import org.vitrivr.cottontail.execution.TransactionType;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.legacy.MigrationManager;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.utilities.io.TxFileUtilities;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0014J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0014J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u0015H&J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u0015H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager;", "Lorg/vitrivr/cottontail/legacy/MigrationManager;", "batchSize", "", "logFile", "Ljava/nio/file/Path;", "(ILjava/nio/file/Path;)V", "getBatchSize", "()I", "transactionIdCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "writer", "Ljava/io/BufferedWriter;", "close", "", "log", "message", "", "logStdout", "migrate", "config", "Lorg/vitrivr/cottontail/config/Config;", "migrateDBOs", "source", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "destination", "migrateData", "openDestinationCatalogue", "openSourceCatalogue", "MigrationContext", "cottontaildb"})
@ExperimentalTime
public abstract class AbstractMigrationManager
implements MigrationManager {
    private final int batchSize;
    @NotNull
    private final AtomicLong transactionIdCounter;
    @NotNull
    private final BufferedWriter writer;

    public AbstractMigrationManager(int batchSize, @NotNull Path logFile) {
        Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
        this.batchSize = batchSize;
        this.transactionIdCounter = new AtomicLong(0L);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.CREATE};
        BufferedWriter bufferedWriter = Files.newBufferedWriter(logFile.resolve("cottontaildb_migration_" + System.currentTimeMillis() + ".log"), openOptionArray);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedWriter, (String)"newBufferedWriter(\n     \u2026rdOpenOption.CREATE\n    )");
        this.writer = bufferedWriter;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    @Nullable
    public abstract Catalogue openSourceCatalogue(@NotNull Config var1);

    @Nullable
    public abstract Catalogue openDestinationCatalogue(@NotNull Config var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        boolean $i$f$measureTime = false;
        boolean bl = false;
        TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        boolean bl2 = false;
        TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
        boolean bl3 = false;
        this.log("Starting catalogue migration from V" + this.getFrom() + " for " + config.getRoot() + ".\n");
        Catalogue srcCatalogue = this.openSourceCatalogue(config);
        if (srcCatalogue == null) {
            this.log("Failed to open source catalogue.\n");
            return;
        }
        this.log("Source catalogue " + srcCatalogue.getConfig().getRoot() + " loaded successfully.\n");
        Path migratedDatabaseRoot = config.getRoot().getParent().resolve(config.getRoot().getFileName() + "~migrated");
        if (!Files.exists(migratedDatabaseRoot, new LinkOption[0])) {
            Files.createDirectories(migratedDatabaseRoot, new FileAttribute[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)migratedDatabaseRoot, (String)"migratedDatabaseRoot");
        Catalogue dstCatalogue = this.openDestinationCatalogue(Config.copy$default(config, migratedDatabaseRoot, false, false, null, null, null, null, null, 254, null));
        if (dstCatalogue == null) {
            this.log("Failed to open destination catalogue.\n");
            srcCatalogue.close();
            return;
        }
        this.log("Destination catalogue " + dstCatalogue.getConfig().getRoot() + " loaded successfully.\n");
        try {
            this.migrateDBOs(srcCatalogue, dstCatalogue);
            this.migrateData(srcCatalogue, dstCatalogue);
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(config.getRoot(), config.getRoot().getParent().resolve(config.getRoot().getFileName() + "~old"), copyOptionArray);
            copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(migratedDatabaseRoot, config.getRoot(), copyOptionArray);
        }
        catch (Throwable e) {
            this.log("Error during data migration: " + e.getMessage() + '\n');
            TxFileUtilities.INSTANCE.delete(dstCatalogue.getPath());
        }
        finally {
            srcCatalogue.close();
            dstCatalogue.close();
        }
        long duration = mark$iv$iv.elapsedNow-UwyO8pc();
        this.log("Data migration completed. Took " + Duration.toString-impl((long)duration) + ".\n");
    }

    /*
     * WARNING - void declaration
     */
    protected void migrateDBOs(@NotNull Catalogue source, @NotNull Catalogue destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        MigrationContext context2 = new MigrationContext();
        CatalogueTx srcCatalogueTx = (CatalogueTx)context2.getTx(source);
        CatalogueTx dstCatalogueTx = (CatalogueTx)context2.getTx(destination);
        List<Schema> schemas = srcCatalogueTx.listSchemas();
        Iterator<Schema> iterator2 = schemas.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int s = n++;
            Schema srcSchema = iterator2.next();
            this.log("+ Migrating schema " + srcSchema.getName() + " (" + (s + 1) + " / " + schemas.size() + "):\n");
            Schema schema = dstCatalogueTx.createSchema(srcSchema.getName());
            SchemaTx dstSchemaTx = (SchemaTx)context2.getTx(schema);
            SchemaTx srcSchemaTx = (SchemaTx)context2.getTx(srcSchema);
            List<Entity> entities = srcSchemaTx.listEntities();
            Iterator<Entity> iterator3 = entities.iterator();
            int n2 = 0;
            while (iterator3.hasNext()) {
                void $this$toTypedArray$iv;
                Collection<Pair> collection;
                void $this$mapTo$iv$iv;
                Collection $this$map$iv;
                int i = n2++;
                Entity srcEntity = iterator3.next();
                this.log("-- Migrating entity " + srcEntity.getName() + " (" + (i + 1) + " / " + entities.size() + "):\n");
                EntityTx srcEntityTx = (EntityTx)context2.getTx(srcEntity);
                Iterable iterable = srcEntityTx.listColumns();
                Name.EntityName entityName = srcEntity.getName();
                SchemaTx schemaTx = dstSchemaTx;
                boolean $i$f$map = false;
                void var24_25 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Column column = (Column)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to(it.getColumnDef(), (Object)((Object)ColumnEngine.MAPDB));
                    collection.add(pair);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
                if (pairArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Pair[] pairArray2 = pairArray;
                Entity entity = schemaTx.createEntity(entityName, Arrays.copyOf(pairArray2, pairArray2.length));
                for (Index index : srcEntityTx.listIndexes()) {
                    this.log("---- Migrating index " + index.getName() + "...\n");
                    EntityTx destEntityTx = (EntityTx)context2.getTx(entity);
                    destEntityTx.createIndex(index.getName(), index.getType(), index.getColumns(), index.getConfig().toMap());
                }
            }
        }
        context2.commit();
    }

    /*
     * WARNING - void declaration
     */
    protected void migrateData(@NotNull Catalogue source, @NotNull Catalogue destination) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        MigrationContext sourceContext = new MigrationContext();
        CatalogueTx srcCatalogueTx = (CatalogueTx)sourceContext.getTx(source);
        List<Schema> schemas = srcCatalogueTx.listSchemas();
        Iterator<Schema> iterator2 = schemas.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int s = n++;
            Schema srcSchema = iterator2.next();
            SchemaTx srcSchemaTx = (SchemaTx)sourceContext.getTx(srcSchema);
            List<Entity> entities = srcSchemaTx.listEntities();
            for (Entity srcEntity : entities) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                this.logStdout("+ Migrating data for schema " + srcSchema.getName() + " (" + (s + 1) + " / " + schemas.size() + ")...\n");
                EntityTx srcEntityTx = (EntityTx)sourceContext.getTx(srcEntity);
                long count = srcEntityTx.count();
                long maxTupleId = srcEntityTx.maxTupleId();
                Iterable $this$map$iv = srcEntityTx.listColumns();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Column column = (Column)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ColumnDef columnDef = it.getColumnDef();
                    collection.add(columnDef);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                if (thisCollection$iv.toArray(new ColumnDef[0]) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                if (count > 0L) {
                    long i = 0L;
                    int n2 = 0;
                    int p = (int)Math.floorDiv(maxTupleId, this.batchSize);
                    if (n2 < p) {
                        do {
                            ColumnDef[] columns;
                            int j = n2++;
                            MigrationContext context2 = new MigrationContext();
                            CatalogueTx destCatalogueTx = (CatalogueTx)context2.getTx(destination);
                            SchemaTx destSchemaTx = (SchemaTx)context2.getTx(destCatalogueTx.schemaForName(srcSchema.getName()));
                            EntityTx destEntityTx = (EntityTx)context2.getTx(destSchemaTx.entityForName(srcEntity.getName()));
                            Iterator<Record> $this$forEach$iv = srcEntityTx.scan(columns, j, p);
                            boolean $i$f$forEach = false;
                            Iterator<Record> iterator3 = $this$forEach$iv;
                            boolean bl = false;
                            Iterator<Record> iterator4 = iterator3;
                            while (iterator4.hasNext()) {
                                Record element$iv;
                                Record r = element$iv = iterator4.next();
                                boolean bl2 = false;
                                this.logStdout("-- Migrating data for " + srcEntity.getName() + "... (" + ++i + " / " + count + ")\r");
                                destEntityTx.insert(r);
                            }
                            this.log("-- Migrating data for " + srcEntity.getName() + "; committing... (" + i + " / " + count + ")\r");
                            context2.commit();
                        } while (n2 < p);
                    }
                    this.log("-- Data migration for " + srcEntity.getName() + " completed (" + i + " / " + count + ").\n");
                    continue;
                }
                this.log("-- Data migration for " + srcEntity.getName() + " skipped (no data).\n");
            }
        }
        sourceContext.commit();
    }

    protected final void logStdout(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean bl = false;
        System.out.print((Object)message);
    }

    protected final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean bl = false;
        System.out.print((Object)message);
        this.writer.append(message);
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0014H\u0016J\b\u0010%\u001a\u00020\u001dH\u0016J\u0018\u0010&\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u001dH\u0016J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00060\u000ej\u0002`\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager$MigrationContext;", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Lorg/vitrivr/cottontail/execution/Transaction;", "(Lorg/vitrivr/cottontail/legacy/AbstractMigrationManager;)V", "readonly", "", "getReadonly", "()Z", "<set-?>", "Lorg/vitrivr/cottontail/execution/TransactionStatus;", "state", "getState", "()Lorg/vitrivr/cottontail/execution/TransactionStatus;", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "getTxId", "()J", "txns", "", "Lorg/vitrivr/cottontail/database/general/DBO;", "Lorg/vitrivr/cottontail/database/general/Tx;", "getTxns", "()Ljava/util/Map;", "type", "Lorg/vitrivr/cottontail/execution/TransactionType;", "getType", "()Lorg/vitrivr/cottontail/execution/TransactionType;", "commit", "", "execute", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/model/basics/Record;", "operator", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator;", "getTx", "dbo", "kill", "requestLock", "mode", "Lorg/vitrivr/cottontail/database/locking/LockMode;", "rollback", "signalEvent", "action", "Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation;", "cottontaildb"})
    public final class MigrationContext
    implements TransactionContext,
    Transaction {
        private final long txId;
        @NotNull
        private final TransactionType type;
        @NotNull
        private volatile TransactionStatus state;
        @NotNull
        private final Map<DBO, Tx> txns;

        public MigrationContext() {
            Intrinsics.checkNotNullParameter((Object)AbstractMigrationManager.this, (String)"this$0");
            this.txId = AbstractMigrationManager.this.transactionIdCounter.getAndIncrement();
            this.type = TransactionType.SYSTEM;
            this.state = TransactionStatus.IDLE;
            Object2ObjectMap object2ObjectMap = Object2ObjectMaps.synchronize((Object2ObjectMap)((Object2ObjectMap)new Object2ObjectLinkedOpenHashMap()));
            Intrinsics.checkNotNullExpressionValue((Object)object2ObjectMap, (String)"synchronize(Object2ObjectLinkedOpenHashMap())");
            this.txns = (Map)object2ObjectMap;
        }

        @Override
        public long getTxId() {
            return this.txId;
        }

        @Override
        @NotNull
        public TransactionType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public TransactionStatus getState() {
            return this.state;
        }

        @Override
        public boolean getReadonly() {
            return false;
        }

        @NotNull
        protected final Map<DBO, Tx> getTxns() {
            return this.txns;
        }

        @Override
        @NotNull
        public Tx getTx(@NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Tx tx = this.txns.computeIfAbsent(dbo, arg_0 -> MigrationContext.getTx$lambda-0(dbo, this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)tx, (String)"this.txns.computeIfAbsen\u2026dbo.newTx(this)\n        }");
            return tx;
        }

        @Override
        public void requestLock(@NotNull DBO dbo, @NotNull LockMode mode) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        }

        @Override
        public void signalEvent(@NotNull Operation.DataManagementOperation action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            throw new UnsupportedOperationException("Operation signalEvent() not supported for MigrationContext.");
        }

        @Override
        @NotNull
        public Flow<Record> execute(@NotNull Operator operator2) {
            Intrinsics.checkNotNullParameter((Object)operator2, (String)"operator");
            throw new UnsupportedOperationException("Operation execute() not supported for MigrationContext.");
        }

        @Override
        public void kill() {
            throw new UnsupportedOperationException("Operation kill() not supported for MigrationContext.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void commit() {
            boolean bl = this.getState() == TransactionStatus.IDLE;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Cannot commit transaction " + this.getTxId() + " because it is in wrong state (s = " + (Object)((Object)this.getState()) + ").";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.state = TransactionStatus.FINALIZING;
            try {
                Iterable $this$forEachIndexed$iv = CollectionsKt.reversed((Iterable)this.txns.values());
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void txn;
                    int n = index$iv++;
                    boolean bl5 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Tx tx = (Tx)item$iv;
                    int $noName_0 = n;
                    boolean bl6 = false;
                    txn.commit();
                }
            }
            finally {
                this.txns.clear();
                this.state = TransactionStatus.COMMIT;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollback() {
            boolean bl = this.getState() == TransactionStatus.IDLE || this.getState() == TransactionStatus.ERROR;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Cannot rollback transaction " + this.getTxId() + " because it is in wrong state (s = " + (Object)((Object)this.getState()) + ").";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.state = TransactionStatus.FINALIZING;
            try {
                Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)this.txns.values());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Tx txn = (Tx)element$iv;
                    boolean bl5 = false;
                    txn.rollback();
                }
            }
            finally {
                this.txns.clear();
                this.state = TransactionStatus.COMMIT;
            }
        }

        private static final Tx getTx$lambda-0(DBO $dbo, MigrationContext this$0, DBO it) {
            Intrinsics.checkNotNullParameter((Object)$dbo, (String)"$dbo");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $dbo.newTx(this$0);
        }
    }
}

