/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.recordset;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B)\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB5\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000b\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0016\u001a\u00020\u0001H\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J(\u0010\u001b\u001a\u00020\u001c2\u001e\u0010\u001d\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u001c0\u001eH\u0016J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010 \u001a\u00020!J\u0017\u0010\u001f\u001a\u0004\u0018\u00010\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0096\u0002J\u0014\u0010\"\u001a\u00020\u00182\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\b\u0010#\u001a\u00020!H\u0016J\u0014\u0010$\u001a\u00020!2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0018\u0010%\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001f\u0010%\u001a\u00020\u001c2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0096\u0002J\u001a\u0010&\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0'H\u0016R \u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006("}, d2={"Lorg/vitrivr/cottontail/model/recordset/StandaloneRecord;", "Lorg/vitrivr/cottontail/model/basics/Record;", "tupleId", "", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "column", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "value", "Lorg/vitrivr/cottontail/model/values/types/Value;", "(JLorg/vitrivr/cottontail/database/column/ColumnDef;Lorg/vitrivr/cottontail/model/values/types/Value;)V", "columns", "", "values", "(J[Lorg/vitrivr/cottontail/database/column/ColumnDef;[Lorg/vitrivr/cottontail/model/values/types/Value;)V", "getColumns", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getTupleId", "()J", "setTupleId", "(J)V", "[Lorg/vitrivr/cottontail/model/values/types/Value;", "copy", "equals", "", "other", "", "forEach", "", "action", "Lkotlin/Function2;", "get", "columnIndex", "", "has", "hashCode", "indexOf", "set", "toMap", "", "cottontaildb"})
public final class StandaloneRecord
implements Record {
    private long tupleId;
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    private final Value[] values;

    public StandaloneRecord(long tupleId, @NotNull ColumnDef<?>[] columns, @NotNull Value[] values) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.tupleId = tupleId;
        this.columns = columns;
        this.values = values;
        boolean bl = this.getColumns().length == this.values.length;
        int n = 0;
        int n2 = 0;
        if (!bl) {
            boolean bl2 = false;
            String string = "Number of values and number of columns must be the same.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ColumnDef<?>[] columnDefArray = this.getColumns();
        n2 = columnDefArray.length;
        for (n = 0; n < n2; ++n) {
            int i = n;
            ColumnDef<?> c = columnDefArray[n];
            boolean bl3 = c.validate(this.values[i]);
            boolean bl4 = false;
            boolean bl5 = false;
            if (bl3) continue;
            boolean bl6 = false;
            String string = "Value " + this.values[i] + " is incompatible with column " + c + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ StandaloneRecord(long l, ColumnDef[] columnDefArray, Value[] valueArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            valueArray = new Value[columnDefArray.length];
        }
        this(l, columnDefArray, valueArray);
    }

    @Override
    public long getTupleId() {
        return this.tupleId;
    }

    @Override
    public void setTupleId(long l) {
        this.tupleId = l;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    public StandaloneRecord(long tupleId, @NotNull ColumnDef<?> column, @Nullable Value value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Object[] objectArray = new ColumnDef[]{column};
        ColumnDef[] columnDefArray = objectArray;
        objectArray = new Value[]{value};
        this(tupleId, columnDefArray, (Value[])objectArray);
    }

    @Override
    @NotNull
    public Record copy() {
        long l = this.getTupleId();
        ColumnDef<?>[] columnDefArray = this.getColumns();
        Value[] valueArray = this.values;
        boolean bl = false;
        Value[] valueArray2 = Arrays.copyOf(valueArray, valueArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)valueArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return new StandaloneRecord(l, columnDefArray, valueArray2);
    }

    @Override
    public void forEach(@NotNull Function2<? super ColumnDef<?>, ? super Value, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ColumnDef<?>[] columnDefArray = this.getColumns();
        int n = columnDefArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            ColumnDef<?> c = columnDefArray[i];
            action.invoke(c, (Object)this.values[i2]);
        }
    }

    @Override
    public boolean has(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return ArraysKt.contains((Object[])this.getColumns(), column);
    }

    @Override
    public int indexOf(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return ArraysKt.indexOf((Object[])this.getColumns(), column);
    }

    @Override
    @NotNull
    public Map<ColumnDef<?>, Value> toMap() {
        return (Map)new Object2ObjectArrayMap((Object[])this.getColumns(), (Object[])this.values);
    }

    @Override
    @Nullable
    public Value get(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return this.get(ArraysKt.indexOf((Object[])this.getColumns(), column));
    }

    @Nullable
    public final Value get(int columnIndex) {
        boolean bl = 0 <= columnIndex ? columnIndex < this.getSize() : false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The specified column " + columnIndex + " is out of bounds.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.values[columnIndex];
    }

    @Override
    public void set(@NotNull ColumnDef<?> column, @Nullable Value value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        this.set(ArraysKt.indexOf((Object[])this.getColumns(), column), value);
    }

    public final void set(int columnIndex, @Nullable Value value) {
        boolean bl = 0 <= columnIndex ? columnIndex < this.getSize() : false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The specified column " + columnIndex + " is out of bounds.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.getColumns()[columnIndex].validate(value);
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Provided value " + value + " is incompatible with column " + this.getColumns()[columnIndex] + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.values[columnIndex] = value;
    }

    public boolean equals(@Nullable Object other) {
        Object[] objectArray;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (objectArray = other) == null ? null : objectArray.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.recordset.StandaloneRecord");
        }
        StandaloneRecord cfr_ignored_0 = (StandaloneRecord)other;
        if (this.getTupleId() != ((StandaloneRecord)other).getTupleId()) {
            return false;
        }
        objectArray = this.getColumns();
        Object[] objectArray2 = ((StandaloneRecord)other).getColumns();
        boolean bl = false;
        if (Arrays.equals(objectArray, objectArray2)) {
            return false;
        }
        objectArray = this.values;
        objectArray2 = ((StandaloneRecord)other).values;
        bl = false;
        return !Arrays.equals(objectArray, objectArray2);
    }

    public int hashCode() {
        int result = Long.hashCode(this.getTupleId());
        Object[] objectArray = this.getColumns();
        boolean bl = false;
        result = 31 * result + Arrays.hashCode(objectArray);
        objectArray = this.getColumns();
        bl = false;
        result = 31 * result + Arrays.hashCode(objectArray);
        return result;
    }

    @Override
    public int getSize() {
        return Record.DefaultImpls.getSize(this);
    }
}

