/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.values;

import java.util.SplittableRandom;
import kotlin.Metadata;
import kotlin.jvm.JvmInline;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.ByteValue;
import org.vitrivr.cottontail.model.values.Complex32Value;
import org.vitrivr.cottontail.model.values.Complex64Value;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.FloatValue;
import org.vitrivr.cottontail.model.values.IntValue;
import org.vitrivr.cottontail.model.values.ShortValue;
import org.vitrivr.cottontail.model.values.types.NumericValue;
import org.vitrivr.cottontail.model.values.types.RealValue;
import org.vitrivr.cottontail.model.values.types.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JvmInline
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0087@\u0018\u0000 k2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001kB\u0014\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0018\b\u0016\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0007\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0005\u0010\bB\u0012\u0012\u0006\u0010\t\u001a\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0005\u0010\nJ\u0018\u0010\u001a\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001b\u0010\nJ\u0018\u0010\u001c\u001a\u00020\u001dH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0018\u0010 \u001a\u00020!H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0018\u0010$\u001a\u00020%H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b&\u0010'J\u0018\u0010(\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b*\u0010+J\u0018\u0010,\u001a\u00020-H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b.\u0010/J\u0018\u00100\u001a\u000201H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b2\u0010\u0011J\u0018\u00103\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b4\u0010\nJ\u0018\u00105\u001a\u000206H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b7\u00108J\u0018\u00109\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b:\u0010+J\u0018\u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020=H\u0096\u0002\u00a2\u0006\u0004\b>\u0010?J\u0018\u0010@\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bA\u0010+J%\u0010B\u001a\u00020\u00002\n\u0010<\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bC\u0010DJ\u001a\u0010E\u001a\u00020F2\b\u0010<\u001a\u0004\u0018\u00010GH\u00d6\u0003\u00a2\u0006\u0004\bH\u0010IJ\u0018\u0010J\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bK\u0010+J\u0010\u0010L\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\bM\u0010\u0011J\u0017\u0010N\u001a\u00020F2\u0006\u0010<\u001a\u00020=H\u0016\u00a2\u0006\u0004\bO\u0010PJ\u0018\u0010Q\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bR\u0010+J%\u0010S\u001a\u00020\u00002\n\u0010<\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bT\u0010DJ%\u0010U\u001a\u00020\u00002\n\u0010<\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bV\u0010DJ \u0010W\u001a\u00020)2\u0006\u0010X\u001a\u00020YH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bZ\u0010[J \u0010W\u001a\u00020)2\u0006\u0010X\u001a\u00020\u000fH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bZ\u0010\\J\u0018\u0010]\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b^\u0010+J\u0018\u0010_\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b`\u0010+J\u0018\u0010a\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bb\u0010+J%\u0010c\u001a\u00020\u00002\n\u0010<\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bd\u0010DJ\u0010\u0010e\u001a\u00020fH\u00d6\u0001\u00a2\u0006\u0004\bg\u0010hJ\u0019\u0010i\u001a\u00020\u0000H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bj\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0018\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\t\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u0088\u0001\t\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006l"}, d2={"Lorg/vitrivr/cottontail/model/values/LongValue;", "Lorg/vitrivr/cottontail/model/values/types/RealValue;", "", "number", "", "constructor-impl", "(Ljava/lang/Number;)J", "Lorg/vitrivr/cottontail/model/values/types/NumericValue;", "(Lorg/vitrivr/cottontail/model/values/types/NumericValue;)J", "value", "(J)J", "imaginary", "getImaginary-impl", "(J)Lorg/vitrivr/cottontail/model/values/types/RealValue;", "logicalSize", "", "getLogicalSize-impl", "(J)I", "real", "getReal-impl", "type", "Lorg/vitrivr/cottontail/model/basics/Type;", "getType-impl", "(J)Lorg/vitrivr/cottontail/model/basics/Type;", "getValue", "()Ljava/lang/Long;", "abs", "abs-LWoHqF4", "asByte", "Lorg/vitrivr/cottontail/model/values/ByteValue;", "asByte-pCuLKj8", "(J)B", "asComplex32", "Lorg/vitrivr/cottontail/model/values/Complex32Value;", "asComplex32-WO0UQc4", "(J)[F", "asComplex64", "Lorg/vitrivr/cottontail/model/values/Complex64Value;", "asComplex64-IY5coek", "(J)[D", "asDouble", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "asDouble-Z2rTJmk", "(J)D", "asFloat", "Lorg/vitrivr/cottontail/model/values/FloatValue;", "asFloat-JbzPQW8", "(J)F", "asInt", "Lorg/vitrivr/cottontail/model/values/IntValue;", "asInt-HuW2oqM", "asLong", "asLong-LWoHqF4", "asShort", "Lorg/vitrivr/cottontail/model/values/ShortValue;", "asShort-0l6I1b0", "(J)S", "atan", "atan-Z2rTJmk", "compareTo", "other", "Lorg/vitrivr/cottontail/model/values/types/Value;", "compareTo-impl", "(JLorg/vitrivr/cottontail/model/values/types/Value;)I", "cos", "cos-Z2rTJmk", "div", "div--D-JnrY", "(JLorg/vitrivr/cottontail/model/values/types/NumericValue;)J", "equals", "", "", "equals-impl", "(JLjava/lang/Object;)Z", "exp", "exp-Z2rTJmk", "hashCode", "hashCode-impl", "isEqual", "isEqual-impl", "(JLorg/vitrivr/cottontail/model/values/types/Value;)Z", "ln", "ln-Z2rTJmk", "minus", "minus--D-JnrY", "plus", "plus--D-JnrY", "pow", "x", "", "pow-He8yXgM", "(JD)D", "(JI)D", "sin", "sin-Z2rTJmk", "sqrt", "sqrt-Z2rTJmk", "tan", "tan-Z2rTJmk", "times", "times--D-JnrY", "toString", "", "toString-impl", "(J)Ljava/lang/String;", "unaryMinus", "unaryMinus-LWoHqF4", "Companion", "cottontaildb"})
public final class LongValue
implements RealValue<Long> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long value;
    private static final long ZERO = LongValue.constructor-impl(0L);
    private static final long ONE = LongValue.constructor-impl(1L);

    @Override
    @NotNull
    public Long getValue() {
        return this.value;
    }

    public static long constructor-impl(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        long l = LongValue.constructor-impl(number.longValue());
        return l;
    }

    public static long constructor-impl(@NotNull NumericValue<?> number) {
        Intrinsics.checkNotNullParameter(number, (String)"number");
        long l = LongValue.constructor-impl(((Number)number.getValue()).longValue());
        return l;
    }

    public static int getLogicalSize-impl(long arg0) {
        return 1;
    }

    @Override
    public int getLogicalSize() {
        return LongValue.getLogicalSize-impl(this.value);
    }

    @NotNull
    public static Type<?> getType-impl(long arg0) {
        return Type.Long.INSTANCE;
    }

    @Override
    @NotNull
    public Type<?> getType() {
        return LongValue.getType-impl(this.value);
    }

    @NotNull
    public static RealValue<Long> getReal-impl(long arg0) {
        return LongValue.box-impl(arg0);
    }

    @Override
    @NotNull
    public RealValue<Long> getReal() {
        return LongValue.getReal-impl(this.value);
    }

    @NotNull
    public static RealValue<Long> getImaginary-impl(long arg0) {
        return LongValue.box-impl(ZERO);
    }

    @Override
    @NotNull
    public RealValue<Long> getImaginary() {
        return LongValue.getImaginary-impl(this.value);
    }

    public static int compareTo-impl(long arg0, @NotNull Value other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Value value = other;
        if (value instanceof ByteValue) {
            n = Intrinsics.compare((long)arg0, (long)((ByteValue)other).unbox-impl());
        } else if (value instanceof ShortValue) {
            n = Intrinsics.compare((long)arg0, (long)((ShortValue)other).unbox-impl());
        } else if (value instanceof IntValue) {
            n = Intrinsics.compare((long)arg0, (long)((IntValue)other).unbox-impl());
        } else if (value instanceof LongValue) {
            n = Intrinsics.compare((long)arg0, (long)((LongValue)other).unbox-impl());
        } else if (value instanceof DoubleValue) {
            n = Double.compare(arg0, ((DoubleValue)other).unbox-impl());
        } else if (value instanceof FloatValue) {
            n = Float.compare(arg0, ((FloatValue)other).unbox-impl());
        } else if (value instanceof Complex32Value) {
            n = Float.compare(arg0, ((Complex32Value)other).unbox-impl()[0]);
        } else if (value instanceof Complex64Value) {
            n = Double.compare(arg0, ((Complex64Value)other).unbox-impl()[0]);
        } else {
            throw new IllegalArgumentException("LongValues can only be compared to other numeric values.");
        }
        return n;
    }

    @Override
    public int compareTo(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return LongValue.compareTo-impl(this.value, other);
    }

    public static boolean isEqual-impl(long arg0, @NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other instanceof LongValue && ((LongValue)other).unbox-impl() == arg0;
    }

    @Override
    public boolean isEqual(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return LongValue.isEqual-impl(this.value, other);
    }

    public static double asDouble-Z2rTJmk(long arg0) {
        return DoubleValue.constructor-impl((double)arg0);
    }

    @Override
    public double asDouble-Z2rTJmk() {
        return LongValue.asDouble-Z2rTJmk(this.value);
    }

    public static float asFloat-JbzPQW8(long arg0) {
        return FloatValue.constructor-impl(arg0);
    }

    @Override
    public float asFloat-JbzPQW8() {
        return LongValue.asFloat-JbzPQW8(this.value);
    }

    public static int asInt-HuW2oqM(long arg0) {
        return IntValue.constructor-impl((int)arg0);
    }

    @Override
    public int asInt-HuW2oqM() {
        return LongValue.asInt-HuW2oqM(this.value);
    }

    public static long asLong-LWoHqF4(long arg0) {
        return arg0;
    }

    @Override
    public long asLong-LWoHqF4() {
        return LongValue.asLong-LWoHqF4(this.value);
    }

    public static short asShort-0l6I1b0(long arg0) {
        return ShortValue.constructor-impl((short)arg0);
    }

    @Override
    public short asShort-0l6I1b0() {
        return LongValue.asShort-0l6I1b0(this.value);
    }

    public static byte asByte-pCuLKj8(long arg0) {
        return ByteValue.constructor-impl((byte)arg0);
    }

    @Override
    public byte asByte-pCuLKj8() {
        return LongValue.asByte-pCuLKj8(this.value);
    }

    @NotNull
    public static float[] asComplex32-WO0UQc4(long arg0) {
        return Complex32Value.constructor-impl(FloatValue.box-impl(LongValue.asFloat-JbzPQW8(arg0)), FloatValue.box-impl(FloatValue.constructor-impl(0.0f)));
    }

    @Override
    @NotNull
    public float[] asComplex32-WO0UQc4() {
        return LongValue.asComplex32-WO0UQc4(this.value);
    }

    @NotNull
    public static double[] asComplex64-IY5coek(long arg0) {
        return Complex64Value.constructor-impl(DoubleValue.box-impl(LongValue.asDouble-Z2rTJmk(arg0)), DoubleValue.box-impl(DoubleValue.constructor-impl(0.0)));
    }

    @Override
    @NotNull
    public double[] asComplex64-IY5coek() {
        return LongValue.asComplex64-IY5coek(this.value);
    }

    public static long unaryMinus-LWoHqF4(long arg0) {
        return LongValue.constructor-impl(-arg0);
    }

    public long unaryMinus-LWoHqF4() {
        return LongValue.unaryMinus-LWoHqF4(this.value);
    }

    public static long plus--D-JnrY(long arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return LongValue.constructor-impl(arg0 + ((Number)other.getValue()).longValue());
    }

    public long plus--D-JnrY(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return LongValue.plus--D-JnrY(this.value, other);
    }

    public static long minus--D-JnrY(long arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return LongValue.constructor-impl(arg0 - ((Number)other.getValue()).longValue());
    }

    public long minus--D-JnrY(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return LongValue.minus--D-JnrY(this.value, other);
    }

    public static long times--D-JnrY(long arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return LongValue.constructor-impl(arg0 * ((Number)other.getValue()).longValue());
    }

    public long times--D-JnrY(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return LongValue.times--D-JnrY(this.value, other);
    }

    public static long div--D-JnrY(long arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return LongValue.constructor-impl(arg0 / ((Number)other.getValue()).longValue());
    }

    public long div--D-JnrY(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return LongValue.div--D-JnrY(this.value, other);
    }

    public static long abs-LWoHqF4(long arg0) {
        long l = arg0;
        boolean bl = false;
        return LongValue.constructor-impl(Math.abs(l));
    }

    public long abs-LWoHqF4() {
        return LongValue.abs-LWoHqF4(this.value);
    }

    public static double pow-He8yXgM(long arg0, int x) {
        return DoubleValue.pow-He8yXgM(LongValue.asDouble-Z2rTJmk(arg0), x);
    }

    public double pow-He8yXgM(int x) {
        return LongValue.pow-He8yXgM(this.value, x);
    }

    public static double pow-He8yXgM(long arg0, double x) {
        return DoubleValue.pow-He8yXgM(LongValue.asDouble-Z2rTJmk(arg0), x);
    }

    public double pow-He8yXgM(double x) {
        return LongValue.pow-He8yXgM(this.value, x);
    }

    public static double sqrt-Z2rTJmk(long arg0) {
        return DoubleValue.sqrt-Z2rTJmk(LongValue.asDouble-Z2rTJmk(arg0));
    }

    public double sqrt-Z2rTJmk() {
        return LongValue.sqrt-Z2rTJmk(this.value);
    }

    public static double exp-Z2rTJmk(long arg0) {
        return DoubleValue.exp-Z2rTJmk(LongValue.asDouble-Z2rTJmk(arg0));
    }

    public double exp-Z2rTJmk() {
        return LongValue.exp-Z2rTJmk(this.value);
    }

    public static double ln-Z2rTJmk(long arg0) {
        return DoubleValue.ln-Z2rTJmk(LongValue.asDouble-Z2rTJmk(arg0));
    }

    public double ln-Z2rTJmk() {
        return LongValue.ln-Z2rTJmk(this.value);
    }

    public static double cos-Z2rTJmk(long arg0) {
        return DoubleValue.cos-Z2rTJmk(LongValue.asDouble-Z2rTJmk(arg0));
    }

    public double cos-Z2rTJmk() {
        return LongValue.cos-Z2rTJmk(this.value);
    }

    public static double sin-Z2rTJmk(long arg0) {
        return DoubleValue.sin-Z2rTJmk(LongValue.asDouble-Z2rTJmk(arg0));
    }

    public double sin-Z2rTJmk() {
        return LongValue.sin-Z2rTJmk(this.value);
    }

    public static double tan-Z2rTJmk(long arg0) {
        return DoubleValue.tan-Z2rTJmk(LongValue.asDouble-Z2rTJmk(arg0));
    }

    public double tan-Z2rTJmk() {
        return LongValue.tan-Z2rTJmk(this.value);
    }

    public static double atan-Z2rTJmk(long arg0) {
        return DoubleValue.atan-Z2rTJmk(LongValue.asDouble-Z2rTJmk(arg0));
    }

    public double atan-Z2rTJmk() {
        return LongValue.atan-Z2rTJmk(this.value);
    }

    public static String toString-impl(long arg0) {
        return "LongValue(value=" + arg0 + ')';
    }

    public String toString() {
        return LongValue.toString-impl(this.value);
    }

    public static int hashCode-impl(long arg0) {
        return Long.hashCode(arg0);
    }

    public int hashCode() {
        return LongValue.hashCode-impl(this.value);
    }

    public static boolean equals-impl(long arg0, Object other) {
        if (!(other instanceof LongValue)) {
            return false;
        }
        long l = ((LongValue)other).unbox-impl();
        return arg0 == l;
    }

    public boolean equals(Object other) {
        return LongValue.equals-impl(this.value, other);
    }

    private /* synthetic */ LongValue(long value) {
        this.value = value;
    }

    public static long constructor-impl(long value) {
        long l = value;
        return l;
    }

    public static final /* synthetic */ LongValue box-impl(long v) {
        return new LongValue(v);
    }

    public final /* synthetic */ long unbox-impl() {
        return this.value;
    }

    public static final boolean equals-impl0(long p1, long p2) {
        return p1 == p2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\f\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\r\u0010\u000eR\u001c\u0010\u0003\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\b\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\t\u0010\u0006\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u000f"}, d2={"Lorg/vitrivr/cottontail/model/values/LongValue$Companion;", "", "()V", "ONE", "Lorg/vitrivr/cottontail/model/values/LongValue;", "getONE-LWoHqF4", "()J", "J", "ZERO", "getZERO-LWoHqF4", "random", "rnd", "Ljava/util/SplittableRandom;", "random--D-JnrY", "(Ljava/util/SplittableRandom;)J", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public final long getZERO-LWoHqF4() {
            return ZERO;
        }

        public final long getONE-LWoHqF4() {
            return ONE;
        }

        public final long random--D-JnrY(@NotNull SplittableRandom rnd) {
            Intrinsics.checkNotNullParameter((Object)rnd, (String)"rnd");
            return LongValue.constructor-impl(rnd.nextLong());
        }

        public static /* synthetic */ long random--D-JnrY$default(Companion companion, SplittableRandom splittableRandom, int n, Object object) {
            if ((n & 1) != 0) {
                splittableRandom = Value.Companion.getRANDOM();
            }
            return companion.random--D-JnrY(splittableRandom);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

