/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.cli.entity;

import com.github.ajalt.clikt.completion.CompletionCandidates;
import com.github.ajalt.clikt.core.ParameterHolder;
import com.github.ajalt.clikt.core.UsageError;
import com.github.ajalt.clikt.parameters.options.OptionCallTransformContext;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.options.ValueWithDefault;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.cli.AbstractCottontailCommand;
import org.vitrivr.cottontail.cli.entity.DumpEntityCommand$special$;
import org.vitrivr.cottontail.client.SimpleClient;
import org.vitrivr.cottontail.client.iterators.Tuple;
import org.vitrivr.cottontail.client.iterators.TupleIterator;
import org.vitrivr.cottontail.client.language.dql.Query;
import org.vitrivr.cottontail.utilities.data.Format;
import org.vitrivr.cottontail.utilities.data.exporter.DataExporter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/vitrivr/cottontail/cli/entity/DumpEntityCommand;", "Lorg/vitrivr/cottontail/cli/AbstractCottontailCommand$Entity;", "client", "Lorg/vitrivr/cottontail/client/SimpleClient;", "(Lorg/vitrivr/cottontail/client/SimpleClient;)V", "format", "Lorg/vitrivr/cottontail/utilities/data/Format;", "getFormat", "()Lorg/vitrivr/cottontail/utilities/data/Format;", "format$delegate", "Lkotlin/properties/ReadOnlyProperty;", "out", "Ljava/nio/file/Path;", "getOut", "()Ljava/nio/file/Path;", "out$delegate", "exec", "", "cottontaildb"})
@ExperimentalTime
public final class DumpEntityCommand
extends AbstractCottontailCommand.Entity {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty out$delegate;
    @NotNull
    private final ReadOnlyProperty format$delegate;

    public DumpEntityCommand(@NotNull SimpleClient client) {
        Function1 metavar$iv$iv;
        String[] $this$convert$iv$iv;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(client, "dump", "Dumps the content of an entire entity to disk.", false, 8, null);
        String[] stringArray = new String[]{"-o", "--out"};
        String[] $this$convert_u24default$iv = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Path to the output folder (file name will be determined by entity and format).", null, (boolean)false, null, null, null, null, (int)252, null);
        Function1 metavar$iv = special$$inlined$convert$default$1.INSTANCE;
        CompletionCandidates completionCandidates$iv = (CompletionCandidates)$this$convert_u24default$iv.getCompletionCandidatesWithDefault().getDefault();
        String[] stringArray2 = $this$convert_u24default$iv;
        Function1 function1 = metavar$iv;
        CompletionCandidates completionCandidates$iv$iv = completionCandidates$iv;
        boolean $i$f$convert = false;
        Function2 proc$iv$iv = (Function2)new Function2<OptionCallTransformContext, String, Path>((OptionWithValues)$this$convert$iv$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Path invoke(@NotNull OptionCallTransformContext $this$null, @NotNull String it) {
                Path path;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    String string = (String)this.$this_convert.getTransformValue().invoke((Object)$this$null, (Object)it);
                    OptionCallTransformContext $this$out_delegate_u24lambda_u2d0 = $this$null;
                    boolean bl = false;
                    path = Paths.get((String)it2, new String[0]);
                }
                catch (UsageError err) {
                    err.setParamName($this$null.getName());
                    throw err;
                }
                catch (Exception err) {
                    String string = err.getMessage();
                    $this$null.fail(string == null ? "" : string);
                    throw new KotlinNothingValueException();
                }
                return path;
            }
        };
        this.out$delegate = OptionWithValuesKt.required((OptionWithValues)OptionWithValues.copy$default((OptionWithValues)$this$convert$iv$iv, (Function2)proc$iv$iv, (Function2)OptionWithValuesKt.defaultEachProcessor(), (Function2)OptionWithValuesKt.defaultAllProcessor(), (Function2)OptionWithValuesKt.defaultValidator(), null, (ValueWithDefault)ValueWithDefault.copy$default((ValueWithDefault)$this$convert$iv$iv.getMetavarWithDefault(), null, (Object)metavar$iv$iv, (int)1, null), (int)0, null, (boolean)false, null, null, null, null, null, (ValueWithDefault)ValueWithDefault.copy$default((ValueWithDefault)$this$convert$iv$iv.getCompletionCandidatesWithDefault(), null, (Object)completionCandidates$iv$iv, (int)1, null), (int)16336, null)).provideDelegate((ParameterHolder)this, $$delegatedProperties[0]);
        $this$convert_u24default$iv = new String[]{"-f", "--format"};
        $this$convert_u24default$iv = OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])$this$convert_u24default$iv, (String)"Export format. Defaults to PROTO.", null, (boolean)false, null, null, null, null, (int)252, null);
        metavar$iv = special$$inlined$convert$default$3.INSTANCE;
        completionCandidates$iv = (CompletionCandidates)$this$convert_u24default$iv.getCompletionCandidatesWithDefault().getDefault();
        $this$convert$iv$iv = $this$convert_u24default$iv;
        metavar$iv$iv = metavar$iv;
        completionCandidates$iv$iv = completionCandidates$iv;
        $i$f$convert = false;
        proc$iv$iv = (Function2)new Function2<OptionCallTransformContext, String, Format>((OptionWithValues)$this$convert$iv$iv){
            final /* synthetic */ OptionWithValues $this_convert;
            {
                this.$this_convert = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Format invoke(@NotNull OptionCallTransformContext $this$null, @NotNull String it) {
                Format format;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    String string = (String)this.$this_convert.getTransformValue().invoke((Object)$this$null, (Object)it);
                    OptionCallTransformContext $this$format_delegate_u24lambda_u2d1 = $this$null;
                    boolean bl = false;
                    format = Format.valueOf((String)it2);
                }
                catch (UsageError err) {
                    err.setParamName($this$null.getName());
                    throw err;
                }
                catch (Exception err) {
                    String string = err.getMessage();
                    $this$null.fail(string == null ? "" : string);
                    throw new KotlinNothingValueException();
                }
                return format;
            }
        };
        this.format$delegate = OptionWithValuesKt.default$default((OptionWithValues)OptionWithValues.copy$default((OptionWithValues)$this$convert$iv$iv, (Function2)proc$iv$iv, (Function2)OptionWithValuesKt.defaultEachProcessor(), (Function2)OptionWithValuesKt.defaultAllProcessor(), (Function2)OptionWithValuesKt.defaultValidator(), null, (ValueWithDefault)ValueWithDefault.copy$default((ValueWithDefault)$this$convert$iv$iv.getMetavarWithDefault(), null, (Object)metavar$iv$iv, (int)1, null), (int)0, null, (boolean)false, null, null, null, null, null, (ValueWithDefault)ValueWithDefault.copy$default((ValueWithDefault)$this$convert$iv$iv.getCompletionCandidatesWithDefault(), null, (Object)completionCandidates$iv$iv, (int)1, null), (int)16336, null), (Object)((Object)Format.PROTO), null, (int)2, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[1]);
    }

    private final Path getOut() {
        Object object = this.out$delegate.getValue((Object)this, $$delegatedProperties[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-out>(...)");
        return (Path)object;
    }

    private final Format getFormat() {
        return (Format)((Object)this.format$delegate.getValue((Object)this, $$delegatedProperties[1]));
    }

    @Override
    public void exec() {
        Query qm = new Query(this.getEntityName().toString());
        Path path = this.getOut().resolve(this.getEntityName() + '.' + this.getFormat().getSuffix());
        Format format = this.getFormat();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        DataExporter dataExporter = format.newExporter(path);
        try {
            boolean $i$f$measureTime = false;
            boolean bl = false;
            TimeSource $this$measureTime$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            boolean bl2 = false;
            TimeMark mark$iv$iv = $this$measureTime$iv$iv.markNow();
            boolean bl3 = false;
            TupleIterator results = this.getClient().query(qm);
            Iterator iterator2 = (Iterator)results;
            boolean bl4 = false;
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Tuple r = (Tuple)iterator3.next();
                dataExporter.offer(r);
            }
            dataExporter.close();
            long duration = mark$iv$iv.elapsedNow-UwyO8pc();
            String string = "Dumping " + this.getEntityName() + " took " + Duration.toString-impl((long)duration) + '.';
            boolean bl5 = false;
            System.out.println((Object)string);
        }
        catch (Throwable e) {
            String string = "A " + e.getClass().getSimpleName() + " occurred while executing and exporting query: " + e.getMessage() + '.';
            boolean bl = false;
            System.out.print((Object)string);
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DumpEntityCommand.class, "out", "getOut()Ljava/nio/file/Path;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DumpEntityCommand.class, "format", "getFormat()Lorg/vitrivr/cottontail/utilities/data/Format;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

