/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.general.TxAction;
import org.vitrivr.cottontail.database.general.TxSnapshot;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.index.IndexConfig;
import org.vitrivr.cottontail.database.index.IndexHeader;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.index.NoIndexConfig;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.sort.SortOrder;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.utilities.io.TxFileUtilities;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000 :2\u00020\u0001:\u0002:;B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00108\u001a\u000209H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000eR\u0014\u0010\u001b\u001a\u00020\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R,\u0010&\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020(0'0\u0010X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010+\u001a\u0004\b)\u0010*R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u00100\u001a\u000201X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u000205X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006<"}, d2={"Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "Lorg/vitrivr/cottontail/database/index/Index;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/Entity;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "getCloseLock", "()Ljava/util/concurrent/locks/StampedLock;", "closed", "", "getClosed", "()Z", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumns", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "config", "Lorg/vitrivr/cottontail/database/index/IndexConfig;", "getConfig", "()Lorg/vitrivr/cottontail/database/index/IndexConfig;", "dirty", "getDirty", "dirtyField", "Lorg/mapdb/Atomic$Boolean;", "getDirtyField", "()Lorg/mapdb/Atomic$Boolean;", "headerField", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/database/index/IndexHeader;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "order", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;", "getOrder", "()[Lkotlin/Pair;", "[Lkotlin/Pair;", "getParent", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "getPath", "()Ljava/nio/file/Path;", "store", "Lorg/mapdb/DB;", "getStore", "()Lorg/mapdb/DB;", "version", "Lorg/vitrivr/cottontail/database/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/database/general/DBOVersion;", "close", "", "Companion", "Tx", "cottontaildb"})
public abstract class AbstractIndex
implements Index {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @NotNull
    private final Entity parent;
    @NotNull
    private final StampedLock closeLock;
    @NotNull
    private final DB store;
    @NotNull
    private final Atomic.Var<IndexHeader> headerField;
    @NotNull
    private final Atomic.Boolean dirtyField;
    @NotNull
    private final Name.IndexName name;
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    private final Pair<ColumnDef<?>, SortOrder>[] order;
    @NotNull
    private final DBOVersion version;
    @NotNull
    private final IndexConfig config;
    @NotNull
    public static final String INDEX_HEADER_FIELD = "cdb_index_header";
    @NotNull
    public static final String INDEX_CONFIG_FIELD = "cdb_index_config";
    @NotNull
    public static final String INDEX_DIRTY_FIELD = "cdb_index_dirty";

    public AbstractIndex(@NotNull Path path, @NotNull Entity parent) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.path = path;
        this.parent = parent;
        this.closeLock = new StampedLock();
        this.store = this.parent.getParent().getParent().getConfig().getMapdb().db(this.path);
        this.headerField = (Atomic.Var)this.store.atomicVar(INDEX_HEADER_FIELD, (Serializer)IndexHeader.Serializer).createOrOpen();
        this.dirtyField = (Atomic.Boolean)this.store.atomicBoolean(INDEX_DIRTY_FIELD).createOrOpen();
        this.name = this.parent.getName().index(((IndexHeader)this.headerField.get()).getName());
        this.columns = ((IndexHeader)this.headerField.get()).getColumns();
        boolean $i$f$emptyArray = false;
        this.order = (Pair[])((Object[])new Pair[0]);
        this.version = DBOVersion.V2_0;
        this.config = NoIndexConfig.INSTANCE;
    }

    @Override
    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public final Entity getParent() {
        return this.parent;
    }

    @NotNull
    protected final StampedLock getCloseLock() {
        return this.closeLock;
    }

    @NotNull
    protected final DB getStore() {
        return this.store;
    }

    @NotNull
    protected final Atomic.Boolean getDirtyField() {
        return this.dirtyField;
    }

    @Override
    @NotNull
    public Name.IndexName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    @Override
    @NotNull
    public Pair<ColumnDef<?>, SortOrder>[] getOrder() {
        return this.order;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public IndexConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean getDirty() {
        return this.dirtyField.get();
    }

    @Override
    public boolean getClosed() {
        return this.store.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-AbstractIndex$close$22 = false;
            if (!this.getClosed()) {
                this.getStore().close();
            }
            Unit $i$a$-write-AbstractIndex$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/database/index/AbstractIndex$Companion;", "", "()V", "INDEX_CONFIG_FIELD", "", "INDEX_DIRTY_FIELD", "INDEX_HEADER_FIELD", "initialize", "", "path", "Ljava/nio/file/Path;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Lorg/vitrivr/cottontail/database/index/IndexType;[Lorg/vitrivr/cottontail/database/column/ColumnDef;Lorg/vitrivr/cottontail/config/Config;)V", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public final void initialize(@NotNull Path path, @NotNull Name.IndexName name, @NotNull IndexType type, @NotNull ColumnDef<?>[] columns, @NotNull Config config) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Path path2 = path.resolve(Intrinsics.stringPlus((String)name.getSimple(), (Object)".idx"));
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.resolve(\"${name.simple}.idx\")");
            Path dataPath = TxFileUtilities.INSTANCE.createPath(path2);
            if (Files.exists(path, new LinkOption[0])) {
                throw new DatabaseException.InvalidFileException("Failed to create index '" + name + "': A file already exists under " + path + '.');
            }
            try {
                DB db = config.getMapdb().db(path);
                Atomic.Var header = (Atomic.Var)db.atomicVar(AbstractIndex.INDEX_HEADER_FIELD, (Serializer)IndexHeader.Serializer).create();
                header.set((Object)new IndexHeader(name.getSimple(), type, columns, 0L, 0L, 24, null));
                db.commit();
                db.close();
            }
            catch (DBException e) {
                TxFileUtilities.INSTANCE.delete(dataPath);
                throw new DatabaseException("Failed to create index '" + name + "' due to error in the underlying data store: {" + e.getMessage(), null, 2, null);
            }
            catch (IOException e) {
                TxFileUtilities.INSTANCE.delete(dataPath);
                throw new DatabaseException("Failed to create index '" + name + "' due to an IO exception: {" + e.getMessage(), null, 2, null);
            }
            catch (Throwable e) {
                TxFileUtilities.INSTANCE.delete(dataPath);
                throw new DatabaseException("Failed to create index '" + name + "' due to an unexpected error: {" + e.getMessage(), null, 2, null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00a4\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR*\u0010\f\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00020\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lorg/vitrivr/cottontail/database/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/database/general/AbstractTx;", "Lorg/vitrivr/cottontail/database/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/index/AbstractIndex;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "getDbo", "()Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "order", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;", "getOrder", "()[Lkotlin/Pair;", "snapshot", "Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "snapshot$delegate", "Lkotlin/Lazy;", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "canProcess", "", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "cleanup", "", "cottontaildb"})
    protected abstract class Tx
    extends AbstractTx
    implements IndexTx {
        private final long closeStamp;
        @NotNull
        private final Lazy snapshot$delegate;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)AbstractIndex.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.closeStamp = AbstractIndex.this.getCloseLock().readLock();
            this.snapshot$delegate = LazyKt.lazy((Function0)((Function0)new Function0<snapshot.1>(AbstractIndex.this){
                final /* synthetic */ AbstractIndex this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final snapshot.1 invoke() {
                    return new TxSnapshot(this.this$0){
                        @NotNull
                        private final List<TxAction> actions;
                        final /* synthetic */ AbstractIndex this$0;
                        {
                            this.this$0 = $receiver;
                            this.actions = CollectionsKt.emptyList();
                        }

                        @NotNull
                        public List<TxAction> getActions() {
                            return this.actions;
                        }

                        public void commit() {
                            this.this$0.getStore().commit();
                        }

                        public void rollback() {
                            this.this$0.getStore().rollback();
                        }

                        public boolean record(@NotNull TxAction action) {
                            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                            return false;
                        }
                    };
                }
            }));
        }

        @Override
        @NotNull
        public AbstractIndex getDbo() {
            return AbstractIndex.this;
        }

        @Override
        @NotNull
        public Pair<ColumnDef<?>, SortOrder>[] getOrder() {
            return AbstractIndex.this.getOrder();
        }

        @Override
        @NotNull
        public IndexType getType() {
            return AbstractIndex.this.getType();
        }

        @Override
        @NotNull
        public TxSnapshot getSnapshot() {
            Lazy lazy = this.snapshot$delegate;
            Object var2_2 = null;
            boolean bl = false;
            return (TxSnapshot)lazy.getValue();
        }

        @Override
        public boolean canProcess(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return AbstractIndex.this.canProcess(predicate);
        }

        @Override
        protected void cleanup() {
            AbstractIndex.this.getCloseLock().unlock(this.closeStamp);
        }
    }
}

