/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.va.bounds;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.index.va.bounds.Bounds;
import org.vitrivr.cottontail.database.index.va.signature.Marks;
import org.vitrivr.cottontail.database.index.va.signature.VAFSignature;
import org.vitrivr.cottontail.model.values.types.RealVectorValue;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001c\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001c\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/database/index/va/bounds/L1Bounds;", "Lorg/vitrivr/cottontail/database/index/va/bounds/Bounds;", "query", "Lorg/vitrivr/cottontail/model/values/types/RealVectorValue;", "marks", "Lorg/vitrivr/cottontail/database/index/va/signature/Marks;", "(Lorg/vitrivr/cottontail/model/values/types/RealVectorValue;[[DLkotlin/jvm/internal/DefaultConstructorMarker;)V", "lat", "", "", "[[Ljava/lang/Double;", "<set-?>", "lb", "getLb", "()D", "rq", "", "ub", "getUb", "isVASSACandidate", "", "signature", "Lorg/vitrivr/cottontail/database/index/va/signature/VAFSignature;", "threshold", "update", "cottontaildb"})
public final class L1Bounds
implements Bounds {
    private double lb;
    private double ub;
    @NotNull
    private final int[] rq;
    @NotNull
    private final Double[][] lat;

    private L1Bounds(RealVectorValue<?> query2, double[][] marks) {
        this.rq = Marks.getCells-impl(marks, query2);
        int n = ((Object[])marks).length;
        Double[][] doubleArrayArray = new Double[n][];
        L1Bounds l1Bounds = this;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            double qj = ((Number)query2.get(n2).getValue()).doubleValue();
            int n3 = 0;
            int n4 = marks[n2].length;
            Double[] doubleArray = new Double[n4];
            int n5 = n2;
            Double[][] doubleArrayArray2 = doubleArrayArray;
            while (n3 < n4) {
                int n6 = n3++;
                double d = qj - marks[n2][n6];
                boolean bl = false;
                doubleArray[n6] = Math.abs(d);
            }
            doubleArrayArray2[n5] = doubleArray;
        }
        l1Bounds.lat = doubleArrayArray;
    }

    @Override
    public double getLb() {
        return this.lb;
    }

    @Override
    public double getUb() {
        return this.ub;
    }

    @Override
    @NotNull
    public L1Bounds update(@NotNull VAFSignature signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.lb = 0.0;
        this.ub = 0.0;
        int[] nArray = signature.getCells();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            L1Bounds l1Bounds;
            int j = i;
            int rij = nArray[i];
            if (rij < this.rq[j]) {
                l1Bounds = this;
                l1Bounds.lb = l1Bounds.getLb() + this.lat[j][rij + 1];
                l1Bounds = this;
                l1Bounds.ub = l1Bounds.getUb() + this.lat[j][rij];
                continue;
            }
            if (rij != this.rq[j]) continue;
            l1Bounds = this;
            double d = this.lat[j][rij];
            double d2 = this.lat[j][rij + 1];
            boolean bl = false;
            l1Bounds.ub = l1Bounds.getUb() + Math.max(d, d2);
        }
        return this;
    }

    @Override
    public boolean isVASSACandidate(@NotNull VAFSignature signature, double threshold) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        double lb = 0.0;
        int[] nArray = signature.getCells();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int j = n;
            int rij = nArray[n];
            ++n;
            if (rij < this.rq[j]) {
                lb += this.lat[j][rij + 1].doubleValue();
            } else if (rij > this.rq[j]) {
                lb += this.lat[j][rij].doubleValue();
            }
            if (!(lb >= threshold)) continue;
            return false;
        }
        return lb < threshold;
    }

    public /* synthetic */ L1Bounds(RealVectorValue query2, double[][] marks, DefaultConstructorMarker $constructor_marker) {
        this(query2, marks);
    }
}

