/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.queries.OperatorNode;
import org.vitrivr.cottontail.database.queries.binding.BindingContext;
import org.vitrivr.cottontail.database.queries.binding.DefaultBindingContext;
import org.vitrivr.cottontail.database.queries.sort.SortOrder;
import org.vitrivr.cottontail.execution.TransactionManager;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.model.exceptions.QueryException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010-\u001a\u00020\u00142\n\u0010.\u001a\u00060\u0011j\u0002`\u0012H\u0086\u0002J\n\u0010/\u001a\u00060\u0011j\u0002`\u0012J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0014J\u0006\u00103\u001a\u000204R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u0012\u0012\b\u0012\u00060\u0011j\u0002`\u0012\u0012\u0004\u0012\u00020\u00140\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0019\u001a\u001a\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0004\u0012\u00020\u001d0\u001b\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001d\u0010 \u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR(\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\"\u001a\u0004\u0018\u00010#@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0015\u0010\u0006\u001a\u00060\u0007R\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u00065"}, d2={"Lorg/vitrivr/cottontail/database/queries/QueryContext;", "", "queryId", "", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "txn", "Lorg/vitrivr/cottontail/execution/TransactionManager$TransactionImpl;", "Lorg/vitrivr/cottontail/execution/TransactionManager;", "(Ljava/lang/String;Lorg/vitrivr/cottontail/database/catalogue/Catalogue;Lorg/vitrivr/cottontail/execution/TransactionManager$TransactionImpl;)V", "bindings", "Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "getBindings", "()Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "groupIdCounter", "", "Lorg/vitrivr/cottontail/database/queries/GroupId;", "logical", "Lorg/vitrivr/cottontail/database/queries/OperatorNode$Logical;", "getLogical", "()Lorg/vitrivr/cottontail/database/queries/OperatorNode$Logical;", "nodes", "", "order", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "Lorg/vitrivr/cottontail/database/queries/sort/SortOrder;", "getOrder", "()Ljava/util/List;", "output", "getOutput", "<set-?>", "Lorg/vitrivr/cottontail/database/queries/OperatorNode$Physical;", "physical", "getPhysical", "()Lorg/vitrivr/cottontail/database/queries/OperatorNode$Physical;", "setPhysical$cottontaildb", "(Lorg/vitrivr/cottontail/database/queries/OperatorNode$Physical;)V", "getQueryId", "()Ljava/lang/String;", "getTxn", "()Lorg/vitrivr/cottontail/execution/TransactionManager$TransactionImpl;", "get", "groupId", "nextGroupId", "register", "", "plan", "toOperatorTree", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator;", "cottontaildb"})
public final class QueryContext {
    @NotNull
    private final String queryId;
    @NotNull
    private final Catalogue catalogue;
    @NotNull
    private final TransactionManager.TransactionImpl txn;
    @NotNull
    private final BindingContext bindings;
    @NotNull
    private final Map<Integer, OperatorNode.Logical> nodes;
    @Nullable
    private OperatorNode.Physical physical;
    private volatile int groupIdCounter;

    public QueryContext(@NotNull String queryId, @NotNull Catalogue catalogue, @NotNull TransactionManager.TransactionImpl txn) {
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        this.queryId = queryId;
        this.catalogue = catalogue;
        this.txn = txn;
        this.bindings = new DefaultBindingContext(0, 1, null);
        this.nodes = (Map)new Int2ObjectOpenHashMap();
    }

    @NotNull
    public final String getQueryId() {
        return this.queryId;
    }

    @NotNull
    public final Catalogue getCatalogue() {
        return this.catalogue;
    }

    @NotNull
    public final TransactionManager.TransactionImpl getTxn() {
        return this.txn;
    }

    @NotNull
    public final BindingContext getBindings() {
        return this.bindings;
    }

    @Nullable
    public final OperatorNode.Logical getLogical() {
        return this.nodes.get(0);
    }

    @Nullable
    public final OperatorNode.Physical getPhysical() {
        return this.physical;
    }

    public final void setPhysical$cottontaildb(@Nullable OperatorNode.Physical physical) {
        this.physical = physical;
    }

    @Nullable
    public final List<ColumnDef<?>> getOutput() {
        OperatorNode.Logical logical = this.nodes.get(0);
        return logical == null ? null : logical.getColumns();
    }

    @Nullable
    public final List<Pair<ColumnDef<?>, SortOrder>> getOrder() {
        OperatorNode.Logical logical = this.nodes.get(0);
        return logical == null ? null : logical.getSortOn();
    }

    public final int nextGroupId() {
        QueryContext queryContext = this;
        int n = queryContext.groupIdCounter;
        queryContext.groupIdCounter = n + 1;
        return n;
    }

    public final void register(@NotNull OperatorNode.Logical plan) {
        Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
        Map<Integer, OperatorNode.Logical> map2 = this.nodes;
        Integer n = plan.getGroupId();
        boolean bl = false;
        map2.put(n, plan);
    }

    @NotNull
    public final OperatorNode.Logical get(int groupId) {
        OperatorNode.Logical logical = this.nodes.get(groupId);
        if (logical == null) {
            throw new QueryException.QueryPlannerException(Intrinsics.stringPlus((String)"Failed to access sub-query with groupId ", (Object)groupId));
        }
        return logical;
    }

    @NotNull
    public final Operator toOperatorTree() {
        OperatorNode.Physical local = this.physical;
        boolean bl = local != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            IllegalStateException illegalStateException = new IllegalStateException("Cannot generate an operator tree without a valid, physical node expression tree.");
            throw (Throwable)new IllegalStateException(((Object)illegalStateException).toString());
        }
        return local.toOperator(this);
    }
}

