/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.values;

import java.util.Arrays;
import java.util.SplittableRandom;
import kotlin.Metadata;
import kotlin.jvm.JvmInline;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.ByteValue;
import org.vitrivr.cottontail.model.values.Complex64Value;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.FloatValue;
import org.vitrivr.cottontail.model.values.IntValue;
import org.vitrivr.cottontail.model.values.LongValue;
import org.vitrivr.cottontail.model.values.ShortValue;
import org.vitrivr.cottontail.model.values.types.ComplexValue;
import org.vitrivr.cottontail.model.values.types.NumericValue;
import org.vitrivr.cottontail.model.values.types.RealValue;
import org.vitrivr.cottontail.model.values.types.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JvmInline
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0013\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0087@\u0018\u0000 b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001bB\u0014\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0014\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0004\u0010\bB\u0018\b\u0016\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\t\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0004\u0010\nB$\b\u0016\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u000b\u0012\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u000b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0004\u0010\rB\u001c\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0004\u0010\u000eB\u001c\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0004\u0010\u000fB\u0012\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0012J\u0018\u0010$\u001a\u00020\u0015H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b%\u0010\u0017J\u0018\u0010&\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b'\u0010\u0012J\u0018\u0010(\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b*\u0010+J\u0018\u0010,\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b-\u0010+J\u0018\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u000200H\u0096\u0002\u00a2\u0006\u0004\b1\u00102J\u0018\u00103\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b4\u0010\u0012J\u0018\u00105\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b6\u0010+J%\u00107\u001a\u00020\u00002\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\tH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b8\u00109J\u001a\u0010:\u001a\u00020;2\b\u0010/\u001a\u0004\u0018\u00010<H\u00d6\u0003\u00a2\u0006\u0004\b=\u0010>J\u0018\u0010?\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b@\u0010+J\u0010\u0010A\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\bB\u0010\u001bJ\u0018\u0010C\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\bD\u0010\u0012J\u0017\u0010E\u001a\u00020;2\u0006\u0010/\u001a\u000200H\u0016\u00a2\u0006\u0004\bF\u0010GJ\u0018\u0010H\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\bI\u0010+J%\u0010J\u001a\u00020\u00002\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\tH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\bK\u00109J%\u0010L\u001a\u00020\u00002\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\tH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\bM\u00109J \u0010N\u001a\u00020)2\u0006\u0010O\u001a\u00020PH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\bQ\u0010RJ \u0010N\u001a\u00020)2\u0006\u0010O\u001a\u00020\u0019H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\bQ\u0010SJ\u0018\u0010T\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\bU\u0010+J\u0018\u0010V\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\bW\u0010+J\u0018\u0010X\u001a\u00020)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\bY\u0010+J%\u0010Z\u001a\u00020\u00002\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\tH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b[\u00109J\u0010\u0010\\\u001a\u00020]H\u00d6\u0001\u00a2\u0006\u0004\b^\u0010_J\u0019\u0010`\u001a\u00020\u0000H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\ba\u0010\u0012R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\f\u001a\u00020\u00158VX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u0003\u001a\u00020\u00158VX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0017R\u0018\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u0088\u0001\u0010\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006c"}, d2={"Lorg/vitrivr/cottontail/model/values/Complex32Value;", "Lorg/vitrivr/cottontail/model/values/types/ComplexValue;", "", "real", "constructor-impl", "(F)[F", "number", "", "(Ljava/lang/Number;)[F", "Lorg/vitrivr/cottontail/model/values/types/NumericValue;", "(Lorg/vitrivr/cottontail/model/values/types/NumericValue;)[F", "Lorg/vitrivr/cottontail/model/values/types/RealValue;", "imaginary", "(Lorg/vitrivr/cottontail/model/values/types/RealValue;Lorg/vitrivr/cottontail/model/values/types/RealValue;)[F", "(FF)[F", "(Ljava/lang/Number;Ljava/lang/Number;)[F", "data", "", "([F)[F", "getData", "()[F", "Lorg/vitrivr/cottontail/model/values/FloatValue;", "getImaginary-JbzPQW8", "([F)F", "logicalSize", "", "getLogicalSize-impl", "([F)I", "getReal-JbzPQW8", "type", "Lorg/vitrivr/cottontail/model/basics/Type;", "getType-impl", "([F)Lorg/vitrivr/cottontail/model/basics/Type;", "value", "getValue-impl", "([F)Ljava/lang/Float;", "abs", "abs-JbzPQW8", "asComplex32", "asComplex32-WO0UQc4", "asComplex64", "Lorg/vitrivr/cottontail/model/values/Complex64Value;", "asComplex64-IY5coek", "([F)[D", "atan", "atan-IY5coek", "compareTo", "other", "Lorg/vitrivr/cottontail/model/values/types/Value;", "compareTo-impl", "([FLorg/vitrivr/cottontail/model/values/types/Value;)I", "conjugate", "conjugate-WO0UQc4", "cos", "cos-IY5coek", "div", "div-8fBXkOU", "([FLorg/vitrivr/cottontail/model/values/types/NumericValue;)[F", "equals", "", "", "equals-impl", "([FLjava/lang/Object;)Z", "exp", "exp-IY5coek", "hashCode", "hashCode-impl", "inverse", "inverse-WO0UQc4", "isEqual", "isEqual-impl", "([FLorg/vitrivr/cottontail/model/values/types/Value;)Z", "ln", "ln-IY5coek", "minus", "minus-8fBXkOU", "plus", "plus-8fBXkOU", "pow", "x", "", "pow-tQYLdqw", "([FD)[D", "([FI)[D", "sin", "sin-IY5coek", "sqrt", "sqrt-IY5coek", "tan", "tan-IY5coek", "times", "times-8fBXkOU", "toString", "", "toString-impl", "([F)Ljava/lang/String;", "unaryMinus", "unaryMinus-WO0UQc4", "Companion", "cottontaildb"})
public final class Complex32Value
implements ComplexValue<Float> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[] data;
    @NotNull
    private static final float[] I;
    @NotNull
    private static final float[] ZERO;
    @NotNull
    private static final float[] ONE;
    @NotNull
    private static final float[] NaN;
    @NotNull
    private static final float[] INF;

    @NotNull
    public final float[] getData() {
        return this.data;
    }

    @NotNull
    public static float[] constructor-impl(float real) {
        float[] fArray = new float[]{real, 0.0f};
        float[] fArray2 = Complex32Value.constructor-impl(fArray);
        return fArray2;
    }

    @NotNull
    public static float[] constructor-impl(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        float[] fArray = new float[]{number.floatValue(), 0.0f};
        float[] fArray2 = Complex32Value.constructor-impl(fArray);
        return fArray2;
    }

    @NotNull
    public static float[] constructor-impl(@NotNull NumericValue<?> number) {
        float[] fArray;
        Intrinsics.checkNotNullParameter(number, (String)"number");
        NumericValue<?> numericValue = number;
        if (numericValue instanceof ComplexValue) {
            float[] fArray2 = new float[]{((Number)number.getReal().getValue()).floatValue(), ((Number)number.getImaginary().getValue()).floatValue()};
            fArray = fArray2;
        } else {
            float[] fArray3 = new float[]{((Number)number.getValue()).floatValue(), 0.0f};
            fArray = fArray3;
        }
        float[] fArray4 = Complex32Value.constructor-impl(fArray);
        return fArray4;
    }

    @NotNull
    public static float[] constructor-impl(@NotNull RealValue<?> real, @NotNull RealValue<?> imaginary) {
        Intrinsics.checkNotNullParameter(real, (String)"real");
        Intrinsics.checkNotNullParameter(imaginary, (String)"imaginary");
        float[] fArray = Complex32Value.constructor-impl(real.getValue(), imaginary.getValue());
        return fArray;
    }

    @NotNull
    public static float[] constructor-impl(float real, float imaginary) {
        float[] fArray = new float[]{real, imaginary};
        float[] fArray2 = Complex32Value.constructor-impl(fArray);
        return fArray2;
    }

    @NotNull
    public static float[] constructor-impl(@NotNull Number real, @NotNull Number imaginary) {
        Intrinsics.checkNotNullParameter((Object)real, (String)"real");
        Intrinsics.checkNotNullParameter((Object)imaginary, (String)"imaginary");
        float[] fArray = new float[]{real.floatValue(), imaginary.floatValue()};
        float[] fArray2 = Complex32Value.constructor-impl(fArray);
        return fArray2;
    }

    @NotNull
    public static Float getValue-impl(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Float.valueOf(arg0[0]);
    }

    @Override
    @NotNull
    public Float getValue() {
        return Complex32Value.getValue-impl(this.data);
    }

    public static float getReal-JbzPQW8(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return FloatValue.constructor-impl(arg0[0]);
    }

    public float getReal-JbzPQW8() {
        return Complex32Value.getReal-JbzPQW8(this.data);
    }

    public static float getImaginary-JbzPQW8(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return FloatValue.constructor-impl(arg0[1]);
    }

    public float getImaginary-JbzPQW8() {
        return Complex32Value.getImaginary-JbzPQW8(this.data);
    }

    public static int getLogicalSize-impl(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return 1;
    }

    @Override
    public int getLogicalSize() {
        return Complex32Value.getLogicalSize-impl(this.data);
    }

    @NotNull
    public static Type<?> getType-impl(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Type.Complex32.INSTANCE;
    }

    @Override
    @NotNull
    public Type<?> getType() {
        return Complex32Value.getType-impl(this.data);
    }

    /*
     * WARNING - void declaration
     */
    public static int compareTo-impl(float[] arg0, @NotNull Value other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Value value = other;
        if (value instanceof ByteValue) {
            n = Float.compare(Complex32Value.getValue-impl(arg0).floatValue(), ((ByteValue)other).unbox-impl());
        } else if (value instanceof ShortValue) {
            n = Float.compare(Complex32Value.getValue-impl(arg0).floatValue(), ((ShortValue)other).unbox-impl());
        } else if (value instanceof IntValue) {
            n = Float.compare(Complex32Value.getValue-impl(arg0).floatValue(), ((IntValue)other).unbox-impl());
        } else if (value instanceof LongValue) {
            n = Float.compare(Complex32Value.getValue-impl(arg0).floatValue(), ((LongValue)other).unbox-impl());
        } else if (value instanceof DoubleValue) {
            n = Double.compare(Complex32Value.getValue-impl(arg0).floatValue(), ((DoubleValue)other).unbox-impl());
        } else if (value instanceof FloatValue) {
            n = Float.compare(Complex32Value.getValue-impl(arg0).floatValue(), ((FloatValue)other).unbox-impl());
        } else if (value instanceof Complex32Value) {
            int real = FloatValue.compareTo-impl(Complex32Value.getReal-JbzPQW8(arg0), FloatValue.box-impl(Complex32Value.getReal-JbzPQW8(((Complex32Value)other).unbox-impl())));
            n = real == 0 ? real + FloatValue.compareTo-impl(Complex32Value.getImaginary-JbzPQW8(arg0), FloatValue.box-impl(Complex32Value.getImaginary-JbzPQW8(((Complex32Value)other).unbox-impl()))) : real;
        } else if (value instanceof Complex64Value) {
            void var3_4;
            int real = FloatValue.compareTo-impl(Complex32Value.getReal-JbzPQW8(arg0), DoubleValue.box-impl(Complex64Value.getReal-Z2rTJmk(((Complex64Value)other).unbox-impl())));
            n = real == 0 ? real + FloatValue.compareTo-impl(Complex32Value.getImaginary-JbzPQW8(arg0), DoubleValue.box-impl(Complex64Value.getImaginary-Z2rTJmk(((Complex64Value)other).unbox-impl()))) : var3_4;
        } else {
            throw new IllegalArgumentException("LongValues can only be compared to other numeric values.");
        }
        return n;
    }

    @Override
    public int compareTo(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Complex32Value.compareTo-impl(this.data, other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEqual-impl(float[] arg0, @NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof Complex32Value)) return false;
        float[] fArray = arg0;
        float[] fArray2 = ((Complex32Value)other).unbox-impl();
        boolean bl = false;
        if (!Arrays.equals(fArray, fArray2)) return false;
        return true;
    }

    @Override
    public boolean isEqual(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Complex32Value.isEqual-impl(this.data, other);
    }

    @NotNull
    public static float[] asComplex32-WO0UQc4(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return arg0;
    }

    @Override
    @NotNull
    public float[] asComplex32-WO0UQc4() {
        return Complex32Value.asComplex32-WO0UQc4(this.data);
    }

    @NotNull
    public static double[] asComplex64-IY5coek(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex64Value.constructor-impl(Float.valueOf(arg0[0]), Float.valueOf(arg0[1]));
    }

    @Override
    @NotNull
    public double[] asComplex64-IY5coek() {
        return Complex32Value.asComplex64-IY5coek(this.data);
    }

    @NotNull
    public static float[] inverse-WO0UQc4(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex32Value.constructor-impl(arg0[0] / (arg0[0] * arg0[0] + arg0[1] * arg0[1]), -(arg0[1] / (arg0[0] * arg0[0] + arg0[1] * arg0[1])));
    }

    @NotNull
    public float[] inverse-WO0UQc4() {
        return Complex32Value.inverse-WO0UQc4(this.data);
    }

    @NotNull
    public static float[] conjugate-WO0UQc4(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex32Value.constructor-impl(arg0[0], -arg0[1]);
    }

    @NotNull
    public float[] conjugate-WO0UQc4() {
        return Complex32Value.conjugate-WO0UQc4(this.data);
    }

    @NotNull
    public static float[] unaryMinus-WO0UQc4(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex32Value.constructor-impl(-arg0[0], -arg0[1]);
    }

    @NotNull
    public float[] unaryMinus-WO0UQc4() {
        return Complex32Value.unaryMinus-WO0UQc4(this.data);
    }

    @NotNull
    public static float[] plus-8fBXkOU(float[] arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        NumericValue<?> numericValue = other;
        return numericValue instanceof Complex32Value ? Complex32Value.constructor-impl(arg0[0] + ((Complex32Value)other).unbox-impl()[0], arg0[1] + ((Complex32Value)other).unbox-impl()[1]) : (numericValue instanceof Complex64Value ? Complex32Value.constructor-impl((double)arg0[0] + ((Complex64Value)other).unbox-impl()[0], (double)arg0[1] + ((Complex64Value)other).unbox-impl()[1]) : Complex32Value.constructor-impl((double)arg0[0] + other.getReal().asDouble-Z2rTJmk(), Float.valueOf(arg0[1])));
    }

    @NotNull
    public float[] plus-8fBXkOU(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32Value.plus-8fBXkOU(this.data, other);
    }

    @NotNull
    public static float[] minus-8fBXkOU(float[] arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        NumericValue<?> numericValue = other;
        return numericValue instanceof Complex32Value ? Complex32Value.constructor-impl(arg0[0] - ((Complex32Value)other).unbox-impl()[0], arg0[1] - ((Complex32Value)other).unbox-impl()[1]) : (numericValue instanceof Complex64Value ? Complex32Value.constructor-impl((double)arg0[0] - ((Complex64Value)other).unbox-impl()[0], (double)arg0[1] - ((Complex64Value)other).unbox-impl()[1]) : Complex32Value.constructor-impl((double)arg0[0] - other.getReal().asDouble-Z2rTJmk(), Float.valueOf(arg0[1])));
    }

    @NotNull
    public float[] minus-8fBXkOU(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32Value.minus-8fBXkOU(this.data, other);
    }

    @NotNull
    public static float[] times-8fBXkOU(float[] arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        NumericValue<?> numericValue = other;
        return numericValue instanceof Complex32Value ? Complex32Value.constructor-impl(arg0[0] * ((Complex32Value)other).unbox-impl()[0] - arg0[1] * ((Complex32Value)other).unbox-impl()[1], arg0[0] * ((Complex32Value)other).unbox-impl()[1] + arg0[1] * ((Complex32Value)other).unbox-impl()[0]) : (numericValue instanceof Complex64Value ? Complex32Value.constructor-impl((double)arg0[0] * ((Complex64Value)other).unbox-impl()[0] - (double)arg0[1] * ((Complex64Value)other).unbox-impl()[1], (double)arg0[0] * ((Complex64Value)other).unbox-impl()[1] + (double)arg0[1] * ((Complex64Value)other).unbox-impl()[0]) : Complex32Value.constructor-impl((double)arg0[0] * other.getReal().asDouble-Z2rTJmk(), (double)arg0[1] * other.getReal().asDouble-Z2rTJmk()));
    }

    @NotNull
    public float[] times-8fBXkOU(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32Value.times-8fBXkOU(this.data, other);
    }

    @NotNull
    public static float[] div-8fBXkOU(float[] arg0, @NotNull NumericValue<?> other) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        NumericValue<?> numericValue = other;
        if (numericValue instanceof Complex32Value) {
            float c = ((Complex32Value)other).unbox-impl()[0];
            float d = ((Complex32Value)other).unbox-impl()[1];
            boolean bl = false;
            bl = false;
            if (Math.abs(c) < Math.abs(d)) {
                float q = c / d;
                float denominator = c * q + d;
                fArray = Complex32Value.constructor-impl((arg0[0] * q + arg0[1]) / denominator, (arg0[1] * q - arg0[0]) / denominator);
            } else {
                float q2 = d / c;
                float denominator = d * q2 + c;
                fArray = Complex32Value.constructor-impl((arg0[1] * q2 + arg0[0]) / denominator, (arg0[1] - arg0[0] * q2) / denominator);
            }
        } else if (numericValue instanceof Complex64Value) {
            double q;
            double c = ((Complex64Value)other).unbox-impl()[0];
            boolean q2 = false;
            double d = Math.abs(c);
            c = ((Complex64Value)other).unbox-impl()[1];
            q2 = false;
            if (d < Math.abs(c)) {
                q = ((Complex64Value)other).unbox-impl()[0] / ((Complex64Value)other).unbox-impl()[1];
                double denominator = ((Complex64Value)other).unbox-impl()[0] * q + ((Complex64Value)other).unbox-impl()[1];
                fArray = Complex32Value.constructor-impl(((double)arg0[0] * q + (double)arg0[1]) / denominator, ((double)arg0[1] * q - (double)arg0[0]) / denominator);
            } else {
                q = ((Complex64Value)other).unbox-impl()[1] / ((Complex64Value)other).unbox-impl()[0];
                double denominator = ((Complex64Value)other).unbox-impl()[1] * q + ((Complex64Value)other).unbox-impl()[0];
                fArray = Complex32Value.constructor-impl(((double)arg0[1] * q + (double)arg0[0]) / denominator, ((double)arg0[1] - (double)arg0[0] * q) / denominator);
            }
        } else {
            float c = other.asFloat-JbzPQW8();
            fArray = Complex32Value.constructor-impl(arg0[0] / c, arg0[1] / c);
        }
        return fArray;
    }

    @NotNull
    public float[] div-8fBXkOU(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32Value.div-8fBXkOU(this.data, other);
    }

    public static float abs-JbzPQW8(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        float f = arg0[0] * arg0[0] + arg0[1] * arg0[1];
        boolean bl = false;
        return FloatValue.constructor-impl((float)Math.sqrt(f));
    }

    public float abs-JbzPQW8() {
        return Complex32Value.abs-JbzPQW8(this.data);
    }

    @NotNull
    public static double[] pow-tQYLdqw(float[] arg0, double x) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        float f = Complex32Value.abs-JbzPQW8(arg0);
        boolean bl = false;
        double real = x * (double)((float)Math.log(f));
        float f2 = arg0[1];
        float f3 = arg0[0];
        boolean bl2 = false;
        double imaginary = x * (double)((float)Math.atan2(f2, f3));
        bl2 = false;
        double exp = Math.exp(real);
        bl2 = false;
        bl2 = false;
        return Complex64Value.constructor-impl(exp * Math.cos(imaginary), exp * Math.sin(imaginary));
    }

    @NotNull
    public double[] pow-tQYLdqw(double x) {
        return Complex32Value.pow-tQYLdqw(this.data, x);
    }

    @NotNull
    public static double[] pow-tQYLdqw(float[] arg0, int x) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        float f = Complex32Value.abs-JbzPQW8(arg0);
        boolean bl = false;
        float real = (float)x * (float)Math.log(f);
        float f2 = arg0[1];
        float f3 = arg0[0];
        boolean bl2 = false;
        float imaginary = (float)x * (float)Math.atan2(f2, f3);
        boolean bl3 = false;
        float exp = (float)Math.exp(real);
        bl3 = false;
        bl3 = false;
        return Complex64Value.constructor-impl(Float.valueOf(exp * (float)Math.cos(imaginary)), Float.valueOf(exp * (float)Math.sin(imaginary)));
    }

    @NotNull
    public double[] pow-tQYLdqw(int x) {
        return Complex32Value.pow-tQYLdqw(this.data, x);
    }

    @NotNull
    public static double[] exp-IY5coek(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        float f = arg0[0];
        boolean bl = false;
        float expReal = (float)Math.exp(f);
        f = arg0[1];
        bl = false;
        Number number = Float.valueOf(expReal * (float)Math.cos(f));
        f = arg0[1];
        bl = false;
        return Complex64Value.constructor-impl(number, Float.valueOf(expReal * (float)Math.sin(f)));
    }

    @NotNull
    public double[] exp-IY5coek() {
        return Complex32Value.exp-IY5coek(this.data);
    }

    @NotNull
    public static double[] ln-IY5coek(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        float f = Complex32Value.abs-JbzPQW8(arg0);
        boolean bl = false;
        Number number = Float.valueOf((float)Math.log(f));
        f = arg0[1];
        float f2 = arg0[0];
        boolean bl2 = false;
        return Complex64Value.constructor-impl(number, Float.valueOf((float)Math.atan2(f, f2)));
    }

    @NotNull
    public double[] ln-IY5coek() {
        return Complex32Value.ln-IY5coek(this.data);
    }

    @NotNull
    public static double[] sqrt-IY5coek(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex32Value.pow-tQYLdqw(arg0, 0.5);
    }

    @NotNull
    public double[] sqrt-IY5coek() {
        return Complex32Value.sqrt-IY5coek(this.data);
    }

    @NotNull
    public static double[] cos-IY5coek(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        float f = arg0[0];
        boolean bl = false;
        float f2 = (float)Math.cos(f);
        f = arg0[1];
        bl = false;
        Number number = Float.valueOf(f2 * (float)Math.cosh(f));
        f = arg0[0];
        bl = false;
        float f3 = -((float)Math.sin(f));
        f = arg0[1];
        bl = false;
        return Complex64Value.constructor-impl(number, Float.valueOf(f3 * (float)Math.sinh(f)));
    }

    @NotNull
    public double[] cos-IY5coek() {
        return Complex32Value.cos-IY5coek(this.data);
    }

    @NotNull
    public static double[] sin-IY5coek(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        float f = arg0[0];
        boolean bl = false;
        float f2 = (float)Math.sin(f);
        f = arg0[1];
        bl = false;
        Number number = Float.valueOf(f2 * (float)Math.cosh(f));
        f = arg0[0];
        bl = false;
        float f3 = (float)Math.cos(f);
        f = arg0[1];
        bl = false;
        return Complex64Value.constructor-impl(number, Float.valueOf(f3 * (float)Math.sinh(f)));
    }

    @NotNull
    public double[] sin-IY5coek() {
        return Complex32Value.sin-IY5coek(this.data);
    }

    @NotNull
    public static double[] tan-IY5coek(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        if ((double)arg0[1] > 20.0) {
            return Complex64Value.constructor-impl(0.0, 1.0);
        }
        if ((double)arg0[1] < -20.0) {
            return Complex64Value.constructor-impl(0.0, -1.0);
        }
        double r = 2.0 * (double)arg0[0];
        double i = 2.0 * (double)arg0[1];
        boolean bl = false;
        bl = false;
        double d = Math.cos(r) + Math.cosh(i);
        bl = false;
        bl = false;
        return Complex64Value.constructor-impl(Math.sin(r) / d, Math.sinh(i) / d);
    }

    @NotNull
    public double[] tan-IY5coek() {
        return Complex32Value.tan-IY5coek(this.data);
    }

    @NotNull
    public static double[] atan-IY5coek(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        float[] fArray = new float[]{2.0f, 0.0f};
        return Complex64Value.times-tQYLdqw(Complex32Value.ln-IY5coek(Complex32Value.div-8fBXkOU(Complex32Value.plus-8fBXkOU(arg0, Complex32Value.box-impl(I)), Complex32Value.box-impl(Complex32Value.minus-8fBXkOU(I, Complex32Value.box-impl(arg0))))), Complex32Value.box-impl(Complex32Value.div-8fBXkOU(I, Complex32Value.box-impl(Complex32Value.constructor-impl(fArray)))));
    }

    @NotNull
    public double[] atan-IY5coek() {
        return Complex32Value.atan-IY5coek(this.data);
    }

    public static byte asByte-pCuLKj8(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex32Value.box-impl(arg0).asByte-pCuLKj8();
    }

    @Override
    public byte asByte-pCuLKj8() {
        return ComplexValue.DefaultImpls.asByte-pCuLKj8(this);
    }

    public static double asDouble-Z2rTJmk(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex32Value.box-impl(arg0).asDouble-Z2rTJmk();
    }

    @Override
    public double asDouble-Z2rTJmk() {
        return ComplexValue.DefaultImpls.asDouble-Z2rTJmk(this);
    }

    public static float asFloat-JbzPQW8(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex32Value.box-impl(arg0).asFloat-JbzPQW8();
    }

    @Override
    public float asFloat-JbzPQW8() {
        return ComplexValue.DefaultImpls.asFloat-JbzPQW8(this);
    }

    public static int asInt-HuW2oqM(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex32Value.box-impl(arg0).asInt-HuW2oqM();
    }

    @Override
    public int asInt-HuW2oqM() {
        return ComplexValue.DefaultImpls.asInt-HuW2oqM(this);
    }

    public static long asLong-LWoHqF4(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex32Value.box-impl(arg0).asLong-LWoHqF4();
    }

    @Override
    public long asLong-LWoHqF4() {
        return ComplexValue.DefaultImpls.asLong-LWoHqF4(this);
    }

    public static short asShort-0l6I1b0(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex32Value.box-impl(arg0).asShort-0l6I1b0();
    }

    @Override
    public short asShort-0l6I1b0() {
        return ComplexValue.DefaultImpls.asShort-0l6I1b0(this);
    }

    public static String toString-impl(float[] arg0) {
        return "Complex32Value(data=" + Arrays.toString(arg0) + ')';
    }

    public String toString() {
        return Complex32Value.toString-impl(this.data);
    }

    public static int hashCode-impl(float[] arg0) {
        return Arrays.hashCode(arg0);
    }

    public int hashCode() {
        return Complex32Value.hashCode-impl(this.data);
    }

    public static boolean equals-impl(float[] arg0, Object other) {
        if (!(other instanceof Complex32Value)) {
            return false;
        }
        float[] fArray = ((Complex32Value)other).unbox-impl();
        return Intrinsics.areEqual((Object)arg0, (Object)fArray);
    }

    public boolean equals(Object other) {
        return Complex32Value.equals-impl(this.data, other);
    }

    private /* synthetic */ Complex32Value(float[] data) {
        this.data = data;
    }

    @NotNull
    public static float[] constructor-impl(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float[] fArray = data;
        return fArray;
    }

    public static final /* synthetic */ Complex32Value box-impl(float[] v) {
        return new Complex32Value(v);
    }

    public final /* synthetic */ float[] unbox-impl() {
        return this.data;
    }

    public static final boolean equals-impl0(float[] p1, float[] p2) {
        return Intrinsics.areEqual((Object)p1, (Object)p2);
    }

    static {
        float[] fArray = new float[]{0.0f, 1.0f};
        I = Complex32Value.constructor-impl(fArray);
        fArray = new float[]{0.0f, 0.0f};
        ZERO = Complex32Value.constructor-impl(fArray);
        fArray = new float[]{1.0f, 0.0f};
        ONE = Complex32Value.constructor-impl(fArray);
        fArray = new float[]{Float.NaN, Float.NaN};
        NaN = Complex32Value.constructor-impl(fArray);
        fArray = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY};
        INF = Complex32Value.constructor-impl(fArray);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0003\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\b\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\t\u0010\u0006R\u001c\u0010\n\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u000b\u0010\u0006R\u001c\u0010\f\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\r\u0010\u0006R\u001c\u0010\u000e\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u000f\u0010\u0006\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/model/values/Complex32Value$Companion;", "", "()V", "I", "Lorg/vitrivr/cottontail/model/values/Complex32Value;", "getI-WO0UQc4", "()[F", "[F", "INF", "getINF-WO0UQc4", "NaN", "getNaN-WO0UQc4", "ONE", "getONE-WO0UQc4", "ZERO", "getZERO-WO0UQc4", "random", "rnd", "Ljava/util/SplittableRandom;", "random-8fBXkOU", "(Ljava/util/SplittableRandom;)[F", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final float[] getI-WO0UQc4() {
            return I;
        }

        @NotNull
        public final float[] getZERO-WO0UQc4() {
            return ZERO;
        }

        @NotNull
        public final float[] getONE-WO0UQc4() {
            return ONE;
        }

        @NotNull
        public final float[] getNaN-WO0UQc4() {
            return NaN;
        }

        @NotNull
        public final float[] getINF-WO0UQc4() {
            return INF;
        }

        @NotNull
        public final float[] random-8fBXkOU(@NotNull SplittableRandom rnd) {
            Intrinsics.checkNotNullParameter((Object)rnd, (String)"rnd");
            int n = 0;
            float[] fArray = new float[2];
            while (n < 2) {
                int n2 = n++;
                fArray[n2] = (float)rnd.nextDouble();
            }
            return Complex32Value.constructor-impl(fArray);
        }

        public static /* synthetic */ float[] random-8fBXkOU$default(Companion companion, SplittableRandom splittableRandom, int n, Object object) {
            if ((n & 1) != 0) {
                splittableRandom = Value.Companion.getRANDOM();
            }
            return companion.random-8fBXkOU(splittableRandom);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

