/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.values;

import java.util.Arrays;
import java.util.Iterator;
import java.util.SplittableRandom;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.Complex32Value;
import org.vitrivr.cottontail.model.values.Complex32VectorValue;
import org.vitrivr.cottontail.model.values.Complex64Value;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.DoubleVectorValue;
import org.vitrivr.cottontail.model.values.types.ComplexValue;
import org.vitrivr.cottontail.model.values.types.ComplexVectorValue;
import org.vitrivr.cottontail.model.values.types.NumericValue;
import org.vitrivr.cottontail.model.values.types.RealValue;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.model.values.types.VectorValue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JvmInline
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0087@\u0018\u0000 y2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001yB\u001a\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001a\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\b0\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0006\u0010\tB\u0012\u0012\u0006\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0018\u0010\u001b\u001a\u00020\u001cH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001d\u0010\fJ\u000f\u0010\u001e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b#\u0010!J\u0018\u0010$\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b%\u0010\fJ\u0018\u0010&\u001a\u00020\u001cH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b'\u0010\fJ\u0018\u0010(\u001a\u00020\u001cH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b)\u0010\fJ%\u0010*\u001a\u00020\u00002\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b-\u0010.J%\u0010*\u001a\u00020\u00002\n\u0010+\u001a\u0006\u0012\u0002\b\u00030/H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b-\u00100J%\u00101\u001a\u00020\b2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030/H\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b2\u00100J\"\u00103\u001a\u0002042\n\u0010+\u001a\u0006\u0012\u0002\b\u00030/\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b5\u00106J\u001a\u00107\u001a\u00020\u001f2\b\u0010+\u001a\u0004\u0018\u000108H\u00d6\u0003\u00a2\u0006\u0004\b9\u0010:J!\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020\u0014H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b=\u0010>J\u0017\u0010?\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b@\u0010AJ\u0010\u0010B\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\bC\u0010\u0016J \u0010D\u001a\u0002042\u0006\u0010<\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bE\u0010FJ\u001d\u0010G\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0005H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00a2\u0006\u0004\bH\u0010IJ\u001d\u0010J\u001a\u00020\u00002\u0006\u0010+\u001a\u00020KH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00a2\u0006\u0004\bL\u0010IJ\u001d\u0010M\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\bH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00a2\u0006\u0004\bN\u0010OJ\u001d\u0010P\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0000H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00a2\u0006\u0004\bQ\u0010OJ\u0017\u0010R\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020SH\u0016\u00a2\u0006\u0004\bT\u0010UJ%\u0010V\u001a\u0002042\n\u0010+\u001a\u0006\u0012\u0002\b\u00030/H\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bW\u00106J%\u0010X\u001a\u0002042\n\u0010+\u001a\u0006\u0012\u0002\b\u00030/H\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bY\u00106J\"\u0010Z\u001a\u0002042\n\u0010+\u001a\u0006\u0012\u0002\b\u00030/\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b[\u00106J%\u0010\\\u001a\u00020\u00002\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b]\u0010.J%\u0010\\\u001a\u00020\u00002\n\u0010+\u001a\u0006\u0012\u0002\b\u00030/H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b]\u00100J\u0018\u0010^\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b_\u0010\fJ\u0018\u0010`\u001a\u000204H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\ba\u0010bJ%\u0010c\u001a\u00020\u00002\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bd\u0010.J%\u0010c\u001a\u00020\u00002\n\u0010+\u001a\u0006\u0012\u0002\b\u00030/H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bd\u00100J \u0010e\u001a\u00020\u00002\u0006\u0010f\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bg\u0010>J \u0010h\u001a\u0002042\u0006\u0010<\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bi\u0010FJ\u0018\u0010j\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bk\u0010\fJ(\u0010l\u001a\u00020\u00002\u0006\u0010m\u001a\u00020\u00142\u0006\u0010n\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bo\u0010pJ\u0018\u0010q\u001a\u00020\bH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\br\u0010\fJ%\u0010s\u001a\u00020\u00002\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bt\u0010.J%\u0010s\u001a\u00020\u00002\n\u0010+\u001a\u0006\u0012\u0002\b\u00030/H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bt\u00100J\u0010\u0010u\u001a\u00020vH\u00d6\u0001\u00a2\u0006\u0004\bw\u0010xR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u0088\u0001\n\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006z"}, d2={"Lorg/vitrivr/cottontail/model/values/Complex64VectorValue;", "Lorg/vitrivr/cottontail/model/values/types/ComplexVectorValue;", "", "value", "", "Lorg/vitrivr/cottontail/model/values/Complex32Value;", "constructor-impl", "([Lorg/vitrivr/cottontail/model/values/Complex32Value;)[D", "Lorg/vitrivr/cottontail/model/values/Complex64Value;", "([Lorg/vitrivr/cottontail/model/values/Complex64Value;)[D", "data", "", "([D)[D", "getData", "()[D", "indices", "Lkotlin/ranges/IntRange;", "getIndices-impl", "([D)Lkotlin/ranges/IntRange;", "logicalSize", "", "getLogicalSize-impl", "([D)I", "type", "Lorg/vitrivr/cottontail/model/basics/Type;", "getType-impl", "([D)Lorg/vitrivr/cottontail/model/basics/Type;", "abs", "Lorg/vitrivr/cottontail/model/values/DoubleVectorValue;", "abs-Jz4_OW8", "allOnes", "", "allOnes-impl", "([D)Z", "allZeros", "allZeros-impl", "copy", "copy-Leomr7I", "copyImaginary", "copyImaginary-Jz4_OW8", "copyReal", "copyReal-Jz4_OW8", "div", "other", "Lorg/vitrivr/cottontail/model/values/types/NumericValue;", "div-BxIXzO8", "([DLorg/vitrivr/cottontail/model/values/types/NumericValue;)[D", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "([DLorg/vitrivr/cottontail/model/values/types/VectorValue;)[D", "dot", "dot-tQYLdqw", "dotRealPart", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "dotRealPart-He8yXgM", "([DLorg/vitrivr/cottontail/model/values/types/VectorValue;)D", "equals", "", "equals-impl", "([DLjava/lang/Object;)Z", "get", "i", "get-tQYLdqw", "([DI)[D", "getAsBool", "getAsBool-impl", "([DI)Z", "hashCode", "hashCode-impl", "imaginary", "imaginary-He8yXgM", "([DI)D", "internalComplex32ValueDiv", "internalComplex32ValueDiv-4Ci1IXY", "([D[F)[D", "internalComplex32VectorValueDiv", "Lorg/vitrivr/cottontail/model/values/Complex32VectorValue;", "internalComplex32VectorValueDiv-4s-1B_k", "internalComplex64ValueDiv", "internalComplex64ValueDiv-rgFtXmg", "([D[D)[D", "internalComplex64VectorValueDiv", "internalComplex64VectorValueDiv-kZeAFFk", "isEqual", "Lorg/vitrivr/cottontail/model/values/types/Value;", "isEqual-impl", "([DLorg/vitrivr/cottontail/model/values/types/Value;)Z", "l1", "l1-He8yXgM", "l2", "l2-He8yXgM", "l2sq", "l2sq-He8yXgM", "minus", "minus-BxIXzO8", "new", "new-Leomr7I", "norm2", "norm2-Z2rTJmk", "([D)D", "plus", "plus-BxIXzO8", "pow", "x", "pow-BxIXzO8", "real", "real-He8yXgM", "sqrt", "sqrt-Leomr7I", "subvector", "start", "length", "subvector-xPD-sHo", "([DII)[D", "sum", "sum-IY5coek", "times", "times-BxIXzO8", "toString", "", "toString-impl", "([D)Ljava/lang/String;", "Companion", "cottontaildb"})
public final class Complex64VectorValue
implements ComplexVectorValue<Double> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[] data;

    @NotNull
    public final double[] getData() {
        return this.data;
    }

    @NotNull
    public static double[] constructor-impl(@NotNull Complex32Value[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int n = 2 * value.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray[n2] = n2 % 2 == 0 ? (double)Complex32Value.getReal-JbzPQW8(value[n2 / 2].unbox-impl()) : (double)Complex32Value.getImaginary-JbzPQW8(value[n2 / 2].unbox-impl());
        }
        double[] dArray2 = Complex64VectorValue.constructor-impl(dArray);
        return dArray2;
    }

    @NotNull
    public static double[] constructor-impl(@NotNull Complex64Value[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int n = 2 * value.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray[n2] = n2 % 2 == 0 ? Complex64Value.getReal-Z2rTJmk(value[n2 / 2].unbox-impl()) : Complex64Value.getImaginary-Z2rTJmk(value[n2 / 2].unbox-impl());
        }
        double[] dArray2 = Complex64VectorValue.constructor-impl(dArray);
        return dArray2;
    }

    public static int getLogicalSize-impl(double[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return arg0.length / 2;
    }

    @Override
    public int getLogicalSize() {
        return Complex64VectorValue.getLogicalSize-impl(this.data);
    }

    @NotNull
    public static Type<?> getType-impl(double[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return new Type.Complex64Vector(Complex64VectorValue.getLogicalSize-impl(arg0));
    }

    @Override
    @NotNull
    public Type<?> getType() {
        return Complex64VectorValue.getType-impl(this.data);
    }

    @NotNull
    public static double[] get-tQYLdqw(double[] arg0, int i) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex64Value.constructor-impl(arg0[i << 1], arg0[(i << 1) + 1]);
    }

    @NotNull
    public double[] get-tQYLdqw(int i) {
        return Complex64VectorValue.get-tQYLdqw(this.data, i);
    }

    public static double real-He8yXgM(double[] arg0, int i) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return DoubleValue.constructor-impl(arg0[i << 1]);
    }

    public double real-He8yXgM(int i) {
        return Complex64VectorValue.real-He8yXgM(this.data, i);
    }

    public static double imaginary-He8yXgM(double[] arg0, int i) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return DoubleValue.constructor-impl(arg0[(i << 1) + 1]);
    }

    public double imaginary-He8yXgM(int i) {
        return Complex64VectorValue.imaginary-He8yXgM(this.data, i);
    }

    @NotNull
    public static double[] subvector-xPD-sHo(double[] arg0, int start, int length) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        double[] dArray = arg0;
        int n = 2 * start;
        int n2 = 2 * start + 2 * length;
        boolean bl = false;
        return Complex64VectorValue.constructor-impl(ArraysKt.copyOfRange((double[])dArray, (int)n, (int)n2));
    }

    @NotNull
    public double[] subvector-xPD-sHo(int start, int length) {
        return Complex64VectorValue.subvector-xPD-sHo(this.data, start, length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEqual-impl(double[] arg0, @NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof DoubleVectorValue)) return false;
        double[] dArray = arg0;
        double[] dArray2 = ((DoubleVectorValue)other).unbox-impl();
        boolean bl = false;
        if (!Arrays.equals(dArray, dArray2)) return false;
        return true;
    }

    @Override
    public boolean isEqual(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Complex64VectorValue.isEqual-impl(this.data, other);
    }

    @NotNull
    public static IntRange getIndices-impl(double[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return RangesKt.until((int)0, (int)Complex64VectorValue.getLogicalSize-impl(arg0));
    }

    @Override
    @NotNull
    public IntRange getIndices() {
        return Complex64VectorValue.getIndices-impl(this.data);
    }

    public static boolean getAsBool-impl(double[] arg0, int i) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return !Complex64Value.equals-impl0(Complex64VectorValue.get-tQYLdqw(arg0, i), Complex64Value.Companion.getZERO-IY5coek());
    }

    @Override
    public boolean getAsBool(int i) {
        return Complex64VectorValue.getAsBool-impl(this.data, i);
    }

    public static boolean allZeros-impl(double[] arg0) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
            double[] $this$all$iv = arg0;
            boolean $i$f$all = false;
            double[] dArray = $this$all$iv;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double element$iv;
                double it = element$iv = dArray[i];
                boolean bl2 = false;
                if (it == 0.0) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean allZeros() {
        return Complex64VectorValue.allZeros-impl(this.data);
    }

    public static boolean allOnes-impl(double[] arg0) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
            double[] $this$all$iv = arg0;
            boolean $i$f$all = false;
            double[] dArray = $this$all$iv;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double element$iv;
                double it = element$iv = dArray[i];
                boolean bl2 = false;
                if (it == 1.0) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean allOnes() {
        return Complex64VectorValue.allOnes-impl(this.data);
    }

    @NotNull
    public static double[] copy-Leomr7I(double[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        double[] dArray = arg0;
        boolean bl = false;
        double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)dArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return Complex64VectorValue.constructor-impl(dArray2);
    }

    @NotNull
    public double[] copy-Leomr7I() {
        return Complex64VectorValue.copy-Leomr7I(this.data);
    }

    @NotNull
    public static double[] new-Leomr7I(double[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex64VectorValue.constructor-impl(new double[arg0.length]);
    }

    @NotNull
    public double[] new-Leomr7I() {
        return Complex64VectorValue.new-Leomr7I(this.data);
    }

    @NotNull
    public static double[] copyReal-Jz4_OW8(double[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        int n = 0;
        int n2 = Complex64VectorValue.getLogicalSize-impl(arg0);
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = arg0[n3 << 1];
        }
        return DoubleVectorValue.constructor-impl(dArray);
    }

    @NotNull
    public double[] copyReal-Jz4_OW8() {
        return Complex64VectorValue.copyReal-Jz4_OW8(this.data);
    }

    @NotNull
    public static double[] copyImaginary-Jz4_OW8(double[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        int n = 0;
        int n2 = Complex64VectorValue.getLogicalSize-impl(arg0);
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = arg0[(n3 << 1) + 1];
        }
        return DoubleVectorValue.constructor-impl(dArray);
    }

    @NotNull
    public double[] copyImaginary-Jz4_OW8() {
        return Complex64VectorValue.copyImaginary-Jz4_OW8(this.data);
    }

    @NotNull
    public static double[] plus-BxIXzO8(double[] arg0, @NotNull VectorValue<?> other) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.getLogicalSize() == Complex64VectorValue.getLogicalSize-impl(arg0)) {
            VectorValue<?> vectorValue = other;
            if (vectorValue instanceof Complex32VectorValue) {
                int n = 0;
                int n2 = arg0.length;
                double[] dArray2 = new double[n2];
                while (n < n2) {
                    int n3 = n++;
                    dArray2[n3] = arg0[n3] + (double)((Complex32VectorValue)other).unbox-impl()[n3];
                }
                dArray = dArray2;
            } else if (vectorValue instanceof Complex64VectorValue) {
                int n = 0;
                int n4 = arg0.length;
                double[] dArray3 = new double[n4];
                while (n < n4) {
                    int n5 = n++;
                    dArray3[n5] = arg0[n5] + ((Complex64VectorValue)other).unbox-impl()[n5];
                }
                dArray = dArray3;
            } else {
                int n = arg0.length;
                double[] dArray4 = new double[n];
                for (int i = 0; i < n; ++i) {
                    int n6 = i;
                    dArray4[n6] = n6 % 2 == 0 ? arg0[n6] + ((Number)other.get(n6 / 2).getValue()).doubleValue() : arg0[n6];
                }
                dArray = dArray4;
            }
        } else {
            throw new IllegalArgumentException("Dimensions " + Complex64VectorValue.getLogicalSize-impl(arg0) + " and " + other.getLogicalSize() + " don't agree!");
        }
        return Complex64VectorValue.constructor-impl(dArray);
    }

    @NotNull
    public double[] plus-BxIXzO8(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex64VectorValue.plus-BxIXzO8(this.data, other);
    }

    @NotNull
    public static double[] minus-BxIXzO8(double[] arg0, @NotNull VectorValue<?> other) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        VectorValue<?> vectorValue = other;
        if (vectorValue instanceof Complex64VectorValue) {
            int n = 0;
            int n2 = Complex64VectorValue.getLogicalSize-impl(arg0) << 1;
            double[] dArray2 = new double[n2];
            while (n < n2) {
                int n3 = n++;
                dArray2[n3] = arg0[n3] - ((Complex64VectorValue)other).unbox-impl()[n3];
            }
            dArray = dArray2;
        } else if (vectorValue instanceof Complex32VectorValue) {
            int n = 0;
            int n4 = Complex64VectorValue.getLogicalSize-impl(arg0) << 1;
            double[] dArray3 = new double[n4];
            while (n < n4) {
                int n5 = n++;
                dArray3[n5] = arg0[n5] - (double)((Complex32VectorValue)other).unbox-impl()[n5];
            }
            dArray = dArray3;
        } else {
            int n = Complex64VectorValue.getLogicalSize-impl(arg0) << 1;
            double[] dArray4 = new double[n];
            for (int i = 0; i < n; ++i) {
                int n6 = i;
                dArray4[n6] = n6 % 2 == 0 ? arg0[n6] - ((Number)other.get(n6 / 2).getValue()).doubleValue() : arg0[n6];
            }
            dArray = dArray4;
        }
        return Complex64VectorValue.constructor-impl(dArray);
    }

    @NotNull
    public double[] minus-BxIXzO8(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex64VectorValue.minus-BxIXzO8(this.data, other);
    }

    @NotNull
    public static double[] times-BxIXzO8(double[] arg0, @NotNull VectorValue<?> other) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.getLogicalSize() == Complex64VectorValue.getLogicalSize-impl(arg0)) {
            VectorValue<?> vectorValue = other;
            if (vectorValue instanceof Complex32VectorValue) {
                int n = arg0.length;
                double[] dArray2 = new double[n];
                for (int i = 0; i < n; ++i) {
                    int n2 = i;
                    dArray2[n2] = n2 % 2 == 0 ? arg0[n2] * (double)((Complex32VectorValue)other).unbox-impl()[n2] - arg0[n2 + 1] * (double)((Complex32VectorValue)other).unbox-impl()[n2 + 1] : arg0[n2 - 1] * (double)((Complex32VectorValue)other).unbox-impl()[n2] + arg0[n2] * (double)((Complex32VectorValue)other).unbox-impl()[n2 - 1];
                }
                dArray = dArray2;
            } else if (vectorValue instanceof Complex64VectorValue) {
                int n = arg0.length;
                double[] dArray3 = new double[n];
                for (int i = 0; i < n; ++i) {
                    int n3 = i;
                    dArray3[n3] = n3 % 2 == 0 ? arg0[n3] * ((Complex64VectorValue)other).unbox-impl()[n3] - arg0[n3 + 1] * ((Complex64VectorValue)other).unbox-impl()[n3 + 1] : arg0[n3 - 1] * ((Complex64VectorValue)other).unbox-impl()[n3] + arg0[n3] * ((Complex64VectorValue)other).unbox-impl()[n3 - 1];
                }
                dArray = dArray3;
            } else {
                int n = 0;
                int n4 = arg0.length;
                double[] dArray4 = new double[n4];
                while (n < n4) {
                    int n5 = n++;
                    dArray4[n5] = arg0[n5] * ((Number)other.get(n5 / 2).getValue()).doubleValue();
                }
                dArray = dArray4;
            }
        } else {
            throw new IllegalArgumentException("Dimensions " + Complex64VectorValue.getLogicalSize-impl(arg0) + " and " + other.getLogicalSize() + " don't agree!");
        }
        return Complex64VectorValue.constructor-impl(dArray);
    }

    @NotNull
    public double[] times-BxIXzO8(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex64VectorValue.times-BxIXzO8(this.data, other);
    }

    @NotNull
    public static double[] div-BxIXzO8(double[] arg0, @NotNull VectorValue<?> other) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.getLogicalSize() == Complex64VectorValue.getLogicalSize-impl(arg0)) {
            VectorValue<?> vectorValue = other;
            if (vectorValue instanceof Complex64VectorValue) {
                dArray = Complex64VectorValue.internalComplex64VectorValueDiv-kZeAFFk(arg0, ((Complex64VectorValue)other).unbox-impl());
            } else if (vectorValue instanceof Complex32VectorValue) {
                dArray = Complex64VectorValue.internalComplex32VectorValueDiv-4s-1B_k(arg0, ((Complex32VectorValue)other).unbox-impl());
            } else {
                int n = 0;
                int n2 = arg0.length;
                double[] dArray2 = new double[n2];
                while (n < n2) {
                    int n3 = n++;
                    dArray2[n3] = arg0[n3] / ((Number)other.get(n3 / 2).getValue()).doubleValue();
                }
                dArray = Complex64VectorValue.constructor-impl(dArray2);
            }
        } else {
            throw new IllegalArgumentException("Dimensions " + Complex64VectorValue.getLogicalSize-impl(arg0) + " and " + other.getLogicalSize() + " don't agree!");
        }
        return dArray;
    }

    @NotNull
    public double[] div-BxIXzO8(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex64VectorValue.div-BxIXzO8(this.data, other);
    }

    private static final double[] internalComplex64VectorValueDiv-kZeAFFk(double[] arg0, double[] other) {
        double[] doubles = new double[arg0.length];
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                double denominator;
                double q;
                int i = n++;
                double c = other[i << 1];
                double d = other[(i << 1) + 1];
                boolean bl = false;
                bl = false;
                if (Math.abs(c) < Math.abs(d)) {
                    q = c / d;
                    denominator = c * q + d;
                    doubles[i << 1] = (arg0[i << 1] * q + arg0[(i << 1) + 1]) / denominator;
                    doubles[(i << 1) + 1] = (arg0[(i << 1) + 1] * q - arg0[i << 1]) / denominator;
                    continue;
                }
                q = d / c;
                denominator = d * q + c;
                doubles[i << 1] = (arg0[(i << 1) + 1] * q + arg0[i << 1]) / denominator;
                doubles[(i << 1) + 1] = (arg0[(i << 1) + 1] - arg0[i << 1] * q) / denominator;
            } while (n < n2);
        }
        return Complex64VectorValue.constructor-impl(doubles);
    }

    private static final double[] internalComplex32VectorValueDiv-4s-1B_k(double[] arg0, float[] other) {
        double[] doubles = new double[arg0.length];
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                float denominator;
                float q;
                int i = n++;
                float c = other[i << 1];
                float d = other[(i << 1) + 1];
                boolean bl = false;
                bl = false;
                if (Math.abs(c) < Math.abs(d)) {
                    q = c / d;
                    denominator = c * q + d;
                    doubles[i << 1] = (arg0[i << 1] * (double)q + arg0[(i << 1) + 1]) / (double)denominator;
                    doubles[(i << 1) + 1] = (arg0[(i << 1) + 1] * (double)q - arg0[i << 1]) / (double)denominator;
                    continue;
                }
                q = d / c;
                denominator = d * q + c;
                doubles[i << 1] = (arg0[(i << 1) + 1] * (double)q + arg0[i << 1]) / (double)denominator;
                doubles[(i << 1) + 1] = (arg0[(i << 1) + 1] - arg0[i << 1] * (double)q) / (double)denominator;
            } while (n < n2);
        }
        return Complex64VectorValue.constructor-impl(doubles);
    }

    @NotNull
    public static double[] plus-BxIXzO8(double[] arg0, @NotNull NumericValue<?> other) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        NumericValue<?> numericValue = other;
        if (numericValue instanceof Complex32Value) {
            int n = arg0.length;
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                dArray2[n2] = n2 % 2 == 0 ? arg0[n2] + (double)((Complex32Value)other).unbox-impl()[0] : arg0[n2] + (double)((Complex32Value)other).unbox-impl()[1];
            }
            dArray = dArray2;
        } else if (numericValue instanceof Complex64Value) {
            int n = arg0.length;
            double[] dArray3 = new double[n];
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                dArray3[n3] = n3 % 2 == 0 ? arg0[n3] + ((Complex64Value)other).unbox-impl()[0] : arg0[n3] + ((Complex64Value)other).unbox-impl()[1];
            }
            dArray = dArray3;
        } else {
            int n = arg0.length;
            double[] dArray4 = new double[n];
            for (int i = 0; i < n; ++i) {
                int n4 = i;
                dArray4[n4] = n4 % 2 == 0 ? arg0[n4] + ((Number)other.getValue()).doubleValue() : arg0[n4];
            }
            dArray = dArray4;
        }
        return Complex64VectorValue.constructor-impl(dArray);
    }

    @NotNull
    public double[] plus-BxIXzO8(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex64VectorValue.plus-BxIXzO8(this.data, other);
    }

    @NotNull
    public static double[] minus-BxIXzO8(double[] arg0, @NotNull NumericValue<?> other) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        NumericValue<?> numericValue = other;
        if (numericValue instanceof Complex32Value) {
            int n = arg0.length;
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                dArray2[n2] = n2 % 2 == 0 ? arg0[n2] - (double)((Complex32Value)other).unbox-impl()[0] : arg0[n2] - (double)((Complex32Value)other).unbox-impl()[1];
            }
            dArray = dArray2;
        } else if (numericValue instanceof Complex64Value) {
            int n = arg0.length;
            double[] dArray3 = new double[n];
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                dArray3[n3] = n3 % 2 == 0 ? arg0[n3] - ((Complex64Value)other).unbox-impl()[0] : arg0[n3] - ((Complex64Value)other).unbox-impl()[1];
            }
            dArray = dArray3;
        } else {
            int n = arg0.length;
            double[] dArray4 = new double[n];
            for (int i = 0; i < n; ++i) {
                int n4 = i;
                dArray4[n4] = n4 % 2 == 0 ? arg0[n4] - ((Number)other.getValue()).doubleValue() : arg0[n4];
            }
            dArray = dArray4;
        }
        return Complex64VectorValue.constructor-impl(dArray);
    }

    @NotNull
    public double[] minus-BxIXzO8(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex64VectorValue.minus-BxIXzO8(this.data, other);
    }

    @NotNull
    public static double[] times-BxIXzO8(double[] arg0, @NotNull NumericValue<?> other) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        NumericValue<?> numericValue = other;
        if (numericValue instanceof Complex32Value) {
            int n = arg0.length;
            double[] dArray2 = new double[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                dArray2[n2] = n2 % 2 == 0 ? arg0[n2] * (double)((Complex32Value)other).unbox-impl()[0] - arg0[n2 + 1] * (double)((Complex32Value)other).unbox-impl()[1] : arg0[n2 - 1] * (double)((Complex32Value)other).unbox-impl()[1] + arg0[n2] * (double)((Complex32Value)other).unbox-impl()[0];
            }
            dArray = dArray2;
        } else if (numericValue instanceof Complex64Value) {
            int n = arg0.length;
            double[] dArray3 = new double[n];
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                dArray3[n3] = n3 % 2 == 0 ? arg0[n3] * ((Complex64Value)other).unbox-impl()[0] - arg0[n3 + 1] * ((Complex64Value)other).unbox-impl()[1] : arg0[n3 - 1] * ((Complex64Value)other).unbox-impl()[1] + arg0[n3] * ((Complex64Value)other).unbox-impl()[0];
            }
            dArray = dArray3;
        } else {
            int n = 0;
            int n4 = arg0.length;
            double[] dArray4 = new double[n4];
            while (n < n4) {
                int n5 = n++;
                dArray4[n5] = arg0[n5] * ((Number)other.getValue()).doubleValue();
            }
            dArray = dArray4;
        }
        return Complex64VectorValue.constructor-impl(dArray);
    }

    @NotNull
    public double[] times-BxIXzO8(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex64VectorValue.times-BxIXzO8(this.data, other);
    }

    @NotNull
    public static double[] div-BxIXzO8(double[] arg0, @NotNull NumericValue<?> other) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        NumericValue<?> numericValue = other;
        if (numericValue instanceof Complex64Value) {
            dArray = Complex64VectorValue.internalComplex64ValueDiv-rgFtXmg(arg0, ((Complex64Value)other).unbox-impl());
        } else if (numericValue instanceof Complex32Value) {
            dArray = Complex64VectorValue.internalComplex32ValueDiv-4Ci1IXY(arg0, ((Complex32Value)other).unbox-impl());
        } else {
            int n = 0;
            int n2 = arg0.length;
            double[] dArray2 = new double[n2];
            while (n < n2) {
                int n3 = n++;
                dArray2[n3] = arg0[n3] / ((Number)other.getValue()).doubleValue();
            }
            dArray = Complex64VectorValue.constructor-impl(dArray2);
        }
        return dArray;
    }

    @NotNull
    public double[] div-BxIXzO8(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex64VectorValue.div-BxIXzO8(this.data, other);
    }

    private static final double[] internalComplex64ValueDiv-rgFtXmg(double[] arg0, double[] other) {
        double[] doubles = new double[arg0.length];
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                double denominator;
                double q;
                int i = n++;
                double c = other[0];
                double d = other[1];
                boolean bl = false;
                bl = false;
                if (Math.abs(c) < Math.abs(d)) {
                    q = c / d;
                    denominator = c * q + d;
                    doubles[i << 1] = (arg0[i << 1] * q + arg0[(i << 1) + 1]) / denominator;
                    doubles[(i << 1) + 1] = (arg0[(i << 1) + 1] * q - arg0[i << 1]) / denominator;
                    continue;
                }
                q = d / c;
                denominator = d * q + c;
                doubles[i << 1] = (arg0[(i << 1) + 1] * q + arg0[i << 1]) / denominator;
                doubles[(i << 1) + 1] = (arg0[(i << 1) + 1] - arg0[i << 1] * q) / denominator;
            } while (n < n2);
        }
        return Complex64VectorValue.constructor-impl(doubles);
    }

    private static final double[] internalComplex32ValueDiv-4Ci1IXY(double[] arg0, float[] other) {
        double[] doubles = new double[arg0.length];
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                float denominator;
                float q;
                int i = n++;
                float c = other[0];
                float d = other[1];
                boolean bl = false;
                bl = false;
                if (Math.abs(c) < Math.abs(d)) {
                    q = c / d;
                    denominator = c * q + d;
                    doubles[i << 1] = (arg0[i << 1] * (double)q + arg0[(i << 1) + 1]) / (double)denominator;
                    doubles[(i << 1) + 1] = (arg0[(i << 1) + 1] * (double)q - arg0[i << 1]) / (double)denominator;
                    continue;
                }
                q = d / c;
                denominator = d * q + c;
                doubles[i << 1] = (arg0[(i << 1) + 1] * (double)q + arg0[i << 1]) / (double)denominator;
                doubles[(i << 1) + 1] = (arg0[(i << 1) + 1] - arg0[i << 1] * (double)q) / (double)denominator;
            } while (n < n2);
        }
        return Complex64VectorValue.constructor-impl(doubles);
    }

    @NotNull
    public static double[] pow-BxIXzO8(double[] arg0, int x) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        double[] doubles = new double[arg0.length];
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                int i = n++;
                double d = arg0[i << 1] * arg0[i << 1] + arg0[(i << 1) + 1] * arg0[(i << 1) + 1];
                boolean bl = false;
                d = Math.sqrt(d);
                bl = false;
                double real = (double)x * Math.log(d);
                double d2 = arg0[(i << 1) + 1];
                double d3 = arg0[i << 1];
                boolean bl2 = false;
                double imaginary = (double)x * Math.atan2(d2, d3);
                boolean bl3 = false;
                double exp = Math.exp(real);
                bl3 = false;
                doubles[i << 1] = exp * Math.cos(imaginary);
                bl3 = false;
                doubles[(i << 1) + 1] = exp * Math.sin(imaginary);
            } while (n < n2);
        }
        return Complex64VectorValue.constructor-impl(doubles);
    }

    @NotNull
    public double[] pow-BxIXzO8(int x) {
        return Complex64VectorValue.pow-BxIXzO8(this.data, x);
    }

    @NotNull
    public static double[] sqrt-Leomr7I(double[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        int n = 0;
        int n2 = arg0.length;
        double[] dArray = new double[n2];
        if (n < n2) {
            int n3 = n;
            double[] dArray2 = dArray;
            int n4 = n3;
            double[] doubles = new double[arg0.length];
            int n5 = 0;
            int n6 = arg0.length / 2;
            if (n5 < n6) {
                int n7 = n4;
                double[] dArray3 = dArray2;
                do {
                    int i;
                    if (arg0[(i = n5++) << 1] == 0.0 && arg0[(i << 1) + 1] == 0.0) continue;
                    double d = arg0[i << 1] * arg0[i << 1] + arg0[(i << 1) + 1] * arg0[(i << 1) + 1];
                    boolean bl = false;
                    double modulus = Math.sqrt(d);
                    double d2 = arg0[i << 1];
                    boolean bl2 = false;
                    d2 = (Math.abs(d2) + modulus) / 2.0;
                    bl2 = false;
                    double t = Math.sqrt(d2);
                    if (arg0[i << 1] >= 0.0) {
                        doubles[i << 1] = t;
                        doubles[(i << 1) + 1] = arg0[(i << 1) + 1] / (2.0 * t);
                        continue;
                    }
                    d2 = arg0[(i << 1) + 1];
                    bl2 = false;
                    doubles[i << 1] = Math.abs(d2) / (2.0 * t);
                    doubles[(i << 1) + 1] = FastMath.copySign((double)1.0, (double)arg0[(i << 1) + 1]) * t;
                } while (n5 < n6);
                dArray2 = dArray3;
                n4 = n7;
            }
            return Complex64VectorValue.constructor-impl(doubles);
        }
        return Complex64VectorValue.constructor-impl(dArray);
    }

    @NotNull
    public double[] sqrt-Leomr7I() {
        return Complex64VectorValue.sqrt-Leomr7I(this.data);
    }

    @NotNull
    public static double[] abs-Jz4_OW8(double[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        int n = 0;
        int n2 = arg0.length / 2;
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            double d = arg0[n3 << 1] * arg0[n3 << 1] + arg0[(n3 << 1) + 1] * arg0[(n3 << 1) + 1];
            boolean bl = false;
            dArray[n3] = Math.sqrt(d);
        }
        return DoubleVectorValue.constructor-impl(dArray);
    }

    @NotNull
    public double[] abs-Jz4_OW8() {
        return Complex64VectorValue.abs-Jz4_OW8(this.data);
    }

    @NotNull
    public static double[] sum-IY5coek(double[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        double real = 0.0;
        double imaginary = 0.0;
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                int i = n++;
                real += arg0[i << 1];
                imaginary += arg0[(i << 1) + 1];
            } while (n < n2);
        }
        return Complex64Value.constructor-impl(real, imaginary);
    }

    @NotNull
    public double[] sum-IY5coek() {
        return Complex64VectorValue.sum-IY5coek(this.data);
    }

    @NotNull
    public static double[] dot-tQYLdqw(double[] arg0, @NotNull VectorValue<?> other) {
        double[] dArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        VectorValue<?> vectorValue = other;
        if (vectorValue instanceof Complex64VectorValue) {
            double real = 0.0;
            double imaginary = 0.0;
            int n = 0;
            int n2 = Complex64VectorValue.getLogicalSize-impl(arg0);
            if (n < n2) {
                do {
                    int i = n++;
                    int iprime = i << 1;
                    real += arg0[iprime] * ((Complex64VectorValue)other).unbox-impl()[iprime] + arg0[iprime + 1] * ((Complex64VectorValue)other).unbox-impl()[iprime + 1];
                    imaginary += arg0[iprime + 1] * ((Complex64VectorValue)other).unbox-impl()[iprime] - arg0[iprime] * ((Complex64VectorValue)other).unbox-impl()[iprime + 1];
                } while (n < n2);
            }
            dArray = Complex64Value.constructor-impl(real, imaginary);
        } else if (vectorValue instanceof Complex32VectorValue) {
            double real = 0.0;
            double imaginary = 0.0;
            int n = 0;
            int n3 = Complex64VectorValue.getLogicalSize-impl(arg0);
            if (n < n3) {
                do {
                    int i = n++;
                    int iprime = i << 1;
                    real += arg0[iprime] * (double)((Complex32VectorValue)other).unbox-impl()[iprime] + arg0[iprime + 1] * (double)((Complex32VectorValue)other).unbox-impl()[iprime + 1];
                    imaginary += arg0[iprime + 1] * (double)((Complex32VectorValue)other).unbox-impl()[iprime] - arg0[iprime] * (double)((Complex32VectorValue)other).unbox-impl()[iprime + 1];
                } while (n < n3);
            }
            dArray = Complex64Value.constructor-impl(real, imaginary);
        } else {
            double real = 0.0;
            double imaginary = 0.0;
            int n = 0;
            int n4 = arg0.length / 2;
            if (n < n4) {
                do {
                    int i = n++;
                    int iprime = i << 1;
                    real += arg0[iprime] * ((Number)other.get(i).getValue()).doubleValue();
                    imaginary += arg0[iprime + 1] * ((Number)other.get(i).getValue()).doubleValue();
                } while (n < n4);
            }
            dArray = Complex64Value.constructor-impl(real, imaginary);
        }
        return dArray;
    }

    @NotNull
    public double[] dot-tQYLdqw(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex64VectorValue.dot-tQYLdqw(this.data, other);
    }

    public static final double dotRealPart-He8yXgM(double[] arg0, @NotNull VectorValue<?> other) {
        double d;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.getLogicalSize() == Complex64VectorValue.getLogicalSize-impl(arg0)) {
            VectorValue<?> vectorValue = other;
            if (vectorValue instanceof Complex32VectorValue) {
                double real = 0.0;
                int n = 0;
                int n2 = arg0.length / 2;
                if (n < n2) {
                    do {
                        int i = n++;
                        real += arg0[i << 1] * (double)((Complex32VectorValue)other).unbox-impl()[i << 1] + arg0[(i << 1) + 1] * (double)((Complex32VectorValue)other).unbox-impl()[(i << 1) + 1];
                    } while (n < n2);
                }
                d = DoubleValue.constructor-impl(real);
            } else if (vectorValue instanceof Complex64VectorValue) {
                double real = 0.0;
                int n = 0;
                int n3 = arg0.length / 2;
                if (n < n3) {
                    do {
                        int i = n++;
                        real += arg0[i << 1] * ((Complex64VectorValue)other).unbox-impl()[i << 1] + arg0[(i << 1) + 1] * ((Complex64VectorValue)other).unbox-impl()[(i << 1) + 1];
                    } while (n < n3);
                }
                d = DoubleValue.constructor-impl(real);
            } else {
                double real = 0.0;
                int n = 0;
                int n4 = arg0.length / 2;
                if (n < n4) {
                    do {
                        int i = n++;
                        real += arg0[i << 1] * ((Number)other.get(i).getValue()).doubleValue();
                    } while (n < n4);
                }
                d = DoubleValue.constructor-impl(real);
            }
        } else {
            throw new IllegalArgumentException("Dimensions " + Complex64VectorValue.getLogicalSize-impl(arg0) + " and " + other.getLogicalSize() + " don't agree!");
        }
        return d;
    }

    public static double norm2-Z2rTJmk(double[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        double sum = 0.0;
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                int i = n++;
                sum += arg0[i << 1] * arg0[i << 1] + arg0[(i << 1) + 1] * arg0[(i << 1) + 1];
            } while (n < n2);
        }
        n = 0;
        return DoubleValue.constructor-impl(Math.sqrt(sum));
    }

    public double norm2-Z2rTJmk() {
        return Complex64VectorValue.norm2-Z2rTJmk(this.data);
    }

    public static double l1-He8yXgM(double[] arg0, @NotNull VectorValue<?> other) {
        double d;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.getLogicalSize() == Complex64VectorValue.getLogicalSize-impl(arg0)) {
            VectorValue<?> vectorValue = other;
            if (vectorValue instanceof Complex32VectorValue) {
                double sum = 0.0;
                int n = 0;
                int n2 = arg0.length / 2;
                if (n < n2) {
                    do {
                        int i = n++;
                        double diffReal = arg0[i << 1] - (double)((Complex32VectorValue)other).unbox-impl()[i << 1];
                        double diffImaginary = arg0[(i << 1) + 1] - (double)((Complex32VectorValue)other).unbox-impl()[(i << 1) + 1];
                        double d2 = diffReal;
                        int n3 = 2;
                        boolean bl = false;
                        double d3 = Math.pow(d2, n3);
                        d2 = diffImaginary;
                        n3 = 2;
                        bl = false;
                        d2 = d3 + Math.pow(d2, n3);
                        n3 = 0;
                        sum += Math.sqrt(d2);
                    } while (n < n2);
                }
                d = DoubleValue.constructor-impl(sum);
            } else if (vectorValue instanceof Complex64VectorValue) {
                double sum = 0.0;
                int n = 0;
                int n4 = arg0.length / 2;
                if (n < n4) {
                    do {
                        int i = n++;
                        double diffReal = arg0[i << 1] - ((Complex64VectorValue)other).unbox-impl()[i << 1];
                        double diffImaginary = arg0[(i << 1) + 1] - ((Complex64VectorValue)other).unbox-impl()[(i << 1) + 1];
                        double d4 = diffReal;
                        int n5 = 2;
                        boolean bl = false;
                        double d5 = Math.pow(d4, n5);
                        d4 = diffImaginary;
                        n5 = 2;
                        bl = false;
                        d4 = d5 + Math.pow(d4, n5);
                        n5 = 0;
                        sum += Math.sqrt(d4);
                    } while (n < n4);
                }
                d = DoubleValue.constructor-impl(sum);
            } else {
                double sum = 0.0;
                int n = 0;
                int n6 = arg0.length / 2;
                if (n < n6) {
                    do {
                        int i = n++;
                        double diffReal = arg0[i << 1] - other.get(i).asDouble-Z2rTJmk();
                        double diffImaginary = arg0[(i << 1) + 1];
                        double d6 = diffReal;
                        int n7 = 2;
                        boolean bl = false;
                        double d7 = Math.pow(d6, n7);
                        d6 = diffImaginary;
                        n7 = 2;
                        bl = false;
                        d6 = d7 + Math.pow(d6, n7);
                        n7 = 0;
                        sum += Math.sqrt(d6);
                    } while (n < n6);
                }
                d = DoubleValue.constructor-impl(sum);
            }
        } else {
            throw new IllegalArgumentException("Dimensions " + Complex64VectorValue.getLogicalSize-impl(arg0) + " and " + other.getLogicalSize() + " don't agree!");
        }
        return d;
    }

    public double l1-He8yXgM(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex64VectorValue.l1-He8yXgM(this.data, other);
    }

    public static final double l2sq-He8yXgM(double[] arg0, @NotNull VectorValue<?> other) {
        double d;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.getLogicalSize() == Complex64VectorValue.getLogicalSize-impl(arg0)) {
            VectorValue<?> vectorValue = other;
            if (vectorValue instanceof Complex32VectorValue) {
                double sum = 0.0;
                int n = 0;
                int n2 = arg0.length + -1;
                if (n <= n2) {
                    do {
                        int i = n++;
                        double d2 = arg0[i] - (double)((Complex32VectorValue)other).unbox-impl()[i];
                        int n3 = 2;
                        boolean bl = false;
                        sum += Math.pow(d2, n3);
                    } while (n <= n2);
                }
                d = DoubleValue.constructor-impl(sum);
            } else if (vectorValue instanceof Complex64VectorValue) {
                double sum = 0.0;
                int n = 0;
                int n4 = arg0.length + -1;
                if (n <= n4) {
                    do {
                        int i = n++;
                        double d3 = arg0[i] - ((Complex64VectorValue)other).unbox-impl()[i];
                        int n5 = 2;
                        boolean bl = false;
                        sum += Math.pow(d3, n5);
                    } while (n <= n4);
                }
                d = DoubleValue.constructor-impl(sum);
            } else {
                double sum = 0.0;
                int n = 0;
                int n6 = arg0.length / 2;
                if (n < n6) {
                    do {
                        int i = n++;
                        double diffReal = arg0[i << 1] - other.get(i).asDouble-Z2rTJmk();
                        double diffImaginary = arg0[(i << 1) + 1];
                        double d4 = diffReal;
                        int n7 = 2;
                        boolean bl = false;
                        double d5 = Math.pow(d4, n7);
                        d4 = diffImaginary;
                        n7 = 2;
                        bl = false;
                        sum += d5 + Math.pow(d4, n7);
                    } while (n < n6);
                }
                d = DoubleValue.constructor-impl(sum);
            }
        } else {
            throw new IllegalArgumentException("Dimensions " + Complex64VectorValue.getLogicalSize-impl(arg0) + " and " + other.getLogicalSize() + " don't agree!");
        }
        return d;
    }

    public static double l2-He8yXgM(double[] arg0, @NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return DoubleValue.sqrt-Z2rTJmk(Complex64VectorValue.l2sq-He8yXgM(arg0, other));
    }

    public double l2-He8yXgM(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex64VectorValue.l2-He8yXgM(this.data, other);
    }

    public static int compareTo-impl(double[] arg0, @NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Complex64VectorValue.box-impl(arg0).compareTo(other);
    }

    @Override
    public int compareTo(@NotNull Value other) {
        return ComplexVectorValue.DefaultImpls.compareTo(this, other);
    }

    @NotNull
    public static RealValue<?> hamming-impl(double[] arg0, @NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex64VectorValue.box-impl(arg0).hamming(other);
    }

    @Override
    @NotNull
    public RealValue<?> hamming(@NotNull VectorValue<?> other) {
        return ComplexVectorValue.DefaultImpls.hamming(this, other);
    }

    @NotNull
    public static Iterator<ComplexValue<Double>> iterator-impl(double[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex64VectorValue.box-impl(arg0).iterator();
    }

    @Override
    @NotNull
    public Iterator<ComplexValue<Double>> iterator() {
        return ComplexVectorValue.DefaultImpls.iterator(this);
    }

    @NotNull
    public static RealValue<?> lp-impl(double[] arg0, @NotNull VectorValue<?> other, int p) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex64VectorValue.box-impl(arg0).lp(other, p);
    }

    @Override
    @NotNull
    public RealValue<?> lp(@NotNull VectorValue<?> other, int p) {
        return ComplexVectorValue.DefaultImpls.lp(this, other, p);
    }

    public static String toString-impl(double[] arg0) {
        return "Complex64VectorValue(data=" + Arrays.toString(arg0) + ')';
    }

    public String toString() {
        return Complex64VectorValue.toString-impl(this.data);
    }

    public static int hashCode-impl(double[] arg0) {
        return Arrays.hashCode(arg0);
    }

    public int hashCode() {
        return Complex64VectorValue.hashCode-impl(this.data);
    }

    public static boolean equals-impl(double[] arg0, Object other) {
        if (!(other instanceof Complex64VectorValue)) {
            return false;
        }
        double[] dArray = ((Complex64VectorValue)other).unbox-impl();
        return Intrinsics.areEqual((Object)arg0, (Object)dArray);
    }

    public boolean equals(Object other) {
        return Complex64VectorValue.equals-impl(this.data, other);
    }

    private /* synthetic */ Complex64VectorValue(double[] data) {
        this.data = data;
    }

    @NotNull
    public static double[] constructor-impl(@NotNull double[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double[] dArray = data;
        return dArray;
    }

    public static final /* synthetic */ Complex64VectorValue box-impl(double[] v) {
        return new Complex64VectorValue(v);
    }

    public final /* synthetic */ double[] unbox-impl() {
        return this.data;
    }

    public static final boolean equals-impl0(double[] p1, double[] p2) {
        return Intrinsics.areEqual((Object)p1, (Object)p2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u000f\u0010\b\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/model/values/Complex64VectorValue$Companion;", "", "()V", "one", "Lorg/vitrivr/cottontail/model/values/Complex64VectorValue;", "size", "", "one-BxIXzO8", "(I)[D", "random", "rnd", "Ljava/util/SplittableRandom;", "random-xPD-sHo", "(ILjava/util/SplittableRandom;)[D", "zero", "zero-BxIXzO8", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final double[] random-xPD-sHo(int size, @NotNull SplittableRandom rnd) {
            Intrinsics.checkNotNullParameter((Object)rnd, (String)"rnd");
            int n = 0;
            int n2 = 2 * size;
            double[] dArray = new double[n2];
            while (n < n2) {
                int n3 = n++;
                dArray[n3] = rnd.nextDouble();
            }
            return Complex64VectorValue.constructor-impl(dArray);
        }

        public static /* synthetic */ double[] random-xPD-sHo$default(Companion companion, int n, SplittableRandom splittableRandom, int n2, Object object) {
            if ((n2 & 2) != 0) {
                splittableRandom = Value.Companion.getRANDOM();
            }
            return companion.random-xPD-sHo(n, splittableRandom);
        }

        @NotNull
        public final double[] one-BxIXzO8(int size) {
            int n = size * 2;
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                dArray[n2] = n2 % 2 == 0 ? 1.0 : 0.0;
            }
            return Complex64VectorValue.constructor-impl(dArray);
        }

        @NotNull
        public final double[] zero-BxIXzO8(int size) {
            int n = 0;
            int n2 = size * 2;
            double[] dArray = new double[n2];
            while (n < n2) {
                int n3 = n++;
                dArray[n3] = 0.0;
            }
            return Complex64VectorValue.constructor-impl(dArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

