/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import io.grpc.StatusException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.column.ColumnEngine;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.queries.QueryContext;
import org.vitrivr.cottontail.database.queries.binding.extensions.NameExtensionsKt;
import org.vitrivr.cottontail.database.queries.sort.SortOrder;
import org.vitrivr.cottontail.execution.TransactionManager;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.execution.operators.definition.CreateEntityOperator;
import org.vitrivr.cottontail.execution.operators.definition.CreateIndexOperator;
import org.vitrivr.cottontail.execution.operators.definition.CreateSchemaOperator;
import org.vitrivr.cottontail.execution.operators.definition.DropEntityOperator;
import org.vitrivr.cottontail.execution.operators.definition.DropIndexOperator;
import org.vitrivr.cottontail.execution.operators.definition.DropSchemaOperator;
import org.vitrivr.cottontail.execution.operators.definition.EntityDetailsOperator;
import org.vitrivr.cottontail.execution.operators.definition.ListEntityOperator;
import org.vitrivr.cottontail.execution.operators.definition.ListSchemaOperator;
import org.vitrivr.cottontail.execution.operators.definition.OptimizeEntityOperator;
import org.vitrivr.cottontail.execution.operators.definition.RebuildIndexOperator;
import org.vitrivr.cottontail.execution.operators.definition.TruncateEntityOperator;
import org.vitrivr.cottontail.execution.operators.sort.HeapSortOperator;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.DDLGrpcKt;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.server.grpc.services.TransactionalGrpcService;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0019\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0018H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u0019\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0019\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0019\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020!H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0$2\u0006\u0010\u000e\u001a\u00020%H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0$2\u0006\u0010\u000e\u001a\u00020'H\u0016J\u0019\u0010(\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u0019\u0010+\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020,H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0019\u0010.\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020/H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00061"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/DDLService;", "Lorg/vitrivr/cottontail/grpc/DDLGrpcKt$DDLCoroutineImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/TransactionalGrpcService;", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "manager", "Lorg/vitrivr/cottontail/execution/TransactionManager;", "(Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;Lorg/vitrivr/cottontail/execution/TransactionManager;)V", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/DefaultCatalogue;", "getManager", "()Lorg/vitrivr/cottontail/execution/TransactionManager;", "createEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "request", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateEntityMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateEntityMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createIndex", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateIndexMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateIndexMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createSchema", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateSchemaMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$CreateSchemaMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dropEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropEntityMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropEntityMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dropIndex", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropIndexMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropIndexMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dropSchema", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropSchemaMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$DropSchemaMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "entityDetails", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$EntityDetailsMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$EntityDetailsMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "listEntities", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$ListEntityMessage;", "listSchemas", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$ListSchemaMessage;", "optimizeEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$OptimizeEntityMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$OptimizeEntityMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "rebuildIndex", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$RebuildIndexMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$RebuildIndexMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "truncateEntity", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$TruncateEntityMessage;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$TruncateEntityMessage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cottontaildb"})
@ExperimentalTime
public final class DDLService
extends DDLGrpcKt.DDLCoroutineImplBase
implements TransactionalGrpcService {
    @NotNull
    private final DefaultCatalogue catalogue;
    @NotNull
    private final TransactionManager manager;

    public DDLService(@NotNull DefaultCatalogue catalogue, @NotNull TransactionManager manager) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super(null, 1, null);
        this.catalogue = catalogue;
        this.manager = manager;
    }

    @Override
    @NotNull
    public DefaultCatalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return this.manager;
    }

    @Nullable
    public Object createSchema(@NotNull CottontailGrpc.CreateSchemaMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.Metadata metadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"request.metadata");
        return FlowKt.single(this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.CreateSchemaMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull QueryContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CottontailGrpc.SchemaName schemaName = this.$request.getSchema();
                Intrinsics.checkNotNullExpressionValue((Object)schemaName, (String)"request.schema");
                Name.SchemaName schemaName2 = NameExtensionsKt.fqn(schemaName);
                return new CreateSchemaOperator(this.this$0.getCatalogue(), schemaName2);
            }
        })), $completion);
    }

    @Nullable
    public Object dropSchema(@NotNull CottontailGrpc.DropSchemaMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.Metadata metadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"request.metadata");
        return FlowKt.single(this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.DropSchemaMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull QueryContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CottontailGrpc.SchemaName schemaName = this.$request.getSchema();
                Intrinsics.checkNotNullExpressionValue((Object)schemaName, (String)"request.schema");
                Name.SchemaName schemaName2 = NameExtensionsKt.fqn(schemaName);
                return new DropSchemaOperator(this.this$0.getCatalogue(), schemaName2);
            }
        })), $completion);
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> listSchemas(@NotNull CottontailGrpc.ListSchemaMessage request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.Metadata metadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"request.metadata");
        return this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(this){
            final /* synthetic */ DDLService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull QueryContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new HeapSortOperator(new ListSchemaOperator(this.this$0.getCatalogue()), CollectionsKt.listOf((Object)new Pair(ListSchemaOperator.Companion.getCOLUMNS().get(0), (Object)((Object)SortOrder.ASCENDING))), 100);
            }
        }));
    }

    @Nullable
    public Object createEntity(@NotNull CottontailGrpc.CreateEntityMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.Metadata metadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"request.metadata");
        return FlowKt.single(this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.CreateEntityMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Operator invoke(@NotNull QueryContext it) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CottontailGrpc.EntityName entityName = this.$request.getDefinition().getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.definition.entity");
                Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                List list = this.$request.getDefinition().getColumnsList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.definition.columnsList");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    CottontailGrpc.ColumnDefinition columnDefinition = (CottontailGrpc.ColumnDefinition)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Type<?> type = Type.Companion.forName(it2.getType().name(), it2.getLength());
                    String string = it2.getName().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name.name");
                    Name.ColumnName name = entityName2.column(string);
                    Pair pair = TuplesKt.to(new ColumnDef<T>(name, type, it2.getNullable(), false, 8, null), (Object)((Object)ColumnEngine.valueOf(it2.getEngine().toString())));
                    collection.add(pair);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
                if (pairArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Pair[] columns = pairArray;
                return new CreateEntityOperator(this.this$0.getCatalogue(), entityName2, columns);
            }
        })), $completion);
    }

    @Nullable
    public Object dropEntity(@NotNull CottontailGrpc.DropEntityMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.Metadata metadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"request.metadata");
        return FlowKt.single(this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.DropEntityMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull QueryContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CottontailGrpc.EntityName entityName = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                return new DropEntityOperator(this.this$0.getCatalogue(), entityName2);
            }
        })), $completion);
    }

    @Nullable
    public Object truncateEntity(@NotNull CottontailGrpc.TruncateEntityMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.Metadata metadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"request.metadata");
        return FlowKt.single(this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.TruncateEntityMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull QueryContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CottontailGrpc.EntityName entityName = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                return new TruncateEntityOperator(this.this$0.getCatalogue(), entityName2);
            }
        })), $completion);
    }

    @Nullable
    public Object optimizeEntity(@NotNull CottontailGrpc.OptimizeEntityMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.Metadata metadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"request.metadata");
        return FlowKt.single(this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.OptimizeEntityMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull QueryContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CottontailGrpc.EntityName entityName = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                return new OptimizeEntityOperator(this.this$0.getCatalogue(), entityName2);
            }
        })), $completion);
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> listEntities(@NotNull CottontailGrpc.ListEntityMessage request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.Metadata metadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"request.metadata");
        return this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.ListEntityMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull QueryContext it) {
                Name.SchemaName schemaName;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$request.hasSchema()) {
                    CottontailGrpc.SchemaName schemaName2 = this.$request.getSchema();
                    Intrinsics.checkNotNullExpressionValue((Object)schemaName2, (String)"request.schema");
                    schemaName = NameExtensionsKt.fqn(schemaName2);
                } else {
                    schemaName = null;
                }
                Name.SchemaName schemaName3 = schemaName;
                return new HeapSortOperator(new ListEntityOperator(this.this$0.getCatalogue(), schemaName3), CollectionsKt.listOf((Object)new Pair(ListSchemaOperator.Companion.getCOLUMNS().get(0), (Object)((Object)SortOrder.ASCENDING))), 100);
            }
        }));
    }

    @Nullable
    public Object entityDetails(@NotNull CottontailGrpc.EntityDetailsMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.Metadata metadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"request.metadata");
        return FlowKt.single(this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.EntityDetailsMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull QueryContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CottontailGrpc.EntityName entityName = this.$request.getEntity();
                Intrinsics.checkNotNullExpressionValue((Object)entityName, (String)"request.entity");
                Name.EntityName entityName2 = NameExtensionsKt.fqn(entityName);
                return new EntityDetailsOperator(this.this$0.getCatalogue(), entityName2);
            }
        })), $completion);
    }

    @Nullable
    public Object createIndex(@NotNull CottontailGrpc.CreateIndexMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.Metadata metadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"request.metadata");
        return FlowKt.single(this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.CreateIndexMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Operator invoke(@NotNull QueryContext it) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CottontailGrpc.IndexName indexName = this.$request.getDefinition().getName();
                Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.definition.name");
                Name.IndexName indexName2 = NameExtensionsKt.fqn(indexName);
                List list = this.$request.getDefinition().getColumnsList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.definition.columnsList");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    CottontailGrpc.ColumnName columnName = (CottontailGrpc.ColumnName)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Name.EntityName entityName = indexName2.entity();
                    String string = it2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    Name.ColumnName columnName2 = entityName.column(string);
                    collection.add(columnName2);
                }
                List columns = (List)destination$iv$iv;
                IndexType indexType = IndexType.valueOf(this.$request.getDefinition().getType().toString());
                Map params = this.$request.getDefinition().getParamsMap();
                DefaultCatalogue defaultCatalogue = this.this$0.getCatalogue();
                Intrinsics.checkNotNullExpressionValue((Object)params, (String)"params");
                return new CreateIndexOperator(defaultCatalogue, indexName2, indexType, columns, params, this.$request.getRebuild());
            }
        })), $completion);
    }

    @Nullable
    public Object dropIndex(@NotNull CottontailGrpc.DropIndexMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.Metadata metadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"request.metadata");
        return FlowKt.single(this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.DropIndexMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull QueryContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CottontailGrpc.IndexName indexName = this.$request.getIndex();
                Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                Name.IndexName indexName2 = NameExtensionsKt.fqn(indexName);
                return new DropIndexOperator(this.this$0.getCatalogue(), indexName2);
            }
        })), $completion);
    }

    @Nullable
    public Object rebuildIndex(@NotNull CottontailGrpc.RebuildIndexMessage request, @NotNull Continuation<? super CottontailGrpc.QueryResponseMessage> $completion) {
        CottontailGrpc.Metadata metadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"request.metadata");
        return FlowKt.single(this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.RebuildIndexMessage $request;
            final /* synthetic */ DDLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull QueryContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                CottontailGrpc.IndexName indexName = this.$request.getIndex();
                Intrinsics.checkNotNullExpressionValue((Object)indexName, (String)"request.index");
                Name.IndexName indexName2 = NameExtensionsKt.fqn(indexName);
                return new RebuildIndexOperator(this.this$0.getCatalogue(), indexName2);
            }
        })), $completion);
    }

    @Override
    @NotNull
    public StatusException toStatusException(@NotNull QueryContext $this$toStatusException, @NotNull Throwable e) {
        return TransactionalGrpcService.DefaultImpls.toStatusException(this, $this$toStatusException, e);
    }

    @Override
    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> prepareAndExecute(@NotNull CottontailGrpc.Metadata metadata, @NotNull Function1<? super QueryContext, ? extends Operator> prepare) {
        return TransactionalGrpcService.DefaultImpls.prepareAndExecute(this, metadata, prepare);
    }

    @Override
    @Nullable
    public QueryContext queryContextFromMetadata(@NotNull CottontailGrpc.Metadata metadata) {
        return TransactionalGrpcService.DefaultImpls.queryContextFromMetadata(this, metadata);
    }
}

