/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import com.google.protobuf.Empty;
import io.grpc.Status;
import io.grpc.StatusException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.database.queries.QueryContext;
import org.vitrivr.cottontail.execution.TransactionManager;
import org.vitrivr.cottontail.execution.TransactionType;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.execution.operators.system.ListLocksOperator;
import org.vitrivr.cottontail.execution.operators.system.ListTransactionsOperator;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.TXNGrpcKt;
import org.vitrivr.cottontail.server.grpc.services.TransactionalGrpcService;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0019\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0019\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/TXNService;", "Lorg/vitrivr/cottontail/grpc/TXNGrpcKt$TXNCoroutineImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/TransactionalGrpcService;", "catalogue", "Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "manager", "Lorg/vitrivr/cottontail/execution/TransactionManager;", "(Lorg/vitrivr/cottontail/database/catalogue/Catalogue;Lorg/vitrivr/cottontail/execution/TransactionManager;)V", "getCatalogue", "()Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "getManager", "()Lorg/vitrivr/cottontail/execution/TransactionManager;", "begin", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Metadata;", "request", "Lcom/google/protobuf/Empty;", "(Lcom/google/protobuf/Empty;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "commit", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Metadata;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "kill", "listLocks", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "listTransactions", "rollback", "cottontaildb"})
@ExperimentalTime
public final class TXNService
extends TXNGrpcKt.TXNCoroutineImplBase
implements TransactionalGrpcService {
    @NotNull
    private final Catalogue catalogue;
    @NotNull
    private final TransactionManager manager;

    public TXNService(@NotNull Catalogue catalogue, @NotNull TransactionManager manager) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super(null, 1, null);
        this.catalogue = catalogue;
        this.manager = manager;
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return this.manager;
    }

    @Nullable
    public Object begin(@NotNull Empty request, @NotNull Continuation<? super CottontailGrpc.Metadata> $completion) {
        TransactionManager.TransactionImpl txn = new TransactionManager.TransactionImpl(this.getManager(), TransactionType.USER);
        CottontailGrpc.Metadata metadata = CottontailGrpc.Metadata.newBuilder().setTransactionId(txn.getTxId()).build();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"newBuilder().setTransactionId(txn.txId).build()");
        return metadata;
    }

    @Nullable
    public Object commit(@NotNull CottontailGrpc.Metadata request, @NotNull Continuation<? super Empty> $completion) {
        if (request.getTransactionId() <= 0L) {
            StatusException statusException = Status.INVALID_ARGUMENT.withDescription("Failed to execute COMMIT: Invalid transaction identifier " + request.getTransactionId() + '!').asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"INVALID_ARGUMENT.withDes\u2026tionId }!\").asException()");
            throw (Throwable)statusException;
        }
        QueryContext queryContext = this.queryContextFromMetadata(request);
        if (queryContext == null) {
            StatusException statusException = Status.FAILED_PRECONDITION.withDescription("Failed to execute COMMIT: Transaction " + request.getTransactionId() + " could not be resumed.").asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"FAILED_PRECONDITION.with\u2026 resumed.\").asException()");
            throw (Throwable)statusException;
        }
        QueryContext ctx = queryContext;
        try {
            ctx.getTxn().commit();
            queryContext = Empty.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)queryContext, (String)"getDefaultInstance()");
            return queryContext;
        }
        catch (Throwable e) {
            StatusException statusException = Status.INTERNAL.withDescription(Intrinsics.stringPlus((String)"Failed to execute COMMIT due to unexpected error: ", (Object)e.getMessage())).asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"INTERNAL.withDescription\u2026.message}\").asException()");
            throw (Throwable)statusException;
        }
    }

    @Nullable
    public Object rollback(@NotNull CottontailGrpc.Metadata request, @NotNull Continuation<? super Empty> $completion) {
        if (request.getTransactionId() <= 0L) {
            StatusException statusException = Status.INVALID_ARGUMENT.withDescription("Failed to execute ROLLBACK: Invalid transaction identifier " + request.getTransactionId() + '!').asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"INVALID_ARGUMENT.withDes\u2026tionId }!\").asException()");
            throw (Throwable)statusException;
        }
        QueryContext queryContext = this.queryContextFromMetadata(request);
        if (queryContext == null) {
            StatusException statusException = Status.FAILED_PRECONDITION.withDescription("Failed to execute ROLLBACK: Transaction " + request.getTransactionId() + " could not be resumed.").asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"FAILED_PRECONDITION.with\u2026 resumed.\").asException()");
            throw (Throwable)statusException;
        }
        QueryContext ctx = queryContext;
        try {
            ctx.getTxn().rollback();
            queryContext = Empty.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)queryContext, (String)"getDefaultInstance()");
            return queryContext;
        }
        catch (Throwable e) {
            StatusException statusException = Status.INTERNAL.withDescription(Intrinsics.stringPlus((String)"Failed to execute COMMIT due to unexpected error: ", (Object)e.getMessage())).asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"INTERNAL.withDescription\u2026.message}\").asException()");
            throw (Throwable)statusException;
        }
    }

    @Nullable
    public Object kill(@NotNull CottontailGrpc.Metadata request, @NotNull Continuation<? super Empty> $completion) {
        if (request.getTransactionId() <= 0L) {
            StatusException statusException = Status.INVALID_ARGUMENT.withDescription("Failed to execute KILL: Invalid transaction identifier " + request.getTransactionId() + '!').asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"INVALID_ARGUMENT.withDes\u2026tionId }!\").asException()");
            throw (Throwable)statusException;
        }
        QueryContext queryContext = this.queryContextFromMetadata(request);
        if (queryContext == null) {
            StatusException statusException = Status.FAILED_PRECONDITION.withDescription("Failed to execute KILL: Transaction " + request.getTransactionId() + " could not be resumed.").asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"FAILED_PRECONDITION.with\u2026 resumed.\").asException()");
            throw (Throwable)statusException;
        }
        QueryContext ctx = queryContext;
        try {
            ctx.getTxn().kill();
            queryContext = Empty.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)queryContext, (String)"getDefaultInstance()");
            return queryContext;
        }
        catch (Throwable e) {
            StatusException statusException = Status.INTERNAL.withDescription(Intrinsics.stringPlus((String)"Failed to execute KILL due to unexpected error: ", (Object)e.getMessage())).asException();
            Intrinsics.checkNotNullExpressionValue((Object)statusException, (String)"INTERNAL.withDescription\u2026.message}\").asException()");
            throw (Throwable)statusException;
        }
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> listTransactions(@NotNull Empty request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.Metadata metadata = CottontailGrpc.Metadata.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"getDefaultInstance()");
        return this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(this){
            final /* synthetic */ TXNService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull QueryContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new ListTransactionsOperator(this.this$0.getManager());
            }
        }));
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> listLocks(@NotNull Empty request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.Metadata metadata = CottontailGrpc.Metadata.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"getDefaultInstance()");
        return this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(this){
            final /* synthetic */ TXNService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull QueryContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new ListLocksOperator(this.this$0.getManager().getLockManager());
            }
        }));
    }

    @Override
    @NotNull
    public StatusException toStatusException(@NotNull QueryContext $this$toStatusException, @NotNull Throwable e) {
        return TransactionalGrpcService.DefaultImpls.toStatusException(this, $this$toStatusException, e);
    }

    @Override
    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> prepareAndExecute(@NotNull CottontailGrpc.Metadata metadata, @NotNull Function1<? super QueryContext, ? extends Operator> prepare) {
        return TransactionalGrpcService.DefaultImpls.prepareAndExecute(this, metadata, prepare);
    }

    @Override
    @Nullable
    public QueryContext queryContextFromMetadata(@NotNull CottontailGrpc.Metadata metadata) {
        return TransactionalGrpcService.DefaultImpls.queryContextFromMetadata(this, metadata);
    }
}

