/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.storage.store;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/storage/store/CleanerUtility;", "", "()V", "CLEANER_METHOD", "Ljava/lang/reflect/Method;", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "PRE_JAVA_9", "", "UNSAFE_INSTANCE", "forceUnmap", "buffer", "Ljava/nio/MappedByteBuffer;", "cottontaildb"})
public final class CleanerUtility {
    @NotNull
    public static final CleanerUtility INSTANCE = new CleanerUtility();
    private static final boolean PRE_JAVA_9;
    @Nullable
    private static Method CLEANER_METHOD;
    @Nullable
    private static Object UNSAFE_INSTANCE;
    private static final Logger LOGGER;

    private CleanerUtility() {
    }

    @Nullable
    public final Object forceUnmap(@NotNull MappedByteBuffer buffer) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (PRE_JAVA_9) {
            Method method = CLEANER_METHOD;
            if (method == null) {
                object = null;
            } else {
                Object[] objectArray = new Object[]{buffer};
                object = method.invoke(null, objectArray);
            }
        } else {
            Method method = CLEANER_METHOD;
            if (method == null) {
                object = null;
            } else {
                Object[] objectArray = new Object[]{buffer};
                object = method.invoke(UNSAFE_INSTANCE, objectArray);
            }
        }
        return object;
    }

    static {
        String string = System.getProperty("java.specification.version", "9");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"java.specification.version\", \"9\")");
        PRE_JAVA_9 = StringsKt.startsWith$default((String)string, (String)"1.", (boolean)false, (int)2, null);
        LOGGER = LoggerFactory.getLogger(CleanerUtility.class);
        try {
            Object unsafeClass;
            if (PRE_JAVA_9) {
                Method cleanMethod = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
                CLEANER_METHOD = cleanMethod;
            } else {
                Class[] classArray;
                try {
                    classArray = Class.forName("sun.misc.Unsafe");
                }
                catch (Exception e) {
                    classArray = Class.forName("jdk.internal.misc.Unsafe");
                }
                unsafeClass = classArray;
                classArray = new Class[]{ByteBuffer.class};
                CLEANER_METHOD = ((Class)unsafeClass).getMethod("invokeCleaner", classArray);
                Field field = ((Class)unsafeClass).getDeclaredField("theUnsafe");
                field.setAccessible(true);
                UNSAFE_INSTANCE = field.get(null);
            }
            unsafeClass = CLEANER_METHOD;
            if (unsafeClass != null) {
                ((Method)unsafeClass).setAccessible(true);
            }
        }
        catch (Exception ex) {
            if (PRE_JAVA_9) {
                LOGGER.warn("Could not obtain a valid instance of sun.misc.Cleaner. Therefore, memory-mapped files will probably not be unmapped until garbage collected.");
            }
            LOGGER.warn("Could not obtain a valid instance of sun.misc.Unsafe. Therefore, memory-mapped files will probably not be unmapped until garbage collected.");
        }
    }
}

