/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.data.exporter;

import com.google.gson.stream.JsonWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.client.iterators.Tuple;
import org.vitrivr.cottontail.client.iterators.TupleIterator;
import org.vitrivr.cottontail.client.language.basics.Type;
import org.vitrivr.cottontail.utilities.data.Format;
import org.vitrivr.cottontail.utilities.data.exporter.DataExporter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/vitrivr/cottontail/utilities/data/exporter/JsonDataExporter;", "Lorg/vitrivr/cottontail/utilities/data/exporter/DataExporter;", "path", "Ljava/nio/file/Path;", "indent", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "<set-?>", "", "closed", "getClosed", "()Z", "format", "Lorg/vitrivr/cottontail/utilities/data/Format;", "getFormat", "()Lorg/vitrivr/cottontail/utilities/data/Format;", "getIndent", "()Ljava/lang/String;", "getPath", "()Ljava/nio/file/Path;", "writer", "Lcom/google/gson/stream/JsonWriter;", "close", "", "offer", "tuple", "Lorg/vitrivr/cottontail/client/iterators/Tuple;", "writeComplex", "real", "", "imaginary", "cottontaildb"})
public final class JsonDataExporter
implements DataExporter {
    @NotNull
    private final Path path;
    @NotNull
    private final String indent;
    @NotNull
    private final Format format;
    private boolean closed;
    @NotNull
    private final JsonWriter writer;

    public JsonDataExporter(@NotNull Path path, @NotNull String indent) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        this.path = path;
        this.indent = indent;
        this.format = Format.JSON;
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE};
        this.writer = new JsonWriter((Writer)Files.newBufferedWriter(this.getPath(), openOptionArray));
        this.writer.setIndent(this.indent);
        this.writer.beginArray();
    }

    public /* synthetic */ JsonDataExporter(Path path, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(path, string);
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @NotNull
    public final String getIndent() {
        return this.indent;
    }

    @Override
    @NotNull
    public Format getFormat() {
        return this.format;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    public void offer(@NotNull Tuple tuple) {
        Intrinsics.checkNotNullParameter((Object)tuple, (String)"tuple");
        this.writer.beginObject();
        int n = tuple.size();
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            int it = n2;
            boolean bl2 = false;
            this.writer.name(tuple.nameForIndex(it));
            Type type = tuple.type(it);
            int n4 = WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
            switch (n4) {
                case 1: {
                    this.writer.value(tuple.asBoolean(it));
                    break;
                }
                case 2: {
                    this.writer.value((Number)tuple.asByte(it));
                    break;
                }
                case 3: {
                    this.writer.value((Number)tuple.asShort(it));
                    break;
                }
                case 4: {
                    this.writer.value((Number)tuple.asInt(it));
                    break;
                }
                case 5: {
                    this.writer.value((Number)tuple.asLong(it));
                    break;
                }
                case 6: {
                    this.writer.value((Number)tuple.asFloat(it));
                    break;
                }
                case 7: {
                    this.writer.value((Number)tuple.asDouble(it));
                    break;
                }
                case 8: {
                    this.writer.value((Number)tuple.asLong(it));
                    break;
                }
                case 9: {
                    this.writer.value(tuple.asString(it));
                    break;
                }
                case 10: {
                    Object object = tuple.get(it);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Pair<kotlin.Float, kotlin.Float>");
                    }
                    Pair pair = (Pair)object;
                    this.writeComplex((Number)pair.getFirst(), (Number)pair.getSecond());
                    break;
                }
                case 11: {
                    Object object = tuple.get(it);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Pair<kotlin.Double, kotlin.Double>");
                    }
                    Pair pair = (Pair)object;
                    this.writeComplex((Number)pair.getFirst(), (Number)pair.getSecond());
                    break;
                }
                case 12: {
                    int n5;
                    this.writer.beginArray();
                    float[] fArray = tuple.asFloatVector(it);
                    Intrinsics.checkNotNull((Object)fArray);
                    Pair[] $this$forEach$iv = (Pair[])fArray;
                    boolean $i$f$forEach = false;
                    Pair[] pairArray = $this$forEach$iv;
                    int n6 = pairArray.length;
                    for (n5 = 0; n5 < n6; ++n5) {
                        Pair element$iv;
                        Pair v = element$iv = pairArray[n5];
                        boolean bl3 = false;
                        this.writer.value((Number)Float.valueOf((float)v));
                    }
                    this.writer.endArray();
                    break;
                }
                case 13: {
                    int n5;
                    this.writer.beginArray();
                    long[] lArray = tuple.asLongVector(it);
                    Intrinsics.checkNotNull((Object)lArray);
                    Pair[] $this$forEach$iv = (Pair[])lArray;
                    boolean $i$f$forEach = false;
                    Pair[] pairArray = $this$forEach$iv;
                    int n6 = pairArray.length;
                    for (n5 = 0; n5 < n6; ++n5) {
                        Pair element$iv;
                        Pair v = element$iv = pairArray[n5];
                        boolean bl4 = false;
                        this.writer.value((long)v);
                    }
                    this.writer.endArray();
                    break;
                }
                case 14: {
                    int n5;
                    this.writer.beginArray();
                    int[] nArray = tuple.asIntVector(it);
                    Intrinsics.checkNotNull((Object)nArray);
                    Pair[] $this$forEach$iv = (Pair[])nArray;
                    boolean $i$f$forEach = false;
                    Pair[] pairArray = $this$forEach$iv;
                    int n6 = pairArray.length;
                    for (n5 = 0; n5 < n6; ++n5) {
                        Pair element$iv;
                        Pair v = element$iv = pairArray[n5];
                        boolean bl5 = false;
                        this.writer.value((Number)((int)v));
                    }
                    this.writer.endArray();
                    break;
                }
                case 15: {
                    int n5;
                    this.writer.beginArray();
                    boolean[] blArray = tuple.asBooleanVector(it);
                    Intrinsics.checkNotNull((Object)blArray);
                    Pair[] $this$forEach$iv = (Pair[])blArray;
                    boolean $i$f$forEach = false;
                    Pair[] pairArray = $this$forEach$iv;
                    int n6 = pairArray.length;
                    for (n5 = 0; n5 < n6; ++n5) {
                        Pair element$iv;
                        Pair v = element$iv = pairArray[n5];
                        boolean bl6 = false;
                        this.writer.value((boolean)v);
                    }
                    this.writer.endArray();
                    break;
                }
                case 16: {
                    int n5;
                    this.writer.beginArray();
                    Pair[] $this$forEach$iv = tuple.get(it);
                    if ($this$forEach$iv == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Pair<kotlin.Float, kotlin.Float>>");
                    }
                    $this$forEach$iv = $this$forEach$iv;
                    boolean $i$f$forEach = false;
                    Pair[] pairArray = $this$forEach$iv;
                    int n6 = pairArray.length;
                    for (n5 = 0; n5 < n6; ++n5) {
                        Pair element$iv;
                        Pair v = element$iv = pairArray[n5];
                        boolean bl7 = false;
                        this.writeComplex((Number)v.getFirst(), (Number)v.getSecond());
                    }
                    this.writer.endArray();
                    break;
                }
                case 17: {
                    int n5;
                    this.writer.beginArray();
                    Pair[] $this$forEach$iv = tuple.get(it);
                    if ($this$forEach$iv == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<kotlin.Pair<kotlin.Double, kotlin.Double>>");
                    }
                    $this$forEach$iv = $this$forEach$iv;
                    boolean $i$f$forEach = false;
                    Pair[] pairArray = $this$forEach$iv;
                    int n6 = pairArray.length;
                    for (n5 = 0; n5 < n6; ++n5) {
                        Pair element$iv;
                        Pair v = element$iv = pairArray[n5];
                        boolean bl8 = false;
                        this.writeComplex((Number)v.getFirst(), (Number)v.getSecond());
                    }
                    this.writer.endArray();
                    break;
                }
                default: {
                    throw new IllegalStateException("Type " + tuple.type(it) + " cannot be serialized to JSON!");
                }
            }
        }
        this.writer.endObject();
    }

    private final void writeComplex(Number real, Number imaginary) {
        this.writer.beginObject();
        this.writer.name("real");
        this.writer.value(real);
        this.writer.name("imaginary");
        this.writer.value(imaginary);
        this.writer.endObject();
    }

    @Override
    public void close() {
        if (!this.getClosed()) {
            this.writer.endArray();
            this.writer.close();
            this.closed = true;
        }
    }

    @Override
    public void offerAll(@NotNull TupleIterator iterator2) {
        DataExporter.DefaultImpls.offerAll(this, iterator2);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            nArray[Type.BOOLEAN.ordinal()] = 1;
            nArray[Type.BYTE.ordinal()] = 2;
            nArray[Type.SHORT.ordinal()] = 3;
            nArray[Type.INTEGER.ordinal()] = 4;
            nArray[Type.LONG.ordinal()] = 5;
            nArray[Type.FLOAT.ordinal()] = 6;
            nArray[Type.DOUBLE.ordinal()] = 7;
            nArray[Type.DATE.ordinal()] = 8;
            nArray[Type.STRING.ordinal()] = 9;
            nArray[Type.COMPLEX32.ordinal()] = 10;
            nArray[Type.COMPLEX64.ordinal()] = 11;
            nArray[Type.FLOAT_VECTOR.ordinal()] = 12;
            nArray[Type.LONG_VECTOR.ordinal()] = 13;
            nArray[Type.INTEGER_VECTOR.ordinal()] = 14;
            nArray[Type.BOOLEAN_VECTOR.ordinal()] = 15;
            nArray[Type.COMPLEX32_VECTOR.ordinal()] = 16;
            nArray[Type.COMPLEX64_VECTOR.ordinal()] = 17;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

