/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.data.importer;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.utilities.data.Format;
import org.vitrivr.cottontail.utilities.data.importer.DataImporter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u0006H\u0096\u0002J\t\u0010\u0011\u001a\u00020\u001cH\u0096\u0002R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lorg/vitrivr/cottontail/utilities/data/importer/ProtoDataImporter;", "Lorg/vitrivr/cottontail/utilities/data/importer/DataImporter;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "<set-?>", "", "closed", "getClosed", "()Z", "format", "Lorg/vitrivr/cottontail/utilities/data/Format;", "getFormat", "()Lorg/vitrivr/cottontail/utilities/data/Format;", "input", "Ljava/io/InputStream;", "kotlin.jvm.PlatformType", "next", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$InsertMessage;", "getNext", "()Lorg/vitrivr/cottontail/grpc/CottontailGrpc$InsertMessage;", "setNext", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$InsertMessage;)V", "getPath", "()Ljava/nio/file/Path;", "close", "", "hasNext", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$InsertMessage$Builder;", "cottontaildb"})
public final class ProtoDataImporter
implements DataImporter {
    @NotNull
    private final Path path;
    @NotNull
    private final Format format;
    private boolean closed;
    private final InputStream input;
    @Nullable
    private CottontailGrpc.InsertMessage next;

    public ProtoDataImporter(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.format = Format.PROTO;
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ};
        this.input = Files.newInputStream(this.getPath(), openOptionArray);
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Format getFormat() {
        return this.format;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Nullable
    protected final CottontailGrpc.InsertMessage getNext() {
        return this.next;
    }

    protected final void setNext(@Nullable CottontailGrpc.InsertMessage insertMessage) {
        this.next = insertMessage;
    }

    @Override
    @NotNull
    public CottontailGrpc.InsertMessage.Builder next() {
        CottontailGrpc.InsertMessage insertMessage = this.next;
        if (insertMessage == null) {
            throw new NoSuchElementException("");
        }
        CottontailGrpc.InsertMessage ret = insertMessage;
        this.next = null;
        insertMessage = ret.toBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)insertMessage, (String)"ret.toBuilder()");
        return insertMessage;
    }

    @Override
    public boolean hasNext() {
        boolean bl;
        try {
            this.next = CottontailGrpc.InsertMessage.parseDelimitedFrom((InputStream)this.input);
            bl = this.next != null;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void close() {
        if (!this.getClosed()) {
            this.input.close();
            this.closed = true;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

