/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.ExperimentalTime;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.cli.Cli;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.legacy.VersionProber;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.server.grpc.CottontailGrpcServer;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u001b\u0010\u0007\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u0002\u00a2\u0006\u0002\u0010\n\u001a\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u001b\u0010\r\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u0007\u00a2\u0006\u0002\u0010\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"COTTONTAIL_CONFIG_FILE_ENV_KEY", "", "COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY", "embedded", "Lorg/vitrivr/cottontail/server/grpc/CottontailGrpcServer;", "config", "Lorg/vitrivr/cottontail/config/Config;", "findConfigPathOrdered", "args", "", "([Ljava/lang/String;)Ljava/lang/String;", "loadConfig", "path", "main", "", "([Ljava/lang/String;)V", "standalone", "cottontaildb"})
public final class CottontailKt {
    @NotNull
    public static final String COTTONTAIL_CONFIG_FILE_ENV_KEY = "COTTONTAIL_CONFIG";
    @NotNull
    public static final String COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY = "org.vitrivr.cottontail.config";

    @ExperimentalTime
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object object = args;
        boolean bl = false;
        Object[] objectArray = object;
        int n = 0;
        if (!(objectArray.length == 0) && ArraysKt.contains((Object[])(object = new String[]{"prompt", "cli"}), (Object)args[0])) {
            if (args.length < 3) {
                object = "Starting CLI on default setup";
                bl = false;
                System.out.println(object);
                new Cli(null, 0, 3, null).loop();
                return;
            }
            object = args[2];
            bl = false;
            new Cli(args[1], Integer.parseInt((String)object)).loop();
            return;
        }
        Config config = null;
        String configPath = CottontailKt.findConfigPathOrdered(args);
        try {
            config = CottontailKt.loadConfig(configPath);
        }
        catch (FileNotFoundException e) {
            System.err.println("Specified Cottontail DB configuration file " + configPath + " does not exist. Cottontail DB will shut down.");
            n = 1;
            boolean bl2 = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        catch (RuntimeException r) {
            System.err.println("Error on reading Cottontail DB configuration file (" + configPath + "). Cottontail DB will shut down.");
            n = 1;
            boolean bl3 = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        try {
            CottontailKt.standalone(config);
        }
        catch (Throwable e) {
            System.err.println("Failed to start Cottontail DB due to error:");
            e.printStackTrace();
            System.err.println(Unit.INSTANCE);
            n = 1;
            boolean bl4 = false;
            System.exit(n);
            throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String findConfigPathOrdered(String[] args) {
        String string;
        String[] stringArray = args;
        boolean bl = false;
        String[] stringArray2 = stringArray;
        boolean bl2 = false;
        if (!(stringArray2.length == 0)) {
            CharSequence charSequence = args[0];
            bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                string = args[0];
                return string;
            }
        }
        if (System.getProperties().containsKey(COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY)) {
            String string2 = System.getProperty(COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY, "");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\n           \u2026ROPERTY_KEY, \"\"\n        )");
            CharSequence charSequence = string2;
            bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                String string3 = System.getProperty(COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n        System.getProp\u2026YSTEM_PROPERTY_KEY)\n    }");
                string = string3;
                return string;
            }
        }
        if (System.getenv().containsKey(COTTONTAIL_CONFIG_FILE_ENV_KEY)) {
            String string4 = System.getenv(COTTONTAIL_CONFIG_FILE_ENV_KEY);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getenv(\n            COTT\u2026IG_FILE_ENV_KEY\n        )");
            CharSequence charSequence = string4;
            bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                String string5 = System.getenv(COTTONTAIL_CONFIG_FILE_ENV_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"{\n        System.getenv(\u2026ONFIG_FILE_ENV_KEY)\n    }");
                string = string5;
                return string;
            }
        }
        System.err.println("No CottontailDB Config file specified. Defaulting to ./config.json");
        return "./config.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Config loadConfig(String path) {
        Path configPath = Paths.get(path, new String[0]);
        if (!Files.isRegularFile(configPath, new LinkOption[0])) {
            throw new FileNotFoundException("Cottontail DB configuration file " + configPath + " des not exist.");
        }
        try {
            Config config;
            Closeable closeable = Files.newBufferedReader(configPath);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl3 = false;
                DeserializationStrategy deserializationStrategy = (DeserializationStrategy)Config.Companion.serializer();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                config = (Config)Json.Default.decodeFromString(deserializationStrategy, TextStreamsKt.readText((Reader)it));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return config;
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not read Cottontail DB configuration file", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @ExperimentalTime
    public static final void standalone(@NotNull Config config) {
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                if (config.getLogConfig() != null && Files.isRegularFile(config.getLogConfig(), new LinkOption[0])) {
                    System.getProperties().setProperty("log4j.configurationFile", config.getLogConfig().toString());
                }
                server = CottontailKt.embedded(config);
                var2_2 = "Cottontail DB server is up and running at port " + config.getServer().getPort() + "! Hop along... (catalogue: " + (Object)server.getCatalogue().getVersion() + ", pid: " + ProcessHandle.current().pid() + ')';
                var3_3 = false;
                System.out.println((Object)var2_2);
                if (!config.getCli()) break block13;
                new Cli("localhost", config.getServer().getPort()).loop();
                break block14;
            }
            obj = new BufferedReader(new InputStreamReader(System.in));
            block8: while (server.isRunning()) {
                var3_4 = obj.readLine();
                if (var3_4 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var3_4.hashCode()) {
                    case 3127582: {
                        if (var3_4.equals("exit")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 3540994: {
                        if (var3_4.equals("stop")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 3482191: {
                        if (var3_4.equals("quit")) {
                            tmp = 1;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        break block8;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        Thread.sleep(100L);
                        continue block8;
                    }
                }
            }
        }
        server.stop();
        var2_2 = "Cottontail DB was shut down. Have a binky day!";
        var3_3 = false;
        System.out.println((Object)var2_2);
    }

    @ExperimentalTime
    @NotNull
    public static final CottontailGrpcServer embedded(@NotNull Config config) {
        DBOVersion detected;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!Files.exists(config.getRoot(), new LinkOption[0])) {
            Files.createDirectories(config.getRoot(), new FileAttribute[0]);
        }
        if ((detected = new VersionProber(config).probe(config.getRoot())) != VersionProber.Companion.getEXPECTED() && detected != DBOVersion.UNDEFINED) {
            throw new DatabaseException.VersionMismatchException(VersionProber.Companion.getEXPECTED(), detected);
        }
        return new CottontailGrpcServer(config);
    }
}

