/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.cli.entity;

import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.ParameterHolder;
import com.github.ajalt.clikt.parameters.arguments.ArgumentKt;
import com.github.ajalt.clikt.parameters.arguments.ProcessedArgument;
import com.github.ajalt.clikt.parameters.options.FlagOptionKt;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.types.ChoiceKt;
import com.jakewharton.picnic.Table;
import io.grpc.StatusException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.cli.AbstractCottontailCommand;
import org.vitrivr.cottontail.client.SimpleClient;
import org.vitrivr.cottontail.database.queries.binding.extensions.NameExtensionsKt;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.utilities.output.TabulationUtilities;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/cli/entity/CreateIndexCommand;", "Lorg/vitrivr/cottontail/cli/AbstractCottontailCommand$Entity;", "client", "Lorg/vitrivr/cottontail/client/SimpleClient;", "(Lorg/vitrivr/cottontail/client/SimpleClient;)V", "attribute", "", "getAttribute", "()Ljava/lang/String;", "attribute$delegate", "Lkotlin/properties/ReadOnlyProperty;", "index", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$IndexType;", "getIndex", "()Lorg/vitrivr/cottontail/grpc/CottontailGrpc$IndexType;", "index$delegate", "rebuild", "", "getRebuild", "()Z", "rebuild$delegate", "exec", "", "cottontaildb"})
@ExperimentalTime
public final class CreateIndexCommand
extends AbstractCottontailCommand.Entity {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty attribute$delegate;
    @NotNull
    private final ReadOnlyProperty index$delegate;
    @NotNull
    private final ReadOnlyProperty rebuild$delegate;

    /*
     * WARNING - void declaration
     */
    public CreateIndexCommand(@NotNull SimpleClient client) {
        Map map2;
        void $this$associateByTo$iv$iv$iv;
        void $this$associateBy$iv$iv;
        void $this$enum_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(client, "create-index", "Creates an index on the given entity and rebuilds the newly created index. Usage: entity createIndex <schema>.<entity> <column> <index>", false, 8, null);
        this.attribute$delegate = ArgumentKt.argument$default((CliktCommand)this, (String)"column", (String)"The column name to create the index for", null, null, (int)12, null).provideDelegate((CliktCommand)this, $$delegatedProperties[0]);
        String[] stringArray = ArgumentKt.argument$default((CliktCommand)this, (String)"index", (String)"The index to create", null, null, (int)12, null);
        CreateIndexCommand createIndexCommand = this;
        boolean ignoreCase$iv = true;
        boolean $i$f$enum = false;
        CottontailGrpc.IndexType[] indexTypeArray = CottontailGrpc.IndexType.values();
        void var6_7 = $this$enum_u24default$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associateBy$iv$iv).length), (int)16);
        void var9_10 = $this$associateBy$iv$iv;
        Map destination$iv$iv$iv = new LinkedHashMap(capacity$iv$iv);
        boolean $i$f$associateByTo = false;
        for (void element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv;
            Enum enum_ = (Enum)element$iv$iv$iv;
            map2 = destination$iv$iv$iv;
            boolean bl = false;
            void it = it$iv;
            String string = it.name();
            map2.put(string, element$iv$iv$iv);
        }
        map2 = destination$iv$iv$iv;
        ProcessedArgument processedArgument = ChoiceKt.choice((ProcessedArgument)var6_7, (Map)map2, (boolean)ignoreCase$iv);
        createIndexCommand.index$delegate = processedArgument.provideDelegate((CliktCommand)this, $$delegatedProperties[1]);
        stringArray = new String[]{"-r", "--rebuild"};
        this.rebuild$delegate = FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Limits the amount of printed results", null, (boolean)false, null, null, null, null, (int)252, null), (String[])new String[0], (boolean)false, null, (int)4, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[2]);
    }

    private final String getAttribute() {
        return (String)this.attribute$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final CottontailGrpc.IndexType getIndex() {
        return (CottontailGrpc.IndexType)this.index$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final boolean getRebuild() {
        return (Boolean)this.rebuild$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Override
    public void exec() {
        CottontailGrpc.EntityName entity = NameExtensionsKt.proto(this.getEntityName());
        CottontailGrpc.IndexDefinition.Builder builder = CottontailGrpc.IndexDefinition.newBuilder().setType(this.getIndex());
        CottontailGrpc.IndexName.Builder builder2 = CottontailGrpc.IndexName.newBuilder().setEntity(entity);
        StringBuilder stringBuilder = new StringBuilder().append("index-");
        String string = this.getIndex().name();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        CottontailGrpc.IndexDefinition index = builder.setName(builder2.setName(stringBuilder.append(string3).append('-').append(this.getEntityName().schema()).append('_').append((Object)entity.getName()).append('_').append(this.getAttribute()).toString())).addColumns(CottontailGrpc.ColumnName.newBuilder().setName(this.getAttribute())).build();
        try {
            boolean $i$f$measureTimedValue = false;
            boolean bl2 = false;
            TimeSource $this$measureTimedValue$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            boolean bl3 = false;
            TimeMark mark$iv$iv = $this$measureTimedValue$iv$iv.markNow();
            boolean bl4 = false;
            SimpleClient simpleClient = this.getClient();
            CottontailGrpc.CreateIndexMessage createIndexMessage = CottontailGrpc.CreateIndexMessage.newBuilder().setRebuild(this.getRebuild()).setDefinition(index).build();
            Intrinsics.checkNotNullExpressionValue((Object)createIndexMessage, (String)"newBuilder().setRebuild(\u2026Definition(index).build()");
            Table result$iv$iv = TabulationUtilities.INSTANCE.tabulate(simpleClient.create(createIndexMessage));
            TimedValue timedTable2 = new TimedValue((Object)result$iv$iv, mark$iv$iv.elapsedNow-UwyO8pc(), null);
            StringBuilder stringBuilder2 = new StringBuilder().append("Successfully created index ");
            Object object = index.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"index.name");
            object = stringBuilder2.append(NameExtensionsKt.fqn(object)).append(" (took ").append((Object)Duration.toString-impl((long)timedTable2.getDuration-UwyO8pc())).append(").").toString();
            boolean bl5 = false;
            System.out.println(object);
            object = timedTable2.getValue();
            bl5 = false;
            System.out.print(object);
        }
        catch (StatusException e) {
            StringBuilder stringBuilder3 = new StringBuilder().append("Error while creating index ");
            Object object = index.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"index.name");
            object = stringBuilder3.append(NameExtensionsKt.fqn(object)).append(": ").append((Object)e.getMessage()).append('.').toString();
            boolean bl6 = false;
            System.out.println(object);
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CreateIndexCommand.class, "attribute", "getAttribute()Ljava/lang/String;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CreateIndexCommand.class, "index", "getIndex()Lorg/vitrivr/cottontail/grpc/CottontailGrpc$IndexType;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CreateIndexCommand.class, "rebuild", "getRebuild()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

