/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.cli.entity;

import com.github.ajalt.clikt.completion.CompletionCandidates;
import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.ParameterHolder;
import com.github.ajalt.clikt.core.UsageError;
import com.github.ajalt.clikt.output.TermUi;
import com.github.ajalt.clikt.parameters.arguments.ArgumentKt;
import com.github.ajalt.clikt.parameters.arguments.ArgumentTransformContext;
import com.github.ajalt.clikt.parameters.arguments.ProcessedArgument;
import com.github.ajalt.clikt.parameters.options.FlagOptionKt;
import com.github.ajalt.clikt.parameters.options.OptionWithValues;
import com.github.ajalt.clikt.parameters.options.OptionWithValuesKt;
import com.github.ajalt.clikt.parameters.options.ValueWithDefault;
import com.jakewharton.picnic.Table;
import io.grpc.StatusException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.ExperimentalTime;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.cli.AbstractCottontailCommand;
import org.vitrivr.cottontail.client.SimpleClient;
import org.vitrivr.cottontail.client.language.ddl.DropIndex;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.utilities.output.TabulationUtilities;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/vitrivr/cottontail/cli/entity/DropIndexCommand;", "Lorg/vitrivr/cottontail/cli/AbstractCottontailCommand$Entity;", "client", "Lorg/vitrivr/cottontail/client/SimpleClient;", "(Lorg/vitrivr/cottontail/client/SimpleClient;)V", "confirm", "", "getConfirm", "()Z", "confirm$delegate", "Lkotlin/properties/ReadOnlyProperty;", "indexName", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "getIndexName", "()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "indexName$delegate", "exec", "", "cottontaildb"})
@ExperimentalTime
public final class DropIndexCommand
extends AbstractCottontailCommand.Entity {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty indexName$delegate;
    @NotNull
    private final ReadOnlyProperty confirm$delegate;

    public DropIndexCommand(@NotNull SimpleClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(client, "drop-index", "Drops the index on an entity. Usage: entity drop-index <schema>.<entity> <index>", false, 8, null);
        ProcessedArgument $this$convert_u24default$iv = ArgumentKt.argument$default((CliktCommand)this, (String)"name", (String)"The name of the index. Ideally from a previous list-indices call", null, null, (int)12, null);
        CompletionCandidates completionCandidates$iv = (CompletionCandidates)$this$convert_u24default$iv.getCompletionCandidatesWithDefault().getDefault();
        boolean $i$f$convert = false;
        Function2 conv$iv = (Function2)new Function2<ArgumentTransformContext, String, Name.IndexName>($this$convert_u24default$iv, this){
            final /* synthetic */ ProcessedArgument $this_convert;
            final /* synthetic */ DropIndexCommand this$0;
            {
                this.$this_convert = $receiver;
                this.this$0 = dropIndexCommand;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Name.IndexName invoke(@NotNull ArgumentTransformContext $this$null, @NotNull String it) {
                Name.IndexName indexName;
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    void it2;
                    String string = (String)this.$this_convert.getTransformValue().invoke((Object)$this$null, (Object)it);
                    ArgumentTransformContext $this$indexName_delegate_u24lambda_u2d0 = $this$null;
                    boolean bl = false;
                    indexName = DropIndexCommand.access$getEntityName(this.this$0).index((String)it2);
                }
                catch (UsageError err) {
                    err.setArgument($this$null.getArgument());
                    throw err;
                }
                catch (Exception err) {
                    String string = err.getMessage();
                    $this$null.fail(string == null ? "" : string);
                    throw new KotlinNothingValueException();
                }
                return indexName;
            }
        };
        this.indexName$delegate = ProcessedArgument.copy$default((ProcessedArgument)$this$convert_u24default$iv, (Function2)conv$iv, (Function2)ArgumentKt.defaultAllProcessor(), (Function2)ArgumentKt.defaultValidator(), null, (int)0, (boolean)false, null, null, (ValueWithDefault)ValueWithDefault.copy$default((ValueWithDefault)$this$convert_u24default$iv.getCompletionCandidatesWithDefault(), null, (Object)completionCandidates$iv, (int)1, null), (int)248, null).provideDelegate((CliktCommand)this, $$delegatedProperties[0]);
        String[] stringArray = new String[]{"-c", "--confirm"};
        this.confirm$delegate = FlagOptionKt.flag$default((OptionWithValues)OptionWithValuesKt.option$default((ParameterHolder)((ParameterHolder)this), (String[])stringArray, (String)"Directly provides the confirmation option.", null, (boolean)false, null, null, null, null, (int)252, null), (String[])new String[0], (boolean)false, null, (int)6, null).provideDelegate((ParameterHolder)this, $$delegatedProperties[1]);
    }

    private final Name.IndexName getIndexName() {
        return (Name.IndexName)this.indexName$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final boolean getConfirm() {
        return (Boolean)this.confirm$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Override
    public void exec() {
        if (this.getConfirm() || Intrinsics.areEqual((Object)TermUi.confirm$default((TermUi)TermUi.INSTANCE, (String)("Do you really want to drop the index " + this.getIndexName() + " [y/N]?"), (boolean)false, (boolean)false, null, (boolean)false, null, (int)44, null), (Object)true)) {
            try {
                boolean $i$f$measureTimedValue = false;
                boolean bl = false;
                TimeSource $this$measureTimedValue$iv$iv = (TimeSource)TimeSource.Monotonic.INSTANCE;
                boolean $i$f$measureTimedValue2 = false;
                boolean bl2 = false;
                TimeMark mark$iv$iv = $this$measureTimedValue$iv$iv.markNow();
                boolean bl3 = false;
                Table result$iv$iv = TabulationUtilities.INSTANCE.tabulate(this.getClient().drop(new DropIndex(this.getIndexName().toString())));
                TimedValue timedTable2 = new TimedValue((Object)result$iv$iv, mark$iv$iv.elapsedNow-UwyO8pc(), null);
                Object object = "Successfully dropped index " + this.getIndexName() + " (in " + Duration.toString-impl((long)timedTable2.getDuration-UwyO8pc()) + ").";
                boolean bl4 = false;
                System.out.println(object);
                object = timedTable2.getValue();
                bl4 = false;
                System.out.print(object);
            }
            catch (StatusException e) {
                String string = "Failed to remove the index " + this.getIndexName() + " due to error: " + e.getMessage() + '.';
                boolean bl = false;
                System.out.println((Object)string);
            }
        } else {
            String string = "Drop index aborted.";
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    public static final /* synthetic */ Name.EntityName access$getEntityName(DropIndexCommand $this) {
        return $this.getEntityName();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DropIndexCommand.class, "indexName", "getIndexName()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DropIndexCommand.class, "confirm", "getConfirm()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

