/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.hash;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.operations.Operation;
import org.vitrivr.cottontail.database.queries.binding.Binding;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.bool.BooleanPredicate;
import org.vitrivr.cottontail.database.queries.predicates.bool.ComparisonOperator;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.types.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u00060\nj\u0002`\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006)"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/UniqueHashIndex;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/DefaultEntity;)V", "map", "Lorg/mapdb/HTreeMap;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "produces", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getProduces", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "cost-FdqVpck", "(Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;)[F", "newTx", "Lorg/vitrivr/cottontail/database/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "Companion", "Tx", "cottontaildb"})
public final class UniqueHashIndex
extends AbstractIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexType type;
    @NotNull
    private final ColumnDef<?>[] produces;
    @NotNull
    private final HTreeMap<Value, Long> map;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    public static final String UQ_INDEX_MAP = "cdb_uq_map";

    public UniqueHashIndex(@NotNull Path path, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(path, parent);
        this.type = IndexType.HASH_UQ;
        this.produces = this.getColumns();
        DB dB = this.getStore();
        Serializer serializer2 = this.getColumns()[0].getType().serializerFactory().mapdb(this.getColumns()[0].getType().getLogicalSize());
        GroupSerializer groupSerializer = Serializer.LONG_DELTA;
        Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"LONG_DELTA");
        this.map = dB.hashMap(UQ_INDEX_MAP, serializer2, (Serializer)groupSerializer).createOrOpen();
        this.supportsIncrementalUpdate = true;
        this.getStore().commit();
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof BooleanPredicate.Atomic && !((BooleanPredicate.Atomic)predicate).getNot() && ((BooleanPredicate.Atomic)predicate).getColumns().contains(this.getColumns()[0]) && (((BooleanPredicate.Atomic)predicate).getOperator() instanceof ComparisonOperator.In || ((BooleanPredicate.Atomic)predicate).getOperator() instanceof ComparisonOperator.Binary.Equal);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public float[] cost-FdqVpck(@NotNull Predicate predicate) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(predicate instanceof BooleanPredicate.Atomic) || !Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)((Iterable)((BooleanPredicate.Atomic)predicate).getColumns())), this.getColumns()[0]) || ((BooleanPredicate.Atomic)predicate).getNot()) {
            fArray = Cost.Companion.getINVALID-9E9yFcc();
        } else if (((BooleanPredicate.Atomic)predicate).getOperator() instanceof ComparisonOperator.Binary.Equal) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)((BooleanPredicate.Atomic)predicate).getColumns();
            float f = Cost.Companion.getCOST_MEMORY_ACCESS();
            float f2 = 1.0E-4f;
            boolean $i$f$map = false;
            void var4_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ColumnDef columnDef = (ColumnDef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n = it.getType().getPhysicalSize();
                collection.add(n);
            }
            collection = (List)destination$iv$iv;
            fArray = Cost.constructor-impl$default(f2, f, CollectionsKt.sumOfInt((Iterable)collection), 0.0f, 8, null);
        } else if (((BooleanPredicate.Atomic)predicate).getOperator() instanceof ComparisonOperator.In) {
            Collection<Integer> collection;
            Iterable $this$map$iv = (Iterable)((BooleanPredicate.Atomic)predicate).getColumns();
            float f = Cost.Companion.getCOST_MEMORY_ACCESS() * (float)((ComparisonOperator.In)((BooleanPredicate.Atomic)predicate).getOperator()).getRight().size();
            float f3 = 1.0E-4f * (float)((ComparisonOperator.In)((BooleanPredicate.Atomic)predicate).getOperator()).getRight().size();
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ColumnDef it = (ColumnDef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n = it.getType().getPhysicalSize();
                collection.add(n);
            }
            collection = (List)destination$iv$iv;
            fArray = Cost.constructor-impl$default(f3, f, CollectionsKt.sumOfInt((Iterable)collection), 0.0f, 8, null);
        } else {
            fArray = Cost.Companion.getINVALID-9E9yFcc();
        }
        return fArray;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/UniqueHashIndex$Companion;", "", "()V", "UQ_INDEX_MAP", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/UniqueHashIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/index/hash/UniqueHashIndex;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "addMapping", "", "key", "Lorg/vitrivr/cottontail/model/values/types/Value;", "tupleId", "", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "clear", "", "count", "filter", "", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "filterRange", "partitionIndex", "", "partitions", "rebuild", "removeMapping", "update", "event", "Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation;", "cottontaildb"})
    private final class Tx
    extends AbstractIndex.Tx {
        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)UniqueHashIndex.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(UniqueHashIndex.this, context2);
        }

        private final boolean addMapping(Value key, long tupleId) {
            return UniqueHashIndex.this.map.putIfAbsentBoolean((Object)key, (Object)tupleId);
        }

        private final boolean removeMapping(Value key) {
            return UniqueHashIndex.this.map.remove((Object)key) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public long count() {
            long l;
            void this_$iv;
            AbstractTx abstractTx = this;
            UniqueHashIndex uniqueHashIndex = UniqueHashIndex.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                boolean bl3 = false;
                boolean bl4 = false;
                Map map2 = (Map)uniqueHashIndex.map;
                boolean bl5 = false;
                l = map2.size();
            }
            finally {
                readLock.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void rebuild() {
            int n;
            int n2;
            void this_$iv;
            AbstractTx abstractTx = this;
            UniqueHashIndex uniqueHashIndex = UniqueHashIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                EntityTx entityTx = (EntityTx)this.getContext().getTx(this.getDbo().getParent());
                uniqueHashIndex.map.clear();
                Iterator<Record> $this$forEach$iv = entityTx.scan(uniqueHashIndex.getColumns());
                boolean $i$f$forEach = false;
                Iterator<Record> iterator2 = $this$forEach$iv;
                boolean bl6 = false;
                Iterator<Record> iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    Record element$iv;
                    Record record = element$iv = iterator3.next();
                    boolean bl7 = false;
                    Value value = record.get(this.getDbo().getColumns()[0]);
                    if (value == null) {
                        throw new TxException.TxValidationException(this.getContext().getTxId(), "Value cannot be null for UniqueHashIndex " + uniqueHashIndex.getName() + " given value is (value = null, tupleId = " + record.getTupleId() + ").");
                    }
                    Value value2 = value;
                    if (this.addMapping(value2, record.getTupleId())) continue;
                    throw new TxException.TxValidationException(this.getContext().getTxId(), "Value must be unique for UniqueHashIndex " + uniqueHashIndex.getName() + " but is not (value = " + value2 + ", tupleId = " + record.getTupleId() + ").");
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl8 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(@NotNull Operation.DataManagementOperation event) {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus(this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                Value old;
                boolean bl4 = false;
                boolean bl5 = false;
                Operation.DataManagementOperation dataManagementOperation = event;
                if (dataManagementOperation instanceof Operation.DataManagementOperation.InsertOperation) {
                    Value value = ((Operation.DataManagementOperation.InsertOperation)event).getInserts().get(this.getDbo().getColumns()[0]);
                    if (value != null) {
                        this.addMapping(value, event.getTupleId());
                    }
                } else if (dataManagementOperation instanceof Operation.DataManagementOperation.UpdateOperation) {
                    Pair<Value, Value> pair;
                    Value value;
                    Pair<Value, Value> pair2 = ((Operation.DataManagementOperation.UpdateOperation)event).getUpdates().get(this.getDbo().getColumns()[0]);
                    Value value2 = old = pair2 == null ? null : (Value)pair2.getFirst();
                    if (old != null) {
                        this.removeMapping(old);
                    }
                    Value value3 = value = (pair = ((Operation.DataManagementOperation.UpdateOperation)event).getUpdates().get(this.getDbo().getColumns()[0])) == null ? null : (Value)pair.getSecond();
                    if (value != null) {
                        this.addMapping(value, event.getTupleId());
                    }
                } else if (dataManagementOperation instanceof Operation.DataManagementOperation.DeleteOperation && (old = ((Operation.DataManagementOperation.DeleteOperation)event).getDeleted().get(this.getDbo().getColumns()[0])) != null) {
                    this.removeMapping(old);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void clear() {
            int n;
            int n2;
            void this_$iv;
            AbstractTx abstractTx = this;
            UniqueHashIndex uniqueHashIndex = UniqueHashIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                uniqueHashIndex.getDirtyField().compareAndSet(false, true);
                uniqueHashIndex.map.clear();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        @NotNull
        public Iterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new Iterator<Record>(predicate, this, UniqueHashIndex.this){
                @NotNull
                private final BooleanPredicate.Atomic predicate;
                @NotNull
                private final LinkedList<Value> elements;
                final /* synthetic */ Predicate $predicate;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ UniqueHashIndex this$1;
                {
                    this.$predicate = $predicate;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.elements = new LinkedList<E>();
                    boolean bl = this.$predicate instanceof BooleanPredicate.Atomic;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "UniqueHashIndex.filter() does only support Atomic.Literal boolean predicates.";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    bl = !((BooleanPredicate.Atomic)this.$predicate).getNot();
                    bl2 = false;
                    bl3 = false;
                    if (!bl) {
                        boolean bl52 = false;
                        String string = "UniqueHashIndex.filter() does not support negated statements (i.e. NOT EQUALS or NOT IN).";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    AbstractTx this_$iv = this.this$0;
                    boolean $i$f$withReadLock2 = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
                    boolean bl52 = false;
                    boolean bl6 = false;
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    readLock.lock();
                    try {
                        boolean $i$a$-read-AbstractTx$withReadLock$1$iv22 = false;
                        boolean bl7 = false;
                        Unit $i$a$-read-AbstractTx$withReadLock$1$iv22 = Unit.INSTANCE;
                    }
                    finally {
                        readLock.unlock();
                    }
                    this.predicate = (BooleanPredicate.Atomic)this.$predicate;
                    ComparisonOperator comparisonOperator = ((BooleanPredicate.Atomic)this.$predicate).getOperator();
                    if (comparisonOperator instanceof ComparisonOperator.In) {
                        void $this$mapNotNullTo$iv$iv;
                        void $this$mapNotNull$iv;
                        Iterable $i$f$withReadLock2 = ((ComparisonOperator.In)((BooleanPredicate.Atomic)this.$predicate).getOperator()).getRight();
                        LinkedList<Value> linkedList = this.elements;
                        boolean $i$f$mapNotNull = false;
                        void bl52 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            Value value;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator2.next();
                            boolean bl8 = false;
                            Binding.Literal it = (Binding.Literal)element$iv$iv;
                            boolean bl9 = false;
                            if (it.getValue() == null) continue;
                            boolean bl10 = false;
                            boolean bl11 = false;
                            Value it$iv$iv = value;
                            boolean bl12 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List list = (List)destination$iv$iv;
                        linkedList.addAll(list);
                    } else if (comparisonOperator instanceof ComparisonOperator.Binary.Equal) {
                        if (((ComparisonOperator.Binary.Equal)((BooleanPredicate.Atomic)this.$predicate).getOperator()).getRight().getValue() != null) {
                            Value value = ((ComparisonOperator.Binary.Equal)((BooleanPredicate.Atomic)this.$predicate).getOperator()).getRight().getValue();
                            Intrinsics.checkNotNull((Object)value);
                            this.elements.add(value);
                        }
                    } else {
                        throw new IllegalArgumentException("UniqueHashIndex.filter() does only support EQUAL and IN operators.");
                    }
                }

                public boolean hasNext() {
                    while (true) {
                        Object object = this.elements;
                        boolean bl = false;
                        if (!(!object.isEmpty())) break;
                        object = (Map)UniqueHashIndex.access$getMap$p(this.this$1);
                        Value value = this.elements.peek();
                        boolean bl2 = false;
                        Object object2 = object;
                        boolean bl3 = false;
                        if (object2.containsKey(value)) {
                            return true;
                        }
                        this.elements.remove();
                    }
                    return false;
                }

                @NotNull
                public Record next() {
                    Value value = this.elements.poll();
                    Object object = UniqueHashIndex.access$getMap$p(this.this$1).get((Object)value);
                    Intrinsics.checkNotNull((Object)object);
                    long tid = ((Number)object).longValue();
                    Value[] valueArray = new Value[]{value};
                    return new StandaloneRecord(tid, this.this$1.getProduces(), valueArray);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        @NotNull
        public Iterator<Record> filterRange(@NotNull Predicate predicate, int partitionIndex, int partitions) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            throw new UnsupportedOperationException("The UniqueHashIndex does not support ranged filtering!");
        }
    }
}

