/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.pq.codebook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.stat.correlation.Covariance;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.vitrivr.cottontail.database.index.pq.codebook.ClusterableWithIndex;
import org.vitrivr.cottontail.database.index.pq.codebook.PQCodebook;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.FloatVectorValue;
import org.vitrivr.cottontail.storage.serializers.FloatVectorValueSerializerFactory;
import org.vitrivr.cottontail.storage.serializers.mapdb.MapDBSerializer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001f B$\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J!\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\rH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J%\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\rH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001d\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0084\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0084\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0019\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00138VX\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/database/index/pq/codebook/SinglePrecisionPQCodebook;", "Lorg/vitrivr/cottontail/database/index/pq/codebook/PQCodebook;", "Lorg/vitrivr/cottontail/model/values/FloatVectorValue;", "centroids", "", "covMatrix", "(Ljava/util/List;Ljava/util/List;)V", "getCentroids", "()Ljava/util/List;", "getCovMatrix", "diffBuffer", "[F", "logicalSize", "", "getLogicalSize", "()I", "numberOfCentroids", "getNumberOfCentroids", "type", "Lorg/vitrivr/cottontail/model/basics/Type;", "getType", "()Lorg/vitrivr/cottontail/model/basics/Type;", "get", "ci", "get-QzS6wKg", "(I)[F", "quantizeSubspaceForVector", "v", "start", "quantizeSubspaceForVector-ODtDxJY", "([FI)I", "Companion", "Serializer", "cottontaildb"})
public final class SinglePrecisionPQCodebook
implements PQCodebook<FloatVectorValue> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<FloatVectorValue> centroids;
    @NotNull
    private final List<FloatVectorValue> covMatrix;
    @NotNull
    private final float[] diffBuffer;

    public SinglePrecisionPQCodebook(@NotNull List<FloatVectorValue> centroids, @NotNull List<FloatVectorValue> covMatrix) {
        Intrinsics.checkNotNullParameter(centroids, (String)"centroids");
        Intrinsics.checkNotNullParameter(covMatrix, (String)"covMatrix");
        this.centroids = centroids;
        this.covMatrix = covMatrix;
        this.diffBuffer = FloatVectorValue.constructor-impl(new float[this.getLogicalSize()]);
    }

    @NotNull
    protected final List<FloatVectorValue> getCentroids() {
        return this.centroids;
    }

    @NotNull
    protected final List<FloatVectorValue> getCovMatrix() {
        return this.covMatrix;
    }

    @Override
    @NotNull
    public Type<FloatVectorValue> getType() {
        return new Type.FloatVector(this.getLogicalSize());
    }

    @Override
    public int getNumberOfCentroids() {
        return this.centroids.size();
    }

    @Override
    public int getLogicalSize() {
        return FloatVectorValue.getLogicalSize-impl(this.centroids.get(0).unbox-impl());
    }

    @NotNull
    public float[] get-QzS6wKg(int ci) {
        return this.centroids.get(ci).unbox-impl();
    }

    public int quantizeSubspaceForVector-ODtDxJY(@NotNull float[] v, int start) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int mahIndex = 0;
        float mah = Float.POSITIVE_INFINITY;
        int i = 0;
        Iterator<FloatVectorValue> iterator2 = this.centroids.iterator();
        block0: while (iterator2.hasNext()) {
            float[] c = iterator2.next().unbox-impl();
            float dist = 0.0f;
            int n = 0;
            int n2 = this.diffBuffer.length + -1;
            if (n <= n2) {
                do {
                    int it = n++;
                    this.diffBuffer[it] = c[it] - v[start + it];
                } while (n <= n2);
            }
            int j = 0;
            Iterator<FloatVectorValue> iterator3 = this.covMatrix.iterator();
            while (iterator3.hasNext()) {
                float[] m = iterator3.next().unbox-impl();
                int n3 = j;
                j = n3 + 1;
                dist = Math.fma(this.diffBuffer[n3], FloatVectorValue.dot-3fEAwC4(m, FloatVectorValue.box-impl(this.diffBuffer)), dist);
                if (!(dist >= mah)) continue;
                n3 = i;
                i = n3 + 1;
                continue block0;
            }
            if (dist < mah) {
                mah = dist;
                mahIndex = i;
            }
            int n4 = i;
            i = n4 + 1;
        }
        return mahIndex;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/database/index/pq/codebook/SinglePrecisionPQCodebook$Serializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/database/index/pq/codebook/SinglePrecisionPQCodebook;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "isTrusted", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb"})
    public static final class Serializer
    implements org.mapdb.Serializer<SinglePrecisionPQCodebook> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull SinglePrecisionPQCodebook value) {
            float[] v;
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            out.packInt(value.getLogicalSize());
            MapDBSerializer<FloatVectorValue> vectorSerializer = FloatVectorValueSerializerFactory.INSTANCE.mapdb(value.getLogicalSize());
            out.packInt(value.getCentroids().size());
            Iterator<FloatVectorValue> iterator2 = value.getCentroids().iterator();
            while (iterator2.hasNext()) {
                v = iterator2.next().unbox-impl();
                vectorSerializer.serialize(out, FloatVectorValue.box-impl(v));
            }
            out.packInt(value.getCovMatrix().size());
            iterator2 = value.getCovMatrix().iterator();
            while (iterator2.hasNext()) {
                v = iterator2.next().unbox-impl();
                vectorSerializer.serialize(out, FloatVectorValue.box-impl(v));
            }
        }

        @NotNull
        public SinglePrecisionPQCodebook deserialize(@NotNull DataInput2 input, int available) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int logicalSize = input.unpackInt();
            MapDBSerializer<FloatVectorValue> vectorSerializer = FloatVectorValueSerializerFactory.INSTANCE.mapdb(logicalSize);
            int centroidsSize = input.unpackInt();
            ArrayList<Object> centroids = new ArrayList<Object>(centroidsSize);
            int n = 0;
            if (n < centroidsSize) {
                do {
                    int i = n++;
                    centroids.add(vectorSerializer.deserialize(input, available));
                } while (n < centroidsSize);
            }
            int covMatrixSize = input.unpackInt();
            ArrayList<Object> covMatrix = new ArrayList<Object>(covMatrixSize);
            int n2 = 0;
            if (n2 < covMatrixSize) {
                do {
                    int i = n2++;
                    covMatrix.add(vectorSerializer.deserialize(input, available));
                } while (n2 < covMatrixSize);
            }
            return new SinglePrecisionPQCodebook((List<FloatVectorValue>)centroids, (List<FloatVectorValue>)covMatrix);
        }

        public boolean isTrusted() {
            return true;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/database/index/pq/codebook/SinglePrecisionPQCodebook$Companion;", "", "()V", "learnFromData", "Lorg/vitrivr/cottontail/database/index/pq/codebook/SinglePrecisionPQCodebook;", "subspaceData", "", "Lorg/vitrivr/cottontail/model/values/FloatVectorValue;", "numCentroids", "", "seed", "", "maxIterations", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SinglePrecisionPQCodebook learnFromData(@NotNull List<FloatVectorValue> subspaceData, int numCentroids, long seed, int maxIterations) {
            void $this$mapTo$iv$iv;
            Object object;
            Object[] objectArray;
            int n;
            Intrinsics.checkNotNullParameter(subspaceData, (String)"subspaceData");
            int n2 = subspaceData.size();
            double[][] dArrayArray = new double[n2][];
            for (int i = 0; i < n2; ++i) {
                n = i;
                int n3 = 0;
                int n4 = subspaceData.get(n).unbox-impl().length;
                objectArray = new double[n4];
                int n5 = n;
                object = dArrayArray;
                while (n3 < n4) {
                    int n6 = n3++;
                    objectArray[n6] = subspaceData.get(n).unbox-impl()[n6];
                }
                object[n5] = objectArray;
            }
            double[][] array = dArrayArray;
            RealMatrix covMatrix = new Covariance((double[][])array, false).getCovarianceMatrix();
            Intrinsics.checkNotNullExpressionValue((Object)covMatrix, (String)"covMatrix");
            List<CentroidCluster<ClusterableWithIndex>> centroidClusters2 = PQCodebook.Companion.clusterRealData(array, covMatrix, numCentroids, seed, maxIterations);
            ArrayList<FloatVectorValue> centroids = new ArrayList<FloatVectorValue>(numCentroids);
            n = 0;
            if (n < numCentroids) {
                do {
                    int i = n++;
                    double[] dArray = centroidClusters2.get(i).getCenter().getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"centroidClusters[i].center.point");
                    centroids.add(FloatVectorValue.box-impl(FloatVectorValue.constructor-impl(dArray)));
                } while (n < numCentroids);
            }
            double[][] i = covMatrix.getData();
            Intrinsics.checkNotNullExpressionValue((Object)i, (String)"covMatrix.data");
            Object[] $this$map$iv = (Object[])i;
            boolean $i$f$map = false;
            objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                double[] dArray = (double[])item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                FloatVectorValue floatVectorValue = FloatVectorValue.box-impl(FloatVectorValue.constructor-impl((double[])it));
                object.add(floatVectorValue);
            }
            List dataCovMatrix = (List)destination$iv$iv;
            return new SinglePrecisionPQCodebook((List<FloatVectorValue>)centroids, dataCovMatrix);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

