/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.binding;

import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.queries.binding.Binding;
import org.vitrivr.cottontail.database.queries.binding.BindingContext;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0014\u0010\u0011\u001a\u00020\u000f2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u0003H\u0096\u0002J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0002J\u001a\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\n\u0012\u0006\u0012\u0004\u0018\u00010\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/database/queries/binding/DefaultBindingContext;", "Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "startSize", "", "(I)V", "boundRecord", "Lorg/vitrivr/cottontail/model/basics/Record;", "boundValues", "Ljava/util/ArrayList;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "Lkotlin/collections/ArrayList;", "bind", "Lorg/vitrivr/cottontail/database/queries/binding/Binding$Column;", "column", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "Lorg/vitrivr/cottontail/database/queries/binding/Binding$Literal;", "value", "bindNull", "type", "Lorg/vitrivr/cottontail/model/basics/Type;", "bindRecord", "", "record", "get", "bindingIndex", "binding", "Lorg/vitrivr/cottontail/database/queries/binding/Binding;", "update", "cottontaildb"})
public final class DefaultBindingContext
implements BindingContext {
    @NotNull
    private final ArrayList<Value> boundValues;
    @Nullable
    private Record boundRecord;

    public DefaultBindingContext(int startSize) {
        this.boundValues = new ArrayList(startSize);
    }

    public /* synthetic */ DefaultBindingContext(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        this(n);
    }

    @Override
    @Nullable
    public Value get(@NotNull Binding binding) {
        Value value;
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        boolean bl = Intrinsics.areEqual((Object)binding.getContext(), (Object)this);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The given binding " + binding + " has not been registered with this binding context.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Binding binding2 = binding;
        if (binding2 instanceof Binding.Column) {
            Record record = this.boundRecord;
            if (record == null) {
                throw new IllegalStateException("No record bound for column binding " + ((Binding.Column)binding).getColumn() + '.');
            }
            value = record.get(((Binding.Column)binding).getColumn());
        } else if (binding2 instanceof Binding.Literal) {
            value = this.get(((Binding.Literal)binding).getBindingIndex());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return value;
    }

    @Override
    @Nullable
    public Value get(int bindingIndex) {
        boolean bl = bindingIndex < this.boundValues.size();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Binding " + bindingIndex + " is not known to this binding context.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.boundValues.get(bindingIndex);
    }

    @Override
    @NotNull
    public Binding.Literal bind(@NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int bindingIndex = this.boundValues.size();
        boolean bl = this.boundValues.add(value);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Failed to add " + value + " to list of bound values for index " + bindingIndex + '.';
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return new Binding.Literal(bindingIndex, value.getType(), this);
    }

    @Override
    public void update(@NotNull Binding.Literal binding, @Nullable Value value) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        boolean bl = Intrinsics.areEqual((Object)binding.getContext(), (Object)this);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The given binding " + binding + " has not been registered with this binding context.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.boundValues.set(binding.getBindingIndex(), value);
    }

    @Override
    @NotNull
    public Binding.Literal bindNull(@NotNull Type<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        int bindingIndex = this.boundValues.size();
        boolean bl = this.boundValues.add(null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Failed to add null to list of bound values for index " + bindingIndex + '.';
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return new Binding.Literal(bindingIndex, type, this);
    }

    @Override
    @NotNull
    public Binding.Column bind(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return new Binding.Column(column, this);
    }

    @Override
    public void bindRecord(@NotNull Record record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        this.boundRecord = record;
    }

    public DefaultBindingContext() {
        this(0, 1, null);
    }
}

