/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.queries.predicates.knn;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.queries.binding.Binding;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.functions.math.distance.basics.VectorDistance;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.utilities.math.KnnUtilities;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0010\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\r\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\r\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J9\u0010!\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\f\b\u0002\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\b\u0010\"\u001a\u00020#H\u0016J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0002J\b\u0010(\u001a\u00020\u0005H\u0016J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0015\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006+"}, d2={"Lorg/vitrivr/cottontail/database/queries/predicates/knn/KnnPredicate;", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "column", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "k", "", "distance", "Lorg/vitrivr/cottontail/functions/math/distance/basics/VectorDistance$Binary;", "query", "Lorg/vitrivr/cottontail/database/queries/binding/Binding;", "(Lorg/vitrivr/cottontail/database/column/ColumnDef;ILorg/vitrivr/cottontail/functions/math/distance/basics/VectorDistance$Binary;Lorg/vitrivr/cottontail/database/queries/binding/Binding;)V", "atomicCpuCost", "", "getAtomicCpuCost", "()F", "getColumn", "()Lorg/vitrivr/cottontail/database/column/ColumnDef;", "columns", "", "getColumns", "()Ljava/util/Set;", "getDistance", "()Lorg/vitrivr/cottontail/functions/math/distance/basics/VectorDistance$Binary;", "getK", "()I", "produces", "getProduces", "getQuery", "()Lorg/vitrivr/cottontail/database/queries/binding/Binding;", "component1", "component2", "component3", "component4", "copy", "digest", "", "equals", "", "other", "", "hashCode", "toString", "", "cottontaildb"})
public final class KnnPredicate
implements Predicate {
    @NotNull
    private final ColumnDef<?> column;
    private final int k;
    @NotNull
    private final VectorDistance.Binary<?> distance;
    @NotNull
    private final Binding query;

    public KnnPredicate(@NotNull ColumnDef<?> column, int k, @NotNull VectorDistance.Binary<?> distance, @NotNull Binding query2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        this.column = column;
        this.k = k;
        this.distance = distance;
        this.query = query2;
        boolean bl = this.k >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            Unit unit = Unit.INSTANCE;
            throw (Throwable)new IllegalStateException(unit.toString());
        }
        if (this.k <= 0) {
            throw new QueryException.QuerySyntaxException("The value of k for a kNN query cannot be smaller than one (is " + this.k + ")s!");
        }
    }

    @NotNull
    public final ColumnDef<?> getColumn() {
        return this.column;
    }

    public final int getK() {
        return this.k;
    }

    @NotNull
    public final VectorDistance.Binary<?> getDistance() {
        return this.distance;
    }

    @NotNull
    public final Binding getQuery() {
        return this.query;
    }

    @Override
    @NotNull
    public Set<ColumnDef<?>> getColumns() {
        return SetsKt.setOf(this.column);
    }

    @NotNull
    public final ColumnDef<?> getProduces() {
        return KnnUtilities.INSTANCE.distanceColumnDef(this.column.getName().entity());
    }

    @Override
    public float getAtomicCpuCost() {
        return this.distance.getCost();
    }

    @Override
    public long digest() {
        long result = this.getClass().hashCode();
        result = 31L * result + (long)this.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.queries.predicates.knn.KnnPredicate");
        }
        KnnPredicate cfr_ignored_0 = (KnnPredicate)other;
        if (!Intrinsics.areEqual(this.column, ((KnnPredicate)other).column)) {
            return false;
        }
        if (this.k != ((KnnPredicate)other).k) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.query, (Object)((KnnPredicate)other).query)) {
            return false;
        }
        return Intrinsics.areEqual(this.distance, ((KnnPredicate)other).distance);
    }

    public int hashCode() {
        int result = this.column.hashCode();
        result = 31 * result + this.k;
        result = 31 * result + this.query.hashCode();
        result = 31 * result + this.distance.hashCode();
        return result;
    }

    @NotNull
    public final ColumnDef<?> component1() {
        return this.column;
    }

    public final int component2() {
        return this.k;
    }

    @NotNull
    public final VectorDistance.Binary<?> component3() {
        return this.distance;
    }

    @NotNull
    public final Binding component4() {
        return this.query;
    }

    @NotNull
    public final KnnPredicate copy(@NotNull ColumnDef<?> column, int k, @NotNull VectorDistance.Binary<?> distance, @NotNull Binding query2) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        return new KnnPredicate(column, k, distance, query2);
    }

    public static /* synthetic */ KnnPredicate copy$default(KnnPredicate knnPredicate, ColumnDef columnDef, int n, VectorDistance.Binary binary, Binding binding, int n2, Object object) {
        if ((n2 & 1) != 0) {
            columnDef = knnPredicate.column;
        }
        if ((n2 & 2) != 0) {
            n = knnPredicate.k;
        }
        if ((n2 & 4) != 0) {
            binary = knnPredicate.distance;
        }
        if ((n2 & 8) != 0) {
            binding = knnPredicate.query;
        }
        return knnPredicate.copy(columnDef, n, binary, binding);
    }

    @NotNull
    public String toString() {
        return "KnnPredicate(column=" + this.column + ", k=" + this.k + ", distance=" + this.distance + ", query=" + this.query + ')';
    }
}

