/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.execution.operators.basics;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.queries.binding.BindingContext;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.execution.exceptions.OperatorSetupException;
import org.vitrivr.cottontail.model.basics.Record;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00060\rj\u0002`\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0004\u001a\u001b\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/execution/operators/basics/Operator;", "", "()V", "binding", "Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "getBinding", "()Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumns", "()Ljava/util/List;", "groupId", "", "Lorg/vitrivr/cottontail/database/queries/GroupId;", "getGroupId", "()I", "toFlow", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/model/basics/Record;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "MergingPipelineOperator", "PipelineOperator", "SinkOperator", "SourceOperator", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator$PipelineOperator;", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator$MergingPipelineOperator;", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator$SinkOperator;", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator$SourceOperator;", "cottontaildb"})
public abstract class Operator {
    private Operator() {
    }

    public abstract int getGroupId();

    @NotNull
    public abstract List<ColumnDef<?>> getColumns();

    @NotNull
    public abstract BindingContext getBinding();

    @NotNull
    public abstract Flow<Record> toFlow(@NotNull TransactionContext var1);

    public /* synthetic */ Operator(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00060\rj\u0002`\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/execution/operators/basics/Operator$PipelineOperator;", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator;", "parent", "(Lorg/vitrivr/cottontail/execution/operators/basics/Operator;)V", "binding", "Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "getBinding", "()Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "breaker", "", "getBreaker", "()Z", "groupId", "", "Lorg/vitrivr/cottontail/database/queries/GroupId;", "getGroupId", "()I", "getParent", "()Lorg/vitrivr/cottontail/execution/operators/basics/Operator;", "cottontaildb"})
    public static abstract class PipelineOperator
    extends Operator {
        @NotNull
        private final Operator parent;

        public PipelineOperator(@NotNull Operator parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(null);
            this.parent = parent;
        }

        @NotNull
        public final Operator getParent() {
            return this.parent;
        }

        public abstract boolean getBreaker();

        @Override
        public int getGroupId() {
            return this.parent.getGroupId();
        }

        @Override
        @NotNull
        public BindingContext getBinding() {
            return this.parent.getBinding();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00060\u000ej\u0002`\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/execution/operators/basics/Operator$MergingPipelineOperator;", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator;", "parents", "", "(Ljava/util/List;)V", "binding", "Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "getBinding", "()Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "breaker", "", "getBreaker", "()Z", "groupId", "", "Lorg/vitrivr/cottontail/database/queries/GroupId;", "getGroupId", "()I", "getParents", "()Ljava/util/List;", "cottontaildb"})
    public static abstract class MergingPipelineOperator
    extends Operator {
        @NotNull
        private final List<Operator> parents;

        public MergingPipelineOperator(@NotNull List<? extends Operator> parents) {
            Intrinsics.checkNotNullParameter(parents, (String)"parents");
            super(null);
            this.parents = parents;
            if (this.parents.size() <= 1) {
                throw new OperatorSetupException(this, "The use of an MergingPipelineOperator requires at least two inputs.");
            }
        }

        @NotNull
        public final List<Operator> getParents() {
            return this.parents;
        }

        public abstract boolean getBreaker();

        @Override
        public int getGroupId() {
            return this.parents.get(0).getGroupId();
        }

        @Override
        @NotNull
        public BindingContext getBinding() {
            return this.parents.get(0).getBinding();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00060\u000ej\u0002`\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/execution/operators/basics/Operator$SinkOperator;", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator;", "parent", "(Lorg/vitrivr/cottontail/execution/operators/basics/Operator;)V", "binding", "Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "getBinding", "()Lorg/vitrivr/cottontail/database/queries/binding/BindingContext;", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumns", "()Ljava/util/List;", "groupId", "", "Lorg/vitrivr/cottontail/database/queries/GroupId;", "getGroupId", "()I", "getParent", "()Lorg/vitrivr/cottontail/execution/operators/basics/Operator;", "cottontaildb"})
    public static abstract class SinkOperator
    extends Operator {
        @NotNull
        private final Operator parent;
        @NotNull
        private final List<ColumnDef<?>> columns;

        public SinkOperator(@NotNull Operator parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(null);
            this.parent = parent;
            this.columns = CollectionsKt.emptyList();
        }

        @NotNull
        public final Operator getParent() {
            return this.parent;
        }

        @Override
        @NotNull
        public final List<ColumnDef<?>> getColumns() {
            return this.columns;
        }

        @Override
        public int getGroupId() {
            return this.parent.getGroupId();
        }

        @Override
        @NotNull
        public BindingContext getBinding() {
            return this.parent.getBinding();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0013\u0012\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005R\u0018\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/execution/operators/basics/Operator$SourceOperator;", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator;", "groupId", "", "Lorg/vitrivr/cottontail/database/queries/GroupId;", "(I)V", "getGroupId", "()I", "cottontaildb"})
    public static abstract class SourceOperator
    extends Operator {
        private final int groupId;

        public SourceOperator(int groupId) {
            super(null);
            this.groupId = groupId;
        }

        public /* synthetic */ SourceOperator(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            this(n);
        }

        @Override
        public int getGroupId() {
            return this.groupId;
        }

        public SourceOperator() {
            this(0, 1, null);
        }
    }
}

