/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.functions.math.distance.other;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.functions.basics.AbstractFunctionGenerator;
import org.vitrivr.cottontail.functions.basics.Argument;
import org.vitrivr.cottontail.functions.basics.Function;
import org.vitrivr.cottontail.functions.basics.Signature;
import org.vitrivr.cottontail.functions.exception.FunctionNotSupportedException;
import org.vitrivr.cottontail.functions.math.distance.basics.VectorDistance;
import org.vitrivr.cottontail.functions.math.distance.binary.ChisquaredDistance;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.DoubleVectorValue;
import org.vitrivr.cottontail.model.values.FloatValue;
import org.vitrivr.cottontail.model.values.FloatVectorValue;
import org.vitrivr.cottontail.model.values.IntValue;
import org.vitrivr.cottontail.model.values.IntVectorValue;
import org.vitrivr.cottontail.model.values.LongValue;
import org.vitrivr.cottontail.model.values.LongVectorValue;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.model.values.types.VectorValue;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0005\u0016\u0017\u0018\u0019\u001aB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00028\u0000X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u0082\u0001\u0004\u001b\u001c\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lorg/vitrivr/cottontail/functions/math/distance/other/HyperplaneDistance;", "T", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "Lorg/vitrivr/cottontail/functions/math/distance/basics/VectorDistance;", "()V", "cost", "", "getCost", "()F", "name", "Lorg/vitrivr/cottontail/model/basics/Name$FunctionName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$FunctionName;", "query", "getQuery", "()Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "setQuery", "(Lorg/vitrivr/cottontail/model/values/types/VectorValue;)V", "statefulArguments", "", "getStatefulArguments", "()[I", "DoubleVector", "FloatVector", "Generator", "IntVector", "LongVector", "Lorg/vitrivr/cottontail/functions/math/distance/other/HyperplaneDistance$DoubleVector;", "Lorg/vitrivr/cottontail/functions/math/distance/other/HyperplaneDistance$FloatVector;", "Lorg/vitrivr/cottontail/functions/math/distance/other/HyperplaneDistance$LongVector;", "Lorg/vitrivr/cottontail/functions/math/distance/other/HyperplaneDistance$IntVector;", "cottontaildb"})
public abstract class HyperplaneDistance<T extends VectorValue<?>>
implements VectorDistance<T> {
    @NotNull
    private final Name.FunctionName name = Generator.INSTANCE.getFUNCTION_NAME();

    private HyperplaneDistance() {
    }

    @NotNull
    public abstract T getQuery();

    public abstract void setQuery(@NotNull T var1);

    @Override
    @NotNull
    public Name.FunctionName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public int[] getStatefulArguments() {
        int[] nArray = new int[]{1, 2};
        return nArray;
    }

    @Override
    public float getCost() {
        return (float)this.getD() * (3.0f * Cost.Companion.getCOST_FLOP() + 2.0f * Cost.Companion.getCOST_MEMORY_ACCESS()) + Cost.Companion.getCOST_FLOP();
    }

    @Override
    public int getD() {
        return VectorDistance.DefaultImpls.getD(this);
    }

    @Override
    public boolean getExecutable() {
        return VectorDistance.DefaultImpls.getExecutable(this);
    }

    public /* synthetic */ HyperplaneDistance(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0014\u00f8\u0001\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\t8VX\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/functions/math/distance/other/HyperplaneDistance$Generator;", "Lorg/vitrivr/cottontail/functions/basics/AbstractFunctionGenerator;", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "()V", "FUNCTION_NAME", "Lorg/vitrivr/cottontail/model/basics/Name$FunctionName;", "getFUNCTION_NAME", "()Lorg/vitrivr/cottontail/model/basics/Name$FunctionName;", "signature", "Lorg/vitrivr/cottontail/functions/basics/Signature$Open;", "getSignature", "()Lorg/vitrivr/cottontail/functions/basics/Signature$Open;", "generateInternal", "Lorg/vitrivr/cottontail/functions/basics/Function;", "dst", "Lorg/vitrivr/cottontail/functions/basics/Signature$Closed;", "cottontaildb"})
    public static final class Generator
    extends AbstractFunctionGenerator<DoubleValue> {
        @NotNull
        public static final Generator INSTANCE = new Generator();
        @NotNull
        private static final Name.FunctionName FUNCTION_NAME;

        private Generator() {
        }

        @NotNull
        public final Name.FunctionName getFUNCTION_NAME() {
            return FUNCTION_NAME;
        }

        @Override
        @NotNull
        public Signature.Open<? extends DoubleValue> getSignature() {
            Argument[] argumentArray = new Argument[]{Argument.Vector.INSTANCE, Argument.Vector.INSTANCE, Argument.Numeric.INSTANCE};
            return new Signature.Open(ChisquaredDistance.Generator.INSTANCE.getFUNCTION_NAME(), argumentArray, Type.Double.INSTANCE);
        }

        @Override
        @NotNull
        protected Function<DoubleValue> generateInternal(@NotNull Signature.Closed<?> dst) {
            Function function;
            Intrinsics.checkNotNullParameter(dst, (String)"dst");
            Type<?> type = dst.getArguments()[0].getType();
            if (type instanceof Type.DoubleVector) {
                function = new DoubleVector(type.getLogicalSize());
            } else if (type instanceof Type.FloatVector) {
                function = new FloatVector(type.getLogicalSize());
            } else if (type instanceof Type.LongVector) {
                function = new LongVector(type.getLogicalSize());
            } else if (type instanceof Type.IntVector) {
                function = new IntVector(type.getLogicalSize());
            } else {
                throw new FunctionNotSupportedException("Function generator signature " + this.getSignature() + " does not support destination signature (dst = " + dst + ").");
            }
            return function;
        }

        static {
            String[] stringArray = new String[]{"hyperplane"};
            FUNCTION_NAME = new Name.FunctionName(stringArray);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J1\u0010\u001e\u001a\u00020\u00072\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010!0 \"\u0004\u0018\u00010!H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\"\u0010#J%\u0010$\u001a\u00020%2\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010!0 \"\u0004\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010&R)\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010\u000e\u001a\u00020\u0002X\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001f\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00158VX\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006'"}, d2={"Lorg/vitrivr/cottontail/functions/math/distance/other/HyperplaneDistance$DoubleVector;", "Lorg/vitrivr/cottontail/functions/math/distance/other/HyperplaneDistance;", "Lorg/vitrivr/cottontail/model/values/DoubleVectorValue;", "size", "", "(I)V", "<set-?>", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "bias", "getBias-Z2rTJmk", "()D", "D", "cachedNormSqrt", "", "query", "getQuery-Jz4_OW8", "()[D", "setQuery-SrTAqT8", "([D)V", "[D", "signature", "Lorg/vitrivr/cottontail/functions/basics/Signature$Closed;", "getSignature", "()Lorg/vitrivr/cottontail/functions/basics/Signature$Closed;", "type", "Lorg/vitrivr/cottontail/model/basics/Type$DoubleVector;", "getType", "()Lorg/vitrivr/cottontail/model/basics/Type$DoubleVector;", "copy", "d", "invoke", "arguments", "", "Lorg/vitrivr/cottontail/model/values/types/Value;", "invoke-He8yXgM", "([Lorg/vitrivr/cottontail/model/values/types/Value;)D", "prepare", "", "([Lorg/vitrivr/cottontail/model/values/types/Value;)V", "cottontaildb"})
    public static final class DoubleVector
    extends HyperplaneDistance<DoubleVectorValue> {
        @NotNull
        private final Type.DoubleVector type;
        @NotNull
        private double[] query;
        private double bias;
        private double cachedNormSqrt;

        public DoubleVector(int size) {
            super(null);
            this.type = new Type.DoubleVector(size);
            this.query = this.getType().defaultValue-Jz4_OW8();
            this.bias = DoubleValue.Companion.getZERO-Z2rTJmk();
        }

        @NotNull
        public Type.DoubleVector getType() {
            return this.type;
        }

        @NotNull
        public double[] getQuery-Jz4_OW8() {
            return this.query;
        }

        public void setQuery-SrTAqT8(@NotNull double[] dArray) {
            Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
            this.query = dArray;
        }

        public final double getBias-Z2rTJmk() {
            return this.bias;
        }

        @NotNull
        public DoubleVector copy(int d) {
            return new DoubleVector(d);
        }

        @Override
        @NotNull
        public Signature.Closed<? extends DoubleValue> getSignature() {
            Argument.Typed[] typedArray = new Argument.Typed[]{new Argument.Typed(this.getType()), new Argument.Typed(this.getType()), new Argument.Typed(Type.Double.INSTANCE)};
            return new Signature.Closed(this.getName(), typedArray, Type.Double.INSTANCE);
        }

        public double invoke-He8yXgM(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.DoubleVectorValue");
            }
            double[] probing = ((DoubleVectorValue)value).unbox-impl();
            double dotp = 0.0;
            int n = 0;
            int n2 = DoubleVectorValue.getLogicalSize-impl(probing);
            if (n < n2) {
                do {
                    int i = n++;
                    dotp += probing[i] * this.getQuery-Jz4_OW8()[i];
                } while (n < n2);
            }
            double d = this.cachedNormSqrt;
            boolean bl = false;
            return DoubleValue.constructor-impl(dotp + this.getBias-Z2rTJmk() / Math.sqrt(d));
        }

        @Override
        public void prepare(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            boolean bl = Intrinsics.areEqual(value == null ? null : value.getType(), (Object)this.getType());
            boolean bl2 = false;
            int n = 0;
            if (!bl) {
                Value value2;
                boolean bl3 = false;
                String string = "Value of type " + ((value2 = arguments[0]) == null ? null : value2.getType()) + " cannot be applied as argument for " + this.getSignature() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value value3 = arguments[1];
            boolean bl4 = Intrinsics.areEqual(value3 == null ? null : value3.getType(), (Object)Type.Double.INSTANCE);
            bl2 = false;
            n = 0;
            if (!bl4) {
                Value value4;
                boolean bl5 = false;
                String string = "Value of type " + ((value4 = arguments[0]) == null ? null : value4.getType()) + " cannot be applied as argument for " + this.getSignature() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value value5 = arguments[0];
            if (value5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.DoubleVectorValue");
            }
            this.setQuery-SrTAqT8(((DoubleVectorValue)value5).unbox-impl());
            value5 = arguments[1];
            if (value5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.DoubleValue");
            }
            this.bias = ((DoubleValue)value5).unbox-impl();
            double norm = 0.0;
            n = 0;
            int n2 = DoubleVectorValue.getLogicalSize-impl(this.getQuery-Jz4_OW8());
            if (n < n2) {
                do {
                    int i = n++;
                    norm += this.getQuery-Jz4_OW8()[i] * this.getQuery-Jz4_OW8()[i];
                } while (n < n2);
            }
            n = 0;
            this.cachedNormSqrt = Math.sqrt(norm);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J1\u0010\u001f\u001a\u00020\u00162\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\"0!\"\u0004\u0018\u00010\"H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b#\u0010$J%\u0010%\u001a\u00020&2\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\"0!\"\u0004\u0018\u00010\"H\u0016\u00a2\u0006\u0002\u0010'R)\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010\u000e\u001a\u00020\u0002X\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001f\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00158VX\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006("}, d2={"Lorg/vitrivr/cottontail/functions/math/distance/other/HyperplaneDistance$FloatVector;", "Lorg/vitrivr/cottontail/functions/math/distance/other/HyperplaneDistance;", "Lorg/vitrivr/cottontail/model/values/FloatVectorValue;", "size", "", "(I)V", "<set-?>", "Lorg/vitrivr/cottontail/model/values/FloatValue;", "bias", "getBias-JbzPQW8", "()F", "F", "cachedNormSqrt", "", "query", "getQuery-3wzOJwo", "()[F", "setQuery-jre6TT8", "([F)V", "[F", "signature", "Lorg/vitrivr/cottontail/functions/basics/Signature$Closed;", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "getSignature", "()Lorg/vitrivr/cottontail/functions/basics/Signature$Closed;", "type", "Lorg/vitrivr/cottontail/model/basics/Type$FloatVector;", "getType", "()Lorg/vitrivr/cottontail/model/basics/Type$FloatVector;", "copy", "d", "invoke", "arguments", "", "Lorg/vitrivr/cottontail/model/values/types/Value;", "invoke-He8yXgM", "([Lorg/vitrivr/cottontail/model/values/types/Value;)D", "prepare", "", "([Lorg/vitrivr/cottontail/model/values/types/Value;)V", "cottontaildb"})
    public static final class FloatVector
    extends HyperplaneDistance<FloatVectorValue> {
        @NotNull
        private final Type.FloatVector type;
        @NotNull
        private float[] query;
        private float bias;
        private float cachedNormSqrt;

        public FloatVector(int size) {
            super(null);
            this.type = new Type.FloatVector(size);
            this.query = this.getType().defaultValue-3wzOJwo();
            this.bias = FloatValue.Companion.getZERO-JbzPQW8();
        }

        @NotNull
        public Type.FloatVector getType() {
            return this.type;
        }

        @NotNull
        public float[] getQuery-3wzOJwo() {
            return this.query;
        }

        public void setQuery-jre6TT8(@NotNull float[] fArray) {
            Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
            this.query = fArray;
        }

        public final float getBias-JbzPQW8() {
            return this.bias;
        }

        @NotNull
        public FloatVector copy(int d) {
            return new FloatVector(d);
        }

        @Override
        @NotNull
        public Signature.Closed<? extends DoubleValue> getSignature() {
            Argument.Typed[] typedArray = new Argument.Typed[]{new Argument.Typed(this.getType()), new Argument.Typed(this.getType()), new Argument.Typed(Type.Float.INSTANCE)};
            return new Signature.Closed(this.getName(), typedArray, Type.Double.INSTANCE);
        }

        public double invoke-He8yXgM(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.FloatVectorValue");
            }
            float[] probing = ((FloatVectorValue)value).unbox-impl();
            double dotp = 0.0;
            int n = 0;
            int n2 = FloatVectorValue.getLogicalSize-impl(probing);
            if (n < n2) {
                do {
                    int i = n++;
                    dotp += (double)(probing[i] * this.getQuery-3wzOJwo()[i]);
                } while (n < n2);
            }
            return DoubleValue.constructor-impl(dotp + (double)(this.getBias-JbzPQW8() / this.cachedNormSqrt));
        }

        @Override
        public void prepare(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            boolean bl = Intrinsics.areEqual(value == null ? null : value.getType(), (Object)this.getType());
            int n = 0;
            int n2 = 0;
            if (!bl) {
                Value value2;
                boolean bl2 = false;
                String string = "Value of type " + ((value2 = arguments[0]) == null ? null : value2.getType()) + " cannot be applied as argument for " + this.getSignature() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value value3 = arguments[1];
            boolean bl3 = Intrinsics.areEqual(value3 == null ? null : value3.getType(), (Object)Type.Double.INSTANCE);
            n = 0;
            n2 = 0;
            if (!bl3) {
                Value value4;
                boolean bl4 = false;
                String string = "Value of type " + ((value4 = arguments[0]) == null ? null : value4.getType()) + " cannot be applied as argument for " + this.getSignature() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value value5 = arguments[0];
            if (value5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.FloatVectorValue");
            }
            this.setQuery-jre6TT8(((FloatVectorValue)value5).unbox-impl());
            value5 = arguments[1];
            if (value5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.FloatValue");
            }
            this.bias = ((FloatValue)value5).unbox-impl();
            float norm = 0.0f;
            n = 0;
            n2 = FloatVectorValue.getLogicalSize-impl(this.getQuery-3wzOJwo());
            if (n < n2) {
                do {
                    int i = n++;
                    norm += this.getQuery-3wzOJwo()[i] * this.getQuery-3wzOJwo()[i];
                } while (n < n2);
            }
            n = 0;
            this.cachedNormSqrt = (float)Math.sqrt(norm);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J1\u0010\u001f\u001a\u00020\u00162\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\"0!\"\u0004\u0018\u00010\"H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b#\u0010$J%\u0010%\u001a\u00020&2\u0016\u0010 \u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\"0!\"\u0004\u0018\u00010\"H\u0016\u00a2\u0006\u0002\u0010'R)\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010\u000e\u001a\u00020\u0002X\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001f\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00158VX\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006("}, d2={"Lorg/vitrivr/cottontail/functions/math/distance/other/HyperplaneDistance$LongVector;", "Lorg/vitrivr/cottontail/functions/math/distance/other/HyperplaneDistance;", "Lorg/vitrivr/cottontail/model/values/LongVectorValue;", "size", "", "(I)V", "<set-?>", "Lorg/vitrivr/cottontail/model/values/LongValue;", "bias", "getBias-LWoHqF4", "()J", "J", "cachedNormSqrt", "", "query", "getQuery-8fdD9LQ", "()[J", "setQuery-1cZuvkg", "([J)V", "[J", "signature", "Lorg/vitrivr/cottontail/functions/basics/Signature$Closed;", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "getSignature", "()Lorg/vitrivr/cottontail/functions/basics/Signature$Closed;", "type", "Lorg/vitrivr/cottontail/model/basics/Type$LongVector;", "getType", "()Lorg/vitrivr/cottontail/model/basics/Type$LongVector;", "copy", "d", "invoke", "arguments", "", "Lorg/vitrivr/cottontail/model/values/types/Value;", "invoke-He8yXgM", "([Lorg/vitrivr/cottontail/model/values/types/Value;)D", "prepare", "", "([Lorg/vitrivr/cottontail/model/values/types/Value;)V", "cottontaildb"})
    public static final class LongVector
    extends HyperplaneDistance<LongVectorValue> {
        @NotNull
        private final Type.LongVector type;
        @NotNull
        private long[] query;
        private long bias;
        private long cachedNormSqrt;

        public LongVector(int size) {
            super(null);
            this.type = new Type.LongVector(size);
            this.query = this.getType().defaultValue-8fdD9LQ();
            this.bias = LongValue.Companion.getZERO-LWoHqF4();
        }

        @NotNull
        public Type.LongVector getType() {
            return this.type;
        }

        @NotNull
        public long[] getQuery-8fdD9LQ() {
            return this.query;
        }

        public void setQuery-1cZuvkg(@NotNull long[] lArray) {
            Intrinsics.checkNotNullParameter((Object)lArray, (String)"<set-?>");
            this.query = lArray;
        }

        public final long getBias-LWoHqF4() {
            return this.bias;
        }

        @NotNull
        public LongVector copy(int d) {
            return new LongVector(d);
        }

        @Override
        @NotNull
        public Signature.Closed<? extends DoubleValue> getSignature() {
            Argument.Typed[] typedArray = new Argument.Typed[]{new Argument.Typed(this.getType()), new Argument.Typed(this.getType()), new Argument.Typed(Type.Long.INSTANCE)};
            return new Signature.Closed(this.getName(), typedArray, Type.Double.INSTANCE);
        }

        public double invoke-He8yXgM(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.LongVectorValue");
            }
            long[] probing = ((LongVectorValue)value).unbox-impl();
            double dotp = 0.0;
            int n = 0;
            int n2 = LongVectorValue.getLogicalSize-impl(probing);
            if (n < n2) {
                do {
                    int i = n++;
                    dotp += (double)(probing[i] * this.getQuery-8fdD9LQ()[i]);
                } while (n < n2);
            }
            return DoubleValue.constructor-impl(dotp + (double)(this.getBias-LWoHqF4() / this.cachedNormSqrt));
        }

        @Override
        public void prepare(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            boolean bl = Intrinsics.areEqual(value == null ? null : value.getType(), (Object)this.getType());
            boolean bl2 = false;
            int n = 0;
            if (!bl) {
                Value value2;
                boolean bl3 = false;
                String string = "Value of type " + ((value2 = arguments[0]) == null ? null : value2.getType()) + " cannot be applied as argument for " + this.getSignature() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value value3 = arguments[1];
            boolean bl4 = Intrinsics.areEqual(value3 == null ? null : value3.getType(), (Object)Type.Double.INSTANCE);
            bl2 = false;
            n = 0;
            if (!bl4) {
                Value value4;
                boolean bl5 = false;
                String string = "Value of type " + ((value4 = arguments[0]) == null ? null : value4.getType()) + " cannot be applied as argument for " + this.getSignature() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value value5 = arguments[0];
            if (value5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.LongVectorValue");
            }
            this.setQuery-1cZuvkg(((LongVectorValue)value5).unbox-impl());
            value5 = arguments[1];
            if (value5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.LongValue");
            }
            this.bias = ((LongValue)value5).unbox-impl();
            double norm = 0.0;
            n = 0;
            int n2 = LongVectorValue.getLogicalSize-impl(this.getQuery-8fdD9LQ());
            if (n < n2) {
                do {
                    int i = n++;
                    norm += (double)(this.getQuery-8fdD9LQ()[i] * this.getQuery-8fdD9LQ()[i]);
                } while (n < n2);
            }
            n = 0;
            this.cachedNormSqrt = (long)Math.sqrt(norm);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J1\u0010\u001e\u001a\u00020\u00152\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010!0 \"\u0004\u0018\u00010!H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\"\u0010#J%\u0010$\u001a\u00020%2\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010!0 \"\u0004\u0018\u00010!H\u0016\u00a2\u0006\u0002\u0010&R)\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010\r\u001a\u00020\u0002X\u0096\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001f\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00148VX\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006'"}, d2={"Lorg/vitrivr/cottontail/functions/math/distance/other/HyperplaneDistance$IntVector;", "Lorg/vitrivr/cottontail/functions/math/distance/other/HyperplaneDistance;", "Lorg/vitrivr/cottontail/model/values/IntVectorValue;", "size", "", "(I)V", "<set-?>", "Lorg/vitrivr/cottontail/model/values/IntValue;", "bias", "getBias-HuW2oqM", "()I", "I", "cachedNormSqrt", "query", "getQuery-bSjjh_E", "()[I", "setQuery-SN65Eng", "([I)V", "[I", "signature", "Lorg/vitrivr/cottontail/functions/basics/Signature$Closed;", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "getSignature", "()Lorg/vitrivr/cottontail/functions/basics/Signature$Closed;", "type", "Lorg/vitrivr/cottontail/model/basics/Type$IntVector;", "getType", "()Lorg/vitrivr/cottontail/model/basics/Type$IntVector;", "copy", "d", "invoke", "arguments", "", "Lorg/vitrivr/cottontail/model/values/types/Value;", "invoke-He8yXgM", "([Lorg/vitrivr/cottontail/model/values/types/Value;)D", "prepare", "", "([Lorg/vitrivr/cottontail/model/values/types/Value;)V", "cottontaildb"})
    public static final class IntVector
    extends HyperplaneDistance<IntVectorValue> {
        @NotNull
        private final Type.IntVector type;
        @NotNull
        private int[] query;
        private int bias;
        private int cachedNormSqrt;

        public IntVector(int size) {
            super(null);
            this.type = new Type.IntVector(size);
            this.query = this.getType().defaultValue-bSjjh_E();
            this.bias = IntValue.Companion.getZERO-HuW2oqM();
        }

        @NotNull
        public Type.IntVector getType() {
            return this.type;
        }

        @NotNull
        public int[] getQuery-bSjjh_E() {
            return this.query;
        }

        public void setQuery-SN65Eng(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.query = nArray;
        }

        public final int getBias-HuW2oqM() {
            return this.bias;
        }

        @NotNull
        public IntVector copy(int d) {
            return new IntVector(d);
        }

        @Override
        @NotNull
        public Signature.Closed<? extends DoubleValue> getSignature() {
            Argument.Typed[] typedArray = new Argument.Typed[]{new Argument.Typed(this.getType()), new Argument.Typed(this.getType()), new Argument.Typed(Type.Int.INSTANCE)};
            return new Signature.Closed(this.getName(), typedArray, Type.Double.INSTANCE);
        }

        public double invoke-He8yXgM(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.IntVectorValue");
            }
            int[] probing = ((IntVectorValue)value).unbox-impl();
            double dotp = 0.0;
            int n = 0;
            int n2 = IntVectorValue.getLogicalSize-impl(probing);
            if (n < n2) {
                do {
                    int i = n++;
                    dotp += (double)(probing[i] * this.getQuery-bSjjh_E()[i]);
                } while (n < n2);
            }
            return DoubleValue.constructor-impl(dotp + (double)(this.getBias-HuW2oqM() / this.cachedNormSqrt));
        }

        @Override
        public void prepare(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            boolean bl = Intrinsics.areEqual(value == null ? null : value.getType(), (Object)this.getType());
            int n = 0;
            int n2 = 0;
            if (!bl) {
                Value value2;
                boolean bl2 = false;
                String string = "Value of type " + ((value2 = arguments[0]) == null ? null : value2.getType()) + " cannot be applied as argument for " + this.getSignature() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value value3 = arguments[1];
            boolean bl3 = Intrinsics.areEqual(value3 == null ? null : value3.getType(), (Object)Type.Double.INSTANCE);
            n = 0;
            n2 = 0;
            if (!bl3) {
                Value value4;
                boolean bl4 = false;
                String string = "Value of type " + ((value4 = arguments[0]) == null ? null : value4.getType()) + " cannot be applied as argument for " + this.getSignature() + '.';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Value value5 = arguments[0];
            if (value5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.IntVectorValue");
            }
            this.setQuery-SN65Eng(((IntVectorValue)value5).unbox-impl());
            value5 = arguments[1];
            if (value5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.IntValue");
            }
            this.bias = ((IntValue)value5).unbox-impl();
            float norm = 0.0f;
            n = 0;
            n2 = IntVectorValue.getLogicalSize-impl(this.getQuery-bSjjh_E());
            if (n < n2) {
                do {
                    int i = n++;
                    norm += (float)(this.getQuery-bSjjh_E()[i] * this.getQuery-bSjjh_E()[i]);
                } while (n < n2);
            }
            n = 0;
            this.cachedNormSqrt = (int)Math.sqrt(norm);
        }
    }
}

