/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.values;

import java.util.SplittableRandom;
import kotlin.Metadata;
import kotlin.jvm.JvmInline;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.ByteValue;
import org.vitrivr.cottontail.model.values.Complex32Value;
import org.vitrivr.cottontail.model.values.Complex64Value;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.FloatValue;
import org.vitrivr.cottontail.model.values.LongValue;
import org.vitrivr.cottontail.model.values.ShortValue;
import org.vitrivr.cottontail.model.values.types.NumericValue;
import org.vitrivr.cottontail.model.values.types.RealValue;
import org.vitrivr.cottontail.model.values.types.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JvmInline
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0087@\u0018\u0000 j2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001jB\u0014\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0018\b\u0016\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0007\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0005\u0010\bB\u0012\u0012\u0006\u0010\t\u001a\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0005\u0010\nJ\u0018\u0010\u0018\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0019\u0010\nJ\u0018\u0010\u001a\u001a\u00020\u001bH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u001fH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b \u0010!J\u0018\u0010\"\u001a\u00020#H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b$\u0010%J\u0018\u0010&\u001a\u00020'H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b(\u0010)J\u0018\u0010*\u001a\u00020+H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b,\u0010-J\u0018\u0010.\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b/\u0010\nJ\u0018\u00100\u001a\u000201H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b2\u00103J\u0018\u00104\u001a\u000205H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b6\u00107J\u0018\u00108\u001a\u00020'H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b9\u0010)J\u0018\u0010:\u001a\u00020\u00022\u0006\u0010;\u001a\u00020<H\u0096\u0002\u00a2\u0006\u0004\b=\u0010>J\u0018\u0010?\u001a\u00020'H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b@\u0010)J%\u0010A\u001a\u00020\u00002\n\u0010;\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bB\u0010CJ\u001a\u0010D\u001a\u00020E2\b\u0010;\u001a\u0004\u0018\u00010FH\u00d6\u0003\u00a2\u0006\u0004\bG\u0010HJ\u0018\u0010I\u001a\u00020'H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bJ\u0010)J\u0010\u0010K\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\bL\u0010\nJ\u0017\u0010M\u001a\u00020E2\u0006\u0010;\u001a\u00020<H\u0016\u00a2\u0006\u0004\bN\u0010OJ\u0018\u0010P\u001a\u00020'H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bQ\u0010)J%\u0010R\u001a\u00020\u00002\n\u0010;\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bS\u0010CJ%\u0010T\u001a\u00020\u00002\n\u0010;\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bU\u0010CJ \u0010V\u001a\u00020'2\u0006\u0010W\u001a\u00020XH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bY\u0010ZJ \u0010V\u001a\u00020'2\u0006\u0010W\u001a\u00020\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bY\u0010[J\u0018\u0010\\\u001a\u00020'H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b]\u0010)J\u0018\u0010^\u001a\u00020'H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b_\u0010)J\u0018\u0010`\u001a\u00020'H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\ba\u0010)J%\u0010b\u001a\u00020\u00002\n\u0010;\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bc\u0010CJ\u0010\u0010d\u001a\u00020eH\u00d6\u0001\u00a2\u0006\u0004\bf\u0010gJ\u0019\u0010h\u001a\u00020\u0000H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bi\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0018\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\t\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u0088\u0001\t\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006k"}, d2={"Lorg/vitrivr/cottontail/model/values/IntValue;", "Lorg/vitrivr/cottontail/model/values/types/RealValue;", "", "number", "", "constructor-impl", "(Ljava/lang/Number;)I", "Lorg/vitrivr/cottontail/model/values/types/NumericValue;", "(Lorg/vitrivr/cottontail/model/values/types/NumericValue;)I", "value", "(I)I", "imaginary", "getImaginary-impl", "(I)Lorg/vitrivr/cottontail/model/values/types/RealValue;", "logicalSize", "getLogicalSize-impl", "real", "getReal-impl", "type", "Lorg/vitrivr/cottontail/model/basics/Type;", "getType-impl", "(I)Lorg/vitrivr/cottontail/model/basics/Type;", "getValue", "()Ljava/lang/Integer;", "abs", "abs-HuW2oqM", "asByte", "Lorg/vitrivr/cottontail/model/values/ByteValue;", "asByte-pCuLKj8", "(I)B", "asComplex32", "Lorg/vitrivr/cottontail/model/values/Complex32Value;", "asComplex32-WO0UQc4", "(I)[F", "asComplex64", "Lorg/vitrivr/cottontail/model/values/Complex64Value;", "asComplex64-IY5coek", "(I)[D", "asDouble", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "asDouble-Z2rTJmk", "(I)D", "asFloat", "Lorg/vitrivr/cottontail/model/values/FloatValue;", "asFloat-JbzPQW8", "(I)F", "asInt", "asInt-HuW2oqM", "asLong", "Lorg/vitrivr/cottontail/model/values/LongValue;", "asLong-LWoHqF4", "(I)J", "asShort", "Lorg/vitrivr/cottontail/model/values/ShortValue;", "asShort-0l6I1b0", "(I)S", "atan", "atan-Z2rTJmk", "compareTo", "other", "Lorg/vitrivr/cottontail/model/values/types/Value;", "compareTo-impl", "(ILorg/vitrivr/cottontail/model/values/types/Value;)I", "cos", "cos-Z2rTJmk", "div", "div-zhC_DqQ", "(ILorg/vitrivr/cottontail/model/values/types/NumericValue;)I", "equals", "", "", "equals-impl", "(ILjava/lang/Object;)Z", "exp", "exp-Z2rTJmk", "hashCode", "hashCode-impl", "isEqual", "isEqual-impl", "(ILorg/vitrivr/cottontail/model/values/types/Value;)Z", "ln", "ln-Z2rTJmk", "minus", "minus-zhC_DqQ", "plus", "plus-zhC_DqQ", "pow", "x", "", "pow-He8yXgM", "(ID)D", "(II)D", "sin", "sin-Z2rTJmk", "sqrt", "sqrt-Z2rTJmk", "tan", "tan-Z2rTJmk", "times", "times-zhC_DqQ", "toString", "", "toString-impl", "(I)Ljava/lang/String;", "unaryMinus", "unaryMinus-HuW2oqM", "Companion", "cottontaildb"})
public final class IntValue
implements RealValue<Integer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int value;
    private static final int ZERO = IntValue.constructor-impl(0);
    private static final int ONE = IntValue.constructor-impl(1);

    @Override
    @NotNull
    public Integer getValue() {
        return this.value;
    }

    public static int constructor-impl(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        int n = IntValue.constructor-impl(number.intValue());
        return n;
    }

    public static int constructor-impl(@NotNull NumericValue<?> number) {
        Intrinsics.checkNotNullParameter(number, (String)"number");
        int n = IntValue.constructor-impl(((Number)number.getValue()).intValue());
        return n;
    }

    public static int getLogicalSize-impl(int arg0) {
        return 1;
    }

    @Override
    public int getLogicalSize() {
        return IntValue.getLogicalSize-impl(this.value);
    }

    @NotNull
    public static Type<?> getType-impl(int arg0) {
        return Type.Int.INSTANCE;
    }

    @Override
    @NotNull
    public Type<?> getType() {
        return IntValue.getType-impl(this.value);
    }

    @NotNull
    public static RealValue<Integer> getReal-impl(int arg0) {
        return IntValue.box-impl(arg0);
    }

    @Override
    @NotNull
    public RealValue<Integer> getReal() {
        return IntValue.getReal-impl(this.value);
    }

    @NotNull
    public static RealValue<Integer> getImaginary-impl(int arg0) {
        return IntValue.box-impl(ZERO);
    }

    @Override
    @NotNull
    public RealValue<Integer> getImaginary() {
        return IntValue.getImaginary-impl(this.value);
    }

    public static int compareTo-impl(int arg0, @NotNull Value other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Value value = other;
        if (value instanceof ByteValue) {
            n = Intrinsics.compare((int)arg0, (int)((ByteValue)other).unbox-impl());
        } else if (value instanceof ShortValue) {
            n = Intrinsics.compare((int)arg0, (int)((ShortValue)other).unbox-impl());
        } else if (value instanceof IntValue) {
            n = Intrinsics.compare((int)arg0, (int)((IntValue)other).unbox-impl());
        } else if (value instanceof LongValue) {
            n = Intrinsics.compare((long)arg0, (long)((LongValue)other).unbox-impl());
        } else if (value instanceof DoubleValue) {
            n = Double.compare(arg0, ((DoubleValue)other).unbox-impl());
        } else if (value instanceof FloatValue) {
            n = Float.compare(arg0, ((FloatValue)other).unbox-impl());
        } else if (value instanceof Complex32Value) {
            n = Float.compare(arg0, ((Complex32Value)other).unbox-impl()[0]);
        } else if (value instanceof Complex64Value) {
            n = Double.compare(arg0, ((Complex64Value)other).unbox-impl()[0]);
        } else {
            throw new IllegalArgumentException("LongValues can only be compared to other numeric values.");
        }
        return n;
    }

    @Override
    public int compareTo(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return IntValue.compareTo-impl(this.value, other);
    }

    public static boolean isEqual-impl(int arg0, @NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other instanceof IntValue && ((IntValue)other).unbox-impl() == arg0;
    }

    @Override
    public boolean isEqual(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return IntValue.isEqual-impl(this.value, other);
    }

    public static double asDouble-Z2rTJmk(int arg0) {
        return DoubleValue.constructor-impl((double)arg0);
    }

    @Override
    public double asDouble-Z2rTJmk() {
        return IntValue.asDouble-Z2rTJmk(this.value);
    }

    public static float asFloat-JbzPQW8(int arg0) {
        return FloatValue.constructor-impl(arg0);
    }

    @Override
    public float asFloat-JbzPQW8() {
        return IntValue.asFloat-JbzPQW8(this.value);
    }

    public static int asInt-HuW2oqM(int arg0) {
        return arg0;
    }

    @Override
    public int asInt-HuW2oqM() {
        return IntValue.asInt-HuW2oqM(this.value);
    }

    public static long asLong-LWoHqF4(int arg0) {
        return LongValue.constructor-impl(arg0);
    }

    @Override
    public long asLong-LWoHqF4() {
        return IntValue.asLong-LWoHqF4(this.value);
    }

    public static short asShort-0l6I1b0(int arg0) {
        return ShortValue.constructor-impl((short)arg0);
    }

    @Override
    public short asShort-0l6I1b0() {
        return IntValue.asShort-0l6I1b0(this.value);
    }

    public static byte asByte-pCuLKj8(int arg0) {
        return ByteValue.constructor-impl((byte)arg0);
    }

    @Override
    public byte asByte-pCuLKj8() {
        return IntValue.asByte-pCuLKj8(this.value);
    }

    @NotNull
    public static float[] asComplex32-WO0UQc4(int arg0) {
        return Complex32Value.constructor-impl(FloatValue.box-impl(IntValue.asFloat-JbzPQW8(arg0)), FloatValue.box-impl(FloatValue.constructor-impl(0.0f)));
    }

    @Override
    @NotNull
    public float[] asComplex32-WO0UQc4() {
        return IntValue.asComplex32-WO0UQc4(this.value);
    }

    @NotNull
    public static double[] asComplex64-IY5coek(int arg0) {
        return Complex64Value.constructor-impl(DoubleValue.box-impl(IntValue.asDouble-Z2rTJmk(arg0)), DoubleValue.box-impl(DoubleValue.constructor-impl(0.0)));
    }

    @Override
    @NotNull
    public double[] asComplex64-IY5coek() {
        return IntValue.asComplex64-IY5coek(this.value);
    }

    public static int unaryMinus-HuW2oqM(int arg0) {
        return IntValue.constructor-impl(-arg0);
    }

    public int unaryMinus-HuW2oqM() {
        return IntValue.unaryMinus-HuW2oqM(this.value);
    }

    public static int plus-zhC_DqQ(int arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return IntValue.constructor-impl(arg0 + ((Number)other.getValue()).intValue());
    }

    public int plus-zhC_DqQ(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return IntValue.plus-zhC_DqQ(this.value, other);
    }

    public static int minus-zhC_DqQ(int arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return IntValue.constructor-impl(arg0 - ((Number)other.getValue()).intValue());
    }

    public int minus-zhC_DqQ(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return IntValue.minus-zhC_DqQ(this.value, other);
    }

    public static int times-zhC_DqQ(int arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return IntValue.constructor-impl(arg0 * ((Number)other.getValue()).intValue());
    }

    public int times-zhC_DqQ(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return IntValue.times-zhC_DqQ(this.value, other);
    }

    public static int div-zhC_DqQ(int arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return IntValue.constructor-impl(arg0 / ((Number)other.getValue()).intValue());
    }

    public int div-zhC_DqQ(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return IntValue.div-zhC_DqQ(this.value, other);
    }

    public static int abs-HuW2oqM(int arg0) {
        int n = arg0;
        boolean bl = false;
        return IntValue.constructor-impl(Math.abs(n));
    }

    public int abs-HuW2oqM() {
        return IntValue.abs-HuW2oqM(this.value);
    }

    public static double pow-He8yXgM(int arg0, int x) {
        return DoubleValue.pow-He8yXgM(IntValue.asDouble-Z2rTJmk(arg0), x);
    }

    public double pow-He8yXgM(int x) {
        return IntValue.pow-He8yXgM(this.value, x);
    }

    public static double pow-He8yXgM(int arg0, double x) {
        return DoubleValue.pow-He8yXgM(IntValue.asDouble-Z2rTJmk(arg0), x);
    }

    public double pow-He8yXgM(double x) {
        return IntValue.pow-He8yXgM(this.value, x);
    }

    public static double sqrt-Z2rTJmk(int arg0) {
        return DoubleValue.sqrt-Z2rTJmk(IntValue.asDouble-Z2rTJmk(arg0));
    }

    public double sqrt-Z2rTJmk() {
        return IntValue.sqrt-Z2rTJmk(this.value);
    }

    public static double exp-Z2rTJmk(int arg0) {
        return DoubleValue.exp-Z2rTJmk(IntValue.asDouble-Z2rTJmk(arg0));
    }

    public double exp-Z2rTJmk() {
        return IntValue.exp-Z2rTJmk(this.value);
    }

    public static double ln-Z2rTJmk(int arg0) {
        return DoubleValue.ln-Z2rTJmk(IntValue.asDouble-Z2rTJmk(arg0));
    }

    public double ln-Z2rTJmk() {
        return IntValue.ln-Z2rTJmk(this.value);
    }

    public static double cos-Z2rTJmk(int arg0) {
        return DoubleValue.cos-Z2rTJmk(IntValue.asDouble-Z2rTJmk(arg0));
    }

    public double cos-Z2rTJmk() {
        return IntValue.cos-Z2rTJmk(this.value);
    }

    public static double sin-Z2rTJmk(int arg0) {
        return DoubleValue.sin-Z2rTJmk(IntValue.asDouble-Z2rTJmk(arg0));
    }

    public double sin-Z2rTJmk() {
        return IntValue.sin-Z2rTJmk(this.value);
    }

    public static double tan-Z2rTJmk(int arg0) {
        return DoubleValue.tan-Z2rTJmk(IntValue.asDouble-Z2rTJmk(arg0));
    }

    public double tan-Z2rTJmk() {
        return IntValue.tan-Z2rTJmk(this.value);
    }

    public static double atan-Z2rTJmk(int arg0) {
        return DoubleValue.atan-Z2rTJmk(IntValue.asDouble-Z2rTJmk(arg0));
    }

    public double atan-Z2rTJmk() {
        return IntValue.atan-Z2rTJmk(this.value);
    }

    public static String toString-impl(int arg0) {
        return "IntValue(value=" + arg0 + ')';
    }

    public String toString() {
        return IntValue.toString-impl(this.value);
    }

    public static int hashCode-impl(int arg0) {
        return Integer.hashCode(arg0);
    }

    public int hashCode() {
        return IntValue.hashCode-impl(this.value);
    }

    public static boolean equals-impl(int arg0, Object other) {
        if (!(other instanceof IntValue)) {
            return false;
        }
        int n = ((IntValue)other).unbox-impl();
        return arg0 == n;
    }

    public boolean equals(Object other) {
        return IntValue.equals-impl(this.value, other);
    }

    private /* synthetic */ IntValue(int value) {
        this.value = value;
    }

    public static int constructor-impl(int value) {
        int n = value;
        return n;
    }

    public static final /* synthetic */ IntValue box-impl(int v) {
        return new IntValue(v);
    }

    public final /* synthetic */ int unbox-impl() {
        return this.value;
    }

    public static final boolean equals-impl0(int p1, int p2) {
        return p1 == p2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u000b\u001a\u00020\f\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\r\u0010\u000eR\u001c\u0010\u0003\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\b\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\t\u0010\u0006\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u000f"}, d2={"Lorg/vitrivr/cottontail/model/values/IntValue$Companion;", "", "()V", "ONE", "Lorg/vitrivr/cottontail/model/values/IntValue;", "getONE-HuW2oqM", "()I", "I", "ZERO", "getZERO-HuW2oqM", "random", "rnd", "Ljava/util/SplittableRandom;", "random-zhC_DqQ", "(Ljava/util/SplittableRandom;)I", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public final int getZERO-HuW2oqM() {
            return ZERO;
        }

        public final int getONE-HuW2oqM() {
            return ONE;
        }

        public final int random-zhC_DqQ(@NotNull SplittableRandom rnd) {
            Intrinsics.checkNotNullParameter((Object)rnd, (String)"rnd");
            return IntValue.constructor-impl(rnd.nextInt());
        }

        public static /* synthetic */ int random-zhC_DqQ$default(Companion companion, SplittableRandom splittableRandom, int n, Object object) {
            if ((n & 1) != 0) {
                splittableRandom = Value.Companion.getRANDOM();
            }
            return companion.random-zhC_DqQ(splittableRandom);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

