/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.selection;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.utilities.selection.Selection;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u000f\u0010\u001f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0002J\b\u0010#\u001a\u00020\u001bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000ej\b\u0012\u0004\u0012\u00028\u0000`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lorg/vitrivr/cottontail/utilities/selection/MinHeapSelection;", "T", "", "Lorg/vitrivr/cottontail/utilities/selection/Selection;", "k", "", "(I)V", "accessLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "added", "getAdded", "()I", "heap", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getK", "size", "getSize", "", "sorted", "getSorted", "()Z", "get", "i", "(I)Ljava/lang/Comparable;", "heapify", "", "offer", "element", "(Ljava/lang/Comparable;)V", "peek", "()Ljava/lang/Comparable;", "siftDown", "n", "sort", "cottontaildb"})
public final class MinHeapSelection<T extends Comparable<? super T>>
implements Selection<T> {
    private final int k;
    @NotNull
    private final ArrayList<T> heap;
    @NotNull
    private final StampedLock accessLock;
    private volatile boolean sorted;
    private volatile int added;

    public MinHeapSelection(int k) {
        this.k = k;
        this.heap = new ArrayList(this.getK());
        this.accessLock = new StampedLock();
        this.sorted = true;
    }

    @Override
    public int getK() {
        return this.k;
    }

    public final boolean getSorted() {
        return this.sorted;
    }

    public final int getAdded() {
        return this.added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        int n;
        StampedLock $this$read$iv = this.accessLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            n = 0;
            n = this.heap.size();
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offer(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        StampedLock $this$write$iv = this.accessLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-MinHeapSelection$offer$22 = false;
            this.sorted = false;
            if (this.getAdded() < this.getK()) {
                this.heap.add(element);
                MinHeapSelection minHeapSelection = this;
                minHeapSelection.added = minHeapSelection.getAdded() + 1;
                if (this.getAdded() == this.getK()) {
                    this.heapify();
                }
            } else {
                MinHeapSelection<T> minHeapSelection = this;
                minHeapSelection.added = minHeapSelection.getAdded() + 1;
                minHeapSelection = this.heap.get(0);
                Intrinsics.checkNotNullExpressionValue((Object)minHeapSelection, (String)"this.heap[0]");
                if (element.compareTo((MinHeapSelection)minHeapSelection) < 0) {
                    this.heap.set(0, element);
                    this.siftDown(0, this.getK() - 1);
                }
            }
            Unit $i$a$-write-MinHeapSelection$offer$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T peek() {
        StampedLock $this$read$iv = this.accessLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            boolean bl = false;
            Comparable comparable = (Comparable)CollectionsKt.firstOrNull((List)this.heap);
            return (T)comparable;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public T get(int i) {
        StampedLock $this$write$iv = this.accessLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            Comparable ret;
            boolean bl = false;
            int maxIdx = this.heap.size() - 1;
            boolean bl2 = i <= maxIdx;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "Index " + i + " is out of bounds for this MinHeapSelect.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (i == this.getK() - 1) {
                T t = this.heap.get(0);
                Intrinsics.checkNotNullExpressionValue(t, (String)"this.heap[0]");
                Comparable comparable = (Comparable)t;
                return (T)comparable;
            }
            if (!this.getSorted()) {
                this.sort();
            }
            T t = this.heap.get(maxIdx - i);
            Intrinsics.checkNotNullExpressionValue(t, (String)"this.heap[maxIdx - i]");
            Comparable comparable = ret = (Comparable)t;
            return (T)comparable;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    private final void sort() {
        int n = this.getK();
        int n2 = this.added;
        boolean bl = false;
        int n3 = Math.min(n, n2);
        int inc = 1;
        do {
            inc *= 3;
        } while ((inc = (n2 = inc) + 1) <= n3);
        do {
            if ((n2 = (inc /= 3)) >= n3) continue;
            do {
                int i = n2++;
                T t = this.heap.get(i);
                Intrinsics.checkNotNullExpressionValue(t, (String)"this.heap[i]");
                Comparable v = (Comparable)t;
                int j = i;
                while (((Comparable)this.heap.get(j - inc)).compareTo(v) < 0) {
                    this.heap.set(j, this.heap.get(j - inc));
                    if ((j -= inc) >= inc) continue;
                }
                this.heap.set(j, v);
            } while (n2 < n3);
        } while (inc > 1);
        this.sorted = true;
    }

    private final void siftDown(int i, int n) {
        int k = i;
        while (2 * k <= n) {
            T t;
            int j = 2 * k;
            if (j < n) {
                Comparable comparable = (Comparable)this.heap.get(j);
                t = this.heap.get(j + 1);
                Intrinsics.checkNotNullExpressionValue(t, (String)"this.heap[j + 1]");
                if (comparable.compareTo(t) < 0) {
                    int n2 = j;
                    j = n2 + 1;
                }
            }
            Comparable comparable = (Comparable)this.heap.get(k);
            t = this.heap.get(j);
            Intrinsics.checkNotNullExpressionValue(t, (String)"this.heap[j]");
            if (comparable.compareTo(t) >= 0) break;
            T t2 = this.heap.get(k);
            Intrinsics.checkNotNullExpressionValue(t2, (String)"this.heap[k]");
            Comparable a = (Comparable)t2;
            this.heap.set(k, this.heap.get(j));
            this.heap.set(j, a);
            k = j;
        }
    }

    private final void heapify() {
        int n = this.heap.size();
        int n2 = n / 2 - 1;
        if (0 <= n2) {
            do {
                int i = n2--;
                this.siftDown(i, n - 1);
            } while (0 <= n2);
        }
    }
}

