/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.cli;

import com.github.ajalt.clikt.core.BadParameterValue;
import com.github.ajalt.clikt.core.CliktCommand;
import com.github.ajalt.clikt.core.CliktCommandKt;
import com.github.ajalt.clikt.core.Context;
import com.github.ajalt.clikt.core.MissingArgument;
import com.github.ajalt.clikt.core.MissingOption;
import com.github.ajalt.clikt.core.NoOpCliktCommand;
import com.github.ajalt.clikt.core.NoSuchOption;
import com.github.ajalt.clikt.core.NoSuchSubcommand;
import com.github.ajalt.clikt.core.PrintHelpMessage;
import com.github.ajalt.clikt.core.UsageError;
import com.github.ajalt.clikt.output.CliktHelpFormatter;
import com.github.ajalt.clikt.output.HelpFormatter;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.jline.builtins.Completers;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.vitrivr.cottontail.cli.AbstractCottontailCommand;
import org.vitrivr.cottontail.cli.entity.AboutEntityCommand;
import org.vitrivr.cottontail.cli.entity.ClearEntityCommand;
import org.vitrivr.cottontail.cli.entity.CreateEntityCommand;
import org.vitrivr.cottontail.cli.entity.CreateIndexCommand;
import org.vitrivr.cottontail.cli.entity.DropEntityCommand;
import org.vitrivr.cottontail.cli.entity.DropIndexCommand;
import org.vitrivr.cottontail.cli.entity.DumpEntityCommand;
import org.vitrivr.cottontail.cli.entity.ImportDataCommand;
import org.vitrivr.cottontail.cli.entity.ListAllEntitiesCommand;
import org.vitrivr.cottontail.cli.entity.OptimizeEntityCommand;
import org.vitrivr.cottontail.cli.query.CountEntityCommand;
import org.vitrivr.cottontail.cli.query.ExecuteQueryCommand;
import org.vitrivr.cottontail.cli.query.FindInEntityCommand;
import org.vitrivr.cottontail.cli.query.PreviewEntityCommand;
import org.vitrivr.cottontail.cli.schema.CreateSchemaCommand;
import org.vitrivr.cottontail.cli.schema.DropSchemaCommand;
import org.vitrivr.cottontail.cli.schema.ListAllSchemaCommand;
import org.vitrivr.cottontail.cli.schema.ListEntitiesCommand;
import org.vitrivr.cottontail.cli.system.KillTransactionCommand;
import org.vitrivr.cottontail.cli.system.ListLocksCommand;
import org.vitrivr.cottontail.cli.system.ListTransactionsCommand;
import org.vitrivr.cottontail.cli.system.MigrationCommand;
import org.vitrivr.cottontail.client.SimpleClient;
import org.vitrivr.cottontail.client.iterators.Tuple;
import org.vitrivr.cottontail.client.language.ddl.ListEntities;
import org.vitrivr.cottontail.client.language.ddl.ListSchemas;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u000eH\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0002J\u0006\u0010\u001b\u001a\u00020\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/cli/Cli;", "", "host", "", "port", "", "(Ljava/lang/String;I)V", "channel", "Lio/grpc/ManagedChannel;", "client", "Lorg/vitrivr/cottontail/client/SimpleClient;", "clikt", "Lorg/vitrivr/cottontail/cli/Cli$CottontailCommand;", "completer", "Lorg/jline/reader/Completer;", "getHost", "()Ljava/lang/String;", "getPort", "()I", "stopped", "", "initCompleter", "loop", "", "splitLine", "", "line", "stop", "Companion", "CottontailCommand", "cottontaildb"})
@ExperimentalTime
public final class Cli {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final ManagedChannel channel;
    @NotNull
    private final SimpleClient client;
    @NotNull
    private final CottontailCommand clikt;
    @NotNull
    private final Completer completer;
    private volatile boolean stopped;
    @NotNull
    private static final String PROMPT = "cottontaildb> ";
    @NotNull
    private static final Pattern LINE_SPLIT_REGEX;

    public Cli(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.port = port;
        ManagedChannel managedChannel = ManagedChannelBuilder.forAddress((String)this.host, (int)this.port).enableFullStreamDecompression().usePlaintext().build();
        Intrinsics.checkNotNullExpressionValue((Object)managedChannel, (String)"forAddress(this@Cli.host\u2026intext()\n        .build()");
        this.channel = managedChannel;
        this.client = new SimpleClient(this.channel);
        this.clikt = new CottontailCommand();
        this.completer = this.initCompleter();
    }

    public /* synthetic */ Cli(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "localhost";
        }
        if ((n2 & 2) != 0) {
            n = 1865;
        }
        this(string, n);
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public final void loop() {
        Terminal terminal;
        try {
            terminal = TerminalBuilder.builder().jna(true).build();
        }
        catch (IOException e) {
            System.err.println("Could not initialize terminal: " + e.getMessage() + ". Aborting...");
            return;
        }
        Terminal terminal2 = terminal;
        LineReader lineReader = LineReaderBuilder.builder().terminal(terminal2).completer(this.completer).appName("Cottontail DB").build();
        while (!this.stopped) {
            String line;
            boolean bl;
            String string;
            try {
                string = lineReader.readLine(PROMPT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineReader.readLine(PROMPT)");
                bl = false;
                string = ((Object)StringsKt.trim((CharSequence)string)).toString();
            }
            catch (EndOfFileException e) {
                System.err.println("Could not read from terminal. If you're running Cottontail DB in Docker, then either run Docker in interactive mode (-it) or switch off the Cottontail DB CLI via the config.");
                break;
            }
            catch (UserInterruptException e) {
                System.err.println("Cottontail DB was interrupted by the user (Ctrl-C).");
                break;
            }
            string = line = string;
            bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            if (Intrinsics.areEqual((Object)string3, (Object)"help")) {
                string = this.clikt.getFormattedHelp();
                bl = false;
                System.out.println((Object)string);
                continue;
            }
            if (StringsKt.isBlank((CharSequence)line)) continue;
            try {
                CliktCommand.parse$default((CliktCommand)((CliktCommand)this.clikt), this.splitLine(line), null, (int)2, null);
                boolean bl2 = false;
                System.out.println();
            }
            catch (Exception e) {
                boolean bl3;
                String string4;
                Exception exception = e;
                if (exception instanceof PrintHelpMessage) {
                    string4 = ((PrintHelpMessage)e).getCommand().getFormattedHelp();
                    bl3 = false;
                    System.out.println((Object)string4);
                }
                if (((((exception instanceof NoSuchSubcommand ? true : exception instanceof MissingArgument) ? true : exception instanceof MissingOption) ? true : exception instanceof BadParameterValue) ? true : exception instanceof UsageError) ? true : exception instanceof NoSuchOption) {
                    string4 = e.getLocalizedMessage();
                    bl3 = false;
                    System.out.println((Object)string4);
                }
                if (exception instanceof StatusException ? true : exception instanceof StatusRuntimeException) {
                    string4 = e.getLocalizedMessage();
                    bl3 = false;
                    System.out.println((Object)string4);
                }
                e.printStackTrace();
                string4 = Unit.INSTANCE;
                bl3 = false;
                System.out.println((Object)string4);
            }
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Completer initCompleter() {
        void $this$mapTo$iv$iv;
        Object object;
        boolean bl = false;
        List schemata = new ArrayList();
        boolean bl2 = false;
        List entities = new ArrayList();
        try {
            Iterator iterator2 = (Iterator)this.client.list(new ListSchemas());
            boolean bl3 = false;
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                String sfqn;
                Tuple schema = (Tuple)iterator3.next();
                Intrinsics.checkNotNull((Object)schema.asString(0));
                schemata.add(sfqn);
                schemata.add(Intrinsics.stringPlus((String)"warren.", (Object)sfqn));
                Iterator iterator4 = (Iterator)this.client.list(new ListEntities(sfqn));
                boolean bl4 = false;
                object = iterator4;
                while (object.hasNext()) {
                    Tuple entity = (Tuple)object.next();
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNull((Object)entity.asString(0));
                    Completers.TreeCompleter.Node efqn = Completers.TreeCompleter.node((Object[])objectArray);
                    entities.add(sfqn + '.' + efqn);
                    entities.add("warren." + sfqn + '.' + efqn);
                }
            }
        }
        catch (StatusRuntimeException e) {
            System.err.println("Failed to fetch schema from Cottontail DB instance; some commands may be unavailable!");
        }
        Iterable $this$map$iv = this.clikt.registeredSubcommands();
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$toTypedArray$iv;
            Collection<Completers.TreeCompleter.Node> collection;
            void $this$mapTo$iv$iv2;
            Collection $this$map$iv2;
            void ocmd;
            CliktCommand cliktCommand = (CliktCommand)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl5 = false;
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)ocmd.getCommandName());
            Iterable iterable = ocmd.registeredSubcommands();
            SpreadBuilder spreadBuilder2 = spreadBuilder;
            boolean $i$f$map2 = false;
            void var17_22 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                Completers.TreeCompleter.Node node;
                Iterable thisCollection$iv;
                Iterable $this$toTypedArray$iv2;
                boolean $i$f$toTypedArray;
                Completers.TreeCompleter.Node node2;
                Object[] objectArray;
                String it;
                Collection<Completers.TreeCompleter.Node> collection3;
                void $this$mapTo$iv$iv3;
                boolean $i$f$mapTo3;
                Collection destination$iv$iv3;
                Collection $this$map$iv3;
                boolean $i$f$map3;
                SpreadBuilder spreadBuilder3;
                SpreadBuilder spreadBuilder4;
                void icmd;
                CliktCommand cliktCommand2 = (CliktCommand)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl6 = false;
                if (icmd instanceof AbstractCottontailCommand.Schema && ((AbstractCottontailCommand.Schema)icmd).getExpand()) {
                    spreadBuilder4 = new SpreadBuilder(2);
                    spreadBuilder4.add((Object)icmd.getCommandName());
                    Iterable iterable2 = schemata;
                    spreadBuilder3 = spreadBuilder4;
                    $i$f$map3 = false;
                    void var29_34 = $this$map$iv3;
                    destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    $i$f$mapTo3 = false;
                    for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                        String string = (String)item$iv$iv3;
                        collection3 = destination$iv$iv3;
                        boolean bl7 = false;
                        objectArray = new Object[]{it};
                        node2 = Completers.TreeCompleter.node((Object[])objectArray);
                        collection3.add(node2);
                    }
                    collection3 = (List)destination$iv$iv3;
                    $this$map$iv3 = collection3;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv2;
                    Completers.TreeCompleter.Node[] nodeArray = thisCollection$iv.toArray(new Completers.TreeCompleter.Node[0]);
                    if (nodeArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    spreadBuilder3.addSpread((Object)nodeArray);
                    node = Completers.TreeCompleter.node((Object[])spreadBuilder4.toArray(new Object[spreadBuilder4.size()]));
                } else if (icmd instanceof AbstractCottontailCommand.Query && ((AbstractCottontailCommand.Query)icmd).getExpand() || icmd instanceof AbstractCottontailCommand.Entity && ((AbstractCottontailCommand.Entity)icmd).getExpand()) {
                    spreadBuilder4 = new SpreadBuilder(2);
                    spreadBuilder4.add((Object)icmd.getCommandName());
                    $this$toTypedArray$iv2 = entities;
                    spreadBuilder3 = spreadBuilder4;
                    $i$f$map3 = false;
                    thisCollection$iv = $this$map$iv3;
                    destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    $i$f$mapTo3 = false;
                    for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
                        it = (String)item$iv$iv3;
                        collection3 = destination$iv$iv3;
                        boolean bl8 = false;
                        objectArray = new Object[]{it};
                        node2 = Completers.TreeCompleter.node((Object[])objectArray);
                        collection3.add(node2);
                    }
                    collection3 = (List)destination$iv$iv3;
                    $this$map$iv3 = collection3;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv2;
                    Completers.TreeCompleter.Node[] nodeArray = thisCollection$iv.toArray(new Completers.TreeCompleter.Node[0]);
                    if (nodeArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    spreadBuilder3.addSpread((Object)nodeArray);
                    node = Completers.TreeCompleter.node((Object[])spreadBuilder4.toArray(new Object[spreadBuilder4.size()]));
                } else {
                    spreadBuilder4 = new SpreadBuilder[]{icmd.getCommandName()};
                    node = Completers.TreeCompleter.node((Object[])spreadBuilder4);
                }
                Completers.TreeCompleter.Node node3 = node;
                collection.add(node3);
            }
            collection = (List)destination$iv$iv2;
            $this$map$iv2 = collection;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Completers.TreeCompleter.Node[] nodeArray = thisCollection$iv.toArray(new Completers.TreeCompleter.Node[0]);
            if (nodeArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            spreadBuilder2.addSpread((Object)nodeArray);
            Completers.TreeCompleter.Node node = Completers.TreeCompleter.node((Object[])spreadBuilder.toArray(new Object[spreadBuilder.size()]));
            collection2.add(node);
        }
        List nodes = (List)destination$iv$iv;
        return (Completer)new Completers.TreeCompleter(nodes);
    }

    private final List<String> splitLine(String line) {
        block7: {
            block6: {
                if (line == null) break block6;
                CharSequence charSequence = line;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block7;
            }
            return CollectionsKt.emptyList();
        }
        List matchList = new ArrayList();
        Matcher regexMatcher = LINE_SPLIT_REGEX.matcher(line);
        while (regexMatcher.find()) {
            String string;
            if (regexMatcher.group(1) != null) {
                string = regexMatcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"regexMatcher.group(1)");
                matchList.add(string);
                continue;
            }
            if (regexMatcher.group(2) != null) {
                string = regexMatcher.group(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"regexMatcher.group(2)");
                matchList.add(string);
                continue;
            }
            string = regexMatcher.group();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"regexMatcher.group()");
            matchList.add(string);
        }
        return matchList;
    }

    public final void stop() {
        this.stopped = true;
    }

    public Cli() {
        this(null, 0, 3, null);
    }

    static {
        Pattern pattern = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"[^\\\\s\\\"']+|\\\"([^\\\"]*)\\\"|'([^']*)'\")");
        LINE_SPLIT_REGEX = pattern;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/cli/Cli$Companion;", "", "()V", "LINE_SPLIT_REGEX", "Ljava/util/regex/Pattern;", "PROMPT", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\b\u0087\u0004\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004H\u0016\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/cli/Cli$CottontailCommand;", "Lcom/github/ajalt/clikt/core/NoOpCliktCommand;", "(Lorg/vitrivr/cottontail/cli/Cli;)V", "aliases", "", "", "", "CliHelpFormatter", "StopCommand", "cottontaildb"})
    @ExperimentalTime
    public final class CottontailCommand
    extends NoOpCliktCommand {
        public CottontailCommand() {
            Intrinsics.checkNotNullParameter((Object)Cli.this, (String)"this$0");
            super("The base command for all CLI commands.", null, "cottontail", false, false, null, null, false, 250, null);
            CliktCommandKt.context((CliktCommand)((CliktCommand)this), (Function1)((Function1)new Function1<Context.Builder, Unit>(){

                public final void invoke(@NotNull Context.Builder $this$context) {
                    Intrinsics.checkNotNullParameter((Object)$this$context, (String)"$this$context");
                    $this$context.setHelpFormatter((HelpFormatter)new CliHelpFormatter());
                }
            }));
            CliktCommand[] cliktCommandArray = new CliktCommand[5];
            CliktCommand[] cliktCommandArray2 = new CliktCommand[]{new AboutEntityCommand(Cli.this.client), new ClearEntityCommand(Cli.this.client), new CreateEntityCommand(Cli.this.client), new DropEntityCommand(Cli.this.client), new DumpEntityCommand(Cli.this.client), new ListAllEntitiesCommand(Cli.this.client), new OptimizeEntityCommand(Cli.this.client), new CreateIndexCommand(Cli.this.client), new DropIndexCommand(Cli.this.client), new ImportDataCommand(Cli.this.client)};
            cliktCommandArray[0] = CliktCommandKt.subcommands((CliktCommand)((CliktCommand)new NoOpCliktCommand(){

                @NotNull
                public Map<String, List<String>> aliases() {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ls", (Object)CollectionsKt.listOf((Object)"list")), TuplesKt.to((Object)"list-indexes", (Object)CollectionsKt.listOf((Object)"list-indices"))};
                    return MapsKt.mapOf((Pair[])pairArray);
                }
            }), (CliktCommand[])cliktCommandArray2);
            cliktCommandArray2 = new CliktCommand[]{new CreateSchemaCommand(Cli.this.client), new DropSchemaCommand(Cli.this.client), new ListAllSchemaCommand(Cli.this.client), new ListEntitiesCommand(Cli.this.client)};
            cliktCommandArray[1] = CliktCommandKt.subcommands((CliktCommand)((CliktCommand)new NoOpCliktCommand(){

                @NotNull
                public Map<String, List<String>> aliases() {
                    return MapsKt.mapOf((Pair)TuplesKt.to((Object)"ls", (Object)CollectionsKt.listOf((Object)"list")));
                }
            }), (CliktCommand[])cliktCommandArray2);
            cliktCommandArray2 = new CliktCommand[]{new CountEntityCommand(Cli.this.client), new PreviewEntityCommand(Cli.this.client), new FindInEntityCommand(Cli.this.client), new ExecuteQueryCommand(Cli.this.client)};
            cliktCommandArray[2] = CliktCommandKt.subcommands((CliktCommand)((CliktCommand)new NoOpCliktCommand(){}), (CliktCommand[])cliktCommandArray2);
            cliktCommandArray2 = new CliktCommand[]{new ListTransactionsCommand(Cli.this.client), new ListLocksCommand(Cli.this.client), new KillTransactionCommand(Cli.this.client), new MigrationCommand()};
            cliktCommandArray[3] = CliktCommandKt.subcommands((CliktCommand)((CliktCommand)new NoOpCliktCommand(){

                @NotNull
                public Map<String, List<String>> aliases() {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ls", (Object)CollectionsKt.listOf((Object)"list")), TuplesKt.to((Object)"tls", (Object)CollectionsKt.listOf((Object)"transactions")), TuplesKt.to((Object)"list-transactions", (Object)CollectionsKt.listOf((Object)"transactions")), TuplesKt.to((Object)"rb", (Object)CollectionsKt.listOf((Object)"rollback"))};
                    return MapsKt.mapOf((Pair[])pairArray);
                }
            }), (CliktCommand[])cliktCommandArray2);
            cliktCommandArray[4] = new StopCommand();
            CliktCommandKt.subcommands((CliktCommand)((CliktCommand)this), (CliktCommand[])cliktCommandArray);
        }

        @NotNull
        public Map<String, List<String>> aliases() {
            Pair[] pairArray = new Pair[18];
            Object[] objectArray = new String[]{"schema", "all"};
            pairArray[0] = TuplesKt.to((Object)"sls", (Object)CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"schema", "list"};
            pairArray[1] = TuplesKt.to((Object)"els", (Object)CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"system", "transactions"};
            pairArray[2] = TuplesKt.to((Object)"tls", (Object)CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"entity", "all"};
            pairArray[3] = TuplesKt.to((Object)"ls", (Object)CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"entity", "drop"};
            pairArray[4] = TuplesKt.to((Object)"edelete", (Object)CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"entity", "drop"};
            pairArray[5] = TuplesKt.to((Object)"edel", (Object)CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"entity", "drop"};
            pairArray[6] = TuplesKt.to((Object)"erm", (Object)CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"entity", "drop"};
            pairArray[7] = TuplesKt.to((Object)"eremove", (Object)CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"schema", "drop"};
            pairArray[8] = TuplesKt.to((Object)"delete", (Object)CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"schema", "drop"};
            pairArray[9] = TuplesKt.to((Object)"del", (Object)CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"schema", "drop"};
            pairArray[10] = TuplesKt.to((Object)"rm", (Object)CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"schema", "drop"};
            pairArray[11] = TuplesKt.to((Object)"remove", (Object)CollectionsKt.listOf((Object[])objectArray));
            objectArray = new String[]{"entity", "list-indices"};
            pairArray[12] = TuplesKt.to((Object)"li", (Object)CollectionsKt.listOf((Object[])objectArray));
            pairArray[13] = TuplesKt.to((Object)"quit", (Object)CollectionsKt.listOf((Object)"stop"));
            pairArray[14] = TuplesKt.to((Object)"exit", (Object)CollectionsKt.listOf((Object)"stop"));
            pairArray[15] = TuplesKt.to((Object)"schemas", (Object)CollectionsKt.listOf((Object)"schema"));
            pairArray[16] = TuplesKt.to((Object)"entities", (Object)CollectionsKt.listOf((Object)"entity"));
            objectArray = new String[]{"system", "rollback"};
            pairArray[17] = TuplesKt.to((Object)"trb", (Object)CollectionsKt.listOf((Object[])objectArray));
            return MapsKt.mapOf((Pair[])pairArray);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/cli/Cli$CottontailCommand$CliHelpFormatter;", "Lcom/github/ajalt/clikt/output/CliktHelpFormatter;", "(Lorg/vitrivr/cottontail/cli/Cli$CottontailCommand;)V", "formatHelp", "", "prolog", "epilog", "parameters", "", "Lcom/github/ajalt/clikt/output/HelpFormatter$ParameterHelp;", "programName", "cottontaildb"})
        public final class CliHelpFormatter
        extends CliktHelpFormatter {
            public CliHelpFormatter() {
                Intrinsics.checkNotNullParameter((Object)((Object)CottontailCommand.this), (String)"this$0");
                super(null, null, null, 0, null, 0, null, false, false, 511, null);
            }

            @NotNull
            public String formatHelp(@NotNull String prolog, @NotNull String epilog, @NotNull List<? extends HelpFormatter.ParameterHelp> parameters, @NotNull String programName) {
                Intrinsics.checkNotNullParameter((Object)prolog, (String)"prolog");
                Intrinsics.checkNotNullParameter((Object)epilog, (String)"epilog");
                Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)programName, (String)"programName");
                boolean bl = false;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl3 = false;
                boolean bl4 = false;
                StringBuilder $this$formatHelp_u24lambda_u2d0 = stringBuilder;
                boolean bl5 = false;
                if (StringsKt.contains$default((CharSequence)programName, (CharSequence)" ", (boolean)false, (int)2, null)) {
                    String[] stringArray = new String[]{" "};
                    this.addUsage($this$formatHelp_u24lambda_u2d0, parameters, (String)StringsKt.split$default((CharSequence)programName, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1));
                } else {
                    this.addUsage($this$formatHelp_u24lambda_u2d0, parameters, programName);
                }
                this.addOptions($this$formatHelp_u24lambda_u2d0, parameters);
                this.addArguments($this$formatHelp_u24lambda_u2d0, parameters);
                this.addCommands($this$formatHelp_u24lambda_u2d0, parameters);
                if (StringsKt.endsWith$default((String)programName, (String)"cottontail", (boolean)false, (int)2, null)) {
                    this.addEpilog($this$formatHelp_u24lambda_u2d0, "\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0((`\\\u0085\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0___\u00a0\\\\\u00a0'--._\u0085\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0.'`\u00a0\u00a0\u00a0`'\u00a0\u00a0\u00a0\u00a0o\u00a0\u00a0)\u0085\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0/\u00a0\u00a0\u00a0\u00a0\\\u00a0\u00a0\u00a0'.\u00a0__.'\u0085\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0_|\u00a0\u00a0\u00a0\u00a0/_\u00a0\u00a0\\\u00a0\\_\\_\u0085\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0{_\\______\\-'\\__\\_\\\u0085\u0085by jks from https://www.asciiart.eu/animals/rabbits");
                }
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                return string;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/cli/Cli$CottontailCommand$StopCommand;", "Lcom/github/ajalt/clikt/core/CliktCommand;", "(Lorg/vitrivr/cottontail/cli/Cli$CottontailCommand;)V", "run", "", "cottontaildb"})
        public final class StopCommand
        extends CliktCommand {
            public StopCommand() {
                Intrinsics.checkNotNullParameter((Object)((Object)CottontailCommand.this), (String)"this$0");
                super("Stops the database server and this CLI", null, "stop", false, false, null, null, false, false, 506, null);
            }

            public void run() {
                String string = "Stopping Cottontail DB now...";
                boolean bl = false;
                System.out.println((Object)string);
                Cli.this.stop();
            }
        }
    }
}

