/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.general.DBOVersion;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u0018\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003JJ\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lorg/vitrivr/cottontail/database/index/IndexHeader;", "", "name", "", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "created", "", "modified", "(Ljava/lang/String;Lorg/vitrivr/cottontail/database/index/IndexType;[Lorg/vitrivr/cottontail/database/column/ColumnDef;JJ)V", "getColumns", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getCreated", "()J", "getModified", "getName", "()Ljava/lang/String;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;Lorg/vitrivr/cottontail/database/index/IndexType;[Lorg/vitrivr/cottontail/database/column/ColumnDef;JJ)Lorg/vitrivr/cottontail/database/index/IndexHeader;", "equals", "", "other", "hashCode", "", "toString", "Serializer", "cottontaildb"})
public final class IndexHeader {
    @NotNull
    public static final Serializer Serializer = new Serializer(null);
    @NotNull
    private final String name;
    @NotNull
    private final IndexType type;
    @NotNull
    private final ColumnDef<?>[] columns;
    private final long created;
    private final long modified;

    public IndexHeader(@NotNull String name, @NotNull IndexType type, @NotNull ColumnDef<?>[] columns, long created, long modified) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.name = name;
        this.type = type;
        this.columns = columns;
        this.created = created;
        this.modified = modified;
    }

    public /* synthetic */ IndexHeader(String string, IndexType indexType, ColumnDef[] columnDefArray, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l = System.currentTimeMillis();
        }
        if ((n & 0x10) != 0) {
            l2 = System.currentTimeMillis();
        }
        this(string, indexType, columnDefArray, l, l2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final IndexType getType() {
        return this.type;
    }

    @NotNull
    public final ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    public final long getCreated() {
        return this.created;
    }

    public final long getModified() {
        return this.modified;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final IndexType component2() {
        return this.type;
    }

    @NotNull
    public final ColumnDef<?>[] component3() {
        return this.columns;
    }

    public final long component4() {
        return this.created;
    }

    public final long component5() {
        return this.modified;
    }

    @NotNull
    public final IndexHeader copy(@NotNull String name, @NotNull IndexType type, @NotNull ColumnDef<?>[] columns, long created, long modified) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        return new IndexHeader(name, type, columns, created, modified);
    }

    public static /* synthetic */ IndexHeader copy$default(IndexHeader indexHeader, String string, IndexType indexType, ColumnDef[] columnDefArray, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            string = indexHeader.name;
        }
        if ((n & 2) != 0) {
            indexType = indexHeader.type;
        }
        if ((n & 4) != 0) {
            columnDefArray = indexHeader.columns;
        }
        if ((n & 8) != 0) {
            l = indexHeader.created;
        }
        if ((n & 0x10) != 0) {
            l2 = indexHeader.modified;
        }
        return indexHeader.copy(string, indexType, columnDefArray, l, l2);
    }

    @NotNull
    public String toString() {
        return "IndexHeader(name=" + this.name + ", type=" + (Object)((Object)this.type) + ", columns=" + Arrays.toString(this.columns) + ", created=" + this.created + ", modified=" + this.modified + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + Arrays.hashCode(this.columns);
        result = result * 31 + Long.hashCode(this.created);
        result = result * 31 + Long.hashCode(this.modified);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IndexHeader)) {
            return false;
        }
        IndexHeader indexHeader = (IndexHeader)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)indexHeader.name)) {
            return false;
        }
        if (this.type != indexHeader.type) {
            return false;
        }
        if (!Intrinsics.areEqual(this.columns, indexHeader.columns)) {
            return false;
        }
        if (this.created != indexHeader.created) {
            return false;
        }
        return this.modified == indexHeader.modified;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/index/IndexHeader$Serializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/database/index/IndexHeader;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb"})
    public static final class Serializer
    implements org.mapdb.Serializer<IndexHeader> {
        private Serializer() {
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull IndexHeader value) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            out.packInt(DBOVersion.V2_0.ordinal());
            out.writeUTF(value.getName());
            out.packInt(value.getType().ordinal());
            out.packInt(value.getColumns().length);
            ColumnDef<?>[] $this$forEach$iv = value.getColumns();
            boolean $i$f$forEach = false;
            ColumnDef<?>[] columnDefArray = $this$forEach$iv;
            int n = columnDefArray.length;
            for (int i = 0; i < n; ++i) {
                ColumnDef<?> element$iv;
                ColumnDef<?> it = element$iv = columnDefArray[i];
                boolean bl = false;
                ColumnDef.Serializer.serialize(out, it);
            }
        }

        @NotNull
        public IndexHeader deserialize(@NotNull DataInput2 input, int available) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            DBOVersion version = DBOVersion.values()[input.unpackInt()];
            if (version != DBOVersion.V2_0) {
                throw new DatabaseException.VersionMismatchException(version, DBOVersion.V2_0);
            }
            String string = input.readUTF();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.readUTF()");
            int n = 0;
            int n2 = input.unpackInt();
            ColumnDef[] columnDefArray = new ColumnDef[n2];
            IndexType indexType = IndexType.values()[input.unpackInt()];
            String string2 = string;
            while (n < n2) {
                int n3 = n++;
                columnDefArray[n3] = ColumnDef.Serializer.deserialize(input, available);
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n4 = 24;
            long l = 0L;
            long l2 = 0L;
            ColumnDef[] columnDefArray2 = columnDefArray;
            IndexType indexType2 = indexType;
            String string3 = string2;
            return new IndexHeader(string3, indexType2, columnDefArray2, l2, l, n4, defaultConstructorMarker);
        }

        public /* synthetic */ Serializer(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

