/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.lucene;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.SimilarityBase;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.entity.DefaultEntity;
import org.vitrivr.cottontail.database.entity.EntityTx;
import org.vitrivr.cottontail.database.general.AbstractTx;
import org.vitrivr.cottontail.database.general.TxAction;
import org.vitrivr.cottontail.database.general.TxSnapshot;
import org.vitrivr.cottontail.database.general.TxStatus;
import org.vitrivr.cottontail.database.index.AbstractIndex;
import org.vitrivr.cottontail.database.index.IndexTx;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.index.lucene.LuceneAnalyzerType;
import org.vitrivr.cottontail.database.index.lucene.LuceneIndex;
import org.vitrivr.cottontail.database.index.lucene.LuceneIndexConfig;
import org.vitrivr.cottontail.database.locking.LockMode;
import org.vitrivr.cottontail.database.operations.Operation;
import org.vitrivr.cottontail.database.queries.binding.Binding;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.database.queries.predicates.Predicate;
import org.vitrivr.cottontail.database.queries.predicates.bool.BooleanPredicate;
import org.vitrivr.cottontail.database.queries.predicates.bool.ComparisonOperator;
import org.vitrivr.cottontail.database.queries.predicates.bool.ConnectionOperator;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.exceptions.TxException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.StringValue;
import org.vitrivr.cottontail.model.values.pattern.LikePatternValue;
import org.vitrivr.cottontail.model.values.types.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 >2\u00020\u0001:\u0002>?B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\"H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b'\u0010(J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J)\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/2\n\u00100\u001a\u000601j\u0002`2H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00a2\u0006\u0004\b3\u00104J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J\f\u00109\u001a\u00020:*\u00020;H\u0002J\f\u00109\u001a\u00020:*\u00020<H\u0002J\f\u00109\u001a\u00020:*\u00020=H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0017X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006@"}, d2={"Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndex;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/database/entity/DefaultEntity;", "config", "Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndexConfig;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/database/entity/DefaultEntity;Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndexConfig;)V", "getConfig", "()Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndexConfig;", "directory", "Lorg/apache/lucene/store/Directory;", "indexReader", "Lorg/apache/lucene/index/DirectoryReader;", "kotlin.jvm.PlatformType", "produces", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getProduces", "()[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "[Lorg/vitrivr/cottontail/database/column/ColumnDef;", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "close", "", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "cost-FdqVpck", "(Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;)[F", "documentFromRecord", "Lorg/apache/lucene/document/Document;", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "documentFromValue", "value", "Lorg/vitrivr/cottontail/model/values/StringValue;", "tupleId", "", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "documentFromValue-WukLJtg", "(Ljava/lang/String;J)Lorg/apache/lucene/document/Document;", "newTx", "Lorg/vitrivr/cottontail/database/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "toLuceneQuery", "Lorg/apache/lucene/search/Query;", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate;", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Atomic;", "Lorg/vitrivr/cottontail/database/queries/predicates/bool/BooleanPredicate$Compound;", "Companion", "Tx", "cottontaildb"})
public final class LuceneIndex
extends AbstractIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColumnDef<?>[] produces;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    private final IndexType type;
    @NotNull
    private final LuceneIndexConfig config;
    @NotNull
    private final Directory directory;
    private DirectoryReader indexReader;
    @NotNull
    public static final String TID_COLUMN = "_tid";

    public LuceneIndex(@NotNull Path path, @NotNull DefaultEntity parent, @Nullable LuceneIndexConfig config) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(path, parent);
        FSDirectory fSDirectory = new FSDirectory[]{new ColumnDef(this.getParent().getName().column("score"), Type.Double.INSTANCE, false, false, 8, null)};
        this.produces = fSDirectory;
        this.supportsIncrementalUpdate = true;
        this.type = IndexType.LUCENE;
        fSDirectory = FSDirectory.open((Path)this.getPath().getParent().resolve(Intrinsics.stringPlus((String)this.getName().getSimple(), (Object)".lucene")), (LockFactory)((LockFactory)NativeFSLockFactory.getDefault()));
        Intrinsics.checkNotNullExpressionValue((Object)fSDirectory, (String)"open(\n        this.path.\u2026actory.getDefault()\n    )");
        this.directory = (Directory)fSDirectory;
        Atomic.Var configOnDisk = (Atomic.Var)this.getStore().atomicVar("cdb_index_config", (Serializer)LuceneIndexConfig.Serializer).createOrOpen();
        if (configOnDisk.get() == null) {
            this.config = config != null ? config : new LuceneIndexConfig(LuceneAnalyzerType.STANDARD);
            configOnDisk.set((Object)config);
        } else {
            Object object = configOnDisk.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configOnDisk.get()");
            this.config = (LuceneIndexConfig)object;
        }
        IndexWriter writer = new IndexWriter(this.directory, new IndexWriterConfig(this.getConfig().getAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND).setCommitOnClose(true));
        writer.close();
        this.getStore().commit();
        this.indexReader = DirectoryReader.open((Directory)this.directory);
    }

    public /* synthetic */ LuceneIndex(Path path, DefaultEntity defaultEntity, LuceneIndexConfig luceneIndexConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            luceneIndexConfig = null;
        }
        this(path, defaultEntity, luceneIndexConfig);
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public LuceneIndexConfig getConfig() {
        return this.config;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        boolean bl;
        Object it;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(predicate instanceof BooleanPredicate)) return false;
        Iterable $this$all$iv = predicate.getColumns();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl2 = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                it = (ColumnDef)element$iv;
                boolean bl3 = false;
                if (ArraysKt.contains((Object[])this.getColumns(), (Object)it)) continue;
                return false;
            }
            bl2 = true;
        }
        if (!bl2) return false;
        $this$all$iv = ((BooleanPredicate)predicate).getAtomics();
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            it = (BooleanPredicate.Atomic)element$iv;
            boolean bl4 = false;
            if (!(((BooleanPredicate.Atomic)it).getOperator() instanceof ComparisonOperator.Binary.Like) && !(((BooleanPredicate.Atomic)it).getOperator() instanceof ComparisonOperator.Binary.Equal)) {
                if (!(((BooleanPredicate.Atomic)it).getOperator() instanceof ComparisonOperator.Binary.Match)) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public float[] cost-FdqVpck(@NotNull Predicate predicate) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (this.canProcess(predicate)) {
            void var3_3;
            IndexSearcher searcher = new IndexSearcher((IndexReader)this.indexReader);
            float[] cost = null;
            cost = Cost.Companion.getZERO-9E9yFcc();
            int n = predicate.getColumns().size();
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                cost = Cost.plus-n-rxSDE(cost, Cost.times-FdqVpck(Cost.constructor-impl$default(1.0E-4f, Cost.Companion.getCOST_MEMORY_ACCESS(), 0.0f, 0.0f, 12, null), SimilarityBase.log2((double)searcher.getIndexReader().numDocs())));
            }
            fArray = var3_3;
        } else {
            fArray = Cost.Companion.getINVALID-9E9yFcc();
        }
        return fArray;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.indexReader.close();
            this.directory.close();
        }
    }

    private final Document documentFromRecord(Record record) {
        Value value = record.get(this.getColumns()[0]);
        if (value instanceof StringValue) {
            return this.documentFromValue-WukLJtg(((StringValue)value).unbox-impl(), record.getTupleId());
        }
        throw new IllegalArgumentException("Given record does not contain a StringValue column named " + this.getColumns()[0].getName() + '.');
    }

    private final Document documentFromValue-WukLJtg(String value, long tupleId) {
        Document doc = new Document();
        doc.add((IndexableField)new NumericDocValuesField(TID_COLUMN, tupleId));
        doc.add((IndexableField)new StoredField(TID_COLUMN, tupleId));
        doc.add((IndexableField)new TextField(this.getColumns()[0].getName() + "_txt", value, Field.Store.NO));
        doc.add((IndexableField)new StringField(this.getColumns()[0].getName() + "_str", value, Field.Store.NO));
        return doc;
    }

    private final Query toLuceneQuery(BooleanPredicate $this$toLuceneQuery) {
        Query query2;
        BooleanPredicate booleanPredicate = $this$toLuceneQuery;
        if (booleanPredicate instanceof BooleanPredicate.Atomic) {
            query2 = this.toLuceneQuery((BooleanPredicate.Atomic)$this$toLuceneQuery);
        } else if (booleanPredicate instanceof BooleanPredicate.Compound) {
            query2 = this.toLuceneQuery((BooleanPredicate.Compound)$this$toLuceneQuery);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return query2;
    }

    private final Query toLuceneQuery(BooleanPredicate.Atomic $this$toLuceneQuery) {
        Query query2;
        Value value;
        ColumnDef<?> columnDef;
        if (!($this$toLuceneQuery.getOperator() instanceof ComparisonOperator.Binary)) {
            throw new QueryException("Conversion to Lucene query failed: Only binary operators are supported.");
        }
        if (((ComparisonOperator.Binary)$this$toLuceneQuery.getOperator()).getRight() instanceof Binding.Column) {
            columnDef = ((Binding.Column)((ComparisonOperator.Binary)$this$toLuceneQuery.getOperator()).getRight()).getColumn();
        } else if ($this$toLuceneQuery.getOperator().getLeft() instanceof Binding.Column) {
            columnDef = ((Binding.Column)$this$toLuceneQuery.getOperator().getLeft()).getColumn();
        } else {
            throw new QueryException("Conversion to Lucene query failed: One side of the comparison operator must be a column value!");
        }
        ColumnDef<?> column = columnDef;
        if (!Intrinsics.areEqual(column, (Object)ArraysKt.first((Object[])this.getColumns()))) {
            throw new QueryException("Conversion to Lucene query failed: One side of the comparison operator must be an indexed column!");
        }
        if (((ComparisonOperator.Binary)$this$toLuceneQuery.getOperator()).getRight() instanceof Binding.Literal) {
            value = ((Binding.Literal)((ComparisonOperator.Binary)$this$toLuceneQuery.getOperator()).getRight()).getValue();
        } else if ($this$toLuceneQuery.getOperator().getLeft() instanceof Binding.Literal) {
            value = ((Binding.Literal)$this$toLuceneQuery.getOperator().getLeft()).getValue();
        } else {
            throw new QueryException("Conversion to Lucene query failed: One side of the comparison operator must be a literal value!");
        }
        Value literal = value;
        ComparisonOperator comparisonOperator = $this$toLuceneQuery.getOperator();
        if (comparisonOperator instanceof ComparisonOperator.Binary.Equal) {
            if (!(literal instanceof StringValue)) {
                throw new QueryException("Conversion to Lucene query failed: EQUAL queries strictly require a StringValue as second operand!");
            }
            query2 = (Query)new TermQuery(new Term(column.getName() + "_str", ((StringValue)literal).unbox-impl()));
        } else if (comparisonOperator instanceof ComparisonOperator.Binary.Like) {
            if (!(literal instanceof LikePatternValue)) {
                throw new QueryException("Conversion to Lucene query failed: LIKE queries require a LucenePatternValue OR LikePatternValue as second operand!");
            }
            String[] stringArray = new String[]{((LikePatternValue)literal).toLucene().getValue()};
            String[] stringArray2 = stringArray;
            stringArray = new String[]{column.getName() + "_txt"};
            Query query3 = QueryParserUtil.parse((String[])stringArray2, (String[])stringArray, (Analyzer)((Analyzer)new StandardAnalyzer()));
            Intrinsics.checkNotNullExpressionValue((Object)query3, (String)"{\n                if (li\u2026          }\n            }");
            query2 = query3;
        } else if (comparisonOperator instanceof ComparisonOperator.Binary.Match) {
            if (!(literal instanceof StringValue)) {
                throw new QueryException("Conversion to Lucene query failed: MATCH queries strictly require a StringValue as second operand!");
            }
            String[] stringArray = new String[]{((StringValue)literal).unbox-impl()};
            String[] stringArray3 = stringArray;
            stringArray = new String[]{column.getName() + "_txt"};
            Query query4 = QueryParserUtil.parse((String[])stringArray3, (String[])stringArray, (Analyzer)((Analyzer)new StandardAnalyzer()));
            Intrinsics.checkNotNullExpressionValue((Object)query4, (String)"{\n                if (li\u2026          }\n            }");
            query2 = query4;
        } else {
            throw new QueryException("Lucene Query Conversion failed: Only EQUAL, MATCH and LIKE queries can be mapped to a Apache Lucene!");
        }
        return query2;
    }

    private final Query toLuceneQuery(BooleanPredicate.Compound $this$toLuceneQuery) {
        BooleanClause.Occur occur;
        ConnectionOperator connectionOperator = $this$toLuceneQuery.getConnector();
        int n = WhenMappings.$EnumSwitchMapping$0[connectionOperator.ordinal()];
        switch (n) {
            case 1: {
                occur = BooleanClause.Occur.MUST;
                break;
            }
            case 2: {
                occur = BooleanClause.Occur.SHOULD;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        BooleanClause.Occur clause = occur;
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(this.toLuceneQuery($this$toLuceneQuery.getP1()), clause);
        builder.add(this.toLuceneQuery($this$toLuceneQuery.getP2()), clause);
        BooleanQuery booleanQuery = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)booleanQuery, (String)"builder.build()");
        return (Query)booleanQuery;
    }

    public static final /* synthetic */ Query access$toLuceneQuery(LuceneIndex $this, BooleanPredicate $receiver) {
        return $this.toLuceneQuery($receiver);
    }

    public static final /* synthetic */ DB access$getStore(LuceneIndex $this) {
        return $this.getStore();
    }

    public static final /* synthetic */ void access$setIndexReader$p(LuceneIndex $this, DirectoryReader directoryReader) {
        $this.indexReader = directoryReader;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndex$Companion;", "", "()V", "TID_COLUMN", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\rH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\rH\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndex;Lorg/vitrivr/cottontail/execution/TransactionContext;)V", "snapshot", "Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/database/general/TxSnapshot;", "writer", "Lorg/apache/lucene/index/IndexWriter;", "cleanup", "", "clear", "count", "", "ensureWriterAvailable", "filter", "", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/predicates/Predicate;", "filterRange", "partitionIndex", "", "partitions", "rebuild", "update", "event", "Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation;", "cottontaildb"})
    private final class Tx
    extends AbstractIndex.Tx {
        @Nullable
        private IndexWriter writer;
        @NotNull
        private final TxSnapshot snapshot;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)LuceneIndex.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(LuceneIndex.this, context2);
            this.snapshot = new TxSnapshot(LuceneIndex.this, this){
                @NotNull
                private final List<TxAction> actions;
                final /* synthetic */ LuceneIndex this$0;
                final /* synthetic */ Tx this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.actions = CollectionsKt.emptyList();
                }

                @NotNull
                public List<TxAction> getActions() {
                    return this.actions;
                }

                public void commit() {
                    LuceneIndex.access$getStore(this.this$0).commit();
                    IndexWriter indexWriter = Tx.access$getWriter$p(this.this$1);
                    if (indexWriter == null ? false : indexWriter.hasUncommittedChanges()) {
                        indexWriter = Tx.access$getWriter$p(this.this$1);
                        if (indexWriter != null) {
                            indexWriter.commit();
                        }
                        DirectoryReader oldReader = LuceneIndex.access$getIndexReader$p(this.this$0);
                        LuceneIndex.access$setIndexReader$p(this.this$0, DirectoryReader.open((Directory)LuceneIndex.access$getDirectory$p(this.this$0)));
                        oldReader.close();
                    }
                }

                public void rollback() {
                    LuceneIndex.access$getStore(this.this$0).rollback();
                    IndexWriter indexWriter = Tx.access$getWriter$p(this.this$1);
                    if ((indexWriter == null ? false : indexWriter.hasUncommittedChanges()) && (indexWriter = Tx.access$getWriter$p(this.this$1)) != null) {
                        indexWriter.rollback();
                    }
                }

                public boolean record(@NotNull TxAction action) {
                    Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                    return false;
                }
            };
        }

        @Override
        @NotNull
        public TxSnapshot getSnapshot() {
            return this.snapshot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public long count() {
            void this_$iv;
            AbstractTx abstractTx = this;
            LuceneIndex luceneIndex = LuceneIndex.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                boolean bl3 = false;
                boolean bl4 = false;
                long l = luceneIndex.indexReader.numDocs();
                return l;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void rebuild() {
            int n;
            int n2;
            void this_$iv;
            AbstractTx abstractTx = this;
            LuceneIndex luceneIndex = LuceneIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                this.ensureWriterAvailable();
                EntityTx entityTx = (EntityTx)this.getContext().getTx(this.getDbo().getParent());
                IndexWriter indexWriter = this.writer;
                if (indexWriter != null) {
                    indexWriter.deleteAll();
                }
                Iterator<Record> $this$forEach$iv = entityTx.scan(luceneIndex.getColumns());
                boolean $i$f$forEach = false;
                Iterator<Record> iterator2 = $this$forEach$iv;
                boolean bl6 = false;
                Iterator<Record> iterator3 = iterator2;
                while (iterator3.hasNext()) {
                    Record element$iv;
                    Record record = element$iv = iterator3.next();
                    boolean bl7 = false;
                    IndexWriter indexWriter2 = this.writer;
                    if (indexWriter2 == null) continue;
                    indexWriter2.addDocument((Iterable)luceneIndex.documentFromRecord(record));
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl8 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void update(@NotNull Operation.DataManagementOperation event) {
            int n;
            int n2;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractTx abstractTx = this;
            LuceneIndex luceneIndex = LuceneIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                IndexWriter indexWriter;
                Term[] termArray;
                Object object;
                boolean bl4 = false;
                boolean bl5 = false;
                this.ensureWriterAvailable();
                Operation.DataManagementOperation dataManagementOperation = event;
                if (dataManagementOperation instanceof Operation.DataManagementOperation.InsertOperation) {
                    object = ((Operation.DataManagementOperation.InsertOperation)event).getInserts().get(this.getDbo().getColumns()[0]);
                    if (object instanceof StringValue && (termArray = this.writer) != null) {
                        termArray.addDocument((Iterable)luceneIndex.documentFromValue-WukLJtg(((StringValue)object).unbox-impl(), event.getTupleId()));
                    }
                } else if (dataManagementOperation instanceof Operation.DataManagementOperation.UpdateOperation) {
                    object = this.writer;
                    if (object != null) {
                        termArray = new IndexWriter[]{new Term(LuceneIndex.TID_COLUMN, String.valueOf(event.getTupleId()))};
                        object.deleteDocuments(termArray);
                    }
                    termArray = ((Operation.DataManagementOperation.UpdateOperation)event).getUpdates().get(this.getDbo().getColumns()[0]);
                    Value value = object = termArray == null ? null : (Value)termArray.getSecond();
                    if (object instanceof StringValue && (termArray = this.writer) != null) {
                        termArray.addDocument((Iterable)luceneIndex.documentFromValue-WukLJtg(((StringValue)object).unbox-impl(), event.getTupleId()));
                    }
                } else if (dataManagementOperation instanceof Operation.DataManagementOperation.DeleteOperation && (indexWriter = this.writer) != null) {
                    termArray = new Term[]{new Term(LuceneIndex.TID_COLUMN, String.valueOf(event.getTupleId()))};
                    indexWriter.deleteDocuments(termArray);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void clear() {
            int n;
            int n2;
            void this_$iv;
            AbstractTx abstractTx = this;
            LuceneIndex luceneIndex = LuceneIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            boolean bl = false;
            boolean bl2 = false;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl3 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                n2 = n4++;
                n = 0;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl4 = false;
                boolean bl5 = false;
                this.ensureWriterAvailable();
                IndexWriter indexWriter = this.writer;
                if (indexWriter != null) {
                    indexWriter.deleteAll();
                }
                luceneIndex.getDirtyField().compareAndSet(false, true);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                n2 = 0;
                n2 = 0;
                n = n3;
                while (n2 < n) {
                    int n6 = n2++;
                    boolean bl6 = false;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        @NotNull
        public Iterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new Iterator<Record>(predicate, LuceneIndex.this, this){
                @NotNull
                private final BooleanPredicate predicate;
                private volatile int returned;
                @NotNull
                private final Query query;
                @NotNull
                private final IndexSearcher searcher;
                private final TopDocs results;
                final /* synthetic */ Predicate $predicate;
                final /* synthetic */ LuceneIndex this$0;
                final /* synthetic */ Tx this$1;
                {
                    this.$predicate = $predicate;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    if (!(this.$predicate instanceof BooleanPredicate)) {
                        throw new QueryException.UnsupportedPredicateException("Index '" + this.this$0.getName() + "' (lucene index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass(this.$predicate.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (BooleanPredicate)this.$predicate;
                    if (!this.this$0.canProcess(this.$predicate)) {
                        throw new QueryException.UnsupportedPredicateException("Index '" + this.this$0.getName() + "' (lucene-index) cannot process the provided predicate.");
                    }
                    AbstractTx this_$iv = this.this$1;
                    boolean $i$f$withReadLock = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
                    boolean bl = false;
                    boolean bl2 = false;
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    readLock.lock();
                    try {
                        boolean bl3 = false;
                        boolean bl4 = false;
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        readLock.unlock();
                    }
                    this.query = LuceneIndex.access$toLuceneQuery(this.this$0, this.predicate);
                    this.searcher = new IndexSearcher((IndexReader)LuceneIndex.access$getIndexReader$p(this.this$0));
                    this.results = this.searcher.search(this.query, Integer.MAX_VALUE);
                }

                public boolean hasNext() {
                    return (long)this.returned < this.results.totalHits.value;
                }

                @NotNull
                public Record next() {
                    filter.1 var2_1 = this;
                    int n = var2_1.returned;
                    var2_1.returned = n + 1;
                    ScoreDoc scores = this.results.scoreDocs[n];
                    Document doc = this.searcher.doc(scores.doc);
                    Value[] valueArray = doc.get("_tid");
                    Intrinsics.checkNotNullExpressionValue((Object)valueArray, (String)"doc[TID_COLUMN]");
                    boolean bl = false;
                    long l = Long.parseLong((String)valueArray);
                    valueArray = new Value[]{DoubleValue.box-impl(DoubleValue.constructor-impl(scores.score))};
                    return new StandaloneRecord(l, this.this$0.getProduces(), valueArray);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        @NotNull
        public Iterator<Record> filterRange(@NotNull Predicate predicate, int partitionIndex, int partitions) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            throw new UnsupportedOperationException("The LuceneIndex does not support ranged filtering!");
        }

        @Override
        protected void cleanup() {
            IndexWriter indexWriter = this.writer;
            if (indexWriter != null) {
                indexWriter.close();
            }
            super.cleanup();
        }

        private final void ensureWriterAvailable() {
            if (this.writer == null) {
                IndexWriterConfig config = new IndexWriterConfig(LuceneIndex.this.getConfig().getAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.APPEND).setMaxBufferedDocs(10000).setCommitOnClose(false);
                this.writer = new IndexWriter(LuceneIndex.this.directory, config);
            }
        }

        public static final /* synthetic */ IndexWriter access$getWriter$p(Tx $this) {
            return $this.writer;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectionOperator.values().length];
            nArray[ConnectionOperator.AND.ordinal()] = 1;
            nArray[ConnectionOperator.OR.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

