/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.operations;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.operations.OperationType;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\t\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014B\u0013\b\u0004\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\t\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/database/operations/Operation;", "", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "(J)V", "opType", "Lorg/vitrivr/cottontail/database/operations/OperationType;", "getOpType", "()Lorg/vitrivr/cottontail/database/operations/OperationType;", "getTxId", "()J", "CommitOperation", "CreateEntityOperation", "CreateIndexOperation", "CreateSchemaOperation", "DataManagementOperation", "DropEntityOperation", "DropIndexOperation", "DropSchemaOperation", "RollbackOperation", "Lorg/vitrivr/cottontail/database/operations/Operation$CommitOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation$RollbackOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation$CreateSchemaOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation$DropSchemaOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation$CreateEntityOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation$DropEntityOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation$CreateIndexOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation$DropIndexOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation;", "cottontaildb"})
public abstract class Operation {
    private final long txId;

    private Operation(long txId) {
        this.txId = txId;
    }

    public final long getTxId() {
        return this.txId;
    }

    @NotNull
    public abstract OperationType getOpType();

    public /* synthetic */ Operation(long txId, DefaultConstructorMarker $constructor_marker) {
        this(txId);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/database/operations/Operation$CommitOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation;", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "(J)V", "opType", "Lorg/vitrivr/cottontail/database/operations/OperationType;", "getOpType", "()Lorg/vitrivr/cottontail/database/operations/OperationType;", "cottontaildb"})
    public static final class CommitOperation
    extends Operation {
        @NotNull
        private final OperationType opType = OperationType.COMMIT;

        public CommitOperation(long txId) {
            super(txId, null);
        }

        @Override
        @NotNull
        public OperationType getOpType() {
            return this.opType;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/database/operations/Operation$RollbackOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation;", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "(J)V", "opType", "Lorg/vitrivr/cottontail/database/operations/OperationType;", "getOpType", "()Lorg/vitrivr/cottontail/database/operations/OperationType;", "cottontaildb"})
    public static final class RollbackOperation
    extends Operation {
        @NotNull
        private final OperationType opType = OperationType.ROLLBACK;

        public RollbackOperation(long txId) {
            super(txId, null);
        }

        @Override
        @NotNull
        public OperationType getOpType() {
            return this.opType;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/operations/Operation$CreateSchemaOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation;", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "schema", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "(JLorg/vitrivr/cottontail/model/basics/Name$SchemaName;)V", "opType", "Lorg/vitrivr/cottontail/database/operations/OperationType;", "getOpType", "()Lorg/vitrivr/cottontail/database/operations/OperationType;", "getSchema", "()Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "cottontaildb"})
    public static final class CreateSchemaOperation
    extends Operation {
        @NotNull
        private final Name.SchemaName schema;
        @NotNull
        private final OperationType opType;

        public CreateSchemaOperation(long txId, @NotNull Name.SchemaName schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super(txId, null);
            this.schema = schema;
            this.opType = OperationType.CREATE_SCHEMA;
        }

        @NotNull
        public final Name.SchemaName getSchema() {
            return this.schema;
        }

        @Override
        @NotNull
        public OperationType getOpType() {
            return this.opType;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/operations/Operation$DropSchemaOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation;", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "schema", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "(JLorg/vitrivr/cottontail/model/basics/Name$SchemaName;)V", "opType", "Lorg/vitrivr/cottontail/database/operations/OperationType;", "getOpType", "()Lorg/vitrivr/cottontail/database/operations/OperationType;", "getSchema", "()Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "cottontaildb"})
    public static final class DropSchemaOperation
    extends Operation {
        @NotNull
        private final Name.SchemaName schema;
        @NotNull
        private final OperationType opType;

        public DropSchemaOperation(long txId, @NotNull Name.SchemaName schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super(txId, null);
            this.schema = schema;
            this.opType = OperationType.DROP_SCHEMA;
        }

        @NotNull
        public final Name.SchemaName getSchema() {
            return this.schema;
        }

        @Override
        @NotNull
        public OperationType getOpType() {
            return this.opType;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b\u00a2\u0006\u0002\u0010\nR\u001b\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/database/operations/Operation$CreateEntityOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation;", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "entity", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "(JLorg/vitrivr/cottontail/model/basics/Name$EntityName;Ljava/util/List;)V", "getColumns", "()Ljava/util/List;", "getEntity", "()Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "opType", "Lorg/vitrivr/cottontail/database/operations/OperationType;", "getOpType", "()Lorg/vitrivr/cottontail/database/operations/OperationType;", "cottontaildb"})
    public static final class CreateEntityOperation
    extends Operation {
        @NotNull
        private final Name.EntityName entity;
        @NotNull
        private final List<ColumnDef<?>> columns;
        @NotNull
        private final OperationType opType;

        public CreateEntityOperation(long txId, @NotNull Name.EntityName entity, @NotNull List<? extends ColumnDef<?>> columns) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            super(txId, null);
            this.entity = entity;
            this.columns = columns;
            this.opType = OperationType.CREATE_ENTITY;
        }

        @NotNull
        public final Name.EntityName getEntity() {
            return this.entity;
        }

        @NotNull
        public final List<ColumnDef<?>> getColumns() {
            return this.columns;
        }

        @Override
        @NotNull
        public OperationType getOpType() {
            return this.opType;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/operations/Operation$DropEntityOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation;", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "entity", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "(JLorg/vitrivr/cottontail/model/basics/Name$EntityName;)V", "getEntity", "()Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "opType", "Lorg/vitrivr/cottontail/database/operations/OperationType;", "getOpType", "()Lorg/vitrivr/cottontail/database/operations/OperationType;", "cottontaildb"})
    public static final class DropEntityOperation
    extends Operation {
        @NotNull
        private final Name.EntityName entity;
        @NotNull
        private final OperationType opType;

        public DropEntityOperation(long txId, @NotNull Name.EntityName entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            super(txId, null);
            this.entity = entity;
            this.opType = OperationType.DROP_ENTITY;
        }

        @NotNull
        public final Name.EntityName getEntity() {
            return this.entity;
        }

        @Override
        @NotNull
        public OperationType getOpType() {
            return this.opType;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001BE\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fR\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/vitrivr/cottontail/database/operations/Operation$CreateIndexOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation;", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "index", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "columns", "", "Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "params", "", "", "(JLorg/vitrivr/cottontail/model/basics/Name$IndexName;Lorg/vitrivr/cottontail/database/index/IndexType;[Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;Ljava/util/Map;)V", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "[Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "getIndex", "()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "opType", "Lorg/vitrivr/cottontail/database/operations/OperationType;", "getOpType", "()Lorg/vitrivr/cottontail/database/operations/OperationType;", "getParams", "()Ljava/util/Map;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "cottontaildb"})
    public static final class CreateIndexOperation
    extends Operation {
        @NotNull
        private final Name.IndexName index;
        @NotNull
        private final IndexType type;
        @NotNull
        private final Name.ColumnName[] columns;
        @NotNull
        private final Map<String, String> params;
        @NotNull
        private final OperationType opType;

        public CreateIndexOperation(long txId, @NotNull Name.IndexName index, @NotNull IndexType type, @NotNull Name.ColumnName[] columns, @NotNull Map<String, String> params) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            super(txId, null);
            this.index = index;
            this.type = type;
            this.columns = columns;
            this.params = params;
            this.opType = OperationType.CREATE_INDEX;
        }

        public /* synthetic */ CreateIndexOperation(long l, Name.IndexName indexName, IndexType indexType, Name.ColumnName[] columnNameArray, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                map2 = MapsKt.emptyMap();
            }
            this(l, indexName, indexType, columnNameArray, map2);
        }

        @NotNull
        public final Name.IndexName getIndex() {
            return this.index;
        }

        @NotNull
        public final IndexType getType() {
            return this.type;
        }

        @NotNull
        public final Name.ColumnName[] getColumns() {
            return this.columns;
        }

        @NotNull
        public final Map<String, String> getParams() {
            return this.params;
        }

        @Override
        @NotNull
        public OperationType getOpType() {
            return this.opType;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/operations/Operation$DropIndexOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation;", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "index", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "(JLorg/vitrivr/cottontail/model/basics/Name$IndexName;)V", "getIndex", "()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "opType", "Lorg/vitrivr/cottontail/database/operations/OperationType;", "getOpType", "()Lorg/vitrivr/cottontail/database/operations/OperationType;", "cottontaildb"})
    public static final class DropIndexOperation
    extends Operation {
        @NotNull
        private final Name.IndexName index;
        @NotNull
        private final OperationType opType;

        public DropIndexOperation(long txId, @NotNull Name.IndexName index) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super(txId, null);
            this.index = index;
            this.opType = OperationType.DROP_INDEX;
        }

        @NotNull
        public final Name.IndexName getIndex() {
            return this.index;
        }

        @Override
        @NotNull
        public OperationType getOpType() {
            return this.opType;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u000e\u000f\u0010B'\b\u0004\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\u0003j\u0002`\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0007\u001a\u00060\u0003j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u0082\u0001\u0003\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation;", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "entity", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "tupleId", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "(JLorg/vitrivr/cottontail/model/basics/Name$EntityName;J)V", "getEntity", "()Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "getTupleId", "()J", "DeleteOperation", "InsertOperation", "UpdateOperation", "Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation$InsertOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation$UpdateOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation$DeleteOperation;", "cottontaildb"})
    public static abstract class DataManagementOperation
    extends Operation {
        @NotNull
        private final Name.EntityName entity;
        private final long tupleId;

        private DataManagementOperation(long txId, Name.EntityName entity, long tupleId) {
            super(txId, null);
            this.entity = entity;
            this.tupleId = tupleId;
        }

        @NotNull
        public final Name.EntityName getEntity() {
            return this.entity;
        }

        public final long getTupleId() {
            return this.tupleId;
        }

        public /* synthetic */ DataManagementOperation(long txId, Name.EntityName entity, long tupleId, DefaultConstructorMarker $constructor_marker) {
            this(txId, entity, tupleId);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B?\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\u0003j\u0002`\b\u0012\u0018\u0010\t\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u00a2\u0006\u0002\u0010\rR#\u0010\t\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation$InsertOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation;", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "entity", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "tupleId", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "inserts", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "(JLorg/vitrivr/cottontail/model/basics/Name$EntityName;JLjava/util/Map;)V", "getInserts", "()Ljava/util/Map;", "opType", "Lorg/vitrivr/cottontail/database/operations/OperationType;", "getOpType", "()Lorg/vitrivr/cottontail/database/operations/OperationType;", "cottontaildb"})
        public static final class InsertOperation
        extends DataManagementOperation {
            @NotNull
            private final Map<ColumnDef<?>, Value> inserts;
            @NotNull
            private final OperationType opType;

            public InsertOperation(long txId, @NotNull Name.EntityName entity, long tupleId, @NotNull Map<ColumnDef<?>, ? extends Value> inserts) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                Intrinsics.checkNotNullParameter(inserts, (String)"inserts");
                super(txId, entity, tupleId, null);
                this.inserts = inserts;
                this.opType = OperationType.INSERT;
            }

            @NotNull
            public final Map<ColumnDef<?>, Value> getInserts() {
                return this.inserts;
            }

            @Override
            @NotNull
            public OperationType getOpType() {
                return this.opType;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BM\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\u0003j\u0002`\b\u0012&\u0010\t\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\n\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R1\u0010\t\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation$UpdateOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation;", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "entity", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "tupleId", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "updates", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "(JLorg/vitrivr/cottontail/model/basics/Name$EntityName;JLjava/util/Map;)V", "opType", "Lorg/vitrivr/cottontail/database/operations/OperationType;", "getOpType", "()Lorg/vitrivr/cottontail/database/operations/OperationType;", "getUpdates", "()Ljava/util/Map;", "cottontaildb"})
        public static final class UpdateOperation
        extends DataManagementOperation {
            @NotNull
            private final Map<ColumnDef<?>, Pair<Value, Value>> updates;
            @NotNull
            private final OperationType opType;

            public UpdateOperation(long txId, @NotNull Name.EntityName entity, long tupleId, @NotNull Map<ColumnDef<?>, ? extends Pair<? extends Value, ? extends Value>> updates) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                Intrinsics.checkNotNullParameter(updates, (String)"updates");
                super(txId, entity, tupleId, null);
                this.updates = updates;
                this.opType = OperationType.UPDATE;
            }

            @NotNull
            public final Map<ColumnDef<?>, Pair<Value, Value>> getUpdates() {
                return this.updates;
            }

            @Override
            @NotNull
            public OperationType getOpType() {
                return this.opType;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B?\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u00060\u0003j\u0002`\b\u0012\u0018\u0010\t\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u00a2\u0006\u0002\u0010\rR#\u0010\t\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation$DeleteOperation;", "Lorg/vitrivr/cottontail/database/operations/Operation$DataManagementOperation;", "txId", "", "Lorg/vitrivr/cottontail/model/basics/TransactionId;", "entity", "Lorg/vitrivr/cottontail/model/basics/Name$EntityName;", "tupleId", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "deleted", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "(JLorg/vitrivr/cottontail/model/basics/Name$EntityName;JLjava/util/Map;)V", "getDeleted", "()Ljava/util/Map;", "opType", "Lorg/vitrivr/cottontail/database/operations/OperationType;", "getOpType", "()Lorg/vitrivr/cottontail/database/operations/OperationType;", "cottontaildb"})
        public static final class DeleteOperation
        extends DataManagementOperation {
            @NotNull
            private final Map<ColumnDef<?>, Value> deleted;
            @NotNull
            private final OperationType opType;

            public DeleteOperation(long txId, @NotNull Name.EntityName entity, long tupleId, @NotNull Map<ColumnDef<?>, ? extends Value> deleted) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                Intrinsics.checkNotNullParameter(deleted, (String)"deleted");
                super(txId, entity, tupleId, null);
                this.deleted = deleted;
                this.opType = OperationType.DELETE;
            }

            @NotNull
            public final Map<ColumnDef<?>, Value> getDeleted() {
                return this.deleted;
            }

            @Override
            @NotNull
            public OperationType getOpType() {
                return this.opType;
            }
        }
    }
}

