/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.execution.operators.transform;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.execution.TransactionContext;
import org.vitrivr.cottontail.execution.operators.basics.FlowExtensionsKt;
import org.vitrivr.cottontail.execution.operators.basics.Operator;
import org.vitrivr.cottontail.model.basics.Record;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/execution/operators/transform/LimitOperator;", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator$PipelineOperator;", "parent", "Lorg/vitrivr/cottontail/execution/operators/basics/Operator;", "skip", "", "limit", "(Lorg/vitrivr/cottontail/execution/operators/basics/Operator;JJ)V", "breaker", "", "getBreaker", "()Z", "columns", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "getColumns", "()Ljava/util/List;", "getLimit", "()J", "getSkip", "toFlow", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/model/basics/Record;", "context", "Lorg/vitrivr/cottontail/execution/TransactionContext;", "cottontaildb"})
public final class LimitOperator
extends Operator.PipelineOperator {
    private final long skip;
    private final long limit;
    private final boolean breaker;

    public LimitOperator(@NotNull Operator parent, long skip2, long limit2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(parent);
        this.skip = skip2;
        this.limit = limit2;
    }

    public final long getSkip() {
        return this.skip;
    }

    public final long getLimit() {
        return this.limit;
    }

    @Override
    @NotNull
    public List<ColumnDef<?>> getColumns() {
        return this.getParent().getColumns();
    }

    @Override
    public boolean getBreaker() {
        return this.breaker;
    }

    @Override
    @NotNull
    public Flow<Record> toFlow(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Flow<Record> ret = this.getParent().toFlow(context2);
        if (this.skip > 0L) {
            ret = FlowExtensionsKt.drop(ret, this.skip);
        }
        if (this.limit > 0L) {
            ret = FlowExtensionsKt.take(ret, this.limit);
        }
        return ret;
    }
}

