/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.values;

import java.util.Arrays;
import java.util.Iterator;
import java.util.SplittableRandom;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.apache.commons.math3.util.FastMath;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.Complex32Value;
import org.vitrivr.cottontail.model.values.Complex64Value;
import org.vitrivr.cottontail.model.values.Complex64VectorValue;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.FloatValue;
import org.vitrivr.cottontail.model.values.FloatVectorValue;
import org.vitrivr.cottontail.model.values.types.ComplexValue;
import org.vitrivr.cottontail.model.values.types.ComplexVectorValue;
import org.vitrivr.cottontail.model.values.types.NumericValue;
import org.vitrivr.cottontail.model.values.types.RealValue;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.model.values.types.VectorValue;
import org.vitrivr.cottontail.utilities.extensions.SplittableRandomExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JvmInline
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0087@\u0018\u0000 w2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001wB\u001a\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001a\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\b0\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0006\u0010\tB\u0012\u0012\u0006\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0018\u0010\u001b\u001a\u00020\u001cH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001d\u0010\fJ\u000f\u0010\u001e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b#\u0010!J\u0018\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0096\u0002\u00a2\u0006\u0004\b'\u0010(J\u0018\u0010)\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b*\u0010\fJ\u0018\u0010+\u001a\u00020\u001cH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b,\u0010\fJ\u0018\u0010-\u001a\u00020\u001cH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b.\u0010\fJ%\u0010/\u001a\u00020\u00002\n\u0010%\u001a\u0006\u0012\u0002\b\u000300H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b1\u00102J%\u0010/\u001a\u00020\u00002\n\u0010%\u001a\u0006\u0012\u0002\b\u000303H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b1\u00104J%\u00105\u001a\u00020\u00052\n\u0010%\u001a\u0006\u0012\u0002\b\u000303H\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b6\u00104J\u001a\u00107\u001a\u00020\u001f2\b\u0010%\u001a\u0004\u0018\u000108H\u00d6\u0003\u00a2\u0006\u0004\b9\u0010:J!\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u0014H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b=\u0010>J\u0017\u0010?\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b@\u0010AJ\u0010\u0010B\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\bC\u0010\u0016J \u0010D\u001a\u00020E2\u0006\u0010<\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bF\u0010GJ\u001d\u0010H\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0005H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00a2\u0006\u0004\bI\u0010JJ\u001d\u0010K\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0000H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00a2\u0006\u0004\bL\u0010JJ\u001d\u0010M\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\bH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00a2\u0006\u0004\bN\u0010OJ\u001d\u0010P\u001a\u00020\u00002\u0006\u0010%\u001a\u00020QH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00a2\u0006\u0004\bR\u0010OJ\u0017\u0010S\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0016\u00a2\u0006\u0004\bT\u0010UJ%\u0010V\u001a\u00020W2\n\u0010%\u001a\u0006\u0012\u0002\b\u000303H\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bX\u0010YJ%\u0010Z\u001a\u00020\u00002\n\u0010%\u001a\u0006\u0012\u0002\b\u000300H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b[\u00102J%\u0010Z\u001a\u00020\u00002\n\u0010%\u001a\u0006\u0012\u0002\b\u000303H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b[\u00104J\u0018\u0010\\\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b]\u0010\fJ\u0018\u0010^\u001a\u00020WH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b_\u0010`J%\u0010a\u001a\u00020\u00002\n\u0010%\u001a\u0006\u0012\u0002\b\u000300H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bb\u00102J%\u0010a\u001a\u00020\u00002\n\u0010%\u001a\u0006\u0012\u0002\b\u000303H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bb\u00104J \u0010c\u001a\u00020\u00002\u0006\u0010d\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\be\u0010>J \u0010f\u001a\u00020E2\u0006\u0010<\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bg\u0010GJ\u0018\u0010h\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bi\u0010\fJ(\u0010j\u001a\u00020\u00002\u0006\u0010k\u001a\u00020\u00142\u0006\u0010l\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bm\u0010nJ\u0018\u0010o\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bp\u0010\fJ%\u0010q\u001a\u00020\u00002\n\u0010%\u001a\u0006\u0012\u0002\b\u000300H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\br\u00102J%\u0010q\u001a\u00020\u00002\n\u0010%\u001a\u0006\u0012\u0002\b\u000303H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\br\u00104J\u0010\u0010s\u001a\u00020tH\u00d6\u0001\u00a2\u0006\u0004\bu\u0010vR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u0088\u0001\n\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006x"}, d2={"Lorg/vitrivr/cottontail/model/values/Complex32VectorValue;", "Lorg/vitrivr/cottontail/model/values/types/ComplexVectorValue;", "", "value", "", "Lorg/vitrivr/cottontail/model/values/Complex32Value;", "constructor-impl", "([Lorg/vitrivr/cottontail/model/values/Complex32Value;)[F", "Lorg/vitrivr/cottontail/model/values/Complex64Value;", "([Lorg/vitrivr/cottontail/model/values/Complex64Value;)[F", "data", "", "([F)[F", "getData", "()[F", "indices", "Lkotlin/ranges/IntRange;", "getIndices-impl", "([F)Lkotlin/ranges/IntRange;", "logicalSize", "", "getLogicalSize-impl", "([F)I", "type", "Lorg/vitrivr/cottontail/model/basics/Type;", "getType-impl", "([F)Lorg/vitrivr/cottontail/model/basics/Type;", "abs", "Lorg/vitrivr/cottontail/model/values/FloatVectorValue;", "abs-3wzOJwo", "allOnes", "", "allOnes-impl", "([F)Z", "allZeros", "allZeros-impl", "compareTo", "other", "Lorg/vitrivr/cottontail/model/values/types/Value;", "compareTo-impl", "([FLorg/vitrivr/cottontail/model/values/types/Value;)I", "copy", "copy-4O27Dt0", "copyImaginary", "copyImaginary-3wzOJwo", "copyReal", "copyReal-3wzOJwo", "div", "Lorg/vitrivr/cottontail/model/values/types/NumericValue;", "div-TM7V8EU", "([FLorg/vitrivr/cottontail/model/values/types/NumericValue;)[F", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "([FLorg/vitrivr/cottontail/model/values/types/VectorValue;)[F", "dot", "dot-8fBXkOU", "equals", "", "equals-impl", "([FLjava/lang/Object;)Z", "get", "i", "get-8fBXkOU", "([FI)[F", "getAsBool", "getAsBool-impl", "([FI)Z", "hashCode", "hashCode-impl", "imaginary", "Lorg/vitrivr/cottontail/model/values/FloatValue;", "imaginary-3fEAwC4", "([FI)F", "internalComplex32ValueDiv", "internalComplex32ValueDiv-LggembY", "([F[F)[F", "internalComplex32VectorValueDiv", "internalComplex32VectorValueDiv-_opcBBI", "internalComplex64ValueDiv", "internalComplex64ValueDiv-YVQM6cw", "([F[D)[F", "internalComplex64VectorValueDiv", "Lorg/vitrivr/cottontail/model/values/Complex64VectorValue;", "internalComplex64VectorValueDiv-MBqrpMI", "isEqual", "isEqual-impl", "([FLorg/vitrivr/cottontail/model/values/types/Value;)Z", "l1", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "l1-He8yXgM", "([FLorg/vitrivr/cottontail/model/values/types/VectorValue;)D", "minus", "minus-TM7V8EU", "new", "new-4O27Dt0", "norm2", "norm2-Z2rTJmk", "([F)D", "plus", "plus-TM7V8EU", "pow", "x", "pow-TM7V8EU", "real", "real-3fEAwC4", "sqrt", "sqrt-4O27Dt0", "subvector", "start", "length", "subvector-sq7g6_Y", "([FII)[F", "sum", "sum-WO0UQc4", "times", "times-TM7V8EU", "toString", "", "toString-impl", "([F)Ljava/lang/String;", "Companion", "cottontaildb"})
public final class Complex32VectorValue
implements ComplexVectorValue<Float> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[] data;

    @NotNull
    public final float[] getData() {
        return this.data;
    }

    @NotNull
    public static float[] constructor-impl(@NotNull Complex32Value[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int n = 2 * value.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            fArray[n2] = n2 % 2 == 0 ? Complex32Value.getReal-JbzPQW8(value[n2 / 2].unbox-impl()) : Complex32Value.getImaginary-JbzPQW8(value[n2 / 2].unbox-impl());
        }
        float[] fArray2 = Complex32VectorValue.constructor-impl(fArray);
        return fArray2;
    }

    @NotNull
    public static float[] constructor-impl(@NotNull Complex64Value[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int n = 2 * value.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            fArray[n2] = n2 % 2 == 0 ? (float)Complex64Value.getReal-Z2rTJmk(value[n2 / 2].unbox-impl()) : (float)Complex64Value.getImaginary-Z2rTJmk(value[n2 / 2].unbox-impl());
        }
        float[] fArray2 = Complex32VectorValue.constructor-impl(fArray);
        return fArray2;
    }

    public static int getLogicalSize-impl(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return arg0.length / 2;
    }

    @Override
    public int getLogicalSize() {
        return Complex32VectorValue.getLogicalSize-impl(this.data);
    }

    @NotNull
    public static Type<?> getType-impl(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return new Type.Complex32Vector(Complex32VectorValue.getLogicalSize-impl(arg0));
    }

    @Override
    @NotNull
    public Type<?> getType() {
        return Complex32VectorValue.getType-impl(this.data);
    }

    @NotNull
    public static float[] get-8fBXkOU(float[] arg0, int i) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex32Value.constructor-impl(arg0[i << 1], arg0[(i << 1) + 1]);
    }

    @NotNull
    public float[] get-8fBXkOU(int i) {
        return Complex32VectorValue.get-8fBXkOU(this.data, i);
    }

    public static float real-3fEAwC4(float[] arg0, int i) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return FloatValue.constructor-impl(arg0[i << 1]);
    }

    public float real-3fEAwC4(int i) {
        return Complex32VectorValue.real-3fEAwC4(this.data, i);
    }

    public static float imaginary-3fEAwC4(float[] arg0, int i) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return FloatValue.constructor-impl(arg0[(i << 1) + 1]);
    }

    public float imaginary-3fEAwC4(int i) {
        return Complex32VectorValue.imaginary-3fEAwC4(this.data, i);
    }

    @NotNull
    public static float[] subvector-sq7g6_Y(float[] arg0, int start, int length) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        float[] fArray = arg0;
        int n = 2 * start;
        int n2 = 2 * start + 2 * length;
        boolean bl = false;
        return Complex32VectorValue.constructor-impl(ArraysKt.copyOfRange((float[])fArray, (int)n, (int)n2));
    }

    @NotNull
    public float[] subvector-sq7g6_Y(int start, int length) {
        return Complex32VectorValue.subvector-sq7g6_Y(this.data, start, length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEqual-impl(float[] arg0, @NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof FloatVectorValue)) return false;
        float[] fArray = arg0;
        float[] fArray2 = ((FloatVectorValue)other).unbox-impl();
        boolean bl = false;
        if (!Arrays.equals(fArray, fArray2)) return false;
        return true;
    }

    @Override
    public boolean isEqual(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Complex32VectorValue.isEqual-impl(this.data, other);
    }

    public static int compareTo-impl(float[] arg0, @NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        throw new IllegalArgumentException("ComplexVectorValues can can only be compared for equality.");
    }

    @Override
    public int compareTo(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Complex32VectorValue.compareTo-impl(this.data, other);
    }

    @NotNull
    public static IntRange getIndices-impl(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return RangesKt.until((int)0, (int)Complex32VectorValue.getLogicalSize-impl(arg0));
    }

    @Override
    @NotNull
    public IntRange getIndices() {
        return Complex32VectorValue.getIndices-impl(this.data);
    }

    public static boolean getAsBool-impl(float[] arg0, int i) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return !Complex32Value.equals-impl0(Complex32VectorValue.get-8fBXkOU(arg0, i), Complex32Value.Companion.getZERO-WO0UQc4());
    }

    @Override
    public boolean getAsBool(int i) {
        return Complex32VectorValue.getAsBool-impl(this.data, i);
    }

    public static boolean allZeros-impl(float[] arg0) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
            float[] $this$all$iv = arg0;
            boolean $i$f$all = false;
            float[] fArray = $this$all$iv;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                float element$iv;
                float it = element$iv = fArray[i];
                boolean bl2 = false;
                if (it == 0.0f) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean allZeros() {
        return Complex32VectorValue.allZeros-impl(this.data);
    }

    public static boolean allOnes-impl(float[] arg0) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
            float[] $this$all$iv = arg0;
            boolean $i$f$all = false;
            float[] fArray = $this$all$iv;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                float element$iv;
                float it = element$iv = fArray[i];
                boolean bl2 = false;
                if (it == 1.0f) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean allOnes() {
        return Complex32VectorValue.allOnes-impl(this.data);
    }

    @NotNull
    public static float[] copy-4O27Dt0(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        float[] fArray = arg0;
        boolean bl = false;
        float[] fArray2 = Arrays.copyOf(fArray, fArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return Complex32VectorValue.constructor-impl(fArray2);
    }

    @NotNull
    public float[] copy-4O27Dt0() {
        return Complex32VectorValue.copy-4O27Dt0(this.data);
    }

    @NotNull
    public static float[] new-4O27Dt0(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex32VectorValue.constructor-impl(new float[arg0.length]);
    }

    @NotNull
    public float[] new-4O27Dt0() {
        return Complex32VectorValue.new-4O27Dt0(this.data);
    }

    @NotNull
    public static float[] copyReal-3wzOJwo(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        int n = 0;
        int n2 = Complex32VectorValue.getLogicalSize-impl(arg0);
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = arg0[n3 << 1];
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] copyReal-3wzOJwo() {
        return Complex32VectorValue.copyReal-3wzOJwo(this.data);
    }

    @NotNull
    public static float[] copyImaginary-3wzOJwo(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        int n = 0;
        int n2 = Complex32VectorValue.getLogicalSize-impl(arg0);
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = arg0[(n3 << 1) + 1];
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] copyImaginary-3wzOJwo() {
        return Complex32VectorValue.copyImaginary-3wzOJwo(this.data);
    }

    @NotNull
    public static float[] plus-TM7V8EU(float[] arg0, @NotNull VectorValue<?> other) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.getLogicalSize() == Complex32VectorValue.getLogicalSize-impl(arg0)) {
            VectorValue<?> vectorValue = other;
            if (vectorValue instanceof Complex32VectorValue) {
                int n = 0;
                int n2 = arg0.length;
                float[] fArray2 = new float[n2];
                while (n < n2) {
                    int n3 = n++;
                    fArray2[n3] = arg0[n3] + ((Complex32VectorValue)other).unbox-impl()[n3];
                }
                fArray = fArray2;
            } else if (vectorValue instanceof Complex64VectorValue) {
                int n = 0;
                int n4 = arg0.length;
                float[] fArray3 = new float[n4];
                while (n < n4) {
                    int n5 = n++;
                    fArray3[n5] = (float)((double)arg0[n5] + ((Complex64VectorValue)other).unbox-impl()[n5]);
                }
                fArray = fArray3;
            } else {
                int n = arg0.length;
                float[] fArray4 = new float[n];
                for (int i = 0; i < n; ++i) {
                    int n6 = i;
                    fArray4[n6] = n6 % 2 == 0 ? arg0[n6] + ((Number)other.get(n6 / 2).getValue()).floatValue() : arg0[n6];
                }
                fArray = fArray4;
            }
        } else {
            throw new IllegalArgumentException("Dimensions " + Complex32VectorValue.getLogicalSize-impl(arg0) + " and " + other.getLogicalSize() + " don't agree!");
        }
        return Complex32VectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] plus-TM7V8EU(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32VectorValue.plus-TM7V8EU(this.data, other);
    }

    @NotNull
    public static float[] minus-TM7V8EU(float[] arg0, @NotNull VectorValue<?> other) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        VectorValue<?> vectorValue = other;
        if (vectorValue instanceof Complex32VectorValue) {
            int n = 0;
            int n2 = Complex32VectorValue.getLogicalSize-impl(arg0) * 2;
            float[] fArray2 = new float[n2];
            while (n < n2) {
                int n3 = n++;
                fArray2[n3] = arg0[n3] - ((Complex32VectorValue)other).unbox-impl()[n3];
            }
            fArray = fArray2;
        } else if (vectorValue instanceof Complex64VectorValue) {
            int n = 0;
            int n4 = Complex32VectorValue.getLogicalSize-impl(arg0) * 2;
            float[] fArray3 = new float[n4];
            while (n < n4) {
                int n5 = n++;
                fArray3[n5] = (float)((double)arg0[n5] - ((Complex64VectorValue)other).unbox-impl()[n5]);
            }
            fArray = fArray3;
        } else {
            int n = Complex32VectorValue.getLogicalSize-impl(arg0) * 2;
            float[] fArray4 = new float[n];
            for (int i = 0; i < n; ++i) {
                int n6 = i;
                fArray4[n6] = n6 % 2 == 0 ? arg0[n6] - ((Number)other.get(n6 / 2).getValue()).floatValue() : arg0[n6];
            }
            fArray = fArray4;
        }
        return Complex32VectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] minus-TM7V8EU(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32VectorValue.minus-TM7V8EU(this.data, other);
    }

    @NotNull
    public static float[] times-TM7V8EU(float[] arg0, @NotNull VectorValue<?> other) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.getLogicalSize() == Complex32VectorValue.getLogicalSize-impl(arg0)) {
            VectorValue<?> vectorValue = other;
            if (vectorValue instanceof Complex32VectorValue) {
                int n = arg0.length;
                float[] fArray2 = new float[n];
                for (int i = 0; i < n; ++i) {
                    int n2 = i;
                    fArray2[n2] = n2 % 2 == 0 ? arg0[n2] * ((Complex32VectorValue)other).unbox-impl()[n2] - arg0[n2 + 1] * ((Complex32VectorValue)other).unbox-impl()[n2 + 1] : arg0[n2 - 1] * ((Complex32VectorValue)other).unbox-impl()[n2] + arg0[n2] * ((Complex32VectorValue)other).unbox-impl()[n2 - 1];
                }
                fArray = fArray2;
            } else if (vectorValue instanceof Complex64VectorValue) {
                int n = arg0.length;
                float[] fArray3 = new float[n];
                for (int i = 0; i < n; ++i) {
                    int n3 = i;
                    fArray3[n3] = n3 % 2 == 0 ? (float)((double)arg0[n3] * ((Complex64VectorValue)other).unbox-impl()[n3] - (double)arg0[n3 + 1] * ((Complex64VectorValue)other).unbox-impl()[n3 + 1]) : (float)((double)arg0[n3 - 1] * ((Complex64VectorValue)other).unbox-impl()[n3] + (double)arg0[n3] * ((Complex64VectorValue)other).unbox-impl()[n3 - 1]);
                }
                fArray = fArray3;
            } else {
                int n = 0;
                int n4 = arg0.length;
                float[] fArray4 = new float[n4];
                while (n < n4) {
                    int n5 = n++;
                    fArray4[n5] = arg0[n5] * ((Number)other.get(n5 / 2).getValue()).floatValue();
                }
                fArray = fArray4;
            }
        } else {
            throw new IllegalArgumentException("Dimensions " + Complex32VectorValue.getLogicalSize-impl(arg0) + " and " + other.getLogicalSize() + " don't agree!");
        }
        return Complex32VectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] times-TM7V8EU(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32VectorValue.times-TM7V8EU(this.data, other);
    }

    @NotNull
    public static float[] div-TM7V8EU(float[] arg0, @NotNull VectorValue<?> other) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.getLogicalSize() == Complex32VectorValue.getLogicalSize-impl(arg0)) {
            VectorValue<?> vectorValue = other;
            if (vectorValue instanceof Complex64VectorValue) {
                fArray = Complex32VectorValue.internalComplex64VectorValueDiv-MBqrpMI(arg0, ((Complex64VectorValue)other).unbox-impl());
            } else if (vectorValue instanceof Complex32VectorValue) {
                fArray = Complex32VectorValue.internalComplex32VectorValueDiv-_opcBBI(arg0, ((Complex32VectorValue)other).unbox-impl());
            } else {
                int n = 0;
                int n2 = arg0.length;
                float[] fArray2 = new float[n2];
                while (n < n2) {
                    int n3 = n++;
                    fArray2[n3] = arg0[n3] / ((Number)other.get(n3 / 2).getValue()).floatValue();
                }
                fArray = Complex32VectorValue.constructor-impl(fArray2);
            }
        } else {
            throw new IllegalArgumentException("Dimensions " + Complex32VectorValue.getLogicalSize-impl(arg0) + " and " + other.getLogicalSize() + " don't agree!");
        }
        return fArray;
    }

    @NotNull
    public float[] div-TM7V8EU(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32VectorValue.div-TM7V8EU(this.data, other);
    }

    private static final float[] internalComplex64VectorValueDiv-MBqrpMI(float[] arg0, double[] other) {
        float[] floats = new float[arg0.length];
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                double denominator;
                double q;
                int i = n++;
                double c = other[i << 1];
                double d = other[(i << 1) + 1];
                boolean bl = false;
                bl = false;
                if (Math.abs(c) < Math.abs(d)) {
                    q = c / d;
                    denominator = c * q + d;
                    floats[i << 1] = (float)(((double)arg0[i << 1] * q + (double)arg0[(i << 1) + 1]) / denominator);
                    floats[(i << 1) + 1] = (float)(((double)arg0[(i << 1) + 1] * q - (double)arg0[i << 1]) / denominator);
                    continue;
                }
                q = d / c;
                denominator = d * q + c;
                floats[i << 1] = (float)(((double)arg0[(i << 1) + 1] * q + (double)arg0[i << 1]) / denominator);
                floats[(i << 1) + 1] = (float)(((double)arg0[(i << 1) + 1] - (double)arg0[i << 1] * q) / denominator);
            } while (n < n2);
        }
        return Complex32VectorValue.constructor-impl(floats);
    }

    private static final float[] internalComplex32VectorValueDiv-_opcBBI(float[] arg0, float[] other) {
        float[] floats = new float[arg0.length];
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                float denominator;
                float q;
                int i = n++;
                float c = other[i << 1];
                float d = other[(i << 1) + 1];
                boolean bl = false;
                bl = false;
                if (Math.abs(c) < Math.abs(d)) {
                    q = c / d;
                    denominator = c * q + d;
                    floats[i << 1] = (arg0[i << 1] * q + arg0[(i << 1) + 1]) / denominator;
                    floats[(i << 1) + 1] = (arg0[(i << 1) + 1] * q - arg0[i << 1]) / denominator;
                    continue;
                }
                q = d / c;
                denominator = d * q + c;
                floats[i << 1] = (arg0[(i << 1) + 1] * q + arg0[i << 1]) / denominator;
                floats[(i << 1) + 1] = (arg0[(i << 1) + 1] - arg0[i << 1] * q) / denominator;
            } while (n < n2);
        }
        return Complex32VectorValue.constructor-impl(floats);
    }

    @NotNull
    public static float[] plus-TM7V8EU(float[] arg0, @NotNull NumericValue<?> other) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        NumericValue<?> numericValue = other;
        if (numericValue instanceof Complex32Value) {
            int n = arg0.length;
            float[] fArray2 = new float[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                fArray2[n2] = n2 % 2 == 0 ? arg0[n2] + ((Complex32Value)other).unbox-impl()[0] : arg0[n2] + ((Complex32Value)other).unbox-impl()[1];
            }
            fArray = fArray2;
        } else if (numericValue instanceof Complex64Value) {
            int n = arg0.length;
            float[] fArray3 = new float[n];
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                fArray3[n3] = n3 % 2 == 0 ? (float)((double)arg0[n3] + ((Complex64Value)other).unbox-impl()[0]) : (float)((double)arg0[n3] + ((Complex64Value)other).unbox-impl()[1]);
            }
            fArray = fArray3;
        } else {
            int n = arg0.length;
            float[] fArray4 = new float[n];
            for (int i = 0; i < n; ++i) {
                int n4 = i;
                fArray4[n4] = n4 % 2 == 0 ? arg0[n4] + ((Number)other.getValue()).floatValue() : arg0[n4];
            }
            fArray = fArray4;
        }
        return Complex32VectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] plus-TM7V8EU(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32VectorValue.plus-TM7V8EU(this.data, other);
    }

    @NotNull
    public static float[] minus-TM7V8EU(float[] arg0, @NotNull NumericValue<?> other) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        NumericValue<?> numericValue = other;
        if (numericValue instanceof Complex32Value) {
            int n = arg0.length;
            float[] fArray2 = new float[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                fArray2[n2] = n2 % 2 == 0 ? arg0[n2] - ((Complex32Value)other).unbox-impl()[0] : arg0[n2] - ((Complex32Value)other).unbox-impl()[1];
            }
            fArray = fArray2;
        } else if (numericValue instanceof Complex64Value) {
            int n = arg0.length;
            float[] fArray3 = new float[n];
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                fArray3[n3] = n3 % 2 == 0 ? (float)((double)arg0[n3] - ((Complex64Value)other).unbox-impl()[0]) : (float)((double)arg0[n3] - ((Complex64Value)other).unbox-impl()[1]);
            }
            fArray = fArray3;
        } else {
            int n = arg0.length;
            float[] fArray4 = new float[n];
            for (int i = 0; i < n; ++i) {
                int n4 = i;
                fArray4[n4] = n4 % 2 == 0 ? arg0[n4] - ((Number)other.getValue()).floatValue() : arg0[n4];
            }
            fArray = fArray4;
        }
        return Complex32VectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] minus-TM7V8EU(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32VectorValue.minus-TM7V8EU(this.data, other);
    }

    @NotNull
    public static float[] times-TM7V8EU(float[] arg0, @NotNull NumericValue<?> other) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        NumericValue<?> numericValue = other;
        if (numericValue instanceof Complex32Value) {
            int n = arg0.length;
            float[] fArray2 = new float[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                fArray2[n2] = n2 % 2 == 0 ? arg0[n2] * ((Complex32Value)other).unbox-impl()[0] - arg0[n2 + 1] * ((Complex32Value)other).unbox-impl()[1] : arg0[n2 - 1] * ((Complex32Value)other).unbox-impl()[1] + arg0[n2] * ((Complex32Value)other).unbox-impl()[0];
            }
            fArray = fArray2;
        } else if (numericValue instanceof Complex64Value) {
            int n = arg0.length;
            float[] fArray3 = new float[n];
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                fArray3[n3] = n3 % 2 == 0 ? (float)((double)arg0[n3] * ((Complex64Value)other).unbox-impl()[0] - (double)arg0[n3 + 1] * ((Complex64Value)other).unbox-impl()[1]) : (float)((double)arg0[n3 - 1] * ((Complex64Value)other).unbox-impl()[1] + (double)arg0[n3] * ((Complex64Value)other).unbox-impl()[0]);
            }
            fArray = fArray3;
        } else {
            int n = 0;
            int n4 = arg0.length;
            float[] fArray4 = new float[n4];
            while (n < n4) {
                int n5 = n++;
                fArray4[n5] = arg0[n5] * ((Number)other.getValue()).floatValue();
            }
            fArray = fArray4;
        }
        return Complex32VectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] times-TM7V8EU(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32VectorValue.times-TM7V8EU(this.data, other);
    }

    @NotNull
    public static float[] div-TM7V8EU(float[] arg0, @NotNull NumericValue<?> other) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        NumericValue<?> numericValue = other;
        if (numericValue instanceof Complex64Value) {
            fArray = Complex32VectorValue.internalComplex64ValueDiv-YVQM6cw(arg0, ((Complex64Value)other).unbox-impl());
        } else if (numericValue instanceof Complex32Value) {
            fArray = Complex32VectorValue.internalComplex32ValueDiv-LggembY(arg0, ((Complex32Value)other).unbox-impl());
        } else {
            int n = 0;
            int n2 = arg0.length;
            float[] fArray2 = new float[n2];
            while (n < n2) {
                int n3 = n++;
                fArray2[n3] = arg0[n3] / ((Number)other.getValue()).floatValue();
            }
            fArray = Complex32VectorValue.constructor-impl(fArray2);
        }
        return fArray;
    }

    @NotNull
    public float[] div-TM7V8EU(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32VectorValue.div-TM7V8EU(this.data, other);
    }

    private static final float[] internalComplex64ValueDiv-YVQM6cw(float[] arg0, double[] other) {
        float[] floats = new float[arg0.length];
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                double denominator;
                double q;
                int i = n++;
                double c = other[0];
                double d = other[1];
                boolean bl = false;
                bl = false;
                if (Math.abs(c) < Math.abs(d)) {
                    q = c / d;
                    denominator = c * q + d;
                    floats[i << 1] = (float)(((double)arg0[i << 1] * q + (double)arg0[(i << 1) + 1]) / denominator);
                    floats[(i << 1) + 1] = (float)(((double)arg0[(i << 1) + 1] * q - (double)arg0[i << 1]) / denominator);
                    continue;
                }
                q = d / c;
                denominator = d * q + c;
                floats[i << 1] = (float)(((double)arg0[(i << 1) + 1] * q + (double)arg0[i << 1]) / denominator);
                floats[(i << 1) + 1] = (float)(((double)arg0[(i << 1) + 1] - (double)arg0[i << 1] * q) / denominator);
            } while (n < n2);
        }
        return Complex32VectorValue.constructor-impl(floats);
    }

    private static final float[] internalComplex32ValueDiv-LggembY(float[] arg0, float[] other) {
        float[] floats = new float[arg0.length];
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                float denominator;
                float q;
                int i = n++;
                float c = other[0];
                float d = other[1];
                boolean bl = false;
                bl = false;
                if (Math.abs(c) < Math.abs(d)) {
                    q = c / d;
                    denominator = c * q + d;
                    floats[i << 1] = (arg0[i << 1] * q + arg0[(i << 1) + 1]) / denominator;
                    floats[(i << 1) + 1] = (arg0[(i << 1) + 1] * q - arg0[i << 1]) / denominator;
                    continue;
                }
                q = d / c;
                denominator = d * q + c;
                floats[i << 1] = (arg0[(i << 1) + 1] * q + arg0[i << 1]) / denominator;
                floats[(i << 1) + 1] = (arg0[(i << 1) + 1] - arg0[i << 1] * q) / denominator;
            } while (n < n2);
        }
        return Complex32VectorValue.constructor-impl(floats);
    }

    @NotNull
    public static float[] pow-TM7V8EU(float[] arg0, int x) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        float[] floats = new float[arg0.length];
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                int i = n++;
                float f = arg0[i << 1] * arg0[i << 1] + arg0[(i << 1) + 1] * arg0[(i << 1) + 1];
                boolean bl = false;
                f = (float)Math.sqrt(f);
                bl = false;
                float real = (float)x * (float)Math.log(f);
                float f2 = arg0[(i << 1) + 1];
                float f3 = arg0[i << 1];
                boolean bl2 = false;
                float imaginary = (float)x * (float)Math.atan2(f2, f3);
                boolean bl3 = false;
                float exp = (float)Math.exp(real);
                bl3 = false;
                floats[i << 1] = exp * (float)Math.cos(imaginary);
                bl3 = false;
                floats[(i << 1) + 1] = exp * (float)Math.sin(imaginary);
            } while (n < n2);
        }
        return Complex32VectorValue.constructor-impl(floats);
    }

    @NotNull
    public float[] pow-TM7V8EU(int x) {
        return Complex32VectorValue.pow-TM7V8EU(this.data, x);
    }

    @NotNull
    public static float[] sqrt-4O27Dt0(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        float[] floats = new float[arg0.length];
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                int i;
                if (arg0[(i = n++) << 1] == 0.0f && arg0[(i << 1) + 1] == 0.0f) continue;
                float f = arg0[i << 1] * arg0[i << 1] + arg0[(i << 1) + 1] * arg0[(i << 1) + 1];
                boolean bl = false;
                float modulus = (float)Math.sqrt(f);
                float f2 = arg0[i << 1];
                boolean bl2 = false;
                f2 = (Math.abs(f2) + modulus) / 2.0f;
                bl2 = false;
                float t = (float)Math.sqrt(f2);
                if ((double)arg0[i << 1] >= 0.0) {
                    floats[i << 1] = t;
                    floats[(i << 1) + 1] = arg0[(i << 1) + 1] / (2.0f * t);
                    continue;
                }
                f2 = arg0[(i << 1) + 1];
                bl2 = false;
                floats[i << 1] = Math.abs(f2) / (2.0f * t);
                floats[(i << 1) + 1] = FastMath.copySign((float)1.0f, (float)arg0[(i << 1) + 1]) * t;
            } while (n < n2);
        }
        return Complex32VectorValue.constructor-impl(floats);
    }

    @NotNull
    public float[] sqrt-4O27Dt0() {
        return Complex32VectorValue.sqrt-4O27Dt0(this.data);
    }

    @NotNull
    public static float[] abs-3wzOJwo(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        int n = 0;
        int n2 = arg0.length / 2;
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            float f = arg0[n3 << 1] * arg0[n3 << 1] + arg0[(n3 << 1) + 1] * arg0[(n3 << 1) + 1];
            boolean bl = false;
            fArray[n3] = (float)Math.sqrt(f);
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] abs-3wzOJwo() {
        return Complex32VectorValue.abs-3wzOJwo(this.data);
    }

    @NotNull
    public static float[] sum-WO0UQc4(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        float real = 0.0f;
        float imaginary = 0.0f;
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                int i = n++;
                real += arg0[i << 1];
                imaginary += arg0[(i << 1) + 1];
            } while (n < n2);
        }
        return Complex32Value.constructor-impl(real, imaginary);
    }

    @NotNull
    public float[] sum-WO0UQc4() {
        return Complex32VectorValue.sum-WO0UQc4(this.data);
    }

    @NotNull
    public static float[] dot-8fBXkOU(float[] arg0, @NotNull VectorValue<?> other) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        VectorValue<?> vectorValue = other;
        if (vectorValue instanceof Complex32VectorValue) {
            float real = 0.0f;
            float imaginary = 0.0f;
            int n = 0;
            int n2 = Complex32VectorValue.getLogicalSize-impl(arg0);
            if (n < n2) {
                do {
                    int i = n++;
                    int iprime = i << 1;
                    real += arg0[iprime] * ((Complex32VectorValue)other).unbox-impl()[iprime] - arg0[iprime + 1] * -((Complex32VectorValue)other).unbox-impl()[iprime + 1];
                    imaginary += arg0[iprime] * -((Complex32VectorValue)other).unbox-impl()[iprime + 1] + arg0[iprime + 1] * ((Complex32VectorValue)other).unbox-impl()[iprime];
                } while (n < n2);
            }
            fArray = Complex32Value.constructor-impl(real, imaginary);
        } else if (vectorValue instanceof Complex64VectorValue) {
            float real = 0.0f;
            float imaginary = 0.0f;
            int n = 0;
            int n3 = Complex32VectorValue.getLogicalSize-impl(arg0);
            if (n < n3) {
                do {
                    int i = n++;
                    int iprime = i << 1;
                    real += arg0[iprime] * (float)((Complex64VectorValue)other).unbox-impl()[iprime] - arg0[iprime + 1] * (float)(-((Complex64VectorValue)other).unbox-impl()[iprime + 1]);
                    imaginary += arg0[iprime] * (float)(-((Complex64VectorValue)other).unbox-impl()[iprime + 1]) + arg0[iprime + 1] * (float)((Complex64VectorValue)other).unbox-impl()[iprime];
                } while (n < n3);
            }
            fArray = Complex32Value.constructor-impl(real, imaginary);
        } else {
            float real = 0.0f;
            float imaginary = 0.0f;
            int n = 0;
            int n4 = Complex32VectorValue.getLogicalSize-impl(arg0);
            if (n < n4) {
                do {
                    int i = n++;
                    int iprime = i << 1;
                    real += arg0[iprime] * ((Number)other.get(iprime + i).getValue()).floatValue();
                    imaginary += arg0[iprime + 1] * ((Number)other.get(iprime + i).getValue()).floatValue();
                } while (n < n4);
            }
            fArray = Complex32Value.constructor-impl(real, imaginary);
        }
        return fArray;
    }

    @NotNull
    public float[] dot-8fBXkOU(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32VectorValue.dot-8fBXkOU(this.data, other);
    }

    public static double norm2-Z2rTJmk(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        double sum = 0.0;
        int n = 0;
        int n2 = arg0.length / 2;
        if (n < n2) {
            do {
                int i = n++;
                sum += (double)(arg0[i << 1] * arg0[i << 1] + arg0[(i << 1) + 1] * arg0[(i << 1) + 1]);
            } while (n < n2);
        }
        n = 0;
        return DoubleValue.constructor-impl(Math.sqrt(sum));
    }

    public double norm2-Z2rTJmk() {
        return Complex32VectorValue.norm2-Z2rTJmk(this.data);
    }

    public static double l1-He8yXgM(float[] arg0, @NotNull VectorValue<?> other) {
        double d;
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other.getLogicalSize() == Complex32VectorValue.getLogicalSize-impl(arg0)) {
            VectorValue<?> vectorValue = other;
            if (vectorValue instanceof Complex32VectorValue) {
                double sum = 0.0;
                int n = 0;
                int n2 = arg0.length / 2;
                if (n < n2) {
                    do {
                        int i = n++;
                        float diffReal = arg0[i << 1] - ((Complex32VectorValue)other).unbox-impl()[i << 1];
                        float diffImaginary = arg0[(i << 1) + 1] - ((Complex32VectorValue)other).unbox-impl()[(i << 1) + 1];
                        float f = diffReal;
                        int n3 = 2;
                        boolean bl = false;
                        float f2 = (float)Math.pow(f, n3);
                        f = diffImaginary;
                        n3 = 2;
                        bl = false;
                        f = f2 + (float)Math.pow(f, n3);
                        n3 = 0;
                        sum += (double)((float)Math.sqrt(f));
                    } while (n < n2);
                }
                d = DoubleValue.constructor-impl(sum);
            } else if (vectorValue instanceof Complex64VectorValue) {
                double sum = 0.0;
                int n = 0;
                int n4 = arg0.length / 2;
                if (n < n4) {
                    do {
                        int i = n++;
                        double diffReal = (double)arg0[i << 1] - ((Complex64VectorValue)other).unbox-impl()[i << 1];
                        double diffImaginary = (double)arg0[(i << 1) + 1] - ((Complex64VectorValue)other).unbox-impl()[(i << 1) + 1];
                        double d2 = diffReal;
                        int n5 = 2;
                        boolean bl = false;
                        double d3 = Math.pow(d2, n5);
                        d2 = diffImaginary;
                        n5 = 2;
                        bl = false;
                        d2 = d3 + Math.pow(d2, n5);
                        n5 = 0;
                        sum += Math.sqrt(d2);
                    } while (n < n4);
                }
                d = DoubleValue.constructor-impl(sum);
            } else {
                double sum = 0.0;
                int n = 0;
                int n6 = arg0.length / 2;
                if (n < n6) {
                    do {
                        int i = n++;
                        double diffReal = (double)arg0[i << 1] - other.get(i).asDouble-Z2rTJmk();
                        float diffImaginary = arg0[(i << 1) + 1];
                        double d4 = diffReal;
                        int n7 = 2;
                        boolean bl = false;
                        double d5 = Math.pow(d4, n7);
                        float f = diffImaginary;
                        int n8 = 2;
                        n7 = 0;
                        d4 = d5 + (double)((float)Math.pow(f, n8));
                        n7 = 0;
                        sum += Math.sqrt(d4);
                    } while (n < n6);
                }
                d = DoubleValue.constructor-impl(sum);
            }
        } else {
            throw new IllegalArgumentException("Dimensions " + Complex32VectorValue.getLogicalSize-impl(arg0) + " and " + other.getLogicalSize() + " don't agree!");
        }
        return d;
    }

    public double l1-He8yXgM(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32VectorValue.l1-He8yXgM(this.data, other);
    }

    @NotNull
    public static RealValue<?> hamming-impl(float[] arg0, @NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32VectorValue.box-impl(arg0).hamming(other);
    }

    @Override
    @NotNull
    public RealValue<?> hamming(@NotNull VectorValue<?> other) {
        return ComplexVectorValue.DefaultImpls.hamming(this, other);
    }

    @NotNull
    public static Iterator<ComplexValue<Float>> iterator-impl(float[] arg0) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        return Complex32VectorValue.box-impl(arg0).iterator();
    }

    @Override
    @NotNull
    public Iterator<ComplexValue<Float>> iterator() {
        return ComplexVectorValue.DefaultImpls.iterator(this);
    }

    @NotNull
    public static RealValue<?> l2-impl(float[] arg0, @NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32VectorValue.box-impl(arg0).l2(other);
    }

    @Override
    @NotNull
    public RealValue<?> l2(@NotNull VectorValue<?> other) {
        return ComplexVectorValue.DefaultImpls.l2(this, other);
    }

    @NotNull
    public static RealValue<?> lp-impl(float[] arg0, @NotNull VectorValue<?> other, int p) {
        Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return Complex32VectorValue.box-impl(arg0).lp(other, p);
    }

    @Override
    @NotNull
    public RealValue<?> lp(@NotNull VectorValue<?> other, int p) {
        return ComplexVectorValue.DefaultImpls.lp(this, other, p);
    }

    public static String toString-impl(float[] arg0) {
        return "Complex32VectorValue(data=" + Arrays.toString(arg0) + ')';
    }

    public String toString() {
        return Complex32VectorValue.toString-impl(this.data);
    }

    public static int hashCode-impl(float[] arg0) {
        return Arrays.hashCode(arg0);
    }

    public int hashCode() {
        return Complex32VectorValue.hashCode-impl(this.data);
    }

    public static boolean equals-impl(float[] arg0, Object other) {
        if (!(other instanceof Complex32VectorValue)) {
            return false;
        }
        float[] fArray = ((Complex32VectorValue)other).unbox-impl();
        return Intrinsics.areEqual((Object)arg0, (Object)fArray);
    }

    public boolean equals(Object other) {
        return Complex32VectorValue.equals-impl(this.data, other);
    }

    private /* synthetic */ Complex32VectorValue(float[] data) {
        this.data = data;
    }

    @NotNull
    public static float[] constructor-impl(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        float[] fArray = data;
        return fArray;
    }

    public static final /* synthetic */ Complex32VectorValue box-impl(float[] v) {
        return new Complex32VectorValue(v);
    }

    public final /* synthetic */ float[] unbox-impl() {
        return this.data;
    }

    public static final boolean equals-impl0(float[] p1, float[] p2) {
        return Intrinsics.areEqual((Object)p1, (Object)p2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u000f\u0010\b\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/model/values/Complex32VectorValue$Companion;", "", "()V", "one", "Lorg/vitrivr/cottontail/model/values/Complex32VectorValue;", "size", "", "one-TM7V8EU", "(I)[F", "random", "rnd", "Ljava/util/SplittableRandom;", "random-sq7g6_Y", "(ILjava/util/SplittableRandom;)[F", "zero", "zero-TM7V8EU", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final float[] random-sq7g6_Y(int size, @NotNull SplittableRandom rnd) {
            Intrinsics.checkNotNullParameter((Object)rnd, (String)"rnd");
            int n = 0;
            int n2 = size * 2;
            float[] fArray = new float[n2];
            while (n < n2) {
                int n3 = n++;
                fArray[n3] = SplittableRandomExtensionsKt.nextFloat(rnd);
            }
            return Complex32VectorValue.constructor-impl(fArray);
        }

        public static /* synthetic */ float[] random-sq7g6_Y$default(Companion companion, int n, SplittableRandom splittableRandom, int n2, Object object) {
            if ((n2 & 2) != 0) {
                splittableRandom = Value.Companion.getRANDOM();
            }
            return companion.random-sq7g6_Y(n, splittableRandom);
        }

        @NotNull
        public final float[] one-TM7V8EU(int size) {
            int n = size * 2;
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                fArray[n2] = n2 % 2 == 0 ? 1.0f : 0.0f;
            }
            return Complex32VectorValue.constructor-impl(fArray);
        }

        @NotNull
        public final float[] zero-TM7V8EU(int size) {
            int n = 0;
            int n2 = size * 2;
            float[] fArray = new float[n2];
            while (n < n2) {
                int n3 = n++;
                fArray[n3] = 0.0f;
            }
            return Complex32VectorValue.constructor-impl(fArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

