/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.model.values;

import java.util.SplittableRandom;
import kotlin.Metadata;
import kotlin.jvm.JvmInline;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.model.basics.Type;
import org.vitrivr.cottontail.model.values.ByteValue;
import org.vitrivr.cottontail.model.values.Complex32Value;
import org.vitrivr.cottontail.model.values.Complex64Value;
import org.vitrivr.cottontail.model.values.DoubleValue;
import org.vitrivr.cottontail.model.values.IntValue;
import org.vitrivr.cottontail.model.values.LongValue;
import org.vitrivr.cottontail.model.values.ShortValue;
import org.vitrivr.cottontail.model.values.types.NumericValue;
import org.vitrivr.cottontail.model.values.types.RealValue;
import org.vitrivr.cottontail.model.values.types.Value;
import org.vitrivr.cottontail.utilities.extensions.SplittableRandomExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JvmInline
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u001e\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0087@\u0018\u0000 m2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001mB\u0014\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0014\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0007\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0005\u0010\bB\u0018\b\u0016\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\t\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0005\u0010\nB\u0012\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0005\u0010\fJ\u0018\u0010\u001c\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001d\u0010\fJ\u0018\u0010\u001e\u001a\u00020\u001fH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b \u0010!J\u0018\u0010\"\u001a\u00020#H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b$\u0010%J\u0018\u0010&\u001a\u00020'H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b(\u0010)J\u0018\u0010*\u001a\u00020+H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b,\u0010-J\u0018\u0010.\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b/\u0010\fJ\u0018\u00100\u001a\u000201H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b2\u0010\u0013J\u0018\u00103\u001a\u000204H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b5\u00106J\u0018\u00107\u001a\u000208H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b9\u0010:J\u0018\u0010;\u001a\u00020+H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b<\u0010-J\u0018\u0010=\u001a\u00020\u00112\u0006\u0010>\u001a\u00020?H\u0096\u0002\u00a2\u0006\u0004\b@\u0010AJ\u0018\u0010B\u001a\u00020+H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bC\u0010-J%\u0010D\u001a\u00020\u00002\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\tH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bE\u0010FJ\u001a\u0010G\u001a\u00020H2\b\u0010>\u001a\u0004\u0018\u00010IH\u00d6\u0003\u00a2\u0006\u0004\bJ\u0010KJ\u0018\u0010L\u001a\u00020+H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bM\u0010-J\u0010\u0010N\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\bO\u0010\u0013J\u0017\u0010P\u001a\u00020H2\u0006\u0010>\u001a\u00020?H\u0016\u00a2\u0006\u0004\bQ\u0010RJ\u0018\u0010S\u001a\u00020+H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bT\u0010-J%\u0010U\u001a\u00020\u00002\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\tH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bV\u0010FJ%\u0010W\u001a\u00020\u00002\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\tH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bX\u0010FJ \u0010Y\u001a\u00020+2\u0006\u0010Z\u001a\u00020\u0004H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b[\u0010\\J \u0010Y\u001a\u00020\u00002\u0006\u0010Z\u001a\u00020\u0011H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b]\u0010^J\u0018\u0010_\u001a\u00020+H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b`\u0010-J\u0018\u0010a\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bb\u0010\fJ\u0018\u0010c\u001a\u00020+H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bd\u0010-J%\u0010e\u001a\u00020\u00002\n\u0010>\u001a\u0006\u0012\u0002\b\u00030\tH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bf\u0010FJ\u0010\u0010g\u001a\u00020hH\u00d6\u0001\u00a2\u0006\u0004\bi\u0010jJ\u0019\u0010k\u001a\u00020\u0000H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\bl\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0018\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u000b\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u0088\u0001\u000b\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006n"}, d2={"Lorg/vitrivr/cottontail/model/values/FloatValue;", "Lorg/vitrivr/cottontail/model/values/types/RealValue;", "", "number", "", "constructor-impl", "(D)F", "", "(Ljava/lang/Number;)F", "Lorg/vitrivr/cottontail/model/values/types/NumericValue;", "(Lorg/vitrivr/cottontail/model/values/types/NumericValue;)F", "value", "(F)F", "imaginary", "getImaginary-impl", "(F)Lorg/vitrivr/cottontail/model/values/types/RealValue;", "logicalSize", "", "getLogicalSize-impl", "(F)I", "real", "getReal-impl", "type", "Lorg/vitrivr/cottontail/model/basics/Type;", "getType-impl", "(F)Lorg/vitrivr/cottontail/model/basics/Type;", "getValue", "()Ljava/lang/Float;", "abs", "abs-JbzPQW8", "asByte", "Lorg/vitrivr/cottontail/model/values/ByteValue;", "asByte-pCuLKj8", "(F)B", "asComplex32", "Lorg/vitrivr/cottontail/model/values/Complex32Value;", "asComplex32-WO0UQc4", "(F)[F", "asComplex64", "Lorg/vitrivr/cottontail/model/values/Complex64Value;", "asComplex64-IY5coek", "(F)[D", "asDouble", "Lorg/vitrivr/cottontail/model/values/DoubleValue;", "asDouble-Z2rTJmk", "(F)D", "asFloat", "asFloat-JbzPQW8", "asInt", "Lorg/vitrivr/cottontail/model/values/IntValue;", "asInt-HuW2oqM", "asLong", "Lorg/vitrivr/cottontail/model/values/LongValue;", "asLong-LWoHqF4", "(F)J", "asShort", "Lorg/vitrivr/cottontail/model/values/ShortValue;", "asShort-0l6I1b0", "(F)S", "atan", "atan-Z2rTJmk", "compareTo", "other", "Lorg/vitrivr/cottontail/model/values/types/Value;", "compareTo-impl", "(FLorg/vitrivr/cottontail/model/values/types/Value;)I", "cos", "cos-Z2rTJmk", "div", "div-3fEAwC4", "(FLorg/vitrivr/cottontail/model/values/types/NumericValue;)F", "equals", "", "", "equals-impl", "(FLjava/lang/Object;)Z", "exp", "exp-Z2rTJmk", "hashCode", "hashCode-impl", "isEqual", "isEqual-impl", "(FLorg/vitrivr/cottontail/model/values/types/Value;)Z", "ln", "ln-Z2rTJmk", "minus", "minus-3fEAwC4", "plus", "plus-3fEAwC4", "pow", "x", "pow-He8yXgM", "(FD)D", "pow-3fEAwC4", "(FI)F", "sin", "sin-Z2rTJmk", "sqrt", "sqrt-JbzPQW8", "tan", "tan-Z2rTJmk", "times", "times-3fEAwC4", "toString", "", "toString-impl", "(F)Ljava/lang/String;", "unaryMinus", "unaryMinus-JbzPQW8", "Companion", "cottontaildb"})
public final class FloatValue
implements RealValue<Float> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float value;
    private static final float ZERO = FloatValue.constructor-impl(0.0f);
    private static final float ONE = FloatValue.constructor-impl(1.0f);
    @NotNull
    private static final float[] NaN = Complex32Value.constructor-impl(Float.NaN);
    @NotNull
    private static final float[] INF = Complex32Value.constructor-impl(Float.POSITIVE_INFINITY);

    @Override
    @NotNull
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public static float constructor-impl(double number) {
        String string = String.valueOf(number);
        boolean bl = false;
        float f = FloatValue.constructor-impl(Float.parseFloat(string));
        return f;
    }

    public static float constructor-impl(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        float f = FloatValue.constructor-impl(number.floatValue());
        return f;
    }

    public static float constructor-impl(@NotNull NumericValue<?> number) {
        Intrinsics.checkNotNullParameter(number, (String)"number");
        float f = FloatValue.constructor-impl(((Number)number.getValue()).floatValue());
        return f;
    }

    public static int getLogicalSize-impl(float arg0) {
        return 1;
    }

    @Override
    public int getLogicalSize() {
        return FloatValue.getLogicalSize-impl(this.value);
    }

    @NotNull
    public static Type<?> getType-impl(float arg0) {
        return Type.Float.INSTANCE;
    }

    @Override
    @NotNull
    public Type<?> getType() {
        return FloatValue.getType-impl(this.value);
    }

    @NotNull
    public static RealValue<Float> getReal-impl(float arg0) {
        return FloatValue.box-impl(arg0);
    }

    @Override
    @NotNull
    public RealValue<Float> getReal() {
        return FloatValue.getReal-impl(this.value);
    }

    @NotNull
    public static RealValue<Float> getImaginary-impl(float arg0) {
        return FloatValue.box-impl(ZERO);
    }

    @Override
    @NotNull
    public RealValue<Float> getImaginary() {
        return FloatValue.getImaginary-impl(this.value);
    }

    public static int compareTo-impl(float arg0, @NotNull Value other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Value value = other;
        if (value instanceof ByteValue) {
            n = Float.compare(arg0, ((ByteValue)other).unbox-impl());
        } else if (value instanceof ShortValue) {
            n = Float.compare(arg0, ((ShortValue)other).unbox-impl());
        } else if (value instanceof IntValue) {
            n = Float.compare(arg0, ((IntValue)other).unbox-impl());
        } else if (value instanceof LongValue) {
            n = Float.compare(arg0, ((LongValue)other).unbox-impl());
        } else if (value instanceof DoubleValue) {
            n = Double.compare(arg0, ((DoubleValue)other).unbox-impl());
        } else if (value instanceof FloatValue) {
            n = Float.compare(arg0, ((FloatValue)other).unbox-impl());
        } else if (value instanceof Complex32Value) {
            n = Float.compare(arg0, ((Complex32Value)other).unbox-impl()[0]);
        } else if (value instanceof Complex64Value) {
            n = Double.compare(arg0, ((Complex64Value)other).unbox-impl()[0]);
        } else {
            throw new IllegalArgumentException("LongValues can only be compared to other numeric values.");
        }
        return n;
    }

    @Override
    public int compareTo(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return FloatValue.compareTo-impl(this.value, other);
    }

    public static boolean isEqual-impl(float arg0, @NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other instanceof FloatValue && ((FloatValue)other).unbox-impl() == arg0;
    }

    @Override
    public boolean isEqual(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return FloatValue.isEqual-impl(this.value, other);
    }

    public static double asDouble-Z2rTJmk(float arg0) {
        return DoubleValue.constructor-impl((double)arg0);
    }

    @Override
    public double asDouble-Z2rTJmk() {
        return FloatValue.asDouble-Z2rTJmk(this.value);
    }

    public static float asFloat-JbzPQW8(float arg0) {
        return arg0;
    }

    @Override
    public float asFloat-JbzPQW8() {
        return FloatValue.asFloat-JbzPQW8(this.value);
    }

    public static int asInt-HuW2oqM(float arg0) {
        return IntValue.constructor-impl((int)arg0);
    }

    @Override
    public int asInt-HuW2oqM() {
        return FloatValue.asInt-HuW2oqM(this.value);
    }

    public static long asLong-LWoHqF4(float arg0) {
        return LongValue.constructor-impl((long)arg0);
    }

    @Override
    public long asLong-LWoHqF4() {
        return FloatValue.asLong-LWoHqF4(this.value);
    }

    public static short asShort-0l6I1b0(float arg0) {
        return ShortValue.constructor-impl((short)arg0);
    }

    @Override
    public short asShort-0l6I1b0() {
        return FloatValue.asShort-0l6I1b0(this.value);
    }

    public static byte asByte-pCuLKj8(float arg0) {
        return ByteValue.constructor-impl((byte)arg0);
    }

    @Override
    public byte asByte-pCuLKj8() {
        return FloatValue.asByte-pCuLKj8(this.value);
    }

    @NotNull
    public static float[] asComplex32-WO0UQc4(float arg0) {
        return Complex32Value.constructor-impl(FloatValue.box-impl(FloatValue.asFloat-JbzPQW8(arg0)), FloatValue.box-impl(FloatValue.constructor-impl(0.0f)));
    }

    @Override
    @NotNull
    public float[] asComplex32-WO0UQc4() {
        return FloatValue.asComplex32-WO0UQc4(this.value);
    }

    @NotNull
    public static double[] asComplex64-IY5coek(float arg0) {
        return Complex64Value.constructor-impl(DoubleValue.box-impl(FloatValue.asDouble-Z2rTJmk(arg0)), DoubleValue.box-impl(DoubleValue.constructor-impl(0.0)));
    }

    @Override
    @NotNull
    public double[] asComplex64-IY5coek() {
        return FloatValue.asComplex64-IY5coek(this.value);
    }

    public static float unaryMinus-JbzPQW8(float arg0) {
        return FloatValue.constructor-impl(-arg0);
    }

    public float unaryMinus-JbzPQW8() {
        return FloatValue.unaryMinus-JbzPQW8(this.value);
    }

    public static float plus-3fEAwC4(float arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.constructor-impl(arg0 + ((Number)other.getValue()).floatValue());
    }

    public float plus-3fEAwC4(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.plus-3fEAwC4(this.value, other);
    }

    public static float minus-3fEAwC4(float arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.constructor-impl(arg0 - ((Number)other.getValue()).floatValue());
    }

    public float minus-3fEAwC4(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.minus-3fEAwC4(this.value, other);
    }

    public static float times-3fEAwC4(float arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.constructor-impl(arg0 * ((Number)other.getValue()).floatValue());
    }

    public float times-3fEAwC4(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.times-3fEAwC4(this.value, other);
    }

    public static float div-3fEAwC4(float arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.constructor-impl(arg0 / ((Number)other.getValue()).floatValue());
    }

    public float div-3fEAwC4(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.div-3fEAwC4(this.value, other);
    }

    public static float abs-JbzPQW8(float arg0) {
        float f = arg0;
        boolean bl = false;
        return FloatValue.constructor-impl(Math.abs(f));
    }

    public float abs-JbzPQW8() {
        return FloatValue.abs-JbzPQW8(this.value);
    }

    public static double pow-He8yXgM(float arg0, double x) {
        float f = arg0;
        float f2 = (float)x;
        boolean bl = false;
        return DoubleValue.constructor-impl((float)Math.pow(f, f2));
    }

    public double pow-He8yXgM(double x) {
        return FloatValue.pow-He8yXgM(this.value, x);
    }

    public static float pow-3fEAwC4(float arg0, int x) {
        float f = arg0;
        boolean bl = false;
        return FloatValue.constructor-impl((float)Math.pow(f, x));
    }

    public float pow-3fEAwC4(int x) {
        return FloatValue.pow-3fEAwC4(this.value, x);
    }

    public static float sqrt-JbzPQW8(float arg0) {
        float f = arg0;
        boolean bl = false;
        return FloatValue.constructor-impl((float)Math.sqrt(f));
    }

    public float sqrt-JbzPQW8() {
        return FloatValue.sqrt-JbzPQW8(this.value);
    }

    public static double exp-Z2rTJmk(float arg0) {
        float f = arg0;
        boolean bl = false;
        return DoubleValue.constructor-impl((float)Math.exp(f));
    }

    public double exp-Z2rTJmk() {
        return FloatValue.exp-Z2rTJmk(this.value);
    }

    public static double ln-Z2rTJmk(float arg0) {
        float f = arg0;
        boolean bl = false;
        return DoubleValue.constructor-impl((float)Math.log(f));
    }

    public double ln-Z2rTJmk() {
        return FloatValue.ln-Z2rTJmk(this.value);
    }

    public static double cos-Z2rTJmk(float arg0) {
        float f = arg0;
        boolean bl = false;
        return DoubleValue.constructor-impl((float)Math.cos(f));
    }

    public double cos-Z2rTJmk() {
        return FloatValue.cos-Z2rTJmk(this.value);
    }

    public static double sin-Z2rTJmk(float arg0) {
        float f = arg0;
        boolean bl = false;
        return DoubleValue.constructor-impl((float)Math.sin(f));
    }

    public double sin-Z2rTJmk() {
        return FloatValue.sin-Z2rTJmk(this.value);
    }

    public static double tan-Z2rTJmk(float arg0) {
        float f = arg0;
        boolean bl = false;
        return DoubleValue.constructor-impl((float)Math.tan(f));
    }

    public double tan-Z2rTJmk() {
        return FloatValue.tan-Z2rTJmk(this.value);
    }

    public static double atan-Z2rTJmk(float arg0) {
        float f = arg0;
        boolean bl = false;
        return DoubleValue.constructor-impl((float)Math.atan(f));
    }

    public double atan-Z2rTJmk() {
        return FloatValue.atan-Z2rTJmk(this.value);
    }

    public static String toString-impl(float arg0) {
        return "FloatValue(value=" + arg0 + ')';
    }

    public String toString() {
        return FloatValue.toString-impl(this.value);
    }

    public static int hashCode-impl(float arg0) {
        return Float.hashCode(arg0);
    }

    public int hashCode() {
        return FloatValue.hashCode-impl(this.value);
    }

    public static boolean equals-impl(float arg0, Object other) {
        if (!(other instanceof FloatValue)) {
            return false;
        }
        float f = ((FloatValue)other).unbox-impl();
        return Intrinsics.areEqual((Object)Float.valueOf(arg0), (Object)Float.valueOf(f));
    }

    public boolean equals(Object other) {
        return FloatValue.equals-impl(this.value, other);
    }

    private /* synthetic */ FloatValue(float value) {
        this.value = value;
    }

    public static float constructor-impl(float value) {
        float f = value;
        return f;
    }

    public static final /* synthetic */ FloatValue box-impl(float v) {
        return new FloatValue(v);
    }

    public final /* synthetic */ float unbox-impl() {
        return this.value;
    }

    public static final boolean equals-impl0(float p1, float p2) {
        return Intrinsics.areEqual((Object)Float.valueOf(p1), (Object)Float.valueOf(p2));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u00020\u000b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0003\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\b\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\t\u0010\u0006R\u001c\u0010\n\u001a\u00020\u000b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000f\u001a\u00020\u000b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0010\u0010\r\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/model/values/FloatValue$Companion;", "", "()V", "INF", "Lorg/vitrivr/cottontail/model/values/Complex32Value;", "getINF-WO0UQc4", "()[F", "[F", "NaN", "getNaN-WO0UQc4", "ONE", "Lorg/vitrivr/cottontail/model/values/FloatValue;", "getONE-JbzPQW8", "()F", "F", "ZERO", "getZERO-JbzPQW8", "random", "rnd", "Ljava/util/SplittableRandom;", "random-3fEAwC4", "(Ljava/util/SplittableRandom;)F", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public final float getZERO-JbzPQW8() {
            return ZERO;
        }

        public final float getONE-JbzPQW8() {
            return ONE;
        }

        @NotNull
        public final float[] getNaN-WO0UQc4() {
            return NaN;
        }

        @NotNull
        public final float[] getINF-WO0UQc4() {
            return INF;
        }

        public final float random-3fEAwC4(@NotNull SplittableRandom rnd) {
            Intrinsics.checkNotNullParameter((Object)rnd, (String)"rnd");
            return FloatValue.constructor-impl(SplittableRandomExtensionsKt.nextFloat(rnd));
        }

        public static /* synthetic */ float random-3fEAwC4$default(Companion companion, SplittableRandom splittableRandom, int n, Object object) {
            if ((n & 1) != 0) {
                splittableRandom = Value.Companion.getRANDOM();
            }
            return companion.random-3fEAwC4(splittableRandom);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

