/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.data;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.database.column.ColumnDef;
import org.vitrivr.cottontail.utilities.data.exporter.DataExporter;
import org.vitrivr.cottontail.utilities.data.exporter.JsonDataExporter;
import org.vitrivr.cottontail.utilities.data.exporter.ProtoDataExporter;
import org.vitrivr.cottontail.utilities.data.importer.DataImporter;
import org.vitrivr.cottontail.utilities.data.importer.JsonDataImporter;
import org.vitrivr.cottontail.utilities.data.importer.ProtoDataImporter;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ)\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/utilities/data/Format;", "", "suffix", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getSuffix", "()Ljava/lang/String;", "newExporter", "Lorg/vitrivr/cottontail/utilities/data/exporter/DataExporter;", "file", "Ljava/nio/file/Path;", "newImporter", "Lorg/vitrivr/cottontail/utilities/data/importer/DataImporter;", "schema", "", "Lorg/vitrivr/cottontail/database/column/ColumnDef;", "(Ljava/nio/file/Path;[Lorg/vitrivr/cottontail/database/column/ColumnDef;)Lorg/vitrivr/cottontail/utilities/data/importer/DataImporter;", "PROTO", "JSON", "CSV", "cottontaildb"})
public final class Format
extends Enum<Format> {
    @NotNull
    private final String suffix;
    public static final /* enum */ Format PROTO = new Format("proto");
    public static final /* enum */ Format JSON = new Format("json");
    public static final /* enum */ Format CSV = new Format("csv");
    private static final /* synthetic */ Format[] $VALUES;

    private Format(String suffix) {
        this.suffix = suffix;
    }

    @NotNull
    public final String getSuffix() {
        return this.suffix;
    }

    @NotNull
    public final DataImporter newImporter(@NotNull Path file, @Nullable ColumnDef<?>[] schema) {
        DataImporter dataImporter;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Format format = this;
        int n = WhenMappings.$EnumSwitchMapping$0[format.ordinal()];
        switch (n) {
            case 1: {
                dataImporter = new ProtoDataImporter(file);
                break;
            }
            case 2: {
                ColumnDef<?>[] columnDefArray = schema;
                if (columnDefArray == null) {
                    throw new IllegalArgumentException("Schema is required to create an instance of JsonDataImporter.");
                }
                dataImporter = new JsonDataImporter(file, columnDefArray);
                break;
            }
            case 3: {
                boolean bl = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return dataImporter;
    }

    public static /* synthetic */ DataImporter newImporter$default(Format format, Path path, ColumnDef[] columnDefArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newImporter");
        }
        if ((n & 2) != 0) {
            columnDefArray = null;
        }
        return format.newImporter(path, columnDefArray);
    }

    @NotNull
    public final DataExporter newExporter(@NotNull Path file) {
        DataExporter dataExporter;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Format format = this;
        int n = WhenMappings.$EnumSwitchMapping$0[format.ordinal()];
        switch (n) {
            case 1: {
                dataExporter = new ProtoDataExporter(file);
                break;
            }
            case 2: {
                dataExporter = new JsonDataExporter(file, null, 2, null);
                break;
            }
            case 3: {
                boolean bl = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return dataExporter;
    }

    public static Format[] values() {
        return (Format[])$VALUES.clone();
    }

    public static Format valueOf(String value) {
        return Enum.valueOf(Format.class, value);
    }

    static {
        $VALUES = formatArray = new Format[]{Format.PROTO, Format.JSON, Format.CSV};
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Format.values().length];
            nArray[Format.PROTO.ordinal()] = 1;
            nArray[Format.JSON.ordinal()] = 2;
            nArray[Format.CSV.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

