package org.vitrivr.cottontail.dbms.queries.operators.logical.projection

import org.vitrivr.cottontail.core.database.ColumnDef
import org.vitrivr.cottontail.core.queries.binding.Binding
import org.vitrivr.cottontail.dbms.queries.operators.logical.UnaryLogicalOperatorNode
import org.vitrivr.cottontail.dbms.queries.operators.physical.projection.CountProjectionPhysicalOperatorNode
import org.vitrivr.cottontail.dbms.queries.projection.Projection

/**
 * A [UnaryLogicalOperatorNode] that represents a projection operation involving aggregate functions such as [Projection.COUNT].
 *
 * @author Ralph Gasser
 * @version 2.2.0
 */
class CountProjectionLogicalOperatorNode(input: Logical? = null, val out: Binding.Column) : AbstractProjectionLogicalOperatorOperator(input, Projection.COUNT) {

    /** The [ColumnDef] generated by this [CountProjectionLogicalOperatorNode]. */
    override val columns: List<ColumnDef<*>>
        get() = listOf(this.out.column)

    /**
     * Creates and returns a copy of this [CountProjectionLogicalOperatorNode] without any children or parents.
     *
     * @return Copy of this [CountProjectionLogicalOperatorNode].
     */
    override fun copy() = CountProjectionLogicalOperatorNode(out = this.out)

    /**
     * Returns a [CountProjectionPhysicalOperatorNode] representation of this [CountProjectionLogicalOperatorNode]
     *
     * @return [CountProjectionPhysicalOperatorNode]
     */
    override fun implement(): Physical = CountProjectionPhysicalOperatorNode(this.input?.implement(), this.out)

    /**
     * Compares this [CountProjectionLogicalOperatorNode] to another object.
     *
     * @param other The other [Any] to compare this [CountProjectionLogicalOperatorNode] to.
     * @return True if other equals this, false otherwise.
     */
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is CountProjectionLogicalOperatorNode) return false
        if (this.type != other.type) return false
        if (this.out != other.out) return false
        return true
    }

    /**
     * Generates and returns a hash code for this [CountProjectionLogicalOperatorNode].
     */
    override fun hashCode(): Int {
        var result = type.hashCode()
        result = 31 * result + this.out.hashCode()
        return result
    }
}