/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.entity;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.recordset.StandaloneRecord;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.dbms.column.Column;
import org.vitrivr.cottontail.dbms.column.ColumnEngine;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.column.mapdb.MapDBColumn;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.entity.EntityHeader;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.entity.EntityTxSnapshot;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TxException;
import org.vitrivr.cottontail.dbms.execution.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.general.TxAction;
import org.vitrivr.cottontail.dbms.general.TxStatus;
import org.vitrivr.cottontail.dbms.index.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.Index;
import org.vitrivr.cottontail.dbms.index.IndexTx;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.dbms.locking.LockMode;
import org.vitrivr.cottontail.dbms.operations.Operation;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.dbms.statistics.ValueStatisticsFactory;
import org.vitrivr.cottontail.dbms.statistics.entity.EntityStatistics;
import org.vitrivr.cottontail.utilities.io.TxFileUtilities;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ;2\u00020\u0001:\u0002;<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00105\u001a\u000206H\u0016J\u0014\u00107\u001a\u000608R\u00020\u00002\u0006\u00109\u001a\u00020:H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u00060\u0018j\u0002`\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020+0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u0002028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006="}, d2={"Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/dbms/schema/Schema;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/dbms/schema/Schema;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "closed", "", "getClosed", "()Z", "columns", "", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "Lorg/vitrivr/cottontail/dbms/column/Column;", "headerField", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/dbms/entity/EntityHeader;", "indexes", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "Lorg/vitrivr/cottontail/dbms/index/Index;", "maxTupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "getMaxTupleId", "()J", "name", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "numberOfColumns", "", "getNumberOfColumns", "()I", "numberOfRows", "getNumberOfRows", "getParent", "()Lorg/vitrivr/cottontail/dbms/schema/Schema;", "getPath", "()Ljava/nio/file/Path;", "statistics", "Lorg/vitrivr/cottontail/dbms/statistics/entity/EntityStatistics;", "getStatistics", "()Lorg/vitrivr/cottontail/dbms/statistics/entity/EntityStatistics;", "statisticsField", "store", "Lorg/mapdb/DB;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class DefaultEntity
implements Entity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @NotNull
    private final Schema parent;
    @NotNull
    private final DB store;
    @NotNull
    private final Atomic.Var<EntityHeader> headerField;
    @NotNull
    private final Atomic.Var<EntityStatistics> statisticsField;
    @NotNull
    private final Name.EntityName name;
    @NotNull
    private final StampedLock closeLock;
    @NotNull
    private final Map<Name.ColumnName, Column<?>> columns;
    @NotNull
    private final Map<Name.IndexName, Index> indexes;
    @NotNull
    public static final String CATALOGUE_FILE = "index.db";
    @NotNull
    public static final String ENTITY_HEADER_FIELD = "cdb_entity_header";
    @NotNull
    public static final String ENTITY_STATISTICS_FIELD = "cdb_entity_statistics";

    /*
     * WARNING - void declaration
     */
    public DefaultEntity(@NotNull Path path, @NotNull Schema parent) {
        void $this$mapTo$iv$iv;
        Path path2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.path = path;
        this.parent = parent;
        Object object = this;
        try {
            DefaultEntity defaultEntity = object;
            MapDBConfig mapDBConfig = this.getParent().getParent().getConfig().getMapdb();
            path2 = this.getPath().resolve(CATALOGUE_FILE);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.path.resolve(CATALOGUE_FILE)");
            path2 = mapDBConfig.db(path2);
        }
        catch (DBException dBException) {
            void e;
            DefaultEntity defaultEntity = object;
            throw new DatabaseException("Failed to open entity at " + this.getPath() + ": " + e.getMessage() + "'.", null, 2, null);
        }
        defaultEntity.store = path2;
        this.headerField = (Atomic.Var)this.store.atomicVar(ENTITY_HEADER_FIELD, (Serializer)EntityHeader.Serializer).createOrOpen();
        this.statisticsField = (Atomic.Var)this.store.atomicVar(ENTITY_STATISTICS_FIELD, (Serializer)EntityStatistics.Serializer).createOrOpen();
        this.name = this.getParent().getName().entity(((EntityHeader)this.headerField.get()).getName());
        this.closeLock = new StampedLock();
        this.columns = (Map)new Object2ObjectLinkedOpenHashMap();
        this.indexes = (Map)new Object2ObjectOpenHashMap();
        EntityHeader header = (EntityHeader)this.headerField.get();
        Iterable $this$map$iv = header.getColumns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EntityHeader.ColumnRef columnRef = (EntityHeader.ColumnRef)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Name.ColumnName columnName = this.getName().column(it.getName());
            Path path3 = this.getPath().resolve(Intrinsics.stringPlus((String)it.getName(), (Object)".col"));
            Map<Name.ColumnName, Column<?>> map2 = this.columns;
            ColumnEngine columnEngine = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
            MapDBColumn<Value> mapDBColumn = columnEngine.open(path3, this);
            map2.put(columnName, mapDBColumn);
            object.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Iterable $this$forEach$iv = header.getIndexes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityHeader.IndexRef it = (EntityHeader.IndexRef)element$iv;
            boolean bl = false;
            Name.IndexName indexName = this.getName().index(it.getName());
            Path path4 = this.getPath().resolve(Intrinsics.stringPlus((String)it.getName(), (Object)".idx"));
            Map<Name.IndexName, Index> map3 = this.indexes;
            IndexType indexType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"path");
            AbstractIndex abstractIndex = indexType.open(path4, this);
            map3.put(indexName, abstractIndex);
        }
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Schema getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Name.EntityName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V2_0;
    }

    @Override
    @NotNull
    public EntityStatistics getStatistics() {
        Object object = this.statisticsField.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.statisticsField.get()");
        return (EntityStatistics)object;
    }

    @Override
    public int getNumberOfColumns() {
        return this.columns.size();
    }

    @Override
    public long getNumberOfRows() {
        return this.getStatistics().getCount();
    }

    @Override
    public long getMaxTupleId() {
        return this.getStatistics().getMaximumTupleId();
    }

    @Override
    public boolean getClosed() {
        return this.store.isClosed();
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-DefaultEntity$close$22 = false;
            if (!this.getClosed()) {
                DBO it;
                this.store.close();
                Iterable $this$forEach$iv = this.columns.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Column)element$iv;
                    boolean bl = false;
                    it.close();
                }
                $this$forEach$iv = this.indexes.values();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Index)element$iv;
                    boolean bl = false;
                    it.close();
                }
            }
            Unit $i$a$-write-DefaultEntity$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    public static final /* synthetic */ Atomic.Var access$getStatisticsField$p(DefaultEntity $this) {
        return $this.statisticsField;
    }

    public static final /* synthetic */ Atomic.Var access$getHeaderField$p(DefaultEntity $this) {
        return $this.headerField;
    }

    public static final /* synthetic */ DB access$getStore$p(DefaultEntity $this) {
        return $this.store;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u001c\u0010\u000e\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Companion;", "", "()V", "CATALOGUE_FILE", "", "ENTITY_HEADER_FIELD", "ENTITY_STATISTICS_FIELD", "initialize", "Ljava/nio/file/Path;", "name", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "path", "config", "Lorg/vitrivr/cottontail/config/Config;", "columns", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "Lorg/vitrivr/cottontail/dbms/column/ColumnEngine;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final Path initialize(@NotNull Name.EntityName name, @NotNull Path path, @NotNull Config config, @NotNull List<? extends Pair<? extends ColumnDef<?>, ? extends ColumnEngine>> columns) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Path path2 = path.resolve(Intrinsics.stringPlus((String)"entity_", (Object)name.getSimple()));
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.resolve(\"entity_${name.simple}\")");
            Path dataPath = TxFileUtilities.INSTANCE.createPath(path2);
            if (Files.exists(dataPath, new LinkOption[0])) {
                throw new DatabaseException.InvalidFileException("Failed to create entity '" + name + "'. Data directory '" + dataPath + "' seems to be occupied.");
            }
            Files.createDirectories(dataPath, new FileAttribute[0]);
            try {
                Collection<EntityHeader.ColumnRef> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = columns;
                long l = 0L;
                long l2 = 0L;
                String string = name.getSimple();
                boolean $i$f$map = false;
                void var9_16 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Path colPath = dataPath.resolve(Intrinsics.stringPlus((String)((ColumnDef)it.getFirst()).getName().getSimple(), (Object)".col"));
                    ColumnEngine columnEngine = (ColumnEngine)((Object)it.getSecond());
                    Intrinsics.checkNotNullExpressionValue((Object)colPath, (String)"colPath");
                    columnEngine.create(colPath, (ColumnDef)it.getFirst(), config);
                    collection.add(new EntityHeader.ColumnRef(((ColumnDef)it.getFirst()).getName().getSimple(), (ColumnEngine)((Object)it.getSecond())));
                }
                collection = (List)destination$iv$iv;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 22;
                List list = null;
                Collection<EntityHeader.ColumnRef> collection2 = collection;
                long l3 = l;
                long l4 = l2;
                String string2 = string;
                EntityHeader entityHeader = new EntityHeader(string2, l4, l3, (List)collection2, list, n, defaultConstructorMarker);
                EntityStatistics entityStatistics = new EntityStatistics(0L, 0L, 3, null);
                Iterable $this$forEach$iv = columns;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl = false;
                    entityStatistics.set((ColumnDef)it.getFirst(), ValueStatisticsFactory.INSTANCE.create(((ColumnDef)it.getFirst()).getType()));
                }
                MapDBConfig mapDBConfig = config.getMapdb();
                Object object = dataPath.resolve(DefaultEntity.CATALOGUE_FILE);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"dataPath.resolve(CATALOGUE_FILE)");
                object = (Closeable)mapDBConfig.db((Path)object);
                Throwable throwable = null;
                try {
                    DB it = (DB)object;
                    boolean bl = false;
                    ((Atomic.Var)it.atomicVar(DefaultEntity.ENTITY_HEADER_FIELD, (Serializer)EntityHeader.Serializer).create()).set((Object)entityHeader);
                    ((Atomic.Var)it.atomicVar(DefaultEntity.ENTITY_STATISTICS_FIELD, (Serializer)EntityStatistics.Serializer).create()).set((Object)entityStatistics);
                    it.commit();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            catch (DBException e) {
                TxFileUtilities.INSTANCE.delete(dataPath);
                throw new DatabaseException("Failed to create entity '" + name + "' due to error in the underlying data store: {" + e.getMessage(), null, 2, null);
            }
            catch (IOException e) {
                TxFileUtilities.INSTANCE.delete(dataPath);
                throw new DatabaseException("Failed to create entity '" + name + "' due to an IO exception: {" + e.getMessage(), null, 2, null);
            }
            catch (Throwable e) {
                TxFileUtilities.INSTANCE.delete(dataPath);
                throw new DatabaseException("Failed to create entity '" + name + "' due to an unexpected error: {" + e.getMessage(), null, 2, null);
            }
            return dataPath;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0002<=B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0014\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016JC\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001f2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0\"H\u0016\u00a2\u0006\u0002\u0010$J\u0014\u0010%\u001a\u00020\u00132\n\u0010&\u001a\u00060\u0007j\u0002`'H\u0016J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J\u0014\u0010*\u001a\u00060\u0007j\u0002`'2\u0006\u0010+\u001a\u00020,H\u0016J\u0012\u0010-\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150.H\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001a0.H\u0016J\f\u00100\u001a\u00060\u0007j\u0002`'H\u0016J\b\u00101\u001a\u00020\u0013H\u0016J+\u00102\u001a\u00020,2\n\u0010&\u001a\u00060\u0007j\u0002`'2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001fH\u0016\u00a2\u0006\u0002\u00103J%\u00104\u001a\b\u0012\u0004\u0012\u00020,052\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001fH\u0016\u00a2\u0006\u0002\u00106J5\u00104\u001a\b\u0012\u0004\u0012\u00020,052\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001f2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H\u0016\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020\u00132\u0006\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006>"}, d2={"Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/entity/EntityTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "snapshot", "Lorg/vitrivr/cottontail/dbms/entity/EntityTxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/dbms/entity/EntityTxSnapshot;", "snapshot$delegate", "Lkotlin/Lazy;", "cleanup", "", "columnForName", "Lorg/vitrivr/cottontail/dbms/column/Column;", "name", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "count", "createIndex", "Lorg/vitrivr/cottontail/dbms/index/Index;", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "type", "Lorg/vitrivr/cottontail/dbms/index/IndexType;", "columns", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "params", "", "", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/index/IndexType;[Lorg/vitrivr/cottontail/core/database/ColumnDef;Ljava/util/Map;)Lorg/vitrivr/cottontail/dbms/index/Index;", "delete", "tupleId", "Lorg/vitrivr/cottontail/core/database/TupleId;", "dropIndex", "indexForName", "insert", "record", "Lorg/vitrivr/cottontail/core/basics/Record;", "listColumns", "", "listIndexes", "maxTupleId", "optimize", "read", "(J[Lorg/vitrivr/cottontail/core/database/ColumnDef;)Lorg/vitrivr/cottontail/core/basics/Record;", "scan", "", "([Lorg/vitrivr/cottontail/core/database/ColumnDef;)Ljava/util/Iterator;", "partitionIndex", "", "partitions", "([Lorg/vitrivr/cottontail/core/database/ColumnDef;II)Ljava/util/Iterator;", "update", "CreateIndexTxAction", "DropIndexTxAction", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements EntityTx {
        private final long closeStamp;
        @NotNull
        private final Lazy snapshot$delegate;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)DefaultEntity.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.closeStamp = DefaultEntity.this.closeLock.readLock();
            this.snapshot$delegate = LazyKt.lazy((Function0)((Function0)new Function0<snapshot.1>(DefaultEntity.this, this){
                final /* synthetic */ DefaultEntity this$0;
                final /* synthetic */ Tx this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(0);
                }

                @NotNull
                public final snapshot.1 invoke() {
                    return new EntityTxSnapshot(this.this$0, this.this$1){
                        @NotNull
                        private final EntityStatistics statistics;
                        @NotNull
                        private final Object2ObjectOpenHashMap<Name.IndexName, Index> indexes;
                        @NotNull
                        private final LinkedList<TxAction> actions;
                        final /* synthetic */ DefaultEntity this$0;
                        final /* synthetic */ Tx this$1;
                        {
                            this.this$0 = $receiver;
                            this.this$1 = $receiver2;
                            Object object = DefaultEntity.access$getStatisticsField$p(this.this$0).get();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this@DefaultEntity.statisticsField.get()");
                            this.statistics = (EntityStatistics)object;
                            this.indexes = new Object2ObjectOpenHashMap(DefaultEntity.access$getIndexes$p(this.this$0));
                            this.actions = new LinkedList<E>();
                        }

                        @NotNull
                        public EntityStatistics getStatistics() {
                            return this.statistics;
                        }

                        @NotNull
                        public Object2ObjectOpenHashMap<Name.IndexName, Index> getIndexes() {
                            return this.indexes;
                        }

                        @NotNull
                        public LinkedList<TxAction> getActions() {
                            return this.actions;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void commit() {
                            try {
                                Collection<EntityHeader.IndexRef> collection;
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                TxAction it;
                                Iterable $this$forEach$iv = this.getActions();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    it = (TxAction)element$iv;
                                    boolean bl = false;
                                    it.commit();
                                }
                                EntityHeader oldHeader = (EntityHeader)DefaultEntity.access$getHeaderField$p(this.this$0).get();
                                Intrinsics.checkNotNullExpressionValue((Object)oldHeader, (String)"oldHeader");
                                long l = System.currentTimeMillis();
                                Object object = this.getIndexes().values();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.indexes.values");
                                object = (Iterable)object;
                                List list = null;
                                long l2 = l;
                                long l3 = 0L;
                                String string = null;
                                EntityHeader entityHeader = oldHeader;
                                boolean $i$f$map = false;
                                it = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it2;
                                    Index index = (Index)item$iv$iv;
                                    collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(new EntityHeader.IndexRef(it2.getName().getSimple(), it2.getType()));
                                }
                                collection = (List)destination$iv$iv;
                                EntityHeader newHeader = EntityHeader.copy$default(entityHeader, string, l3, l2, list, (List)collection, 11, null);
                                DefaultEntity.access$getHeaderField$p(this.this$0).compareAndSet((Object)oldHeader, (Object)newHeader);
                                DefaultEntity.access$getStatisticsField$p(this.this$0).set((Object)this.getStatistics());
                                DefaultEntity.access$getStore$p(this.this$0).commit();
                            }
                            catch (Throwable e) {
                                Tx.access$setStatus(this.this$1, TxStatus.ERROR);
                                throw new DatabaseException("Failed to create index '" + this.this$0.getName() + "' due to a storage exception: " + e.getMessage(), null, 2, null);
                            }
                        }

                        public void rollback() {
                            Iterable $this$forEach$iv = this.getActions();
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                TxAction it = (TxAction)element$iv;
                                boolean bl = false;
                                it.rollback();
                            }
                            DefaultEntity.access$getStore$p(this.this$0).rollback();
                        }

                        public boolean record(@NotNull TxAction action) {
                            boolean bl;
                            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                            TxAction txAction = action;
                            if (txAction instanceof CreateIndexTxAction ? true : txAction instanceof DropIndexTxAction) {
                                ((LinkedList)this.getActions()).add(action);
                                bl = true;
                            } else {
                                bl = false;
                            }
                            return bl;
                        }
                    };
                }
            }));
            if (DefaultEntity.this.getClosed()) {
                DefaultEntity.this.closeLock.unlockRead(this.closeStamp);
                throw new TxException.TxDBOClosedException(this.getContext().getTxId(), DefaultEntity.this);
            }
        }

        @Override
        @NotNull
        public DefaultEntity getDbo() {
            return DefaultEntity.this;
        }

        @Override
        @NotNull
        public EntityTxSnapshot getSnapshot() {
            Lazy lazy = this.snapshot$delegate;
            return (EntityTxSnapshot)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Record read(long tupleId, @NotNull ColumnDef<?>[] columns) {
            void this_$iv;
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            AbstractTx abstractTx = this;
            DefaultEntity defaultEntity = DefaultEntity.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                boolean bl = false;
                boolean bl2 = false;
                Object $this$map$iv = columns;
                boolean $i$f$map = false;
                ColumnDef<?>[] columnDefArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((ColumnDef<?>[])$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    Column column;
                    void it;
                    void var19_19 = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    if ((Column)defaultEntity.columns.get(it.getName()) == null) {
                        throw new IllegalArgumentException("Column " + it + " does not exist on entity " + defaultEntity.getName() + '.');
                    }
                    collection.add(((ColumnTx)this.getContext().getTx(column)).read(tupleId));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                Value[] valueArray = thisCollection$iv.toArray(new Value[0]);
                if (valueArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                Value[] values = valueArray;
                Record record = (Record)new StandaloneRecord(tupleId, columns, values);
                return record;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long count() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                long l = this.getSnapshot().getStatistics().getCount();
                return l;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long maxTupleId() {
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                long l = this.getSnapshot().getStatistics().getMaximumTupleId();
                return l;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Column<?>> listColumns() {
            void this_$iv;
            AbstractTx abstractTx = this;
            DefaultEntity defaultEntity = DefaultEntity.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                List list = CollectionsKt.toList((Iterable)defaultEntity.columns.values());
                return list;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Column<?> columnForName(@NotNull Name.ColumnName name) {
            Column column;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx abstractTx = this;
            DefaultEntity defaultEntity = DefaultEntity.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                Column column2;
                boolean bl = false;
                boolean bl2 = false;
                if (!name.getWildcard()) {
                    column2 = (Column)defaultEntity.columns.get(name);
                    if (column2 == null) {
                        throw new DatabaseException.ColumnDoesNotExistException(name);
                    }
                } else {
                    Name.ColumnName fqn = defaultEntity.getName().column(name.getSimple());
                    column2 = (Column)defaultEntity.columns.get(fqn);
                    if (column2 == null) {
                        throw new DatabaseException.ColumnDoesNotExistException(fqn);
                    }
                }
                column = column2;
            }
            finally {
                readLock.unlock();
            }
            return column;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<Index> listIndexes() {
            List list;
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                list = CollectionsKt.toList((Iterable)this.getSnapshot().getIndexes().values());
            }
            finally {
                readLock.unlock();
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Index indexForName(@NotNull Name.IndexName name) {
            Index index;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                Index index2 = this.getSnapshot().getIndexes().get(name);
                if (index2 == null) {
                    throw new DatabaseException.IndexDoesNotExistException((Name)name);
                }
                index = index2;
            }
            finally {
                readLock.unlock();
            }
            return index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Index createIndex(@NotNull Name.IndexName name, @NotNull IndexType type, @NotNull ColumnDef<?>[] columns, @NotNull Map<String, String> params) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            AbstractTx abstractTx = this;
            DefaultEntity defaultEntity = DefaultEntity.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                if (this.getSnapshot().getIndexes().containsKey(name)) {
                    throw new DatabaseException.IndexAlreadyExistsException(name);
                }
                try {
                    Path data = defaultEntity.getPath().resolve(Intrinsics.stringPlus((String)name.getSimple(), (Object)".idx"));
                    Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                    AbstractIndex index = type.create(data, this.getDbo(), name, columns, params);
                    this.getSnapshot().getIndexes().put(name, index);
                    this.getSnapshot().record(new CreateIndexTxAction(index));
                    Index index2 = index;
                    return index2;
                }
                catch (DatabaseException e) {
                    this.setStatus(TxStatus.ERROR);
                    throw e;
                }
            }
            finally {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dropIndex(@NotNull Name.IndexName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx this_$iv = this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus(this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                Index index = this.getSnapshot().getIndexes().remove(name);
                if (index == null) {
                    throw new DatabaseException.IndexDoesNotExistException((Name)name);
                }
                Index index2 = index;
                this.getContext().requestLock(index2, LockMode.EXCLUSIVE);
                this.getSnapshot().getIndexes().remove(name);
                this.getSnapshot().record(new DropIndexTxAction(name));
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void optimize() {
            void this_$iv;
            AbstractTx abstractTx = this;
            DefaultEntity defaultEntity = DefaultEntity.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                void $this$filterTo$iv$iv;
                Object it;
                Object event;
                Object element$iv2;
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                Object it2;
                void $this$filterTo$iv$iv2;
                boolean bl = false;
                boolean bl2 = false;
                Iterable $this$filter$iv = this.getSnapshot().getIndexes().values();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it2 = (Index)element$iv$iv;
                    boolean bl3 = false;
                    if (!it2.getSupportsIncrementalUpdate()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv2 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it2 = (Index)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add((IndexTx)this.getContext().getTx((DBO)it2));
                }
                List incremental = (List)destination$iv$iv;
                Iterable $this$map$iv2 = defaultEntity.columns.values();
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo222 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    Column bl4 = (Column)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl5 = false;
                    collection.add(it3.getColumnDef());
                }
                $this$map$iv2 = (List)destination$iv$iv2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                ColumnDef[] columnDefArray = thisCollection$iv.toArray(new ColumnDef[0]);
                if (columnDefArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                ColumnDef[] columns = columnDefArray;
                Object2ObjectOpenHashMap map2 = new Object2ObjectOpenHashMap(columns.length);
                Iterator<Record> iterator = this.scan(columns);
                this.getSnapshot().getStatistics().reset();
                Object $this$forEach$iv = incremental;
                boolean $i$f$forEach = false;
                Iterator $i$f$mapTo222 = $this$forEach$iv.iterator();
                while ($i$f$mapTo222.hasNext()) {
                    element$iv2 = $i$f$mapTo222.next();
                    it2 = (IndexTx)element$iv2;
                    boolean bl6 = false;
                    it2.clear();
                }
                $this$forEach$iv = iterator;
                while ($this$forEach$iv.hasNext()) {
                    Record r = (Record)$this$forEach$iv.next();
                    int $i$f$mapTo222 = 0;
                    int element$iv2 = r.getSize();
                    while ($i$f$mapTo222 < element$iv2) {
                        int i = $i$f$mapTo222++;
                        ((Map)map2).put(r.getColumns()[i], r.get(i));
                    }
                    event = new Operation.DataManagementOperation.InsertOperation(this.getContext().getTxId(), defaultEntity.getName(), r.getTupleId(), (Map)map2);
                    this.getSnapshot().getStatistics().consume((Operation.DataManagementOperation)event);
                    Iterable $this$forEach$iv2 = incremental;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv3 : $this$forEach$iv2) {
                        it = (IndexTx)element$iv3;
                        boolean bl7 = false;
                        it.update((Operation.DataManagementOperation)event);
                    }
                }
                Iterable $this$filter$iv2 = this.getSnapshot().getIndexes().values();
                boolean $i$f$filter2 = false;
                event = $this$filter$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Index)element$iv$iv;
                    boolean bl8 = false;
                    if (!(!it.getSupportsIncrementalUpdate())) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv3;
                $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv2 = iterator2.next();
                    Index it4 = (Index)element$iv2;
                    boolean bl9 = false;
                    ((IndexTx)this.getContext().getTx(it4)).rebuild();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @NotNull
        public Iterator<Record> scan(@NotNull ColumnDef<?>[] columns) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            return this.scan(columns, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public Iterator<Record> scan(@NotNull ColumnDef<?>[] columns, int partitionIndex, int partitions) {
            Iterator<Record> iterator;
            void this_$iv;
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            AbstractTx abstractTx = this;
            DefaultEntity defaultEntity = DefaultEntity.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                iterator = new Iterator<Record>(this, partitions, partitionIndex, columns, defaultEntity){
                    @NotNull
                    private final LongRange range;
                    @NotNull
                    private final List<ColumnTx<?>> txs;
                    @NotNull
                    private final Iterator<Long> wrapped;
                    @NotNull
                    private final Value[] values;
                    final /* synthetic */ Tx this$0;
                    final /* synthetic */ int $partitions;
                    final /* synthetic */ int $partitionIndex;
                    final /* synthetic */ ColumnDef<?>[] $columns;
                    final /* synthetic */ DefaultEntity this$1;
                    {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        this.this$0 = $receiver;
                        this.$partitions = $partitions;
                        this.$partitionIndex = $partitionIndex;
                        this.$columns = $columns;
                        this.this$1 = $receiver2;
                        long maximum22 = this.this$0.maxTupleId();
                        long partitionSize = Math.floorDiv(maximum22, (long)this.$partitions) + 1L;
                        long start22 = (long)this.$partitionIndex * partitionSize;
                        long end = Math.min((long)(this.$partitionIndex + 1) * partitionSize, maximum22);
                        this.range = new LongRange(start22, end);
                        ColumnDef<?>[] maximum22 = this.$columns;
                        DefaultEntity defaultEntity = this.this$1;
                        Tx tx = this.this$0;
                        scan.1.1 var20_15 = this;
                        boolean $i$f$map = false;
                        void start22 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                        boolean $i$f$mapTo = false;
                        for (void item$iv$iv : $this$mapTo$iv$iv) {
                            Column column;
                            void it;
                            void var17_22 = item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            if ((Column)DefaultEntity.access$getColumns$p(defaultEntity).get(it.getName()) == null) {
                                throw new IllegalArgumentException("Column " + it + " does not exist on entity " + defaultEntity.getName() + '.');
                            }
                            collection.add((ColumnTx)tx.getContext().getTx(column));
                        }
                        var20_15.txs = (List)destination$iv$iv;
                        this.wrapped = ((ColumnTx)CollectionsKt.first(this.txs)).scan(this.range);
                        this.values = new Value[this.$columns.length];
                    }

                    @NotNull
                    public Record next() {
                        long tupleId = ((Number)this.wrapped.next()).longValue();
                        Iterator<ColumnTx<?>> iterator = this.txs.iterator();
                        int n = 0;
                        while (iterator.hasNext()) {
                            int i = n++;
                            ColumnTx<?> tx = iterator.next();
                            this.values[i] = tx.read(tupleId);
                        }
                        return (Record)new StandaloneRecord(tupleId, this.$columns, this.values);
                    }

                    public boolean hasNext() {
                        return this.wrapped.hasNext();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
            finally {
                readLock.unlock();
            }
            return iterator;
        }

        /*
         * Exception decompiling
         */
        public long insert(@NotNull Record record) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void update(@NotNull Record record) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            AbstractTx abstractTx = this;
            DefaultEntity defaultEntity = DefaultEntity.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                try {
                    Object2ObjectArrayMap updates = new Object2ObjectArrayMap(record.getColumns().length);
                    ColumnDef[] $this$forEach$iv = record.getColumns();
                    boolean $i$f$forEach = false;
                    for (ColumnDef element$iv : $this$forEach$iv) {
                        Column column;
                        ColumnDef def = element$iv;
                        boolean bl3 = false;
                        if ((Column)defaultEntity.columns.get(def.getName()) == null) {
                            throw new IllegalArgumentException("Column " + def + " does not exist on entity " + defaultEntity.getName() + '.');
                        }
                        Value value = record.get(def);
                        ColumnTx columnTx = (ColumnTx)this.getContext().getTx(column);
                        Map map2 = (Map)updates;
                        Pair pair = new Pair((Object)columnTx.update(record.getTupleId(), value), (Object)value);
                        map2.put(def, pair);
                    }
                    Operation.DataManagementOperation.UpdateOperation event = new Operation.DataManagementOperation.UpdateOperation(this.getContext().getTxId(), defaultEntity.getName(), record.getTupleId(), (Map)updates);
                    Iterable $this$forEach$iv2 = this.getSnapshot().getIndexes().values();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        Index it = (Index)element$iv;
                        boolean bl4 = false;
                        ((IndexTx)this.getContext().getTx(it)).update(event);
                    }
                    this.getSnapshot().getStatistics().consume(event);
                    this.getContext().signalEvent(event);
                }
                catch (DatabaseException e) {
                    this.setStatus(TxStatus.ERROR);
                    throw e;
                }
                catch (DBException e) {
                    this.setStatus(TxStatus.ERROR);
                    throw new DatabaseException("Updating record " + record.getTupleId() + " failed due to an error in the underlying storage: " + e.getMessage() + '.', null, 2, null);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void delete(long tupleId) {
            void this_$iv;
            AbstractTx abstractTx = this;
            DefaultEntity defaultEntity = DefaultEntity.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                try {
                    void $this$mapTo$iv$iv;
                    Object2ObjectArrayMap deleted = new Object2ObjectArrayMap(defaultEntity.columns.size());
                    Iterable $this$map$iv = defaultEntity.columns.values();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Column column = (Column)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        ((Map)deleted).put(it.getColumnDef(), ((ColumnTx)this.getContext().getTx((DBO)it)).delete(tupleId));
                        collection.add(Unit.INSTANCE);
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv;
                    Operation.DataManagementOperation.DeleteOperation event = new Operation.DataManagementOperation.DeleteOperation(this.getContext().getTxId(), defaultEntity.getName(), tupleId, (Map)deleted);
                    Iterable $this$forEach$iv = this.getSnapshot().getIndexes().values();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Index it = (Index)element$iv;
                        boolean bl4 = false;
                        ((IndexTx)this.getContext().getTx(it)).update(event);
                    }
                    this.getSnapshot().getStatistics().consume(event);
                    this.getContext().signalEvent(event);
                }
                catch (DBException e) {
                    this.setStatus(TxStatus.ERROR);
                    throw new DatabaseException("Deleting record " + tupleId + " failed due to an error in the underlying storage: " + e.getMessage() + '.', null, 2, null);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        protected void cleanup() {
            DefaultEntity.this.closeLock.unlockRead(this.closeStamp);
        }

        public static final /* synthetic */ void access$setStatus(Tx $this, TxStatus txStatus) {
            $this.setStatus(txStatus);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx$CreateIndexTxAction;", "Lorg/vitrivr/cottontail/dbms/general/TxAction;", "index", "Lorg/vitrivr/cottontail/dbms/index/Index;", "(Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx;Lorg/vitrivr/cottontail/dbms/index/Index;)V", "commit", "", "rollback", "cottontaildb-dbms"})
        public final class CreateIndexTxAction
        implements TxAction {
            @NotNull
            private final Index index;

            public CreateIndexTxAction(Index index) {
                Intrinsics.checkNotNullParameter((Object)Tx.this, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)index, (String)"index");
                this.index = index;
            }

            @Override
            public void commit() {
                this.index.close();
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
                Path move = Files.move(this.index.getPath(), TxFileUtilities.INSTANCE.plainPath(this.index.getPath()), copyOptionArray);
                Map map2 = DefaultEntity.this.indexes;
                Name.IndexName indexName = this.index.getName();
                IndexType indexType = this.index.getType();
                Intrinsics.checkNotNullExpressionValue((Object)move, (String)"move");
                map2.put(indexName, indexType.open(move, DefaultEntity.this));
            }

            @Override
            public void rollback() {
                this.index.close();
                TxFileUtilities.INSTANCE.delete(this.index.getPath());
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx$DropIndexTxAction;", "Lorg/vitrivr/cottontail/dbms/general/TxAction;", "index", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "(Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx;Lorg/vitrivr/cottontail/core/database/Name$IndexName;)V", "commit", "", "rollback", "cottontaildb-dbms"})
        public final class DropIndexTxAction
        implements TxAction {
            @NotNull
            private final Name.IndexName index;

            public DropIndexTxAction(Name.IndexName index) {
                Intrinsics.checkNotNullParameter((Object)Tx.this, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)index, (String)"index");
                this.index = index;
            }

            @Override
            public void commit() {
                Index index = (Index)DefaultEntity.this.indexes.remove(this.index);
                if (index == null) {
                    throw new IllegalStateException("Failed to drop index " + this.index + " because it is unknown to the enclosing entity. This is a programmer's error!");
                }
                Index index2 = index;
                index2.close();
                if (Files.exists(index2.getPath(), new LinkOption[0])) {
                    TxFileUtilities.INSTANCE.delete(index2.getPath());
                }
            }

            @Override
            public void rollback() {
            }
        }
    }
}

