/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.queries.functions.math.VectorDistance;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.dbms.index.pq.PQIndexConfig;
import org.vitrivr.cottontail.dbms.index.pq.PQLookupTable;
import org.vitrivr.cottontail.dbms.index.pq.PQSignature;
import org.vitrivr.cottontail.dbms.index.pq.codebook.DoublePrecisionPQCodebook;
import org.vitrivr.cottontail.dbms.index.pq.codebook.PQCodebook;
import org.vitrivr.cottontail.dbms.index.pq.codebook.SinglePrecisionPQCodebook;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B)\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ.\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00072\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0012\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0007J\u001a\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u001d\u001a\u00020\u001eR!\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQ;", "", "type", "Lorg/vitrivr/cottontail/core/values/types/Types;", "codebooks", "", "Lorg/vitrivr/cottontail/dbms/index/pq/codebook/PQCodebook;", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "(Lorg/vitrivr/cottontail/core/values/types/Types;Ljava/util/List;)V", "getCodebooks", "()Ljava/util/List;", "dimensionsPerSubspace", "", "getDimensionsPerSubspace", "()I", "numberOfSubspaces", "getNumberOfSubspaces", "getType", "()Lorg/vitrivr/cottontail/core/values/types/Types;", "getLookupTable", "Lorg/vitrivr/cottontail/dbms/index/pq/PQLookupTable;", "query", "distance", "Lorg/vitrivr/cottontail/core/queries/functions/math/VectorDistance;", "getLookupTable-MSj3omc", "(Lorg/vitrivr/cottontail/core/values/types/VectorValue;Lorg/vitrivr/cottontail/core/queries/functions/math/VectorDistance;)[[D", "getSignature", "Lorg/vitrivr/cottontail/dbms/index/pq/PQSignature;", "v", "array", "", "Companion", "Serializer", "cottontaildb-dbms"})
public final class PQ {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Types<?> type;
    @NotNull
    private final List<PQCodebook<VectorValue<?>>> codebooks;
    @NotNull
    private static final Logger LOGGER;
    private static final int MAX_ITERATIONS = 250;

    public PQ(@NotNull Types<?> type, @NotNull List<? extends PQCodebook<VectorValue<?>>> codebooks) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(codebooks, (String)"codebooks");
        this.type = type;
        this.codebooks = codebooks;
    }

    @NotNull
    public final Types<?> getType() {
        return this.type;
    }

    @NotNull
    public final List<PQCodebook<VectorValue<?>>> getCodebooks() {
        return this.codebooks;
    }

    public final int getNumberOfSubspaces() {
        return this.codebooks.size();
    }

    public final int getDimensionsPerSubspace() {
        return this.type.getLogicalSize() / this.codebooks.size();
    }

    @NotNull
    public final PQSignature getSignature(@NotNull VectorValue<?> v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        return this.getSignature(v, new int[this.getNumberOfSubspaces()]);
    }

    @NotNull
    public final PQSignature getSignature(@NotNull VectorValue<?> v, @NotNull int[] array) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (!(array.length == this.getNumberOfSubspaces())) {
            boolean bl = false;
            String string = "IntArray of signature must have the same size as the number of subspaces for this PQ (expected: " + this.getNumberOfSubspaces() + ", actual: " + array.length + ").";
            throw new IllegalArgumentException(string.toString());
        }
        Arrays.parallelSetAll(array, arg_0 -> PQ.getSignature$lambda-1(this, v, arg_0));
        return new PQSignature(array);
    }

    @NotNull
    public final double[][] getLookupTable-MSj3omc(@NotNull VectorValue<?> query2, @NotNull VectorDistance<?> distance) {
        Intrinsics.checkNotNullParameter(query2, (String)"query");
        Intrinsics.checkNotNullParameter(distance, (String)"distance");
        VectorDistance reshape = distance.copy(this.getDimensionsPerSubspace());
        int n = this.getNumberOfSubspaces();
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            PQCodebook<VectorValue<?>> codebook = this.codebooks.get(n2);
            VectorValue queryArgument = query2.subvector(n2 * this.getDimensionsPerSubspace(), this.getDimensionsPerSubspace());
            int n3 = 0;
            int n4 = codebook.getNumberOfCentroids();
            double[] dArray = new double[n4];
            int n5 = n2;
            double[][] dArrayArray2 = dArrayArray;
            while (n3 < n4) {
                int n6 = n3++;
                VectorValue<?> probingArgument = codebook.get(n6);
                Value[] valueArray = new Value[]{(Value)queryArgument, (Value)probingArgument};
                Value value = reshape.invoke(valueArray);
                Intrinsics.checkNotNull((Object)value);
                dArray[n6] = ((DoubleValue)value).unbox-impl();
            }
            dArrayArray2[n5] = dArray;
        }
        return PQLookupTable.constructor-impl(dArrayArray);
    }

    private static final int getSignature$lambda-1(PQ this$0, VectorValue $v, int k) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$v, (String)"$v");
        return this$0.codebooks.get(k).quantizeSubspaceForVector($v, k * this$0.getDimensionsPerSubspace());
    }

    static {
        Logger logger = LoggerFactory.getLogger(PQ.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(PQ::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQ$Serializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/dbms/index/pq/PQ;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb-dbms"})
    public static final class Serializer
    implements org.mapdb.Serializer<PQ> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull PQ value) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            out.writeUTF(value.getType().getName());
            out.packInt(value.getType().getLogicalSize());
            out.packInt(value.getCodebooks().size());
            Iterable $this$forEach$iv = value.getCodebooks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PQCodebook it = (PQCodebook)element$iv;
                boolean bl = false;
                PQCodebook cast = it;
                if (cast instanceof DoublePrecisionPQCodebook) {
                    DoublePrecisionPQCodebook.Serializer.INSTANCE.serialize(out, (DoublePrecisionPQCodebook)cast);
                    continue;
                }
                if (!(cast instanceof SinglePrecisionPQCodebook)) continue;
                SinglePrecisionPQCodebook.Serializer.INSTANCE.serialize(out, (SinglePrecisionPQCodebook)cast);
            }
        }

        @NotNull
        public PQ deserialize(@NotNull DataInput2 input, int available) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            String string = input.readUTF();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.readUTF()");
            Types type = Types.Companion.forName(string, input.unpackInt());
            int size = input.unpackInt();
            ArrayList<PQCodebook> codebooks = new ArrayList<PQCodebook>(size);
            int n = 0;
            while (n < size) {
                PQCodebook pQCodebook;
                int i = n++;
                Types types = type;
                if (types instanceof Types.FloatVector) {
                    pQCodebook = SinglePrecisionPQCodebook.Serializer.INSTANCE.deserialize(input, available);
                } else if (types instanceof Types.DoubleVector) {
                    pQCodebook = DoublePrecisionPQCodebook.Serializer.INSTANCE.deserialize(input, available);
                } else if (types instanceof Types.Complex32Vector) {
                    pQCodebook = SinglePrecisionPQCodebook.Serializer.INSTANCE.deserialize(input, available);
                } else if (types instanceof Types.Complex64Vector) {
                    pQCodebook = DoublePrecisionPQCodebook.Serializer.INSTANCE.deserialize(input, available);
                } else {
                    throw new IllegalStateException("");
                }
                codebooks.add(pQCodebook);
            }
            return new PQ(type, (List)codebooks);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQ$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "MAX_ITERATIONS", "", "fromData", "Lorg/vitrivr/cottontail/dbms/index/pq/PQ;", "config", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig;", "column", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "data", "", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PQ fromData(@NotNull PQIndexConfig config, @NotNull ColumnDef<?> column, @NotNull List<? extends VectorValue<?>> data) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter(column, (String)"column");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            LOGGER.debug("Initializing PQ from initial data.");
            if (!(config.getNumSubspaces() > 0)) {
                boolean $i$a$-require-PQ$Companion$fromData$42 = false;
                String $i$a$-require-PQ$Companion$fromData$42 = "Number of subspaces must be greater than zero for PQIndex.";
                throw new IllegalArgumentException($i$a$-require-PQ$Companion$fromData$42.toString());
            }
            if (!(config.getNumCentroids() > 0)) {
                boolean $i$a$-require-PQ$Companion$fromData$52 = false;
                String $i$a$-require-PQ$Companion$fromData$52 = "Number of centroids must be greater than zero for PQIndex.";
                throw new IllegalArgumentException($i$a$-require-PQ$Companion$fromData$52.toString());
            }
            if (!(column.getType().getLogicalSize() >= config.getNumSubspaces())) {
                boolean $i$a$-require-PQ$Companion$fromData$62 = false;
                String $i$a$-require-PQ$Companion$fromData$62 = "Logical size of column must be greater or equal to number of subspaces.";
                throw new IllegalArgumentException($i$a$-require-PQ$Companion$fromData$62.toString());
            }
            int dimensionsPerSubspace = column.getType().getLogicalSize() / config.getNumSubspaces();
            LOGGER.debug("Creating subspace data");
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)config.getNumSubspaces());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv2 = data;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void k;
                    void v;
                    VectorValue vectorValue = (VectorValue)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    collection2.add(v.subvector((int)(k * dimensionsPerSubspace), dimensionsPerSubspace));
                }
                collection.add((List)destination$iv$iv2);
            }
            List subspaceData = (List)destination$iv$iv;
            LOGGER.debug("Learning centroids");
            List codebooks = new ArrayList();
            subspaceData.parallelStream().forEach(arg_0 -> Companion.fromData$lambda-5(column, config, codebooks, arg_0));
            LOGGER.debug("PQ initialization done.");
            return new PQ(column.getType(), codebooks);
        }

        private static final void fromData$lambda-5(ColumnDef $column, PQIndexConfig $config, List $codebooks, List d) {
            PQCodebook pQCodebook;
            Intrinsics.checkNotNullParameter((Object)$column, (String)"$column");
            Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
            Intrinsics.checkNotNullParameter((Object)$codebooks, (String)"$codebooks");
            Types types = $column.getType();
            if (types instanceof Types.Complex32Vector ? true : types instanceof Types.FloatVector) {
                List list = d;
                if (list == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<org.vitrivr.cottontail.core.values.FloatVectorValue>");
                }
                pQCodebook = SinglePrecisionPQCodebook.Companion.learnFromData(list, $config.getNumCentroids(), $config.getSeed(), 250);
            } else if (types instanceof Types.Complex64Vector ? true : types instanceof Types.DoubleVector) {
                List list = d;
                if (list == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<org.vitrivr.cottontail.core.values.DoubleVectorValue>");
                }
                pQCodebook = DoublePrecisionPQCodebook.Companion.learnFromData(list, $config.getNumCentroids(), $config.getSeed(), 250);
            } else {
                throw new IllegalArgumentException("VectorValue of type " + $column.getType() + " is not supported for PQ.");
            }
            PQCodebook codebook = pQCodebook;
            $codebooks.add(codebook);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

