/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq.codebook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.KMeansPlusPlusClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.dbms.index.pq.codebook.ClusterableWithIndex;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\bf\u0018\u0000 \u0015*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003:\u0001\u0015J\u0016\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u0005H\u00a6\u0002\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0014R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/codebook/PQCodebook;", "T", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "", "logicalSize", "", "getLogicalSize", "()I", "numberOfCentroids", "getNumberOfCentroids", "type", "Lorg/vitrivr/cottontail/core/values/types/Types;", "getType", "()Lorg/vitrivr/cottontail/core/values/types/Types;", "get", "ci", "(I)Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "quantizeSubspaceForVector", "v", "start", "(Lorg/vitrivr/cottontail/core/values/types/VectorValue;I)I", "Companion", "cottontaildb-dbms"})
public interface PQCodebook<T extends VectorValue<?>> {
    @NotNull
    public static final Companion Companion = org.vitrivr.cottontail.dbms.index.pq.codebook.PQCodebook$Companion.$$INSTANCE;

    @NotNull
    public Types<T> getType();

    public int getNumberOfCentroids();

    public int getLogicalSize();

    @NotNull
    public T get(int var1);

    public int quantizeSubspaceForVector(@NotNull T var1, int var2);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JE\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/codebook/PQCodebook$Companion;", "", "()V", "clusterRealData", "", "Lorg/apache/commons/math3/ml/clustering/CentroidCluster;", "Lorg/vitrivr/cottontail/dbms/index/pq/codebook/ClusterableWithIndex;", "data", "", "", "covMatrix", "Lorg/apache/commons/math3/linear/RealMatrix;", "numCentroids", "", "seed", "", "maxIterations", "([[DLorg/apache/commons/math3/linear/RealMatrix;IJI)Ljava/util/List;", "squaredMahalanobis", "", "a", "b", "cottontaildb-dbms"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        public final double squaredMahalanobis(@NotNull double[] a, @NotNull double[] b, @NotNull RealMatrix covMatrix) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)covMatrix, (String)"covMatrix");
            if (!(a.length == b.length)) {
                boolean bl = false;
                Unit unit = Unit.INSTANCE;
                throw new IllegalArgumentException(unit.toString());
            }
            double dist = 0.0;
            int n = 0;
            int n2 = a.length;
            double[] dArray = new double[n2];
            while (n < n2) {
                int n3 = n++;
                dArray[n3] = a[n3] - b[n3];
            }
            double[] diff = dArray;
            n = 0;
            n2 = covMatrix.getColumnDimension();
            while (n < n2) {
                int i = n++;
                double h = 0.0;
                int n4 = 0;
                int n5 = diff.length;
                while (n4 < n5) {
                    int j = n4++;
                    h += diff[j] * covMatrix.getEntry(i, j);
                }
                dist += h * diff[i];
            }
            return dist;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<CentroidCluster<ClusterableWithIndex>> clusterRealData(@NotNull double[][] data, @NotNull RealMatrix covMatrix, int numCentroids, long seed, int maxIterations) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)covMatrix, (String)"covMatrix");
            Function2 measure2 = (Function2)new Function2<double[], double[], Double>(covMatrix){
                final /* synthetic */ RealMatrix $covMatrix;
                {
                    this.$covMatrix = $covMatrix;
                    super(2);
                }

                @NotNull
                public final Double invoke(@NotNull double[] a, @NotNull double[] b) {
                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    return org.vitrivr.cottontail.dbms.index.pq.codebook.PQCodebook$Companion.$$INSTANCE.squaredMahalanobis(a, b, this.$covMatrix);
                }
            };
            KMeansPlusPlusClusterer clusterer = new KMeansPlusPlusClusterer(numCentroids, maxIterations, new DistanceMeasure(measure2){
                private final /* synthetic */ Function2 function;
                {
                    this.function = function;
                }

                public final /* synthetic */ double compute(double[] p0, double[] p1) {
                    return ((Number)this.function.invoke((Object)p0, (Object)p1)).doubleValue();
                }
            }, (RandomGenerator)new JDKRandomGenerator((int)seed));
            Object[] objectArray = (Object[])data;
            KMeansPlusPlusClusterer kMeansPlusPlusClusterer = clusterer;
            boolean $i$f$mapIndexed = false;
            void var12_11 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$mapIndexed$iv).length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void value;
                void i;
                int n = index$iv$iv;
                index$iv$iv = n + 1;
                double[] dArray = (double[])item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ClusterableWithIndex((int)i, (double[])value){
                    final /* synthetic */ int $i;
                    final /* synthetic */ double[] $value;
                    {
                        this.$i = $i;
                        this.$value = $value;
                    }

                    public int getIndex() {
                        return this.$i;
                    }

                    @NotNull
                    public double[] getPoint() {
                        return this.$value;
                    }
                });
            }
            List centroidClusters2 = kMeansPlusPlusClusterer.cluster((Collection)((List)destination$iv$iv));
            Intrinsics.checkNotNullExpressionValue((Object)centroidClusters2, (String)"centroidClusters");
            return centroidClusters2;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

